/***********************************/
/* oroborus (c) Ken Lynch Jan 2001 */
/* Distributed under the GPL       */
/* See LICENSE for more details    */
/***********************************/

#ifdef KEYBOARD_SUPPORT

#include "oroborus.h"
#include <X11/keysym.h>

int NumLockMask, CapsLockMask, ScrollLockMask;

/*
 *
 * Initialize keyboard
 *
 */

void init_keyboard()
{
  XModifierKeymap *xmk=NULL;
  KeyCode *map;
  int m, k;

#ifdef DEBUG
  printf("init_keyboard\n");
#endif

  xmk=XGetModifierMapping(dpy);
  if(xmk)
  {
    map=xmk->modifiermap;
    for(m=0;m<8;m++)
      for(k=0;k<xmk->max_keypermod; k++, map++)
      {
        if(*map==XKeysymToKeycode(dpy, XK_Num_Lock))
          NumLockMask=(1<<m);
        if(*map==XKeysymToKeycode(dpy, XK_Caps_Lock))
          CapsLockMask=(1<<m);
        if(*map==XKeysymToKeycode(dpy, XK_Scroll_Lock))
          ScrollLockMask=(1<<m);
      }
    XFreeModifiermap(xmk);
  }
}

/*
 *
 * Parse key string
 *
 */

void parse_key(char *key_str, Key *key)
{
#ifdef DEBUG
  printf("parse_key\n");
  printf("  %s\n", key_str);
#endif

  key->modifier=0;
  key->keycode=0;
  if(strlen(key_str)<4) return;

  if(key_str[0]=='*') key->modifier=key->modifier|ShiftMask;
  if(key_str[1]=='*') key->modifier=key->modifier|ControlMask;
  if(key_str[2]=='*') key->modifier=key->modifier|Mod1Mask;

  key->keycode=XKeysymToKeycode(dpy, XStringToKeysym(key_str+3));
}

/*
 *
 * XGrabKey wrapper function
 *
 */

void grab_key(int keycode, unsigned int modifiers, Window w)
{
  if(keycode)
  {
    XGrabKey(dpy, keycode, modifiers, w, False, GrabModeAsync, GrabModeAsync);
    XGrabKey(dpy, keycode, modifiers|NumLockMask, w, False, GrabModeAsync, GrabModeAsync); 
    XGrabKey(dpy, keycode, modifiers|CapsLockMask, w, False, GrabModeAsync, GrabModeAsync);
    XGrabKey(dpy, keycode, modifiers|ScrollLockMask, w, False, GrabModeAsync, GrabModeAsync);
    XGrabKey(dpy, keycode, modifiers|NumLockMask|CapsLockMask, w, False, GrabModeAsync, GrabModeAsync);
    XGrabKey(dpy, keycode, modifiers|NumLockMask|ScrollLockMask, w, False, GrabModeAsync, GrabModeAsync);
    XGrabKey(dpy, keycode, modifiers|NumLockMask|CapsLockMask|ScrollLockMask, w, False, GrabModeAsync, GrabModeAsync);
  }
}

/*
 *
 * Ungrab all keys on a window
 *
 */
void ungrab_keys(Window w)
{
  XUngrabKey(dpy, AnyKey, AnyModifier, w);
}

/*
 *
 * Grab keys
 *
 */

void grab_keys(Window w)
{
  grab_key(config.keys.next_window.keycode, config.keys.next_window.modifier, w);
  grab_key(config.keys.prev_window.keycode, config.keys.prev_window.modifier, w);
  grab_key(config.keys.maximize.keycode, config.keys.maximize.modifier, w);
  grab_key(config.keys.shade.keycode, config.keys.shade.modifier, w);
  grab_key(config.keys.hide.keycode, config.keys.hide.modifier, w);
  grab_key(config.keys.close.keycode, config.keys.close.modifier, w);
  grab_key(config.keys.move_up.keycode, config.keys.move_up.modifier, w);
  grab_key(config.keys.move_down.keycode, config.keys.move_down.modifier, w);
  grab_key(config.keys.move_left.keycode, config.keys.move_left.modifier, w);
  grab_key(config.keys.move_right.keycode, config.keys.move_right.modifier, w);
  grab_key(config.keys.resize_up.keycode, config.keys.resize_up.modifier, w);
  grab_key(config.keys.resize_down.keycode, config.keys.resize_down.modifier, w);
  grab_key(config.keys.resize_left.keycode, config.keys.resize_left.modifier, w);
  grab_key(config.keys.resize_right.keycode, config.keys.resize_right.modifier, w);

#ifdef LAYER_SUPPORT
  grab_key(config.keys.raise_layer.keycode, config.keys.raise_layer.modifier, w);
  grab_key(config.keys.lower_layer.keycode, config.keys.lower_layer.modifier, w);
#endif /* LAYER */

#ifdef WORKSPACE_SUPPORT
  grab_key(config.keys.add_ws.keycode, config.keys.add_ws.modifier, w);
  grab_key(config.keys.del_ws.keycode, config.keys.del_ws.modifier, w);
  grab_key(config.keys.next_ws.keycode, config.keys.next_ws.modifier, w);
  grab_key(config.keys.prev_ws.keycode, config.keys.prev_ws.modifier, w);
  grab_key(config.keys.ws_1.keycode, config.keys.ws_1.modifier, w);
  grab_key(config.keys.ws_2.keycode, config.keys.ws_2.modifier, w);
  grab_key(config.keys.ws_3.keycode, config.keys.ws_3.modifier, w);
  grab_key(config.keys.ws_4.keycode, config.keys.ws_4.modifier, w);
  grab_key(config.keys.ws_5.keycode, config.keys.ws_5.modifier, w);
  grab_key(config.keys.ws_6.keycode, config.keys.ws_6.modifier, w);
  grab_key(config.keys.ws_7.keycode, config.keys.ws_7.modifier, w);
  grab_key(config.keys.ws_8.keycode, config.keys.ws_8.modifier, w);
  grab_key(config.keys.ws_9.keycode, config.keys.ws_9.modifier, w);
  grab_key(config.keys.sticky.keycode, config.keys.sticky.modifier, w);
  grab_key(config.keys.move_next_ws.keycode, config.keys.move_next_ws.modifier, w);
  grab_key(config.keys.move_prev_ws.keycode, config.keys.move_prev_ws.modifier, w);
  grab_key(config.keys.move_ws_1.keycode, config.keys.move_ws_1.modifier, w);
  grab_key(config.keys.move_ws_2.keycode, config.keys.move_ws_2.modifier, w);
  grab_key(config.keys.move_ws_3.keycode, config.keys.move_ws_3.modifier, w);
  grab_key(config.keys.move_ws_4.keycode, config.keys.move_ws_4.modifier, w);
  grab_key(config.keys.move_ws_5.keycode, config.keys.move_ws_5.modifier, w);
  grab_key(config.keys.move_ws_6.keycode, config.keys.move_ws_6.modifier, w);
  grab_key(config.keys.move_ws_7.keycode, config.keys.move_ws_7.modifier, w);
  grab_key(config.keys.move_ws_8.keycode, config.keys.move_ws_8.modifier, w);
  grab_key(config.keys.move_ws_9.keycode, config.keys.move_ws_9.modifier, w);
#endif /* WORKSPACE */
}
#endif /* KEYBOARD */

