/*
 * node-store.h
 *
 * 
 * Author: 
 *  Richard Hult <rhult@hem.passagen.se>
 * 
 *  http://www.dtek.chalmers.se/~d4hult/oregano/ 
 * 
 * Copyright (C) 1999,2000  Richard Hult 
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __NODE_STORE_H
#define __NODE_STORE_H

#include <gtk/gtk.h>
#include "sheet-pos.h"
#include "print.h"

#define TYPE_NODE_STORE            (node_store_get_type ())
#define NODE_STORE(obj)            (GTK_CHECK_CAST ((obj), TYPE_NODE_STORE, NodeStore))
#define NODE_STORE_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_NODE_STORE, NodeStoreClass))
#define IS_NODE_STORE(obj)         (GTK_CHECK_TYPE ((obj), TYPE_NODE_STORE))
#define IS_NODE_STORE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_NODE_STORE))

typedef struct _NodeStore NodeStore;
typedef struct _NodeStoreClass NodeStoreClass;

#include "node.h"
#include "wire.h"
#include "part.h"

struct _NodeStore {
	GtkObject parent;

	GHashTable *nodes;
	GList *items;
	GList *wires;
	GList *parts;
};

struct _NodeStoreClass
{
	GtkObjectClass parent_class;
};

guint		 node_store_get_type (void);
NodeStore	*node_store_new (void);
Node		*node_store_get_node (NodeStore *store, SheetPos pos);
int		 node_store_add_part (NodeStore *store, Part *part);
int		 node_store_remove_part (NodeStore *store, Part *part);
int		 node_store_add_wire (NodeStore *store, Wire *wire);
int		 node_store_remove_wire (NodeStore *store, Wire *wire);
void		 node_store_node_foreach (NodeStore *store, GHFunc *func, gpointer user_data);
int		 node_store_is_wire_at_pos (NodeStore *store, SheetPos pos);
GList		*node_store_get_parts (NodeStore *store);
GList		*node_store_get_wires (NodeStore *store);
GList		*node_store_get_items (NodeStore *store);
GList		*node_store_get_node_positions (NodeStore *store);
GList		*node_store_get_nodes (NodeStore *store);
void		 node_store_dump_wires (NodeStore *store);
void		 node_store_get_bounds (NodeStore *store, ArtDRect *rect);
gint		 node_store_count_items (NodeStore *store, ArtDRect *rect);
void		 node_store_print_items (NodeStore *store, OreganoPrintContext *opc, ArtDRect *rect);

#endif
