##############################################################################
#
#  Nero ShowTime 'm3u' File Remote Buffer Overflow Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/12/08
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #0543
#
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
##############################################################################

if(description)
{
  script_id(900410);
  script_cve_id("CVE-2008-7079");
 script_bugtraq_id(32446);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_tag(name:"cvss_base", value:"5.1");
  script_tag(name:"risk_factor", value:"High");
  script_category(ACT_GATHER_INFO);
  script_family("Denial of Service");
  script_name("Nero ShowTime 'm3u' File Remote Buffer Overflow Vulnerability");
  script_summary("Check for vulnerable version of Nero Showtime");
  desc = "
  Overview: This host is installed with Nero Showtime and is prone to
  'm3u' File Remote Buffer Overflow Vulnerability.

  Vulnerability Insight:
  This error is due to inadequate boundary checks on user supplied input.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the application.

  Impact Level: Application

  Affected Software/OS:
  Nero ShowTime 5.0.15.0 and prior on all Windows platforms.

  Fix: Solution/Patch not available as on 08th December, 2008.

  References:
  http://milw0rm.com/exploits/7207
  http://secunia.com/Advisories/32850

  CVSS Score:
    CVSS Base Score     : 5.1 (AV:N/AC:H/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 4.6
  Risk factor: Medium";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

neroExe = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                               "\App Paths\ShowTime.exe",
                          item:"Path");
if(neroExe)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:neroExe);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:neroExe);
  showtime = file + "ShowTime.exe";
  showtime = GetVer(file:showtime, share:share);
  {
    #Grep for Nero ShowTime 5.0.15.0 and prior.
    pattern = "^([0-4]\..*|5\.0(\.[0-9](\..*)?|\.1[0-4](\..*)?|\.15(\.0)?)?)";
    if(egrep(pattern:pattern,string:showtime)){
      security_warning(0);
    }
  }
}
