#
#VID 64c8cc2a-59b1-11d9-8a99-000c6e8f12ef
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52259);
 script_cve_id("CVE-2004-1300");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: libxine";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: libxine

CVE-2004-1300
Buffer overflow in the open_aiff_file function in demux_aiff.c for
xine-lib (libxine) 1-rc7 allows remote attackers to execute arbitrary
code via a crafted AIFF file.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://tigger.uic.edu/~jlongs2/holes/xine-lib.txt
http://xinehq.de/index.php/security/XSA-2004-7
http://www.vuxml.org/freebsd/64c8cc2a-59b1-11d9-8a99-000c6e8f12ef.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: libxine";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"libxine");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.r5_3")<=0) {
    security_note(0, data:"Package libxine version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
