# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12180 (mysql)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66508);
 script_cve_id("CVE-2009-4019", "CVE-2009-2446");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"8.5");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 10 FEDORA-2009-12180 (mysql)");

 desc = "The remote host is missing an update to mysql
announced via advisory FEDORA-2009-12180.

Update Information:

See http://dev.mysql.com/doc/refman/5.0/en/news-5-0-88.html

ChangeLog:

* Tue Nov 24 2009 Tom Lane  5.0.88-1
- Update to MySQL 5.0.88, for various fixes described at
  http://dev.mysql.com/doc/refman/5.0/en/news-5-0-88.html
  including fixes for CVE-2009-4019
  Related: #540906
- Ensure that /var/lib/mysql is created with the right SELinux context
  Related: #502966
- Increase startup timeout per bug #472222

References:

[ 1 ] Bug #540906 - CVE-2009-4019 mysql: DoS (crash) when comparing GIS items from subquery and when handling subqueires in WHERE  and assigning a SELECT result to a @variable
https://bugzilla.redhat.com/show_bug.cgi?id=540906

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update mysql' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12180

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-12180 (mysql)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"mysql", rpm:"mysql~5.0.88~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-bench", rpm:"mysql-bench~5.0.88~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-cluster", rpm:"mysql-cluster~5.0.88~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-devel", rpm:"mysql-devel~5.0.88~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-embedded", rpm:"mysql-embedded~5.0.88~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-embedded-devel", rpm:"mysql-embedded-devel~5.0.88~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-libs", rpm:"mysql-libs~5.0.88~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-server", rpm:"mysql-server~5.0.88~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-test", rpm:"mysql-test~5.0.88~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-debuginfo", rpm:"mysql-debuginfo~5.0.88~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
