#
# This script was written by Michel Arboi <arboi@alussinan.org> starting
# from roxen_percent.nasl
#
# GNU Public Licence
#
# References:
# From:"Securiteinfo.com" <webmaster@securiteinfo.com>
# To:nobody@securiteinfo.com
# Date: Sun, 7 Jul 2002 21:42:47 +0200 
# Message-Id: <02070721424701.01082@scrap>
# Subject: [VulnWatch] KF Web Server version 1.0.2 shows file and directory content
#

if(description)
{
 script_id(11166);
 script_version ("$Revision: 7190 $");
 script_tag(name:"risk_factor", value:"High");
 name = "KF Web Server /%00 bug";
 
 script_name(name);
 
 desc = "
Requesting a URL with '/%00' appended to it
makes some versions of KF Web Server to dump the listing of the  
directory, thus showing potentially sensitive files.

Risk factor : High
Solution : upgrade to the latest version of KF Web Server";


 script_description(desc);
 
 summary = "Make a request like http://www.example.com/%00";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(! get_port_state(port)) exit(0);

buffer = http_get(item:"/%00", port:port);
data   = http_keepalive_send_recv(port:port, data:buffer);
if ( data == NULL ) exit(0);


if (egrep(string: data, pattern: ".*File Name.*Size.*Date.*Type.*"))
{
 security_hole(port);
}
