#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :
    distribution = ChiSquare(0.5)
    size = 10000
    sample = distribution.getNumericalSample(size)
    factory = ChiSquareFactory()
    estimatedDistribution = factory.build(sample)
    print "distribution=", repr(distribution)
    print "Estimated distribution=", repr(estimatedDistribution)
    distribution = ChiSquare(1.0)
    sample = distribution.getNumericalSample(size)
    estimatedDistribution = factory.build(sample)
    print "distribution=", repr(distribution)
    print "Estimated distribution=", repr(estimatedDistribution)
    distribution = ChiSquare(2.5)
    sample = distribution.getNumericalSample(size)
    estimatedDistribution = factory.build(sample)
    print "distribution=", repr(distribution)
    print "Estimated distribution=", repr(estimatedDistribution)

except :
  import sys
  print "t_ChiSquareFactory.py", sys.exc_type, sys.exc_value
