//                                               -*- C++ -*-
/**
 *  @file  DistributionImplementationFactory.hxx
 *  @brief Top-level class for all distribution factories
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: DistributionImplementationFactory.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_DISTRIBUTIONIMPLEMENTATIONFACTORY_HXX
#define OPENTURNS_DISTRIBUTIONIMPLEMENTATIONFACTORY_HXX

#include "DistributionImplementation.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "CovarianceMatrix.hxx"
#include "PersistentObject.hxx"
#include "ResourceMap.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class DistributionImplementationFactory
 */
class DistributionImplementationFactory
  : public PersistentObject
{
  CLASSNAME;
public:

  typedef Collection<NumericalPoint> NumericalPointCollection;
  typedef Collection<NumericalPointWithDescription> NumericalPointWithDescriptionCollection;

  /** Default constructor */
  DistributionImplementationFactory(const UnsignedLong bootstrapSize = ResourceMap::GetAsUnsignedLong("DistributionImplementationFactory-DefaultBootstrapSize"),
                                    const String & name = DefaultName);

  /** Virtual constructor */
  virtual DistributionImplementationFactory * clone() const;

  /** String converter */
  virtual String __repr__() const;

  /** String converter */
  virtual String __str__(const String & offset = "") const;

  /* Here is the interface that all derived class must implement */
  /** Build a distribution based on a sample */
  virtual DistributionImplementation * build(const NumericalSample & sample) const;

  /** Build a distribution based on a sample and gives the covariance matrix of the estimate */
  virtual DistributionImplementation * build(const NumericalSample & sample,
                                             CovarianceMatrix & covariance) const;

  /** Build a distribution based on a set of parameters */
  virtual DistributionImplementation * build(const NumericalPointCollection & parameters) const;
  /** Build a distribution based on a set of parameters */
  virtual DistributionImplementation * build(const NumericalPointWithDescriptionCollection & parameters) const;

  /** Build a distribution using its default constructor */
  virtual DistributionImplementation * build() const;

  /** Bootstrap size accessor */
  UnsignedLong getBootstrapSize() const;
  void setBootstrapSize(const UnsignedLong bootstrapSize);

protected:
  /* Execute a R script */
  virtual NumericalPoint runRFactory(const NumericalSample & sample,
                                     const DistributionImplementation & distribution) const;

  /* Number of bootstrap resampling for ovariance estimation */
  UnsignedLong bootstrapSize_;

private:
  /* Convert a parameters collection into a NumericalPoint */
  static NumericalPoint ParametersAsNumericalPoint(const NumericalPointWithDescriptionCollection & parametersCollection);

}; /* class DistributionImplementationFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_DISTRIBUTIONIMPLEMENTATIONFACTORY_HXX */
