//                                               -*- C++ -*-
/**
 *  @file  ContinuousDistribution.hxx
 *  @brief Abstract top-level class for Continuous distributions
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: ContinuousDistribution.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_CONTINUOUSDISTRIBUTION_HXX
#define OPENTURNS_CONTINUOUSDISTRIBUTION_HXX

#include "UsualDistribution.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class ContinuousDistribution
 *
 * A subclass for Continuous usual distributions.
 */
class ContinuousDistribution
  : public UsualDistribution
{

  CLASSNAME;
public:


  /** Default constructor */
  explicit ContinuousDistribution(const String & name = DefaultName);


  /** Virtual constructor */
  virtual ContinuousDistribution * clone() const;

  /** Comparison operator */
  Bool operator ==(const ContinuousDistribution & other) const;

  /** Compute the CDF of Xi | X1, ..., Xi-1. x = Xi, y = (X1,...,Xi-1) */
  NumericalScalar computeConditionalCDF(const NumericalScalar x, const NumericalPoint & y) const;

  /** String converter */
  String __repr__() const;


  /* Methods inherited from upper classes */

  /** Tell if the distribution is Continuous */
  virtual Bool isContinuous() const;

protected:

  /** Compute the shifted moment of the distribution */
  NumericalPoint computeShiftedMoment(const UnsignedLong n,
                                      const NumericalPoint & shift) const;

  /** Compute the covariance of the distribution */
  void computeCovariance() const;

private:

}; /* class ContinuousDistribution */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_CONTINUOUSDISTRIBUTION_HXX */
