//                                               -*- C++ -*-
/**
 *  @file  LogUniformFactory.hxx
 *  @brief Factory for LogUniform distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (mar. 24 mai 2011) $
 *  Id:      $Id: LogUniformFactory.hxx 1910 2011-05-24 17:30:41Z schueller $
 */
#ifndef OPENTURNS_LOGUNIFORMFACTORY_HXX
#define OPENTURNS_LOGUNIFORMFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "LogUniform.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class LogUniformFactory
 */
class LogUniformFactory
  : public DistributionImplementationFactory
{
public:

  /** Default constructor */
  LogUniformFactory();

  /** Virtual constructor */
  LogUniformFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  LogUniform * build(const NumericalSample & sample) const;
  LogUniform * build(const NumericalPointCollection & parameters) const;
  LogUniform * build() const;


}; /* class LogUniformFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_LOGUNIFORMFACTORY_HXX */
