// SWIG file DistributionFactory.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: DistributionFactory.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "DistributionFactory.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Uncertainty::Model::DistributionFactory>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OpenTURNS::Uncertainty::Model::DistributionFactory
  convert<_PyObject_,OpenTURNS::Uncertainty::Model::DistributionFactory>(PyObject * pyObj)
  {
    void * ptr = 0;
    if ( !SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OpenTURNS::Uncertainty::Model::DistributionImplementationFactory *"), 0 |  0 )))
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object passed as argument is neither a DistributionImplementationFactory nor an object convertible to a DistributionImplementationFactory";

    OpenTURNS::Uncertainty::Model::DistributionImplementationFactory * p_dif = reinterpret_cast< OpenTURNS::Uncertainty::Model::DistributionImplementationFactory * >( ptr );
      return *p_dif;
  }


} /* namespace OpenTURNS */

%}

%template(DistributionImplementationFactoryTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Uncertainty::Model::DistributionImplementationFactory>;
%include DistributionFactory.hxx

namespace OpenTURNS { namespace Uncertainty { namespace Model {

%extend DistributionFactory {

DistributionFactory(const DistributionFactory & other) { return new OpenTURNS::Uncertainty::Model::DistributionFactory(other); }

}
}}}
