//                                               -*- C++ -*-
/**
 *  @file  t_LinearLeastSquares_std.cxx
 *  @brief The test file of class LinearLeastSquares for standard methods
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: t_LinearLeastSquares_std.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include <cmath>
#include "NumericalMathFunction.hxx"
#include "NumericalSample.hxx"
#include "NumericalPoint.hxx"
#include "LinearLeastSquares.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Algorithm;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    NumericalMathFunction myFunc("TestResponseSurface");
    NumericalSample data(9, myFunc.getInputDimension());
    NumericalPoint point(myFunc.getInputDimension());
    point[0] = 0.5;
    point[1] = 0.5;
    data[0] = point;
    point[0] = -0.5;
    point[1] = -0.5;
    data[1] = point;
    point[0] = -0.5;
    point[1] = 0.5;
    data[2] = point;
    point[0] = 0.5;
    point[1] = -0.5;
    data[3] = point;
    point[0] = 0.5;
    point[1] = 0.5;
    data[4] = point;
    point[0] = -0.25;
    point[1] = -0.25;
    data[5] = point;
    point[0] = -0.25;
    point[1] = 0.25;
    data[6] = point;
    point[0] = 0.25;
    point[1] = -0.25;
    data[7] = point;
    point[0] = 0.25;
    point[1] = 0.25;
    data[8] = point;
    {
      LinearLeastSquares myLeastSquares(data, myFunc);
      myLeastSquares.run();
      NumericalMathFunction responseSurface(myLeastSquares.getResponseSurface());
      fullprint << "myLeastSquares=" << myLeastSquares << std::endl;
      fullprint << "responseSurface=" << responseSurface << std::endl;
      NumericalPoint in(myFunc.getInputDimension(),0.1);
      fullprint << "myFunc(" << in << ")=" << myFunc(in) << std::endl;
      fullprint << "responseSurface(" << in << ")=" << responseSurface(in) << std::endl;
    }
    {
      NumericalSample dataOut(myFunc(data));
      LinearLeastSquares myLeastSquares(data, dataOut);
      myLeastSquares.run();
      NumericalMathFunction responseSurface(myLeastSquares.getResponseSurface());
      fullprint << "myLeastSquares=" << myLeastSquares << std::endl;
      fullprint << "responseSurface=" << responseSurface << std::endl;
      NumericalPoint in(myFunc.getInputDimension(),0.1);
      fullprint << "myFunc(" << in << ")=" << myFunc(in) << std::endl;
      fullprint << "responseSurface(" << in << ")=" << responseSurface(in) << std::endl;
    }
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
