//                                               -*- C++ -*-
/**
 *  @file  external_code_threads.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: external_code_threads.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "OTconfig.hxx" // Only needed for test wrappers
#include "WrapperInterface.h"
#include "WrapperCommon.h"
#include "WrapperMacros.h"


/*
 *  This is the declaration of function named 'smallest' into the wrapper.
 */
  

extern "C" {


/*
******************************************************************************************
*                                                                                        *
*                                  smallest function                                     *
*                                                                                        *
******************************************************************************************
*/

#define WRAPPERNAME external_code

  /**
   * Execution function
   * This function is called by the platform to do the real work of the wrapper. It may be
   * called concurrently, so be aware of not using shared or global data not protected by
   * a critical section.
   * This function has a mathematical meaning. It operates on one vector (aka point) and
   * returns another vector.
   */
#define NUM_LOOPS 1000000
  FUNC_EXEC( WRAPPERNAME , 
	     {
	       const long inSize  = getNumberOfVariables(p_exchangedData, WRAPPER_IN);
	       const long outSize = getNumberOfVariables(p_exchangedData, WRAPPER_OUT);

	       // First initialize the output point to the null vector
	       for (long i = 0; i < outSize; i++) outPoint->data_[i] = 0.0;

	       // Search the fixed point of the contraction by a fixed number of iterations
	       for (long i = 0; i < NUM_LOOPS; i++)
		 outPoint->data_[i % outSize] = inPoint->data_[i % inSize] + outPoint->data_[(i + 1) % outSize];
	     } )


  FUNC_EXEC_SAMPLE_MULTITHREADED( WRAPPERNAME )


} /* end extern "C" */
