//                                               -*- C++ -*-
/**
 * @file  DistributionFactory.hxx
 * @brief Top-level class for all distribution factories
 *
 * (C) Copyright 2005-2010 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: dutka $
 * \date   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 */

#ifndef OPENTURNS_DISTRIBUTIONFACTORY_HXX
#define OPENTURNS_DISTRIBUTIONFACTORY_HXX

#include "DistributionImplementationFactory.hxx"
#include "Distribution.hxx"
#include "TypedInterfaceObject.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      /**
       * @class DistributionFactory
       */
      class DistributionFactory
	: public Base::Common::TypedInterfaceObject<DistributionImplementationFactory>
      {
	CLASSNAME;
      public:

	typedef DistributionImplementationFactory::NumericalSample          NumericalSample;
	typedef DistributionImplementationFactory::InternalException        InternalException;
	typedef DistributionImplementationFactory::InvalidArgumentException InvalidArgumentException;
	typedef DistributionImplementationFactory::NumericalPointCollection NumericalPointCollection;

	/** Default constructor */
	DistributionFactory(const String & name = OT::DefaultName);

	/** Parameter constructor */
	DistributionFactory(const DistributionImplementationFactory & factory);

	/** String converter */
	virtual String __repr__() const;

	/** String converter */
	virtual String __str__() const;

	/* Here is the interface that all derived class must implement */

	virtual Distribution buildImplementation(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */;
	virtual Distribution buildImplementation(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */;
	virtual Distribution buildImplementation() const /* throw(InvalidArgumentException, InternalException) */;

      private:    

      }; /* class DistributionFactory */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DISTRIBUTIONFACTORY_HXX */
