//                                               -*- C++ -*-
/**
 *  @file  Copula.cxx
 *  @brief Abstract top-level class for all copulas
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Copula.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "Copula.hxx"
#include "IndependentCopula.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(Copula);

      typedef Uncertainty::Distribution::IndependentCopula IndependentCopula;
      
      /* Default constructor */
      Copula::Copula()
	: Distribution(IndependentCopula(1))
      {
	// Nothing to do
      }
      
      /* Constructor from distribution */
      Copula::Copula(const Distribution & distribution)
	: Distribution(distribution)
      {
	// Nothing to do
      }
      
      /* Constructor from implementation */
      Copula::Copula(const DistributionImplementation & implementation,
		     const String & name)
	: Distribution(implementation, name)
      {
	// Nothing to do
      }
      
      /* Constructor from implementation */
      Copula::Copula(const Implementation & p_implementation,
		     const String & name)
	: Distribution(p_implementation, name)
      {
	// Nothing to do
      }

    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
