//                                               -*- C++ -*-
/**
 *  @file  SimulationResultImplementation.hxx
 *  @brief Implementation of SimulationResult
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-23 13:46:12 +0200 (Fri, 23 May 2008) $
 *  Id:      $Id: SimulationResultImplementation.hxx 821 2008-05-23 11:46:12Z schueller $
 */
#ifndef OPENTURNS_SIMULATIONRESULTIMPLEMENTATION_HXX
#define OPENTURNS_SIMULATIONRESULTIMPLEMENTATION_HXX

#include <cmath>
#include "PersistentObject.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {


      /**
       * @class SimulationResultImplementation
       * Implementation of SimulationResult
       */
      class SimulationResultImplementation
	: public Base::Common::PersistentObject
      {

	CLASSNAME;
      public:

	static const NumericalScalar DefaultConfidenceLevel;

	typedef Base::Common::NotYetImplementedException NotYetImplementedException;
	typedef Base::Common::InvalidArgumentException   InvalidArgumentException;
	typedef Base::Common::StorageManager             StorageManager;

	/** Default constructor */
	explicit SimulationResultImplementation();

	/** Standard constructor */
	explicit SimulationResultImplementation(const NumericalScalar probabilityEstimate,
						const NumericalScalar varianceEstimate,
						const UnsignedLong outerSampling,
						const UnsignedLong blockSize) /* throw(InvalidArgumentException) */;

	/** Virtual constructor */
	virtual SimulationResultImplementation * clone() const;

	/** Probability estimate accessor */
	NumericalScalar getProbabilityEstimate() const;
	void setProbabilityEstimate(const NumericalScalar probabilityEstimate);

	/** Variance estimate accessor */
	NumericalScalar getVarianceEstimate() const;
	void setVarianceEstimate(const NumericalScalar varianceEstimate);

	/** Coefficient of variation estimate accessor */
	virtual NumericalScalar getCoefficientOfVariation() const;

	/** Sample size accessor */
	UnsignedLong getOuterSampling() const;
	void setOuterSampling(const UnsignedLong outerSampling);

	/** Block size accessor */
	UnsignedLong getBlockSize() const;
	void setBlockSize(const UnsignedLong blockSize);

	/** Confidence length */
	virtual NumericalScalar getConfidenceLength(const NumericalScalar level = DefaultConfidenceLevel) const
	  /* throw(InvalidArgumentException) */;

	/** String converter */
	virtual String __repr__() const;

	/** Method save() stores the object through the StorageManager */
	virtual void save(StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	virtual void load(StorageManager::Advocate & adv);

      protected:
	NumericalScalar probabilityEstimate_;
	NumericalScalar varianceEstimate_;
	UnsignedLong outerSampling_;
	UnsignedLong blockSize_;

      }; // class SimulationResultImplementation

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SIMULATIONRESULTIMPLEMENTATION_HXX */
