//                                               -*- C++ -*-
/**
 *  @file  OrthogonalUniVariatePolynomialFamily.cxx
 *  @brief This is the interface class for orthogonal polynomial factories
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "OrthogonalUniVariatePolynomialFamily.hxx"
#include "OSS.hxx"
#include "PersistentObjectFactory.hxx"
#include "HermiteFactory.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      CLASSNAMEINIT(OrthogonalUniVariatePolynomialFamily);

      /* Default constructor */
      OrthogonalUniVariatePolynomialFamily::OrthogonalUniVariatePolynomialFamily()
        : Base::Common::TypedInterfaceObject<OrthogonalUniVariatePolynomialFactory>(new HermiteFactory)
      {
        // Nothing to do
      }


      /* Constructor from implementation */
      OrthogonalUniVariatePolynomialFamily::OrthogonalUniVariatePolynomialFamily(const OrthogonalUniVariatePolynomialFactory & implementation)
        : Base::Common::TypedInterfaceObject<OrthogonalUniVariatePolynomialFactory>(implementation.clone())
      {
        // Nothing to do
      }


      /* The method to get the polynomial of any degree */
      OrthogonalUniVariatePolynomial OrthogonalUniVariatePolynomialFamily::build(const UnsignedLong degree) const
      {
        return getImplementation()->build(degree);
      }


      /* Measure accessor */
      OrthogonalUniVariatePolynomialFamily::Distribution OrthogonalUniVariatePolynomialFamily::getMeasure() const
      {
        return getImplementation()->getMeasure();
      }


      /* Calculate the coefficients of recurrence a0, a1, a2 such that
         Pn(x) = (a0 * x + a1) * Pn-1(x) + a2 * Pn-2(x) */
      OrthogonalUniVariatePolynomialFamily::Coefficients OrthogonalUniVariatePolynomialFamily::getRecurrenceCoefficients(const UnsignedLong n) const
      {
        return getImplementation()->getRecurrenceCoefficients(n);
      }


      /* String converter */
      String OrthogonalUniVariatePolynomialFamily::__repr__() const
      {
        return OSS() << "class=" << getClassName()
                     << " implementation=" << getImplementation()->__repr__();
      }

      /* Roots of the polynomial of degree n */
      OrthogonalUniVariatePolynomialFamily::NumericalPoint OrthogonalUniVariatePolynomialFamily::getRoots(const UnsignedLong n) const
      {
        return getImplementation()->getRoots(n);
      }

      /* Nodes and weights of the polynomial of degree n as the eigenvalues of the associated Jacobi matrix and the square
         of the first component of the associated normalized eigenvectors */
      OrthogonalUniVariatePolynomialFamily::NumericalPoint OrthogonalUniVariatePolynomialFamily::getNodesAndWeights(const UnsignedLong n,
                                                                                                                      NumericalPoint & weights) const
      {
        return getImplementation()->getNodesAndWeights(n, weights);
      }


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
