//                                               -*- C++ -*-
/**
 *  @file  TestResult.hxx
 *  @brief TestResult implements the result of a statistical test
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: TestResult.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_TESTRESULT_HXX
#define OPENTURNS_TESTRESULT_HXX

#include "PersistentObject.hxx"
#include "Description.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      /**
       * @class TestResult
       *
       * TestResult implements the result of a statistical test
       */

      class TestResult :
	public Common::PersistentObject
      {
	CLASSNAME;

      public:
        
        typedef Type::Description Description;

	/** Default constructor */
	TestResult();

	/** Parameters constructor */
	TestResult(const String & type,
		   const Bool binMeasure,
		   const NumericalScalar pVal,
		   const NumericalScalar pThreshold);


	/** Virtual constructor */
	virtual TestResult * clone() const;

	/** Description Accessor */
	void setDescription(const Description & description);
	Description getDescription() const;

	/** String converter */
	String __repr__() const;
	
	/** Elements accessors */
	Bool getBinaryQualityMeasure() const;
	NumericalScalar getPValue() const;
	NumericalScalar getThreshold() const;
	String getTestType() const;
	
	/** Comparison operator */
        Bool operator ==(const TestResult & rhs) const;  

      protected:

        String testType_;
        Bool binaryQualityMeasure_ ;
	NumericalScalar pValueThreshold_ ;
	NumericalScalar pValue_ ;
      

      private:

	/** The description of all components */
	Description description_;

      }
      ; /* class TestResult */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_TESTRESULT_HXX */
