//                                               -*- C++ -*-
/**
 *  @file  Cloud.hxx
 *  @brief Cloud class for cloud plots
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Cloud.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_CLOUD_HXX
#define OPENTURNS_CLOUD_HXX

#include "OTprivate.hxx"
#include "DrawableImplementation.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Graph {

      /**
       * @class Cloud
       *
       * The class describing a cloud plot
       * Instance of Drawable
       */

      class Cloud : public DrawableImplementation
      {
	CLASSNAME;
      public:
	
	typedef DrawableImplementation::NumericalSample          NumericalSample;
	typedef DrawableImplementation::InvalidArgumentException InvalidArgumentException;
	typedef DrawableImplementation::StorageManager           StorageManager;
	
	/** Default constructor */
	Cloud(const NumericalSample & data,
	      const String & legend=NoSpecifiedLabel)
	  /* throw(InvalidArgumentException) */;

	/** Contructor from 2 data sets */
	Cloud(const NumericalSample & dataX,
	      const NumericalSample & dataY,
	      const String & legend = NoSpecifiedLabel);

	/** Constructor with parameters */
	Cloud(const NumericalSample & data,
	      const String & color,
	      const String & pointStyle,
	      const String & legend=NoSpecifiedLabel)
	  /* throw(InvalidArgumentException) */;

	/** String converter */
	String __repr__() const;

	/** Draw method */
	String draw() const;

	/** Clone method */
	Cloud * clone() const;

	/** Check fo data validity */
	Bool isValidData(const NumericalSample & data) const;

 	/** Method save() stores the object through the StorageManager */
	void save(StorageManager::Advocate & adv) const;

 	/** Method load() stores the object through the StorageManager */
	void load(StorageManager::Advocate & adv);

      private:

	Cloud() {};
	friend class Base::Common::Factory<Cloud>;

      }; /* class Cloud */

    }/* namespace Graph */
  }/*namespace Base */
}/* namespace OpenTURNS */
#endif /* OPENTURNS_CLOUD_HXX */
