//                                               -*- C++ -*-
/**
 *  @file  Object.hxx
 *  @brief The class Object is the top-most class of Open TURNS
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Object.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_OBJECT_HXX
#define OPENTURNS_OBJECT_HXX

#include <iostream>              // for std::ostream
#include <sstream>               // for std::ostringstream
#include "OTprivate.hxx"



/** Declare GetClassName() and getClassName() for Object-like classes */

#define CLASSNAME						\
  public:							\
  /** Class name accessor */				        \
  static  const OT::String & GetClassName();			\
  virtual const OT::String & getClassName() const;		\
  private:							\
  /** The name of the class */					\
  static const OT::String ClassName_;



/** Define GetClassName() and getClassName() for Object-like classes */

#define CLASSNAMEINIT(T)						\
  const OT::String   T::ClassName_(#T);					\
  const OT::String & T::GetClassName()       { return T::ClassName_; }	\
  const OT::String & T::getClassName() const { return T::ClassName_; }


#define TEMPLATE_CLASSNAMEINIT(T)						\
  template<> const OT::String   T::ClassName_(#T);			\
  template<> const OT::String & T::GetClassName()       { return T::ClassName_; } \
  template<> const OT::String & T::getClassName() const { return T::ClassName_; }



namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class Object
       *
       * @brief The base classe for almost every object in Open TURNS.
       *
       * Object defines common methods needed by all classes.
       * These are default constructor, copy constructor, virtual
       * destructor, affectation operator, comparison operator and
       * string converters.
       * These methods should be overloaded by every derived class
       */

      class Object
      {
	CLASSNAME;
      public:

	/** Destructor */
	virtual ~Object() = 0;

	/**
	 * String converter
	 *
	 * This method shows human readable information on the
	 * internal state of an object. It is used when streaming
	 * the object or for user information.
	 *
	 * @return A string fully describing the object
	 */
	virtual String __repr__() const;


	/**
	 * Pretty string converter
	 *
	 * This method shows human readable information on the
	 * internal state of an object. It is used for printing the object
	 * and should only show relevant information.
	 *
	 * @return A human readable string
	 */
	virtual String __str__() const;


      protected:

      private:

      } ; /* class Object */

#ifndef SWIG
      /**
       * @fn std::ostream & operator <<(std::ostream & os, const Object & obj)
       * @brief Output stream converter
       * @param os A STL output stream object
       * @param obj The object read by \p os
       * @return A reference to \p os
       *
       * This method allows any Object-derived class to be streamed whitout
       * redefining this method. Each derived-class should have a public
       * method str() that returns a String.
       *
       * @sa String __repr__() const
       */
      std::ostream & operator <<(std::ostream & os, const Object & obj);

#endif

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_OBJECT_HXX */
