//                                               -*- C++ -*-
/**
 *  @file  Greater.hxx
 *  @brief Implementation of strict greater comparison
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Greater.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_GREATER_HXX
#define OPENTURNS_GREATER_HXX

#include "ComparisonOperatorImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {


      /**
       * @class Greater
       *
       * @brief The class implements the strict greater comparison
       *
       * This class is derived from ComparisonOperatorImplementation. It performs the comparison
       * of two NumericalScalar and is mainly used in threshold exceedence algorithms.
       */
      class Greater 
	: public ComparisonOperatorImplementation
      {
	CLASSNAME;
      public:

	/** Default constructor */
	explicit Greater();

	/* String converter */
	String __repr__() const;


	/* Here is the interface that all derived class must implement */

	/* Virtual constructor */
	virtual Greater * clone() const;

	/**
	 * Return true if a > b
	 * @param a The left hand side of the expression
	 * @param b The right hand side of the expression
	 * @return True if comparison succeeds
	 */
	virtual Bool operator() (NumericalScalar a, NumericalScalar b) const;

  	/* Method save() stores the object through the StorageManager */
	void save(StorageManager::Advocate & adv) const;

	/* Method load() reloads the object from the StorageManager */
	void load(StorageManager::Advocate & adv);
  
      }; /* class Greater */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_GREATER_HXX */
