#! /usr/bin/env python
# -*- coding: utf-8 -*-

#	Copyright 2010, David D Lowe
#	Copyright 2010-2013, Marten de Vries
#
#	This file is part of OpenTeacher.
#
#	OpenTeacher is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	OpenTeacher is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with OpenTeacher.  If not, see <http://www.gnu.org/licenses/>.

from distutils.core import setup
from distutils.extension import Extension

setup(
	name = "OpenTeacher",
	version = "3.2",
	description = "Your personal tutor",
	author = "OpenTeacher authors",
	author_email = "openteachermaintainers@lists.launchpad.net",
	url = "http://openteacher.org/",
	license = "GPLv3+",
	packages = [
		"openteacher",
		"openteacher.modules.org.openteacher.testserver.ot_testserver",
		"openteacher.modules.org.openteacher.testserver.ot_testserver.testserver",
		"openteacher.pyttsx",
		"openteacher.pyttsx.drivers",
	],
	package_data = {"openteacher": [
		"modules/org/openteacher/mimicryTypefaceConverter/mimicryTypefaceConverter.py",
		"modules/org/openteacher/flashcardexchangeApi/flashcardexchangeApi.py",
		"modules/org/openteacher/flashcardexchangeApi/translations/pt_BR.mo",
		"modules/org/openteacher/flashcardexchangeApi/translations/nl.po",
		"modules/org/openteacher/flashcardexchangeApi/translations/ru.po",
		"modules/org/openteacher/flashcardexchangeApi/translations/nl.mo",
		"modules/org/openteacher/flashcardexchangeApi/translations/zh_TW.po",
		"modules/org/openteacher/flashcardexchangeApi/translations/zh_TW.mo",
		"modules/org/openteacher/flashcardexchangeApi/translations/de.po",
		"modules/org/openteacher/flashcardexchangeApi/translations/pt_BR.po",
		"modules/org/openteacher/flashcardexchangeApi/translations/ru.mo",
		"modules/org/openteacher/flashcardexchangeApi/translations/org.openteacher.flashcardexchangeApi.pot",
		"modules/org/openteacher/flashcardexchangeApi/translations/tr.po",
		"modules/org/openteacher/flashcardexchangeApi/translations/de.mo",
		"modules/org/openteacher/flashcardexchangeApi/translations/tr.mo",
		"modules/org/openteacher/htmlGenerator/topo/template.html",
		"modules/org/openteacher/htmlGenerator/topo/topo.py",
		"modules/org/openteacher/htmlGenerator/media/media.py",
		"modules/org/openteacher/htmlGenerator/media/template.html",
		"modules/org/openteacher/htmlGenerator/words/words.py",
		"modules/org/openteacher/htmlGenerator/words/template.html",
		"modules/org/openteacher/noteCalculators/test/test.py",
		"modules/org/openteacher/noteCalculators/american/american.py",
		"modules/org/openteacher/noteCalculators/american/translations/fi.po",
		"modules/org/openteacher/noteCalculators/american/translations/si.po",
		"modules/org/openteacher/noteCalculators/american/translations/en_GB.po",
		"modules/org/openteacher/noteCalculators/american/translations/en_GB.mo",
		"modules/org/openteacher/noteCalculators/american/translations/fy.po",
		"modules/org/openteacher/noteCalculators/american/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/american/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/american/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/american/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/american/translations/es.po",
		"modules/org/openteacher/noteCalculators/american/translations/nl.po",
		"modules/org/openteacher/noteCalculators/american/translations/ru.po",
		"modules/org/openteacher/noteCalculators/american/translations/ar.po",
		"modules/org/openteacher/noteCalculators/american/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/american/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/american/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/american/translations/org.openteacher.noteCalculators.american.pot",
		"modules/org/openteacher/noteCalculators/american/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/american/translations/de.po",
		"modules/org/openteacher/noteCalculators/american/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/american/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/american/translations/es.mo",
		"modules/org/openteacher/noteCalculators/american/translations/gl.po",
		"modules/org/openteacher/noteCalculators/american/translations/ru.mo",
		"modules/org/openteacher/noteCalculators/american/translations/it.po",
		"modules/org/openteacher/noteCalculators/american/translations/it.mo",
		"modules/org/openteacher/noteCalculators/american/translations/tr.po",
		"modules/org/openteacher/noteCalculators/american/translations/de.mo",
		"modules/org/openteacher/noteCalculators/american/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/american/translations/si.mo",
		"modules/org/openteacher/noteCalculators/american/translations/cs.po",
		"modules/org/openteacher/noteCalculators/american/translations/gl.mo",
		"modules/org/openteacher/noteCalculators/american/translations/tr.mo",
		"modules/org/openteacher/noteCalculators/american/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/american/translations/fr.po",
		"modules/org/openteacher/noteCalculators/french/french.py",
		"modules/org/openteacher/noteCalculators/french/translations/fi.po",
		"modules/org/openteacher/noteCalculators/french/translations/si.po",
		"modules/org/openteacher/noteCalculators/french/translations/en_GB.po",
		"modules/org/openteacher/noteCalculators/french/translations/en_GB.mo",
		"modules/org/openteacher/noteCalculators/french/translations/fy.po",
		"modules/org/openteacher/noteCalculators/french/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/french/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/french/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/french/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/french/translations/es.po",
		"modules/org/openteacher/noteCalculators/french/translations/nl.po",
		"modules/org/openteacher/noteCalculators/french/translations/ru.po",
		"modules/org/openteacher/noteCalculators/french/translations/ar.po",
		"modules/org/openteacher/noteCalculators/french/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/french/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/french/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/french/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/french/translations/de.po",
		"modules/org/openteacher/noteCalculators/french/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/french/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/french/translations/es.mo",
		"modules/org/openteacher/noteCalculators/french/translations/gl.po",
		"modules/org/openteacher/noteCalculators/french/translations/ru.mo",
		"modules/org/openteacher/noteCalculators/french/translations/it.po",
		"modules/org/openteacher/noteCalculators/french/translations/org.openteacher.noteCalculators.french.pot",
		"modules/org/openteacher/noteCalculators/french/translations/it.mo",
		"modules/org/openteacher/noteCalculators/french/translations/tr.po",
		"modules/org/openteacher/noteCalculators/french/translations/de.mo",
		"modules/org/openteacher/noteCalculators/french/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/french/translations/si.mo",
		"modules/org/openteacher/noteCalculators/french/translations/cs.po",
		"modules/org/openteacher/noteCalculators/french/translations/gl.mo",
		"modules/org/openteacher/noteCalculators/french/translations/tr.mo",
		"modules/org/openteacher/noteCalculators/french/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/french/translations/fr.po",
		"modules/org/openteacher/noteCalculators/german/german.py",
		"modules/org/openteacher/noteCalculators/german/translations/fi.po",
		"modules/org/openteacher/noteCalculators/german/translations/si.po",
		"modules/org/openteacher/noteCalculators/german/translations/fy.po",
		"modules/org/openteacher/noteCalculators/german/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/german/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/german/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/german/translations/org.openteacher.noteCalculators.german.pot",
		"modules/org/openteacher/noteCalculators/german/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/german/translations/es.po",
		"modules/org/openteacher/noteCalculators/german/translations/nl.po",
		"modules/org/openteacher/noteCalculators/german/translations/ru.po",
		"modules/org/openteacher/noteCalculators/german/translations/ar.po",
		"modules/org/openteacher/noteCalculators/german/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/german/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/german/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/german/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/german/translations/de.po",
		"modules/org/openteacher/noteCalculators/german/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/german/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/german/translations/es.mo",
		"modules/org/openteacher/noteCalculators/german/translations/gl.po",
		"modules/org/openteacher/noteCalculators/german/translations/ru.mo",
		"modules/org/openteacher/noteCalculators/german/translations/it.po",
		"modules/org/openteacher/noteCalculators/german/translations/it.mo",
		"modules/org/openteacher/noteCalculators/german/translations/tr.po",
		"modules/org/openteacher/noteCalculators/german/translations/de.mo",
		"modules/org/openteacher/noteCalculators/german/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/german/translations/si.mo",
		"modules/org/openteacher/noteCalculators/german/translations/cs.po",
		"modules/org/openteacher/noteCalculators/german/translations/gl.mo",
		"modules/org/openteacher/noteCalculators/german/translations/tr.mo",
		"modules/org/openteacher/noteCalculators/german/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/german/translations/fr.po",
		"modules/org/openteacher/noteCalculators/percents/percents.py",
		"modules/org/openteacher/noteCalculators/percents/translations/fi.po",
		"modules/org/openteacher/noteCalculators/percents/translations/si.po",
		"modules/org/openteacher/noteCalculators/percents/translations/fy.po",
		"modules/org/openteacher/noteCalculators/percents/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/pl.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/es.po",
		"modules/org/openteacher/noteCalculators/percents/translations/nl.po",
		"modules/org/openteacher/noteCalculators/percents/translations/ru.po",
		"modules/org/openteacher/noteCalculators/percents/translations/ar.po",
		"modules/org/openteacher/noteCalculators/percents/translations/pl.po",
		"modules/org/openteacher/noteCalculators/percents/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/org.openteacher.noteCalculators.percents.pot",
		"modules/org/openteacher/noteCalculators/percents/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/percents/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/percents/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/de.po",
		"modules/org/openteacher/noteCalculators/percents/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/percents/translations/es.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/gl.po",
		"modules/org/openteacher/noteCalculators/percents/translations/ru.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/it.po",
		"modules/org/openteacher/noteCalculators/percents/translations/it.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/tr.po",
		"modules/org/openteacher/noteCalculators/percents/translations/de.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/si.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/cs.po",
		"modules/org/openteacher/noteCalculators/percents/translations/gl.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/tr.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/fr.po",
		"modules/org/openteacher/noteCalculators/dutch/dutch.py",
		"modules/org/openteacher/noteCalculators/dutch/translations/fi.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/si.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/fy.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/hu.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/es.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/nl.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/org.openteacher.noteCalculators.dutch.pot",
		"modules/org/openteacher/noteCalculators/dutch/translations/ru.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/ar.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/de.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/es.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/gl.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/ru.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/it.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/hu.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/it.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/tr.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/de.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/si.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/cs.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/gl.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/el.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/tr.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/el.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/fr.po",
		"modules/org/openteacher/noteCalculators/ects/ects.py",
		"modules/org/openteacher/noteCalculators/ects/translations/fi.po",
		"modules/org/openteacher/noteCalculators/ects/translations/si.po",
		"modules/org/openteacher/noteCalculators/ects/translations/fy.po",
		"modules/org/openteacher/noteCalculators/ects/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/org.openteacher.noteCalculators.ects.pot",
		"modules/org/openteacher/noteCalculators/ects/translations/pl.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/es.po",
		"modules/org/openteacher/noteCalculators/ects/translations/nl.po",
		"modules/org/openteacher/noteCalculators/ects/translations/ru.po",
		"modules/org/openteacher/noteCalculators/ects/translations/ar.po",
		"modules/org/openteacher/noteCalculators/ects/translations/pl.po",
		"modules/org/openteacher/noteCalculators/ects/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/ects/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/ects/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/de.po",
		"modules/org/openteacher/noteCalculators/ects/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/ects/translations/es.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/ru.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/it.po",
		"modules/org/openteacher/noteCalculators/ects/translations/it.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/tr.po",
		"modules/org/openteacher/noteCalculators/ects/translations/de.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/si.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/cs.po",
		"modules/org/openteacher/noteCalculators/ects/translations/tr.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/fr.po",
		"modules/org/openteacher/typingTutor/model/model.py",
		"modules/org/openteacher/typingTutor/model/words.txt",
		"modules/org/openteacher/typingTutor/model/translations/pt_BR.mo",
		"modules/org/openteacher/typingTutor/model/translations/zh_CN.mo",
		"modules/org/openteacher/typingTutor/model/translations/pl.mo",
		"modules/org/openteacher/typingTutor/model/translations/fr.mo",
		"modules/org/openteacher/typingTutor/model/translations/es.po",
		"modules/org/openteacher/typingTutor/model/translations/nl.po",
		"modules/org/openteacher/typingTutor/model/translations/org.openteacher.typingTutor.model.pot",
		"modules/org/openteacher/typingTutor/model/translations/ru.po",
		"modules/org/openteacher/typingTutor/model/translations/pl.po",
		"modules/org/openteacher/typingTutor/model/translations/nl.mo",
		"modules/org/openteacher/typingTutor/model/translations/zh_CN.po",
		"modules/org/openteacher/typingTutor/model/translations/zh_TW.po",
		"modules/org/openteacher/typingTutor/model/translations/zh_TW.mo",
		"modules/org/openteacher/typingTutor/model/translations/de.po",
		"modules/org/openteacher/typingTutor/model/translations/pt_BR.po",
		"modules/org/openteacher/typingTutor/model/translations/es.mo",
		"modules/org/openteacher/typingTutor/model/translations/ru.mo",
		"modules/org/openteacher/typingTutor/model/translations/tr.po",
		"modules/org/openteacher/typingTutor/model/translations/de.mo",
		"modules/org/openteacher/typingTutor/model/translations/tr.mo",
		"modules/org/openteacher/typingTutor/model/translations/fr.po",
		"modules/org/openteacher/typingTutor/main/main.py",
		"modules/org/openteacher/typingTutor/main/typingTutor.png.COPYING",
		"modules/org/openteacher/typingTutor/main/typingTutor.png",
		"modules/org/openteacher/typingTutor/main/translations/fy.po",
		"modules/org/openteacher/typingTutor/main/translations/pt_BR.mo",
		"modules/org/openteacher/typingTutor/main/translations/cs.mo",
		"modules/org/openteacher/typingTutor/main/translations/pl.mo",
		"modules/org/openteacher/typingTutor/main/translations/fr.mo",
		"modules/org/openteacher/typingTutor/main/translations/nl.po",
		"modules/org/openteacher/typingTutor/main/translations/ru.po",
		"modules/org/openteacher/typingTutor/main/translations/pl.po",
		"modules/org/openteacher/typingTutor/main/translations/nl.mo",
		"modules/org/openteacher/typingTutor/main/translations/zh_TW.po",
		"modules/org/openteacher/typingTutor/main/translations/zh_TW.mo",
		"modules/org/openteacher/typingTutor/main/translations/de.po",
		"modules/org/openteacher/typingTutor/main/translations/pt_BR.po",
		"modules/org/openteacher/typingTutor/main/translations/ru.mo",
		"modules/org/openteacher/typingTutor/main/translations/org.openteacher.typingTutor.main.pot",
		"modules/org/openteacher/typingTutor/main/translations/de.mo",
		"modules/org/openteacher/typingTutor/main/translations/cs.po",
		"modules/org/openteacher/typingTutor/main/translations/fy.mo",
		"modules/org/openteacher/typingTutor/main/translations/fr.po",
		"modules/org/openteacher/typingTutor/modelTest/modelTest.py",
		"modules/org/openteacher/typingTutor/keyboard/keyboard.py",
		"modules/org/openteacher/event/event.py",
		"modules/org/openteacher/chars/test/test.py",
		"modules/org/openteacher/chars/cyrillic/cyrillic.py",
		"modules/org/openteacher/chars/cyrillic/translations/fi.po",
		"modules/org/openteacher/chars/cyrillic/translations/fy.po",
		"modules/org/openteacher/chars/cyrillic/translations/pt_BR.mo",
		"modules/org/openteacher/chars/cyrillic/translations/hu.po",
		"modules/org/openteacher/chars/cyrillic/translations/zh_CN.mo",
		"modules/org/openteacher/chars/cyrillic/translations/cs.mo",
		"modules/org/openteacher/chars/cyrillic/translations/pl.mo",
		"modules/org/openteacher/chars/cyrillic/translations/fr.mo",
		"modules/org/openteacher/chars/cyrillic/translations/es.po",
		"modules/org/openteacher/chars/cyrillic/translations/nl.po",
		"modules/org/openteacher/chars/cyrillic/translations/ru.po",
		"modules/org/openteacher/chars/cyrillic/translations/ar.po",
		"modules/org/openteacher/chars/cyrillic/translations/pl.po",
		"modules/org/openteacher/chars/cyrillic/translations/nl.mo",
		"modules/org/openteacher/chars/cyrillic/translations/zh_CN.po",
		"modules/org/openteacher/chars/cyrillic/translations/zh_TW.po",
		"modules/org/openteacher/chars/cyrillic/translations/zh_TW.mo",
		"modules/org/openteacher/chars/cyrillic/translations/de.po",
		"modules/org/openteacher/chars/cyrillic/translations/ar.mo",
		"modules/org/openteacher/chars/cyrillic/translations/pt_BR.po",
		"modules/org/openteacher/chars/cyrillic/translations/es.mo",
		"modules/org/openteacher/chars/cyrillic/translations/ru.mo",
		"modules/org/openteacher/chars/cyrillic/translations/hu.mo",
		"modules/org/openteacher/chars/cyrillic/translations/tr.po",
		"modules/org/openteacher/chars/cyrillic/translations/de.mo",
		"modules/org/openteacher/chars/cyrillic/translations/fi.mo",
		"modules/org/openteacher/chars/cyrillic/translations/cs.po",
		"modules/org/openteacher/chars/cyrillic/translations/org.openteacher.chars.cyrillic.pot",
		"modules/org/openteacher/chars/cyrillic/translations/el.po",
		"modules/org/openteacher/chars/cyrillic/translations/tr.mo",
		"modules/org/openteacher/chars/cyrillic/translations/fy.mo",
		"modules/org/openteacher/chars/cyrillic/translations/el.mo",
		"modules/org/openteacher/chars/cyrillic/translations/fr.po",
		"modules/org/openteacher/chars/greek/greek.py",
		"modules/org/openteacher/chars/greek/translations/fi.po",
		"modules/org/openteacher/chars/greek/translations/si.po",
		"modules/org/openteacher/chars/greek/translations/fy.po",
		"modules/org/openteacher/chars/greek/translations/pt_BR.mo",
		"modules/org/openteacher/chars/greek/translations/hu.po",
		"modules/org/openteacher/chars/greek/translations/zh_CN.mo",
		"modules/org/openteacher/chars/greek/translations/cs.mo",
		"modules/org/openteacher/chars/greek/translations/org.openteacher.chars.greek.pot",
		"modules/org/openteacher/chars/greek/translations/pl.mo",
		"modules/org/openteacher/chars/greek/translations/fr.mo",
		"modules/org/openteacher/chars/greek/translations/es.po",
		"modules/org/openteacher/chars/greek/translations/nl.po",
		"modules/org/openteacher/chars/greek/translations/ru.po",
		"modules/org/openteacher/chars/greek/translations/ar.po",
		"modules/org/openteacher/chars/greek/translations/pl.po",
		"modules/org/openteacher/chars/greek/translations/nl.mo",
		"modules/org/openteacher/chars/greek/translations/zh_CN.po",
		"modules/org/openteacher/chars/greek/translations/zh_TW.po",
		"modules/org/openteacher/chars/greek/translations/zh_TW.mo",
		"modules/org/openteacher/chars/greek/translations/de.po",
		"modules/org/openteacher/chars/greek/translations/ar.mo",
		"modules/org/openteacher/chars/greek/translations/pt_BR.po",
		"modules/org/openteacher/chars/greek/translations/es.mo",
		"modules/org/openteacher/chars/greek/translations/ru.mo",
		"modules/org/openteacher/chars/greek/translations/hu.mo",
		"modules/org/openteacher/chars/greek/translations/tr.po",
		"modules/org/openteacher/chars/greek/translations/de.mo",
		"modules/org/openteacher/chars/greek/translations/fi.mo",
		"modules/org/openteacher/chars/greek/translations/si.mo",
		"modules/org/openteacher/chars/greek/translations/cs.po",
		"modules/org/openteacher/chars/greek/translations/el.po",
		"modules/org/openteacher/chars/greek/translations/tr.mo",
		"modules/org/openteacher/chars/greek/translations/fy.mo",
		"modules/org/openteacher/chars/greek/translations/el.mo",
		"modules/org/openteacher/chars/greek/translations/fr.po",
		"modules/org/openteacher/chars/symbols/symbols.py",
		"modules/org/openteacher/chars/symbols/translations/fi.po",
		"modules/org/openteacher/chars/symbols/translations/ja.mo",
		"modules/org/openteacher/chars/symbols/translations/si.po",
		"modules/org/openteacher/chars/symbols/translations/fy.po",
		"modules/org/openteacher/chars/symbols/translations/pt_BR.mo",
		"modules/org/openteacher/chars/symbols/translations/hu.po",
		"modules/org/openteacher/chars/symbols/translations/zh_CN.mo",
		"modules/org/openteacher/chars/symbols/translations/cs.mo",
		"modules/org/openteacher/chars/symbols/translations/pl.mo",
		"modules/org/openteacher/chars/symbols/translations/fr.mo",
		"modules/org/openteacher/chars/symbols/translations/es.po",
		"modules/org/openteacher/chars/symbols/translations/nl.po",
		"modules/org/openteacher/chars/symbols/translations/ru.po",
		"modules/org/openteacher/chars/symbols/translations/ar.po",
		"modules/org/openteacher/chars/symbols/translations/pl.po",
		"modules/org/openteacher/chars/symbols/translations/nl.mo",
		"modules/org/openteacher/chars/symbols/translations/zh_CN.po",
		"modules/org/openteacher/chars/symbols/translations/zh_TW.po",
		"modules/org/openteacher/chars/symbols/translations/zh_TW.mo",
		"modules/org/openteacher/chars/symbols/translations/de.po",
		"modules/org/openteacher/chars/symbols/translations/ar.mo",
		"modules/org/openteacher/chars/symbols/translations/pt_BR.po",
		"modules/org/openteacher/chars/symbols/translations/es.mo",
		"modules/org/openteacher/chars/symbols/translations/ja.po",
		"modules/org/openteacher/chars/symbols/translations/ru.mo",
		"modules/org/openteacher/chars/symbols/translations/hu.mo",
		"modules/org/openteacher/chars/symbols/translations/tr.po",
		"modules/org/openteacher/chars/symbols/translations/de.mo",
		"modules/org/openteacher/chars/symbols/translations/fi.mo",
		"modules/org/openteacher/chars/symbols/translations/si.mo",
		"modules/org/openteacher/chars/symbols/translations/org.openteacher.chars.symbols.pot",
		"modules/org/openteacher/chars/symbols/translations/cs.po",
		"modules/org/openteacher/chars/symbols/translations/el.po",
		"modules/org/openteacher/chars/symbols/translations/tr.mo",
		"modules/org/openteacher/chars/symbols/translations/fy.mo",
		"modules/org/openteacher/chars/symbols/translations/el.mo",
		"modules/org/openteacher/chars/symbols/translations/fr.po",
		"modules/org/openteacher/modules/modules.py",
		"modules/org/openteacher/lessonTypes/test/test.py",
		"modules/org/openteacher/lessonTypes/allOnce/allOnce.py",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fi.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ja.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/si.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/en_GB.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/en_GB.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fy.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/pt_BR.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/hu.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/zh_CN.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/cs.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/pl.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fr.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/es.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/nl.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ru.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ar.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/mus.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/pl.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/nl.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/zh_CN.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/zh_TW.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/zh_TW.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/de.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ar.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/pt_BR.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/es.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ja.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ru.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/it.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/hu.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/it.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/tr.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/de.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fi.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/sk.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/si.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/cs.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/el.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/tr.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fy.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/mus.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/el.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/org.openteacher.lessonTypes.allOnce.pot",
		"modules/org/openteacher/lessonTypes/allOnce/translations/sk.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fr.po",
		"modules/org/openteacher/lessonTypes/interval/interval.py",
		"modules/org/openteacher/lessonTypes/interval/translations/fi.po",
		"modules/org/openteacher/lessonTypes/interval/translations/ja.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/si.po",
		"modules/org/openteacher/lessonTypes/interval/translations/fy.po",
		"modules/org/openteacher/lessonTypes/interval/translations/pt_BR.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/hu.po",
		"modules/org/openteacher/lessonTypes/interval/translations/zh_CN.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/cs.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/pl.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/fr.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/es.po",
		"modules/org/openteacher/lessonTypes/interval/translations/nl.po",
		"modules/org/openteacher/lessonTypes/interval/translations/ru.po",
		"modules/org/openteacher/lessonTypes/interval/translations/ar.po",
		"modules/org/openteacher/lessonTypes/interval/translations/pl.po",
		"modules/org/openteacher/lessonTypes/interval/translations/nl.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/zh_CN.po",
		"modules/org/openteacher/lessonTypes/interval/translations/zh_TW.po",
		"modules/org/openteacher/lessonTypes/interval/translations/zh_TW.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/org.openteacher.lessonTypes.interval.pot",
		"modules/org/openteacher/lessonTypes/interval/translations/de.po",
		"modules/org/openteacher/lessonTypes/interval/translations/ar.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/pt_BR.po",
		"modules/org/openteacher/lessonTypes/interval/translations/es.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/gl.po",
		"modules/org/openteacher/lessonTypes/interval/translations/ja.po",
		"modules/org/openteacher/lessonTypes/interval/translations/ru.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/it.po",
		"modules/org/openteacher/lessonTypes/interval/translations/hu.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/it.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/tr.po",
		"modules/org/openteacher/lessonTypes/interval/translations/de.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/fi.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/si.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/cs.po",
		"modules/org/openteacher/lessonTypes/interval/translations/gl.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/el.po",
		"modules/org/openteacher/lessonTypes/interval/translations/tr.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/fy.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/el.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/fr.po",
		"modules/org/openteacher/lessonTypes/smart/smart.py",
		"modules/org/openteacher/lessonTypes/smart/translations/fi.po",
		"modules/org/openteacher/lessonTypes/smart/translations/ja.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/en_GB.po",
		"modules/org/openteacher/lessonTypes/smart/translations/en_GB.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/fy.po",
		"modules/org/openteacher/lessonTypes/smart/translations/pt_BR.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/hu.po",
		"modules/org/openteacher/lessonTypes/smart/translations/zh_CN.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/cs.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/org.openteacher.lessonTypes.smart.pot",
		"modules/org/openteacher/lessonTypes/smart/translations/pl.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/fr.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/es.po",
		"modules/org/openteacher/lessonTypes/smart/translations/nl.po",
		"modules/org/openteacher/lessonTypes/smart/translations/ru.po",
		"modules/org/openteacher/lessonTypes/smart/translations/ar.po",
		"modules/org/openteacher/lessonTypes/smart/translations/pl.po",
		"modules/org/openteacher/lessonTypes/smart/translations/nl.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/zh_CN.po",
		"modules/org/openteacher/lessonTypes/smart/translations/zh_TW.po",
		"modules/org/openteacher/lessonTypes/smart/translations/zh_TW.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/de.po",
		"modules/org/openteacher/lessonTypes/smart/translations/ar.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/pt_BR.po",
		"modules/org/openteacher/lessonTypes/smart/translations/es.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/gl.po",
		"modules/org/openteacher/lessonTypes/smart/translations/ja.po",
		"modules/org/openteacher/lessonTypes/smart/translations/ru.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/it.po",
		"modules/org/openteacher/lessonTypes/smart/translations/hu.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/it.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/tr.po",
		"modules/org/openteacher/lessonTypes/smart/translations/de.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/fi.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/sk.po",
		"modules/org/openteacher/lessonTypes/smart/translations/cs.po",
		"modules/org/openteacher/lessonTypes/smart/translations/gl.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/el.po",
		"modules/org/openteacher/lessonTypes/smart/translations/tr.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/fy.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/el.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/sk.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/fr.po",
		"modules/org/openteacher/userDocumentation/getting-started.html",
		"modules/org/openteacher/userDocumentation/userDocumentation.py",
		"modules/org/openteacher/userDocumentation/translations/pt_BR.mo",
		"modules/org/openteacher/userDocumentation/translations/zh_CN.mo",
		"modules/org/openteacher/userDocumentation/translations/es.po",
		"modules/org/openteacher/userDocumentation/translations/nl.po",
		"modules/org/openteacher/userDocumentation/translations/ru.po",
		"modules/org/openteacher/userDocumentation/translations/nl.mo",
		"modules/org/openteacher/userDocumentation/translations/zh_CN.po",
		"modules/org/openteacher/userDocumentation/translations/zh_TW.po",
		"modules/org/openteacher/userDocumentation/translations/zh_TW.mo",
		"modules/org/openteacher/userDocumentation/translations/de.po",
		"modules/org/openteacher/userDocumentation/translations/pt_BR.po",
		"modules/org/openteacher/userDocumentation/translations/es.mo",
		"modules/org/openteacher/userDocumentation/translations/ru.mo",
		"modules/org/openteacher/userDocumentation/translations/tr.po",
		"modules/org/openteacher/userDocumentation/translations/de.mo",
		"modules/org/openteacher/userDocumentation/translations/org.openteacher.userDocumentation.pot",
		"modules/org/openteacher/userDocumentation/translations/tr.mo",
		"modules/org/openteacher/userDocumentation/static/qs5.png",
		"modules/org/openteacher/userDocumentation/static/inst2.png",
		"modules/org/openteacher/userDocumentation/static/qs6.png",
		"modules/org/openteacher/userDocumentation/static/qs2.png",
		"modules/org/openteacher/userDocumentation/static/qs4.png",
		"modules/org/openteacher/noteCalculatorChooser/noteCalculatorChooser.py",
		"modules/org/openteacher/noteCalculatorChooser/translations/fy.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/org.openteacher.noteCalculatorChooser.pot",
		"modules/org/openteacher/noteCalculatorChooser/translations/fr.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/es.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/nl.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/ru.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/nl.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/de.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/es.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/gl.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/ru.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/tr.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/de.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/gl.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/tr.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/fy.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/fr.po",
		"modules/org/openteacher/startWidget/startWidget.py",
		"modules/org/openteacher/startWidget/translations/en_GB.po",
		"modules/org/openteacher/startWidget/translations/en_GB.mo",
		"modules/org/openteacher/startWidget/translations/fy.po",
		"modules/org/openteacher/startWidget/translations/pt_BR.mo",
		"modules/org/openteacher/startWidget/translations/hu.po",
		"modules/org/openteacher/startWidget/translations/zh_CN.mo",
		"modules/org/openteacher/startWidget/translations/cs.mo",
		"modules/org/openteacher/startWidget/translations/en_AU.mo",
		"modules/org/openteacher/startWidget/translations/pl.mo",
		"modules/org/openteacher/startWidget/translations/fr.mo",
		"modules/org/openteacher/startWidget/translations/es.po",
		"modules/org/openteacher/startWidget/translations/nl.po",
		"modules/org/openteacher/startWidget/translations/ru.po",
		"modules/org/openteacher/startWidget/translations/ar.po",
		"modules/org/openteacher/startWidget/translations/pl.po",
		"modules/org/openteacher/startWidget/translations/nl.mo",
		"modules/org/openteacher/startWidget/translations/zh_CN.po",
		"modules/org/openteacher/startWidget/translations/zh_TW.po",
		"modules/org/openteacher/startWidget/translations/zh_TW.mo",
		"modules/org/openteacher/startWidget/translations/de.po",
		"modules/org/openteacher/startWidget/translations/ar.mo",
		"modules/org/openteacher/startWidget/translations/pt_BR.po",
		"modules/org/openteacher/startWidget/translations/es.mo",
		"modules/org/openteacher/startWidget/translations/gl.po",
		"modules/org/openteacher/startWidget/translations/ru.mo",
		"modules/org/openteacher/startWidget/translations/it.po",
		"modules/org/openteacher/startWidget/translations/hu.mo",
		"modules/org/openteacher/startWidget/translations/it.mo",
		"modules/org/openteacher/startWidget/translations/tr.po",
		"modules/org/openteacher/startWidget/translations/de.mo",
		"modules/org/openteacher/startWidget/translations/sk.po",
		"modules/org/openteacher/startWidget/translations/cs.po",
		"modules/org/openteacher/startWidget/translations/gl.mo",
		"modules/org/openteacher/startWidget/translations/tr.mo",
		"modules/org/openteacher/startWidget/translations/en_AU.po",
		"modules/org/openteacher/startWidget/translations/fy.mo",
		"modules/org/openteacher/startWidget/translations/sk.mo",
		"modules/org/openteacher/startWidget/translations/fr.po",
		"modules/org/openteacher/startWidget/translations/org.openteacher.startWidget.pot",
		"modules/org/openteacher/teachTypes/repeatAnswer/repeatAnswer.py",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fi.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ja.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/si.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fy.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/pt_BR.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/hu.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/zh_CN.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/cs.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fr.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/es.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/nl.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ru.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ar.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/nl.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/zh_CN.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/zh_TW.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/org.openteacher.teachTypes.repeatAnswer.pot",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/zh_TW.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/de.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ar.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/pt_BR.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/es.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/gl.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ja.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ru.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/hu.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/tr.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/de.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fi.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/sk.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/si.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/cs.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/gl.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/el.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/tr.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fy.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/el.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/sk.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fr.po",
		"modules/org/openteacher/teachTypes/typing/typing.py",
		"modules/org/openteacher/teachTypes/typing/translations/fi.po",
		"modules/org/openteacher/teachTypes/typing/translations/ja.mo",
		"modules/org/openteacher/teachTypes/typing/translations/si.po",
		"modules/org/openteacher/teachTypes/typing/translations/fy.po",
		"modules/org/openteacher/teachTypes/typing/translations/pt_BR.mo",
		"modules/org/openteacher/teachTypes/typing/translations/hu.po",
		"modules/org/openteacher/teachTypes/typing/translations/zh_CN.mo",
		"modules/org/openteacher/teachTypes/typing/translations/cs.mo",
		"modules/org/openteacher/teachTypes/typing/translations/pl.mo",
		"modules/org/openteacher/teachTypes/typing/translations/fr.mo",
		"modules/org/openteacher/teachTypes/typing/translations/es.po",
		"modules/org/openteacher/teachTypes/typing/translations/nl.po",
		"modules/org/openteacher/teachTypes/typing/translations/ru.po",
		"modules/org/openteacher/teachTypes/typing/translations/ar.po",
		"modules/org/openteacher/teachTypes/typing/translations/pl.po",
		"modules/org/openteacher/teachTypes/typing/translations/nl.mo",
		"modules/org/openteacher/teachTypes/typing/translations/zh_CN.po",
		"modules/org/openteacher/teachTypes/typing/translations/zh_TW.po",
		"modules/org/openteacher/teachTypes/typing/translations/af.po",
		"modules/org/openteacher/teachTypes/typing/translations/zh_TW.mo",
		"modules/org/openteacher/teachTypes/typing/translations/de.po",
		"modules/org/openteacher/teachTypes/typing/translations/ar.mo",
		"modules/org/openteacher/teachTypes/typing/translations/pt_BR.po",
		"modules/org/openteacher/teachTypes/typing/translations/es.mo",
		"modules/org/openteacher/teachTypes/typing/translations/gl.po",
		"modules/org/openteacher/teachTypes/typing/translations/ja.po",
		"modules/org/openteacher/teachTypes/typing/translations/ru.mo",
		"modules/org/openteacher/teachTypes/typing/translations/hu.mo",
		"modules/org/openteacher/teachTypes/typing/translations/org.openteacher.teachTypes.typing.pot",
		"modules/org/openteacher/teachTypes/typing/translations/tr.po",
		"modules/org/openteacher/teachTypes/typing/translations/de.mo",
		"modules/org/openteacher/teachTypes/typing/translations/fi.mo",
		"modules/org/openteacher/teachTypes/typing/translations/sk.po",
		"modules/org/openteacher/teachTypes/typing/translations/si.mo",
		"modules/org/openteacher/teachTypes/typing/translations/af.mo",
		"modules/org/openteacher/teachTypes/typing/translations/cs.po",
		"modules/org/openteacher/teachTypes/typing/translations/gl.mo",
		"modules/org/openteacher/teachTypes/typing/translations/el.po",
		"modules/org/openteacher/teachTypes/typing/translations/tr.mo",
		"modules/org/openteacher/teachTypes/typing/translations/fy.mo",
		"modules/org/openteacher/teachTypes/typing/translations/el.mo",
		"modules/org/openteacher/teachTypes/typing/translations/sk.mo",
		"modules/org/openteacher/teachTypes/typing/translations/fr.po",
		"modules/org/openteacher/teachTypes/hangman/hangman.py",
		"modules/org/openteacher/teachTypes/hangman/word.py",
		"modules/org/openteacher/teachTypes/hangman/graphics.py",
		"modules/org/openteacher/teachTypes/hangman/translations/fy.po",
		"modules/org/openteacher/teachTypes/hangman/translations/pt_BR.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/zh_CN.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/cs.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/pl.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/fr.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/es.po",
		"modules/org/openteacher/teachTypes/hangman/translations/nl.po",
		"modules/org/openteacher/teachTypes/hangman/translations/ru.po",
		"modules/org/openteacher/teachTypes/hangman/translations/pl.po",
		"modules/org/openteacher/teachTypes/hangman/translations/nl.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/zh_CN.po",
		"modules/org/openteacher/teachTypes/hangman/translations/zh_TW.po",
		"modules/org/openteacher/teachTypes/hangman/translations/zh_TW.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/de.po",
		"modules/org/openteacher/teachTypes/hangman/translations/pt_BR.po",
		"modules/org/openteacher/teachTypes/hangman/translations/es.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/ru.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/org.openteacher.teachTypes.hangman.pot",
		"modules/org/openteacher/teachTypes/hangman/translations/tr.po",
		"modules/org/openteacher/teachTypes/hangman/translations/de.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/cs.po",
		"modules/org/openteacher/teachTypes/hangman/translations/tr.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/fy.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/fr.po",
		"modules/org/openteacher/teachTypes/inMind/inMind.py",
		"modules/org/openteacher/teachTypes/inMind/translations/fi.po",
		"modules/org/openteacher/teachTypes/inMind/translations/ja.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/si.po",
		"modules/org/openteacher/teachTypes/inMind/translations/fy.po",
		"modules/org/openteacher/teachTypes/inMind/translations/pt_BR.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/hu.po",
		"modules/org/openteacher/teachTypes/inMind/translations/zh_CN.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/cs.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/pl.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/fr.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/es.po",
		"modules/org/openteacher/teachTypes/inMind/translations/org.openteacher.teachTypes.inMind.pot",
		"modules/org/openteacher/teachTypes/inMind/translations/nl.po",
		"modules/org/openteacher/teachTypes/inMind/translations/ru.po",
		"modules/org/openteacher/teachTypes/inMind/translations/ar.po",
		"modules/org/openteacher/teachTypes/inMind/translations/pl.po",
		"modules/org/openteacher/teachTypes/inMind/translations/nl.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/zh_CN.po",
		"modules/org/openteacher/teachTypes/inMind/translations/zh_TW.po",
		"modules/org/openteacher/teachTypes/inMind/translations/zh_TW.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/de.po",
		"modules/org/openteacher/teachTypes/inMind/translations/ar.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/pt_BR.po",
		"modules/org/openteacher/teachTypes/inMind/translations/es.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/gl.po",
		"modules/org/openteacher/teachTypes/inMind/translations/ja.po",
		"modules/org/openteacher/teachTypes/inMind/translations/ru.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/hu.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/tr.po",
		"modules/org/openteacher/teachTypes/inMind/translations/de.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/fi.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/sk.po",
		"modules/org/openteacher/teachTypes/inMind/translations/si.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/cs.po",
		"modules/org/openteacher/teachTypes/inMind/translations/gl.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/el.po",
		"modules/org/openteacher/teachTypes/inMind/translations/tr.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/fy.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/el.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/sk.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/fr.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/shuffleAnswer.py",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fi.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ja.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/si.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fy.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/pt_BR.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/hu.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/zh_CN.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/cs.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/pl.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fr.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/es.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/nl.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ru.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ar.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/pl.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/nl.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/zh_CN.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/zh_TW.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/af.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/zh_TW.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/de.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ar.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/pt_BR.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/es.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ja.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ru.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/hu.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/tr.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/de.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fi.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/sk.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/si.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/af.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/org.openteacher.teachTypes.shuffleAnswer.pot",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/cs.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/el.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/tr.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fy.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/el.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/sk.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fr.po",
		"modules/org/openteacher/dataStore/dataStore.py",
		"modules/org/openteacher/websiteGenerator/index.php",
		"modules/org/openteacher/websiteGenerator/documentation.html",
		"modules/org/openteacher/websiteGenerator/style.css",
		"modules/org/openteacher/websiteGenerator/websiteGenerator.py",
		"modules/org/openteacher/websiteGenerator/images/information.png",
		"modules/org/openteacher/websiteGenerator/images/gnu150.png",
		"modules/org/openteacher/websiteGenerator/images/screens/3.0-windows-teach.png",
		"modules/org/openteacher/websiteGenerator/images/screens/3.0-ubuntu-enter-thumb.png",
		"modules/org/openteacher/websiteGenerator/images/screens/3.0-windows-topo.png",
		"modules/org/openteacher/websiteGenerator/images/screens/3.0-windows-topo-thumb.png",
		"modules/org/openteacher/websiteGenerator/images/screens/2.-test-mac.png",
		"modules/org/openteacher/websiteGenerator/images/screens/3.0-windows-media-thumb.png",
		"modules/org/openteacher/websiteGenerator/images/screens/3.0-windows-teach-thumb.png",
		"modules/org/openteacher/websiteGenerator/images/screens/3.0-windows-media.png",
		"modules/org/openteacher/websiteGenerator/images/screens/2.-test-mac-thumb.png",
		"modules/org/openteacher/websiteGenerator/images/screens/3.0-ubuntu-enter.png",
		"modules/org/openteacher/websiteGenerator/images/docs/2/qs5.png",
		"modules/org/openteacher/websiteGenerator/images/docs/2/inst2.png",
		"modules/org/openteacher/websiteGenerator/images/docs/2/qs6.png",
		"modules/org/openteacher/websiteGenerator/images/docs/2/qs2.png",
		"modules/org/openteacher/websiteGenerator/images/docs/2/qs3.png",
		"modules/org/openteacher/websiteGenerator/images/docs/2/inst1.png",
		"modules/org/openteacher/websiteGenerator/images/docs/2/qs4.png",
		"modules/org/openteacher/websiteGenerator/images/flags/us.gif",
		"modules/org/openteacher/websiteGenerator/images/flags/nl.gif",
		"modules/org/openteacher/websiteGenerator/images/oslogos/ubulogo.png",
		"modules/org/openteacher/websiteGenerator/images/oslogos/winlogo.png",
		"modules/org/openteacher/websiteGenerator/images/oslogos/archlogo.png",
		"modules/org/openteacher/websiteGenerator/images/oslogos/osxlogo.png",
		"modules/org/openteacher/websiteGenerator/images/oslogos/fedoralogo.png",
		"modules/org/openteacher/websiteGenerator/images/oslogos/tuxlogo.png",
		"modules/org/openteacher/websiteGenerator/images/oslogos/opensuselogo.png",
		"modules/org/openteacher/websiteGenerator/translations/pt_BR.mo",
		"modules/org/openteacher/websiteGenerator/translations/nl.po",
		"modules/org/openteacher/websiteGenerator/translations/ru.po",
		"modules/org/openteacher/websiteGenerator/translations/org.openteacher.websiteGenerator.pot",
		"modules/org/openteacher/websiteGenerator/translations/nl.mo",
		"modules/org/openteacher/websiteGenerator/translations/de.po",
		"modules/org/openteacher/websiteGenerator/translations/pt_BR.po",
		"modules/org/openteacher/websiteGenerator/translations/ru.mo",
		"modules/org/openteacher/websiteGenerator/translations/de.mo",
		"modules/org/openteacher/websiteGenerator/inAppDocs/index.php",
		"modules/org/openteacher/websiteGenerator/templates/about.html",
		"modules/org/openteacher/websiteGenerator/templates/download.html",
		"modules/org/openteacher/websiteGenerator/templates/documentation.html",
		"modules/org/openteacher/websiteGenerator/templates/index.html",
		"modules/org/openteacher/websiteGenerator/templates/contribute.html",
		"modules/org/openteacher/websiteGenerator/templates/base.html",
		"modules/org/openteacher/websiteGenerator/templates/docpage.html",
		"modules/org/openteacher/websiteGenerator/scripts/os.js",
		"modules/org/openteacher/websiteGenerator/scripts/downloadButton.js",
		"modules/org/openteacher/websiteGenerator/scripts/menuPag.js",
		"modules/org/openteacher/websiteGenerator/scripts/jquery-1.9.1.min.js",
		"modules/org/openteacher/websiteGenerator/scripts/menuLight.js",
		"modules/org/openteacher/websiteGenerator/scripts/thumbnails.js",
		"modules/org/openteacher/websiteGenerator/scripts/linkToHere.js",
		"modules/org/openteacher/websiteGenerator/docsTemplates/translator-notes.html",
		"modules/org/openteacher/websiteGenerator/docsTemplates/using-openteacher-2.html",
		"modules/org/openteacher/websiteGenerator/docsTemplates/install-arch.html",
		"modules/org/openteacher/websiteGenerator/docsTemplates/install-ubuntu.html",
		"modules/org/openteacher/websiteGenerator/docsTemplates/the-openteacher-format.html",
		"modules/org/openteacher/websiteGenerator/docsTemplates/faq.html",
		"modules/org/openteacher/loaders/test/test.py",
		"modules/org/openteacher/loaders/test/testFiles/text_csv.openteacher3x.csv",
		"modules/org/openteacher/loaders/test/testFiles/application_x-pauker.pauker-modified.pau",
		"modules/org/openteacher/loaders/test/testFiles/application_x-cuecard.cuecard.wcu",
		"modules/org/openteacher/loaders/test/testFiles/application_xml.abbyylingvotutor_x3-modified.xml",
		"modules/org/openteacher/loaders/test/testFiles/application_x-teach2000.openteacher3x.t2k",
		"modules/org/openteacher/loaders/test/testFiles/application_x-teach2000.teach2000extraoptions.t2k",
		"modules/org/openteacher/loaders/test/testFiles/application_x-kvtml.parley.kvtml",
		"modules/org/openteacher/loaders/test/testFiles/text_csv.teach2000.csv",
		"modules/org/openteacher/loaders/test/testFiles/application_x-sqlite3.mnemosyne.db",
		"modules/org/openteacher/loaders/test/testFiles/netherlands.png",
		"modules/org/openteacher/loaders/test/testFiles/application_x-kvtml.kwordquiz.kvtml",
		"modules/org/openteacher/loaders/test/testFiles/application_x-overhoor.overhoorvoorwindows4.5.1.oh4",
		"modules/org/openteacher/loaders/test/testFiles/application_x-domingo.domingo.voc",
		"modules/org/openteacher/loaders/test/testFiles/application_x-anki.anki.anki",
		"modules/org/openteacher/loaders/test/testFiles/application_x-pauker.pauker.pau.gz",
		"modules/org/openteacher/loaders/test/testFiles/application_x-vokabeltrainer.vokabeltrainer-with-comment.vtl3",
		"modules/org/openteacher/loaders/test/testFiles/application_x-oriente-voca.voca4.0.wdl",
		"modules/org/openteacher/loaders/test/testFiles/text_plain.vtrain.txt",
		"modules/org/openteacher/loaders/test/testFiles/application_x-openteachingwords.ot1converted.otwd",
		"modules/org/openteacher/loaders/test/testFiles/application_x-openteacher.openteacher1x.ot",
		"modules/org/openteacher/loaders/test/testFiles/application_x-granuledeck.granule.dkf",
		"modules/org/openteacher/loaders/test/testFiles/application_x-oriente-voca.voca3.0.wdl",
		"modules/org/openteacher/loaders/test/testFiles/application_x-anki2.anki.anki2",
		"modules/org/openteacher/loaders/test/testFiles/application_x-kvtml.kvoctrain.kvtml",
		"modules/org/openteacher/loaders/test/testFiles/application_x-openteacher.openteacher2x.ot",
		"modules/org/openteacher/loaders/test/testFiles/application_x-teach2000.teach2000.t2k",
		"modules/org/openteacher/loaders/test/testFiles/text_plain.gnuVocabTrain.txt",
		"modules/org/openteacher/loaders/test/testFiles/COPYING",
		"modules/org/openteacher/loaders/test/testFiles/application_x-teach2000.openteacher1x.t2k",
		"modules/org/openteacher/loaders/test/testFiles/application_x-vocabularium.edited(all-files-are).voc",
		"modules/org/openteacher/loaders/test/testFiles/application_x-apkg.anki.apkg",
		"modules/org/openteacher/loaders/test/testFiles/application_x-kgeographymap.kgeography.kgm",
		"modules/org/openteacher/loaders/test/testFiles/application_x-openteachingtopography.openteacher3x.ottp",
		"modules/org/openteacher/loaders/test/testFiles/application_x-jvlt.jvlt.jvlt",
		"modules/org/openteacher/loaders/test/testFiles/application_x-flashqard.flashqard.fq",
		"modules/org/openteacher/loaders/test/testFiles/application_x-teach2000.teach2000greekfonts.t2k",
		"modules/org/openteacher/loaders/test/testFiles/application_x-overhoor.overhoorvoorwindows4.5.1.ohw",
		"modules/org/openteacher/loaders/test/testFiles/application_x-teach2000.wrts.t2k",
		"modules/org/openteacher/loaders/test/testFiles/application_x-wrts.openteacher3x.wrts",
		"modules/org/openteacher/loaders/test/testFiles/application_x-overhoor.wrts.oh4",
		"modules/org/openteacher/loaders/test/testFiles/application_x-overhoor.wrts.ohw",
		"modules/org/openteacher/loaders/test/testFiles/application_x-backpack.backpack",
		"modules/org/openteacher/loaders/test/testFiles/application_x-ludem.stp",
		"modules/org/openteacher/loaders/test/testFiles/application_xml.abbyylingvotutor_x5.xml",
		"modules/org/openteacher/loaders/test/testFiles/application_x-wrts.openteacher1x.wrts",
		"modules/org/openteacher/loaders/test/testFiles/application_x-oriente-voca.vocatude1.0.wdl",
		"modules/org/openteacher/loaders/test/testFiles/application_x-jmemorizelesson.jmemorize-modified.jml",
		"modules/org/openteacher/loaders/test/testFiles/application_x-wrts.openteacher2x.wrts",
		"modules/org/openteacher/loaders/test/testFiles/application_x-vokabeltrainer.vokabeltrainer.vtl3",
		"modules/org/openteacher/loaders/test/testFiles/application_x-teachmaster.vok2",
		"modules/org/openteacher/loaders/test/testFiles/application_x-openteacher.openteacher3x.ot",
		"modules/org/openteacher/loaders/test/testFiles/application_x-openteachingwords.openteacher3x.otwd",
		"modules/org/openteacher/loaders/test/testFiles/application_x-openteachingmedia.openteacher3x.otmd",
		"modules/org/openteacher/loaders/test/testFiles/application_x-teach2000.openteacher30.t2k",
		"modules/org/openteacher/loaders/test/testFiles/application_x-teach2000.openteacher2x.t2k",
		"modules/org/openteacher/loaders/test/testFiles/application_x-jmemorizelesson.jmemorize.jml",
		"modules/org/openteacher/loaders/test/testFiles/application_x-wrts.wrts.wrts",
		"modules/org/openteacher/loaders/test/testFiles/application_x-overhoringsprogrammatalen.downloaded-and-edited.ovr",
		"modules/org/openteacher/loaders/test/testFiles/application_x-overhoor.overhoorvoorwindows4.5.1.oh",
		"modules/org/openteacher/loaders/t2k/t2k.py",
		"modules/org/openteacher/loaders/t2k/translations/fi.po",
		"modules/org/openteacher/loaders/t2k/translations/si.po",
		"modules/org/openteacher/loaders/t2k/translations/fy.po",
		"modules/org/openteacher/loaders/t2k/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/t2k/translations/zh_CN.mo",
		"modules/org/openteacher/loaders/t2k/translations/cs.mo",
		"modules/org/openteacher/loaders/t2k/translations/fr.mo",
		"modules/org/openteacher/loaders/t2k/translations/es.po",
		"modules/org/openteacher/loaders/t2k/translations/nl.po",
		"modules/org/openteacher/loaders/t2k/translations/ru.po",
		"modules/org/openteacher/loaders/t2k/translations/nl.mo",
		"modules/org/openteacher/loaders/t2k/translations/zh_CN.po",
		"modules/org/openteacher/loaders/t2k/translations/zh_TW.po",
		"modules/org/openteacher/loaders/t2k/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/t2k/translations/de.po",
		"modules/org/openteacher/loaders/t2k/translations/pt_BR.po",
		"modules/org/openteacher/loaders/t2k/translations/es.mo",
		"modules/org/openteacher/loaders/t2k/translations/ru.mo",
		"modules/org/openteacher/loaders/t2k/translations/org.openteacher.loaders.t2k.pot",
		"modules/org/openteacher/loaders/t2k/translations/de.mo",
		"modules/org/openteacher/loaders/t2k/translations/fi.mo",
		"modules/org/openteacher/loaders/t2k/translations/si.mo",
		"modules/org/openteacher/loaders/t2k/translations/cs.po",
		"modules/org/openteacher/loaders/t2k/translations/fy.mo",
		"modules/org/openteacher/loaders/t2k/translations/fr.po",
		"modules/org/openteacher/loaders/teachmaster/teachmaster.py",
		"modules/org/openteacher/loaders/teachmaster/translations/en_GB.po",
		"modules/org/openteacher/loaders/teachmaster/translations/en_GB.mo",
		"modules/org/openteacher/loaders/teachmaster/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/teachmaster/translations/nl.po",
		"modules/org/openteacher/loaders/teachmaster/translations/ru.po",
		"modules/org/openteacher/loaders/teachmaster/translations/nl.mo",
		"modules/org/openteacher/loaders/teachmaster/translations/zh_TW.po",
		"modules/org/openteacher/loaders/teachmaster/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/teachmaster/translations/de.po",
		"modules/org/openteacher/loaders/teachmaster/translations/pt_BR.po",
		"modules/org/openteacher/loaders/teachmaster/translations/ru.mo",
		"modules/org/openteacher/loaders/teachmaster/translations/de.mo",
		"modules/org/openteacher/loaders/teachmaster/translations/org.openteacher.teachmaster.pot",
		"modules/org/openteacher/loaders/abbyy/abbyy.py",
		"modules/org/openteacher/loaders/abbyy/translations/fi.po",
		"modules/org/openteacher/loaders/abbyy/translations/fy.po",
		"modules/org/openteacher/loaders/abbyy/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/abbyy/translations/fr.mo",
		"modules/org/openteacher/loaders/abbyy/translations/es.po",
		"modules/org/openteacher/loaders/abbyy/translations/nl.po",
		"modules/org/openteacher/loaders/abbyy/translations/ru.po",
		"modules/org/openteacher/loaders/abbyy/translations/nl.mo",
		"modules/org/openteacher/loaders/abbyy/translations/zh_TW.po",
		"modules/org/openteacher/loaders/abbyy/translations/org.openteacher.loaders.abbyy.pot",
		"modules/org/openteacher/loaders/abbyy/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/abbyy/translations/de.po",
		"modules/org/openteacher/loaders/abbyy/translations/pt_BR.po",
		"modules/org/openteacher/loaders/abbyy/translations/es.mo",
		"modules/org/openteacher/loaders/abbyy/translations/ru.mo",
		"modules/org/openteacher/loaders/abbyy/translations/de.mo",
		"modules/org/openteacher/loaders/abbyy/translations/fi.mo",
		"modules/org/openteacher/loaders/abbyy/translations/fy.mo",
		"modules/org/openteacher/loaders/abbyy/translations/fr.po",
		"modules/org/openteacher/loaders/voca/voca.py",
		"modules/org/openteacher/loaders/voca/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/voca/translations/nl.po",
		"modules/org/openteacher/loaders/voca/translations/ru.po",
		"modules/org/openteacher/loaders/voca/translations/nl.mo",
		"modules/org/openteacher/loaders/voca/translations/zh_TW.po",
		"modules/org/openteacher/loaders/voca/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/voca/translations/de.po",
		"modules/org/openteacher/loaders/voca/translations/pt_BR.po",
		"modules/org/openteacher/loaders/voca/translations/ru.mo",
		"modules/org/openteacher/loaders/voca/translations/org.openteacher.loaders.voca.pot",
		"modules/org/openteacher/loaders/voca/translations/de.mo",
		"modules/org/openteacher/loaders/ovr/ovr.py",
		"modules/org/openteacher/loaders/ovr/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/ovr/translations/nl.po",
		"modules/org/openteacher/loaders/ovr/translations/ru.po",
		"modules/org/openteacher/loaders/ovr/translations/nl.mo",
		"modules/org/openteacher/loaders/ovr/translations/zh_TW.po",
		"modules/org/openteacher/loaders/ovr/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/ovr/translations/org.openteacher.ovr.pot",
		"modules/org/openteacher/loaders/ovr/translations/de.po",
		"modules/org/openteacher/loaders/ovr/translations/pt_BR.po",
		"modules/org/openteacher/loaders/ovr/translations/ru.mo",
		"modules/org/openteacher/loaders/ovr/translations/de.mo",
		"modules/org/openteacher/loaders/jvlt/jvlt.py",
		"modules/org/openteacher/loaders/jvlt/translations/en_GB.po",
		"modules/org/openteacher/loaders/jvlt/translations/en_GB.mo",
		"modules/org/openteacher/loaders/jvlt/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/jvlt/translations/nl.po",
		"modules/org/openteacher/loaders/jvlt/translations/ru.po",
		"modules/org/openteacher/loaders/jvlt/translations/nl.mo",
		"modules/org/openteacher/loaders/jvlt/translations/zh_TW.po",
		"modules/org/openteacher/loaders/jvlt/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/jvlt/translations/de.po",
		"modules/org/openteacher/loaders/jvlt/translations/pt_BR.po",
		"modules/org/openteacher/loaders/jvlt/translations/ru.mo",
		"modules/org/openteacher/loaders/jvlt/translations/de.mo",
		"modules/org/openteacher/loaders/jvlt/translations/org.openteacher.loaders.jvlt.pot",
		"modules/org/openteacher/loaders/granule/granule.py",
		"modules/org/openteacher/loaders/granule/translations/org.openteacher.loaders.granule.pot",
		"modules/org/openteacher/loaders/granule/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/granule/translations/nl.po",
		"modules/org/openteacher/loaders/granule/translations/ru.po",
		"modules/org/openteacher/loaders/granule/translations/nl.mo",
		"modules/org/openteacher/loaders/granule/translations/zh_TW.po",
		"modules/org/openteacher/loaders/granule/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/granule/translations/de.po",
		"modules/org/openteacher/loaders/granule/translations/pt_BR.po",
		"modules/org/openteacher/loaders/granule/translations/ru.mo",
		"modules/org/openteacher/loaders/granule/translations/de.mo",
		"modules/org/openteacher/loaders/csv_/csv_.py",
		"modules/org/openteacher/loaders/csv_/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/csv_/translations/nl.po",
		"modules/org/openteacher/loaders/csv_/translations/ru.po",
		"modules/org/openteacher/loaders/csv_/translations/org.openteacher.loaders.csv.pot",
		"modules/org/openteacher/loaders/csv_/translations/nl.mo",
		"modules/org/openteacher/loaders/csv_/translations/zh_TW.po",
		"modules/org/openteacher/loaders/csv_/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/csv_/translations/de.po",
		"modules/org/openteacher/loaders/csv_/translations/pt_BR.po",
		"modules/org/openteacher/loaders/csv_/translations/ru.mo",
		"modules/org/openteacher/loaders/csv_/translations/de.mo",
		"modules/org/openteacher/loaders/apkg/apkg.py",
		"modules/org/openteacher/loaders/apkg/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/apkg/translations/nl.po",
		"modules/org/openteacher/loaders/apkg/translations/ru.po",
		"modules/org/openteacher/loaders/apkg/translations/nl.mo",
		"modules/org/openteacher/loaders/apkg/translations/zh_TW.po",
		"modules/org/openteacher/loaders/apkg/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/apkg/translations/de.po",
		"modules/org/openteacher/loaders/apkg/translations/pt_BR.po",
		"modules/org/openteacher/loaders/apkg/translations/ru.mo",
		"modules/org/openteacher/loaders/apkg/translations/de.mo",
		"modules/org/openteacher/loaders/apkg/translations/org.openteacher.loaders.apkg.pot",
		"modules/org/openteacher/loaders/jml/jml.py",
		"modules/org/openteacher/loaders/anki2/anki2.py",
		"modules/org/openteacher/loaders/anki2/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/anki2/translations/es.po",
		"modules/org/openteacher/loaders/anki2/translations/org.openteacher.loaders.anki2.pot",
		"modules/org/openteacher/loaders/anki2/translations/nl.po",
		"modules/org/openteacher/loaders/anki2/translations/ru.po",
		"modules/org/openteacher/loaders/anki2/translations/nl.mo",
		"modules/org/openteacher/loaders/anki2/translations/zh_TW.po",
		"modules/org/openteacher/loaders/anki2/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/anki2/translations/de.po",
		"modules/org/openteacher/loaders/anki2/translations/pt_BR.po",
		"modules/org/openteacher/loaders/anki2/translations/es.mo",
		"modules/org/openteacher/loaders/anki2/translations/ru.mo",
		"modules/org/openteacher/loaders/anki2/translations/tr.po",
		"modules/org/openteacher/loaders/anki2/translations/de.mo",
		"modules/org/openteacher/loaders/anki2/translations/tr.mo",
		"modules/org/openteacher/loaders/flashqard/flashqard.py",
		"modules/org/openteacher/loaders/flashqard/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/flashqard/translations/nl.po",
		"modules/org/openteacher/loaders/flashqard/translations/ru.po",
		"modules/org/openteacher/loaders/flashqard/translations/nl.mo",
		"modules/org/openteacher/loaders/flashqard/translations/zh_TW.po",
		"modules/org/openteacher/loaders/flashqard/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/flashqard/translations/de.po",
		"modules/org/openteacher/loaders/flashqard/translations/pt_BR.po",
		"modules/org/openteacher/loaders/flashqard/translations/ru.mo",
		"modules/org/openteacher/loaders/flashqard/translations/de.mo",
		"modules/org/openteacher/loaders/flashqard/translations/org.openteacher.loaders.flashqard.pot",
		"modules/org/openteacher/loaders/ot/ot.py",
		"modules/org/openteacher/loaders/ot/translations/fi.po",
		"modules/org/openteacher/loaders/ot/translations/si.po",
		"modules/org/openteacher/loaders/ot/translations/fy.po",
		"modules/org/openteacher/loaders/ot/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/ot/translations/zh_CN.mo",
		"modules/org/openteacher/loaders/ot/translations/cs.mo",
		"modules/org/openteacher/loaders/ot/translations/fr.mo",
		"modules/org/openteacher/loaders/ot/translations/es.po",
		"modules/org/openteacher/loaders/ot/translations/nl.po",
		"modules/org/openteacher/loaders/ot/translations/ru.po",
		"modules/org/openteacher/loaders/ot/translations/ar.po",
		"modules/org/openteacher/loaders/ot/translations/nl.mo",
		"modules/org/openteacher/loaders/ot/translations/zh_CN.po",
		"modules/org/openteacher/loaders/ot/translations/zh_TW.po",
		"modules/org/openteacher/loaders/ot/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/ot/translations/de.po",
		"modules/org/openteacher/loaders/ot/translations/ar.mo",
		"modules/org/openteacher/loaders/ot/translations/pt_BR.po",
		"modules/org/openteacher/loaders/ot/translations/es.mo",
		"modules/org/openteacher/loaders/ot/translations/ru.mo",
		"modules/org/openteacher/loaders/ot/translations/de.mo",
		"modules/org/openteacher/loaders/ot/translations/fi.mo",
		"modules/org/openteacher/loaders/ot/translations/si.mo",
		"modules/org/openteacher/loaders/ot/translations/org.openteacher.loaders.ot.pot",
		"modules/org/openteacher/loaders/ot/translations/cs.po",
		"modules/org/openteacher/loaders/ot/translations/fy.mo",
		"modules/org/openteacher/loaders/ot/translations/fr.po",
		"modules/org/openteacher/loaders/pauker/pauker.py",
		"modules/org/openteacher/loaders/pauker/translations/fy.po",
		"modules/org/openteacher/loaders/pauker/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/pauker/translations/fr.mo",
		"modules/org/openteacher/loaders/pauker/translations/nl.po",
		"modules/org/openteacher/loaders/pauker/translations/ru.po",
		"modules/org/openteacher/loaders/pauker/translations/nl.mo",
		"modules/org/openteacher/loaders/pauker/translations/zh_TW.po",
		"modules/org/openteacher/loaders/pauker/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/pauker/translations/de.po",
		"modules/org/openteacher/loaders/pauker/translations/pt_BR.po",
		"modules/org/openteacher/loaders/pauker/translations/ru.mo",
		"modules/org/openteacher/loaders/pauker/translations/de.mo",
		"modules/org/openteacher/loaders/pauker/translations/org.openteacher.loaders.pauker.pot",
		"modules/org/openteacher/loaders/pauker/translations/fy.mo",
		"modules/org/openteacher/loaders/pauker/translations/fr.po",
		"modules/org/openteacher/loaders/anki/anki.py",
		"modules/org/openteacher/loaders/anki/translations/fy.po",
		"modules/org/openteacher/loaders/anki/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/anki/translations/cs.mo",
		"modules/org/openteacher/loaders/anki/translations/fr.mo",
		"modules/org/openteacher/loaders/anki/translations/nl.po",
		"modules/org/openteacher/loaders/anki/translations/ru.po",
		"modules/org/openteacher/loaders/anki/translations/nl.mo",
		"modules/org/openteacher/loaders/anki/translations/zh_TW.po",
		"modules/org/openteacher/loaders/anki/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/anki/translations/org.openteacher.loaders.anki.pot",
		"modules/org/openteacher/loaders/anki/translations/de.po",
		"modules/org/openteacher/loaders/anki/translations/pt_BR.po",
		"modules/org/openteacher/loaders/anki/translations/ru.mo",
		"modules/org/openteacher/loaders/anki/translations/de.mo",
		"modules/org/openteacher/loaders/anki/translations/cs.po",
		"modules/org/openteacher/loaders/anki/translations/fy.mo",
		"modules/org/openteacher/loaders/anki/translations/fr.po",
		"modules/org/openteacher/loaders/wrts/wrts.py",
		"modules/org/openteacher/loaders/wrts/translations/fi.po",
		"modules/org/openteacher/loaders/wrts/translations/si.po",
		"modules/org/openteacher/loaders/wrts/translations/fy.po",
		"modules/org/openteacher/loaders/wrts/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/wrts/translations/zh_CN.mo",
		"modules/org/openteacher/loaders/wrts/translations/cs.mo",
		"modules/org/openteacher/loaders/wrts/translations/fr.mo",
		"modules/org/openteacher/loaders/wrts/translations/es.po",
		"modules/org/openteacher/loaders/wrts/translations/nl.po",
		"modules/org/openteacher/loaders/wrts/translations/ru.po",
		"modules/org/openteacher/loaders/wrts/translations/nl.mo",
		"modules/org/openteacher/loaders/wrts/translations/zh_CN.po",
		"modules/org/openteacher/loaders/wrts/translations/zh_TW.po",
		"modules/org/openteacher/loaders/wrts/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/wrts/translations/de.po",
		"modules/org/openteacher/loaders/wrts/translations/pt_BR.po",
		"modules/org/openteacher/loaders/wrts/translations/es.mo",
		"modules/org/openteacher/loaders/wrts/translations/ru.mo",
		"modules/org/openteacher/loaders/wrts/translations/org.openteacher.loaders.wrts.pot",
		"modules/org/openteacher/loaders/wrts/translations/de.mo",
		"modules/org/openteacher/loaders/wrts/translations/fi.mo",
		"modules/org/openteacher/loaders/wrts/translations/si.mo",
		"modules/org/openteacher/loaders/wrts/translations/cs.po",
		"modules/org/openteacher/loaders/wrts/translations/fy.mo",
		"modules/org/openteacher/loaders/wrts/translations/fr.po",
		"modules/org/openteacher/loaders/vocabularium/vocabularium.py",
		"modules/org/openteacher/loaders/vocabularium/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/vocabularium/translations/nl.po",
		"modules/org/openteacher/loaders/vocabularium/translations/ru.po",
		"modules/org/openteacher/loaders/vocabularium/translations/nl.mo",
		"modules/org/openteacher/loaders/vocabularium/translations/zh_TW.po",
		"modules/org/openteacher/loaders/vocabularium/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/vocabularium/translations/de.po",
		"modules/org/openteacher/loaders/vocabularium/translations/pt_BR.po",
		"modules/org/openteacher/loaders/vocabularium/translations/ru.mo",
		"modules/org/openteacher/loaders/vocabularium/translations/de.mo",
		"modules/org/openteacher/loaders/vocabularium/translations/org.openteacher.loaders.vocabularium.pot",
		"modules/org/openteacher/loaders/domingo/domingo.py",
		"modules/org/openteacher/loaders/domingo/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/domingo/translations/nl.po",
		"modules/org/openteacher/loaders/domingo/translations/ru.po",
		"modules/org/openteacher/loaders/domingo/translations/org.openteacher.loaders.domingo.pot",
		"modules/org/openteacher/loaders/domingo/translations/nl.mo",
		"modules/org/openteacher/loaders/domingo/translations/zh_TW.po",
		"modules/org/openteacher/loaders/domingo/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/domingo/translations/de.po",
		"modules/org/openteacher/loaders/domingo/translations/pt_BR.po",
		"modules/org/openteacher/loaders/domingo/translations/ru.mo",
		"modules/org/openteacher/loaders/domingo/translations/de.mo",
		"modules/org/openteacher/loaders/kvtml/kvtml.py",
		"modules/org/openteacher/loaders/kvtml/translations/fy.po",
		"modules/org/openteacher/loaders/kvtml/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/kvtml/translations/cs.mo",
		"modules/org/openteacher/loaders/kvtml/translations/fr.mo",
		"modules/org/openteacher/loaders/kvtml/translations/nl.po",
		"modules/org/openteacher/loaders/kvtml/translations/ru.po",
		"modules/org/openteacher/loaders/kvtml/translations/nl.mo",
		"modules/org/openteacher/loaders/kvtml/translations/zh_TW.po",
		"modules/org/openteacher/loaders/kvtml/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/kvtml/translations/de.po",
		"modules/org/openteacher/loaders/kvtml/translations/pt_BR.po",
		"modules/org/openteacher/loaders/kvtml/translations/ru.mo",
		"modules/org/openteacher/loaders/kvtml/translations/de.mo",
		"modules/org/openteacher/loaders/kvtml/translations/cs.po",
		"modules/org/openteacher/loaders/kvtml/translations/fy.mo",
		"modules/org/openteacher/loaders/kvtml/translations/fr.po",
		"modules/org/openteacher/loaders/kvtml/translations/org.openteacher.loaders.kvtml.pot",
		"modules/org/openteacher/loaders/backpack/backpack.py",
		"modules/org/openteacher/loaders/backpack/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/backpack/translations/org.openteacher.loaders.backpack.pot",
		"modules/org/openteacher/loaders/backpack/translations/ru.po",
		"modules/org/openteacher/loaders/backpack/translations/pt_BR.po",
		"modules/org/openteacher/loaders/backpack/translations/ru.mo",
		"modules/org/openteacher/loaders/overhoor/overhoor.py",
		"modules/org/openteacher/loaders/overhoor/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/overhoor/translations/nl.po",
		"modules/org/openteacher/loaders/overhoor/translations/ru.po",
		"modules/org/openteacher/loaders/overhoor/translations/nl.mo",
		"modules/org/openteacher/loaders/overhoor/translations/zh_TW.po",
		"modules/org/openteacher/loaders/overhoor/translations/org.openteacher.loaders.overhoor.pot",
		"modules/org/openteacher/loaders/overhoor/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/overhoor/translations/de.po",
		"modules/org/openteacher/loaders/overhoor/translations/pt_BR.po",
		"modules/org/openteacher/loaders/overhoor/translations/ru.mo",
		"modules/org/openteacher/loaders/overhoor/translations/de.mo",
		"modules/org/openteacher/loaders/vtrainTxt/vtrainTxt.py",
		"modules/org/openteacher/loaders/vtrainTxt/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/vtrainTxt/translations/org.openteacher.loaders.vtrainTxt.pot",
		"modules/org/openteacher/loaders/vtrainTxt/translations/nl.po",
		"modules/org/openteacher/loaders/vtrainTxt/translations/ru.po",
		"modules/org/openteacher/loaders/vtrainTxt/translations/nl.mo",
		"modules/org/openteacher/loaders/vtrainTxt/translations/zh_TW.po",
		"modules/org/openteacher/loaders/vtrainTxt/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/vtrainTxt/translations/de.po",
		"modules/org/openteacher/loaders/vtrainTxt/translations/pt_BR.po",
		"modules/org/openteacher/loaders/vtrainTxt/translations/ru.mo",
		"modules/org/openteacher/loaders/vtrainTxt/translations/de.mo",
		"modules/org/openteacher/loaders/mnemosyne/mnemosyne.py",
		"modules/org/openteacher/loaders/mnemosyne/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/mnemosyne/translations/pl.mo",
		"modules/org/openteacher/loaders/mnemosyne/translations/nl.po",
		"modules/org/openteacher/loaders/mnemosyne/translations/ru.po",
		"modules/org/openteacher/loaders/mnemosyne/translations/org.openteaher.mnemosyne.pot",
		"modules/org/openteacher/loaders/mnemosyne/translations/pl.po",
		"modules/org/openteacher/loaders/mnemosyne/translations/nl.mo",
		"modules/org/openteacher/loaders/mnemosyne/translations/zh_TW.po",
		"modules/org/openteacher/loaders/mnemosyne/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/mnemosyne/translations/de.po",
		"modules/org/openteacher/loaders/mnemosyne/translations/pt_BR.po",
		"modules/org/openteacher/loaders/mnemosyne/translations/ru.mo",
		"modules/org/openteacher/loaders/mnemosyne/translations/de.mo",
		"modules/org/openteacher/loaders/kgm/kgm.py",
		"modules/org/openteacher/loaders/ottp/ottp.py",
		"modules/org/openteacher/loaders/ottp/translations/fi.po",
		"modules/org/openteacher/loaders/ottp/translations/fy.po",
		"modules/org/openteacher/loaders/ottp/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/ottp/translations/cs.mo",
		"modules/org/openteacher/loaders/ottp/translations/fr.mo",
		"modules/org/openteacher/loaders/ottp/translations/es.po",
		"modules/org/openteacher/loaders/ottp/translations/nl.po",
		"modules/org/openteacher/loaders/ottp/translations/ru.po",
		"modules/org/openteacher/loaders/ottp/translations/nl.mo",
		"modules/org/openteacher/loaders/ottp/translations/zh_TW.po",
		"modules/org/openteacher/loaders/ottp/translations/org.openteacher.loaders.ottp.pot",
		"modules/org/openteacher/loaders/ottp/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/ottp/translations/de.po",
		"modules/org/openteacher/loaders/ottp/translations/pt_BR.po",
		"modules/org/openteacher/loaders/ottp/translations/es.mo",
		"modules/org/openteacher/loaders/ottp/translations/ru.mo",
		"modules/org/openteacher/loaders/ottp/translations/de.mo",
		"modules/org/openteacher/loaders/ottp/translations/fi.mo",
		"modules/org/openteacher/loaders/ottp/translations/cs.po",
		"modules/org/openteacher/loaders/ottp/translations/fy.mo",
		"modules/org/openteacher/loaders/ottp/translations/fr.po",
		"modules/org/openteacher/loaders/vokabelTrainer/vokabelTrainer.py",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/nl.po",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/ru.po",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/nl.mo",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/org.openteacher.vokabelTrainer.pot",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/zh_TW.po",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/de.po",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/pt_BR.po",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/ru.mo",
		"modules/org/openteacher/loaders/vokabelTrainer/translations/de.mo",
		"modules/org/openteacher/loaders/gnuVocabTrain/gnuVocabTrain.py",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/nl.po",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/ru.po",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/org.openteacher.loaders.gnuVocabTrain.pot",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/nl.mo",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/zh_TW.po",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/de.po",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/pt_BR.po",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/ru.mo",
		"modules/org/openteacher/loaders/gnuVocabTrain/translations/de.mo",
		"modules/org/openteacher/loaders/otwd/otwd.py",
		"modules/org/openteacher/loaders/otwd/translations/fi.po",
		"modules/org/openteacher/loaders/otwd/translations/fy.po",
		"modules/org/openteacher/loaders/otwd/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/otwd/translations/zh_CN.mo",
		"modules/org/openteacher/loaders/otwd/translations/cs.mo",
		"modules/org/openteacher/loaders/otwd/translations/fr.mo",
		"modules/org/openteacher/loaders/otwd/translations/es.po",
		"modules/org/openteacher/loaders/otwd/translations/org.openteacher.loaders.otwd.pot",
		"modules/org/openteacher/loaders/otwd/translations/nl.po",
		"modules/org/openteacher/loaders/otwd/translations/ru.po",
		"modules/org/openteacher/loaders/otwd/translations/nl.mo",
		"modules/org/openteacher/loaders/otwd/translations/zh_CN.po",
		"modules/org/openteacher/loaders/otwd/translations/zh_TW.po",
		"modules/org/openteacher/loaders/otwd/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/otwd/translations/de.po",
		"modules/org/openteacher/loaders/otwd/translations/pt_BR.po",
		"modules/org/openteacher/loaders/otwd/translations/es.mo",
		"modules/org/openteacher/loaders/otwd/translations/ru.mo",
		"modules/org/openteacher/loaders/otwd/translations/de.mo",
		"modules/org/openteacher/loaders/otwd/translations/fi.mo",
		"modules/org/openteacher/loaders/otwd/translations/cs.po",
		"modules/org/openteacher/loaders/otwd/translations/fy.mo",
		"modules/org/openteacher/loaders/otwd/translations/fr.po",
		"modules/org/openteacher/loaders/otmd/otmd.py",
		"modules/org/openteacher/loaders/otmd/translations/fi.po",
		"modules/org/openteacher/loaders/otmd/translations/fy.po",
		"modules/org/openteacher/loaders/otmd/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/otmd/translations/zh_CN.mo",
		"modules/org/openteacher/loaders/otmd/translations/cs.mo",
		"modules/org/openteacher/loaders/otmd/translations/fr.mo",
		"modules/org/openteacher/loaders/otmd/translations/es.po",
		"modules/org/openteacher/loaders/otmd/translations/nl.po",
		"modules/org/openteacher/loaders/otmd/translations/ru.po",
		"modules/org/openteacher/loaders/otmd/translations/nl.mo",
		"modules/org/openteacher/loaders/otmd/translations/zh_CN.po",
		"modules/org/openteacher/loaders/otmd/translations/zh_TW.po",
		"modules/org/openteacher/loaders/otmd/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/otmd/translations/de.po",
		"modules/org/openteacher/loaders/otmd/translations/pt_BR.po",
		"modules/org/openteacher/loaders/otmd/translations/es.mo",
		"modules/org/openteacher/loaders/otmd/translations/ru.mo",
		"modules/org/openteacher/loaders/otmd/translations/de.mo",
		"modules/org/openteacher/loaders/otmd/translations/fi.mo",
		"modules/org/openteacher/loaders/otmd/translations/cs.po",
		"modules/org/openteacher/loaders/otmd/translations/org.openteacher.loaders.otmd.pot",
		"modules/org/openteacher/loaders/otmd/translations/fy.mo",
		"modules/org/openteacher/loaders/otmd/translations/fr.po",
		"modules/org/openteacher/loaders/ludem/ludem.py",
		"modules/org/openteacher/loaders/ludem/translations/en_GB.po",
		"modules/org/openteacher/loaders/ludem/translations/en_GB.mo",
		"modules/org/openteacher/loaders/ludem/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/ludem/translations/ru.po",
		"modules/org/openteacher/loaders/ludem/translations/org.openteacher.loaders.ludem.pot",
		"modules/org/openteacher/loaders/ludem/translations/pt_BR.po",
		"modules/org/openteacher/loaders/ludem/translations/ru.mo",
		"modules/org/openteacher/loaders/cuecard/cuecard.py",
		"modules/org/openteacher/loaders/cuecard/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/cuecard/translations/nl.po",
		"modules/org/openteacher/loaders/cuecard/translations/ru.po",
		"modules/org/openteacher/loaders/cuecard/translations/org.openteacher.loaders.cuecard.pot",
		"modules/org/openteacher/loaders/cuecard/translations/nl.mo",
		"modules/org/openteacher/loaders/cuecard/translations/zh_TW.po",
		"modules/org/openteacher/loaders/cuecard/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/cuecard/translations/de.po",
		"modules/org/openteacher/loaders/cuecard/translations/pt_BR.po",
		"modules/org/openteacher/loaders/cuecard/translations/ru.mo",
		"modules/org/openteacher/loaders/cuecard/translations/de.mo",
		"modules/org/openteacher/reversers/mediaTest/mediaTest.py",
		"modules/org/openteacher/reversers/media/media.py",
		"modules/org/openteacher/reversers/wordsTest/wordsTest.py",
		"modules/org/openteacher/reversers/words/words.py",
		"modules/org/openteacher/userDocumentationTest/userDocumentationTest.py",
		"modules/org/openteacher/loaderGui/loaderGui.py",
		"modules/org/openteacher/loaderGui/translations/fy.po",
		"modules/org/openteacher/loaderGui/translations/pt_BR.mo",
		"modules/org/openteacher/loaderGui/translations/org.openteacher.loaderGui.pot",
		"modules/org/openteacher/loaderGui/translations/zh_CN.mo",
		"modules/org/openteacher/loaderGui/translations/cs.mo",
		"modules/org/openteacher/loaderGui/translations/pl.mo",
		"modules/org/openteacher/loaderGui/translations/fr.mo",
		"modules/org/openteacher/loaderGui/translations/es.po",
		"modules/org/openteacher/loaderGui/translations/nl.po",
		"modules/org/openteacher/loaderGui/translations/ru.po",
		"modules/org/openteacher/loaderGui/translations/ar.po",
		"modules/org/openteacher/loaderGui/translations/pl.po",
		"modules/org/openteacher/loaderGui/translations/nl.mo",
		"modules/org/openteacher/loaderGui/translations/zh_CN.po",
		"modules/org/openteacher/loaderGui/translations/zh_TW.po",
		"modules/org/openteacher/loaderGui/translations/zh_TW.mo",
		"modules/org/openteacher/loaderGui/translations/de.po",
		"modules/org/openteacher/loaderGui/translations/ar.mo",
		"modules/org/openteacher/loaderGui/translations/pt_BR.po",
		"modules/org/openteacher/loaderGui/translations/es.mo",
		"modules/org/openteacher/loaderGui/translations/ru.mo",
		"modules/org/openteacher/loaderGui/translations/de.mo",
		"modules/org/openteacher/loaderGui/translations/cs.po",
		"modules/org/openteacher/loaderGui/translations/el.po",
		"modules/org/openteacher/loaderGui/translations/fy.mo",
		"modules/org/openteacher/loaderGui/translations/el.mo",
		"modules/org/openteacher/loaderGui/translations/fr.po",
		"modules/org/openteacher/inputTyping/gui/gui.py",
		"modules/org/openteacher/inputTyping/gui/translations/fi.po",
		"modules/org/openteacher/inputTyping/gui/translations/ja.mo",
		"modules/org/openteacher/inputTyping/gui/translations/si.po",
		"modules/org/openteacher/inputTyping/gui/translations/fy.po",
		"modules/org/openteacher/inputTyping/gui/translations/pt_BR.mo",
		"modules/org/openteacher/inputTyping/gui/translations/hu.po",
		"modules/org/openteacher/inputTyping/gui/translations/zh_CN.mo",
		"modules/org/openteacher/inputTyping/gui/translations/cs.mo",
		"modules/org/openteacher/inputTyping/gui/translations/pl.mo",
		"modules/org/openteacher/inputTyping/gui/translations/fr.mo",
		"modules/org/openteacher/inputTyping/gui/translations/es.po",
		"modules/org/openteacher/inputTyping/gui/translations/nl.po",
		"modules/org/openteacher/inputTyping/gui/translations/ru.po",
		"modules/org/openteacher/inputTyping/gui/translations/ar.po",
		"modules/org/openteacher/inputTyping/gui/translations/pl.po",
		"modules/org/openteacher/inputTyping/gui/translations/nl.mo",
		"modules/org/openteacher/inputTyping/gui/translations/zh_CN.po",
		"modules/org/openteacher/inputTyping/gui/translations/zh_TW.po",
		"modules/org/openteacher/inputTyping/gui/translations/org.openteacher.inputTyping.pot",
		"modules/org/openteacher/inputTyping/gui/translations/zh_TW.mo",
		"modules/org/openteacher/inputTyping/gui/translations/de.po",
		"modules/org/openteacher/inputTyping/gui/translations/ar.mo",
		"modules/org/openteacher/inputTyping/gui/translations/pt_BR.po",
		"modules/org/openteacher/inputTyping/gui/translations/es.mo",
		"modules/org/openteacher/inputTyping/gui/translations/gl.po",
		"modules/org/openteacher/inputTyping/gui/translations/ja.po",
		"modules/org/openteacher/inputTyping/gui/translations/ru.mo",
		"modules/org/openteacher/inputTyping/gui/translations/it.po",
		"modules/org/openteacher/inputTyping/gui/translations/hu.mo",
		"modules/org/openteacher/inputTyping/gui/translations/it.mo",
		"modules/org/openteacher/inputTyping/gui/translations/tr.po",
		"modules/org/openteacher/inputTyping/gui/translations/de.mo",
		"modules/org/openteacher/inputTyping/gui/translations/fi.mo",
		"modules/org/openteacher/inputTyping/gui/translations/sk.po",
		"modules/org/openteacher/inputTyping/gui/translations/si.mo",
		"modules/org/openteacher/inputTyping/gui/translations/cs.po",
		"modules/org/openteacher/inputTyping/gui/translations/gl.mo",
		"modules/org/openteacher/inputTyping/gui/translations/el.po",
		"modules/org/openteacher/inputTyping/gui/translations/tr.mo",
		"modules/org/openteacher/inputTyping/gui/translations/fy.mo",
		"modules/org/openteacher/inputTyping/gui/translations/el.mo",
		"modules/org/openteacher/inputTyping/gui/translations/sk.mo",
		"modules/org/openteacher/inputTyping/gui/translations/fr.po",
		"modules/org/openteacher/inputTyping/javaScriptLogic/javaScriptLogic.py",
		"modules/org/openteacher/inputTyping/javaScriptLogic/inputTypingLogic.js",
		"modules/org/openteacher/inputTyping/logicTest/logicTest.py",
		"modules/org/openteacher/testserver/cert.pem",
		"modules/org/openteacher/testserver/server.py",
		"modules/org/openteacher/testserver/testserver.py",
		"modules/org/openteacher/testserver/COPYING",
		"modules/org/openteacher/testserver/privatekey.pem",
		"modules/org/openteacher/testserver/ot_testserver/auth.py",
		"modules/org/openteacher/testserver/ot_testserver/urls.py",
		"modules/org/openteacher/testserver/ot_testserver/settings.py",
		"modules/org/openteacher/testserver/ot_testserver/database.sqlite3",
		"modules/org/openteacher/testserver/ot_testserver/COPYING",
		"modules/org/openteacher/testserver/ot_testserver/manage.py",
		"modules/org/openteacher/testserver/ot_testserver/__init__.py",
		"modules/org/openteacher/testserver/ot_testserver/testserver/models.py",
		"modules/org/openteacher/testserver/ot_testserver/testserver/forms.py",
		"modules/org/openteacher/testserver/ot_testserver/testserver/views.py",
		"modules/org/openteacher/testserver/ot_testserver/testserver/urls.py",
		"modules/org/openteacher/testserver/ot_testserver/testserver/COPYING",
		"modules/org/openteacher/testserver/ot_testserver/testserver/__init__.py",
		"modules/org/openteacher/testserver/admin_files/COPYING",
		"modules/org/openteacher/testserver/admin_files/css/login.css",
		"modules/org/openteacher/testserver/admin_files/css/forms.css",
		"modules/org/openteacher/testserver/admin_files/css/widgets.css",
		"modules/org/openteacher/testserver/admin_files/css/changelists.css",
		"modules/org/openteacher/testserver/admin_files/css/dashboard.css",
		"modules/org/openteacher/testserver/admin_files/css/ie.css",
		"modules/org/openteacher/testserver/admin_files/css/base.css",
		"modules/org/openteacher/testserver/admin_files/css/rtl.css",
		"modules/org/openteacher/testserver/admin_files/img/gis/move_vertex_on.png",
		"modules/org/openteacher/testserver/admin_files/img/gis/move_vertex_off.png",
		"modules/org/openteacher/testserver/admin_files/img/admin/deleted-overlay.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/tool-left_over.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/tool-left.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/tool-right_over.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/tool-right.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/chooser_stacked-bg.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/changelist-bg_rtl.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/selector-remove.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/inline-restore.png",
		"modules/org/openteacher/testserver/admin_files/img/admin/chooser-bg.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/tooltag-add.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/inline-delete-8bit.png",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon-no.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/selector-addall.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon_searchbox.png",
		"modules/org/openteacher/testserver/admin_files/img/admin/inline-restore-8bit.png",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon_success.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/default-bg-reverse.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/arrow-up.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/default-bg.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/selector_stacked-remove.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/nav-bg-grabber.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon_clock.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/selector-removeall.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/nav-bg.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/selector_stacked-add.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/tooltag-arrowright.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon_addlink.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon_deletelink.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/inline-delete.png",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon_calendar.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/selector-add.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon-unknown.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon-yes.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/tooltag-arrowright_over.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/changelist-bg.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/nav-bg-reverse.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon_changelink.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon_error.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/tooltag-add_over.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/selector-search.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/icon_alert.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/arrow-down.gif",
		"modules/org/openteacher/testserver/admin_files/img/admin/inline-splitter-bg.gif",
		"modules/org/openteacher/testserver/admin_files/js/SelectFilter2.js",
		"modules/org/openteacher/testserver/admin_files/js/core.js",
		"modules/org/openteacher/testserver/admin_files/js/LICENSE-JQUERY.txt",
		"modules/org/openteacher/testserver/admin_files/js/jquery.min.js",
		"modules/org/openteacher/testserver/admin_files/js/SelectBox.js",
		"modules/org/openteacher/testserver/admin_files/js/urlify.js",
		"modules/org/openteacher/testserver/admin_files/js/getElementsBySelector.js",
		"modules/org/openteacher/testserver/admin_files/js/jquery.init.js",
		"modules/org/openteacher/testserver/admin_files/js/prepopulate.js",
		"modules/org/openteacher/testserver/admin_files/js/compress.py",
		"modules/org/openteacher/testserver/admin_files/js/actions.min.js",
		"modules/org/openteacher/testserver/admin_files/js/inlines.js",
		"modules/org/openteacher/testserver/admin_files/js/jquery.js",
		"modules/org/openteacher/testserver/admin_files/js/dateparse.js",
		"modules/org/openteacher/testserver/admin_files/js/inlines.min.js",
		"modules/org/openteacher/testserver/admin_files/js/collapse.min.js",
		"modules/org/openteacher/testserver/admin_files/js/calendar.js",
		"modules/org/openteacher/testserver/admin_files/js/timeparse.js",
		"modules/org/openteacher/testserver/admin_files/js/prepopulate.min.js",
		"modules/org/openteacher/testserver/admin_files/js/actions.js",
		"modules/org/openteacher/testserver/admin_files/js/collapse.js",
		"modules/org/openteacher/testserver/admin_files/js/admin/ordering.js",
		"modules/org/openteacher/testserver/admin_files/js/admin/RelatedObjectLookups.js",
		"modules/org/openteacher/testserver/admin_files/js/admin/DateTimeShortcuts.js",
		"modules/org/openteacher/qtAppTest/qtAppTest.py",
		"modules/org/openteacher/savers/test/test.py",
		"modules/org/openteacher/savers/t2k/template.xml",
		"modules/org/openteacher/savers/t2k/t2k.py",
		"modules/org/openteacher/savers/t2k/translations/si.po",
		"modules/org/openteacher/savers/t2k/translations/fy.po",
		"modules/org/openteacher/savers/t2k/translations/pt_BR.mo",
		"modules/org/openteacher/savers/t2k/translations/zh_CN.mo",
		"modules/org/openteacher/savers/t2k/translations/cs.mo",
		"modules/org/openteacher/savers/t2k/translations/fr.mo",
		"modules/org/openteacher/savers/t2k/translations/es.po",
		"modules/org/openteacher/savers/t2k/translations/nl.po",
		"modules/org/openteacher/savers/t2k/translations/ru.po",
		"modules/org/openteacher/savers/t2k/translations/nl.mo",
		"modules/org/openteacher/savers/t2k/translations/zh_CN.po",
		"modules/org/openteacher/savers/t2k/translations/zh_TW.po",
		"modules/org/openteacher/savers/t2k/translations/zh_TW.mo",
		"modules/org/openteacher/savers/t2k/translations/de.po",
		"modules/org/openteacher/savers/t2k/translations/pt_BR.po",
		"modules/org/openteacher/savers/t2k/translations/es.mo",
		"modules/org/openteacher/savers/t2k/translations/ru.mo",
		"modules/org/openteacher/savers/t2k/translations/de.mo",
		"modules/org/openteacher/savers/t2k/translations/org.openteacher.savers.t2k.pot",
		"modules/org/openteacher/savers/t2k/translations/si.mo",
		"modules/org/openteacher/savers/t2k/translations/cs.po",
		"modules/org/openteacher/savers/t2k/translations/fy.mo",
		"modules/org/openteacher/savers/t2k/translations/fr.po",
		"modules/org/openteacher/savers/wordsHtml/wordsHtml.py",
		"modules/org/openteacher/savers/wordsHtml/translations/org.openteacher.savers.wordsHtml.pot",
		"modules/org/openteacher/savers/wordsHtml/translations/si.po",
		"modules/org/openteacher/savers/wordsHtml/translations/fy.po",
		"modules/org/openteacher/savers/wordsHtml/translations/pt_BR.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/zh_CN.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/cs.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/fr.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/es.po",
		"modules/org/openteacher/savers/wordsHtml/translations/nl.po",
		"modules/org/openteacher/savers/wordsHtml/translations/ru.po",
		"modules/org/openteacher/savers/wordsHtml/translations/nl.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/zh_CN.po",
		"modules/org/openteacher/savers/wordsHtml/translations/zh_TW.po",
		"modules/org/openteacher/savers/wordsHtml/translations/zh_TW.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/de.po",
		"modules/org/openteacher/savers/wordsHtml/translations/pt_BR.po",
		"modules/org/openteacher/savers/wordsHtml/translations/es.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/ru.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/de.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/si.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/cs.po",
		"modules/org/openteacher/savers/wordsHtml/translations/fy.mo",
		"modules/org/openteacher/savers/wordsHtml/translations/fr.po",
		"modules/org/openteacher/savers/txt/txt.py",
		"modules/org/openteacher/savers/txt/translations/si.po",
		"modules/org/openteacher/savers/txt/translations/fy.po",
		"modules/org/openteacher/savers/txt/translations/pt_BR.mo",
		"modules/org/openteacher/savers/txt/translations/zh_CN.mo",
		"modules/org/openteacher/savers/txt/translations/cs.mo",
		"modules/org/openteacher/savers/txt/translations/pl.mo",
		"modules/org/openteacher/savers/txt/translations/fr.mo",
		"modules/org/openteacher/savers/txt/translations/es.po",
		"modules/org/openteacher/savers/txt/translations/nl.po",
		"modules/org/openteacher/savers/txt/translations/ru.po",
		"modules/org/openteacher/savers/txt/translations/pl.po",
		"modules/org/openteacher/savers/txt/translations/nl.mo",
		"modules/org/openteacher/savers/txt/translations/zh_CN.po",
		"modules/org/openteacher/savers/txt/translations/zh_TW.po",
		"modules/org/openteacher/savers/txt/translations/zh_TW.mo",
		"modules/org/openteacher/savers/txt/translations/de.po",
		"modules/org/openteacher/savers/txt/translations/pt_BR.po",
		"modules/org/openteacher/savers/txt/translations/es.mo",
		"modules/org/openteacher/savers/txt/translations/ru.mo",
		"modules/org/openteacher/savers/txt/translations/org.openteacher.savers.txt.pot",
		"modules/org/openteacher/savers/txt/translations/de.mo",
		"modules/org/openteacher/savers/txt/translations/si.mo",
		"modules/org/openteacher/savers/txt/translations/cs.po",
		"modules/org/openteacher/savers/txt/translations/fy.mo",
		"modules/org/openteacher/savers/txt/translations/fr.po",
		"modules/org/openteacher/savers/csv_/csv_.py",
		"modules/org/openteacher/savers/csv_/translations/fy.po",
		"modules/org/openteacher/savers/csv_/translations/pt_BR.mo",
		"modules/org/openteacher/savers/csv_/translations/pl.mo",
		"modules/org/openteacher/savers/csv_/translations/fr.mo",
		"modules/org/openteacher/savers/csv_/translations/nl.po",
		"modules/org/openteacher/savers/csv_/translations/ru.po",
		"modules/org/openteacher/savers/csv_/translations/pl.po",
		"modules/org/openteacher/savers/csv_/translations/nl.mo",
		"modules/org/openteacher/savers/csv_/translations/zh_TW.po",
		"modules/org/openteacher/savers/csv_/translations/org.openteacher.savers.csv_.pot",
		"modules/org/openteacher/savers/csv_/translations/zh_TW.mo",
		"modules/org/openteacher/savers/csv_/translations/de.po",
		"modules/org/openteacher/savers/csv_/translations/pt_BR.po",
		"modules/org/openteacher/savers/csv_/translations/ru.mo",
		"modules/org/openteacher/savers/csv_/translations/de.mo",
		"modules/org/openteacher/savers/csv_/translations/fy.mo",
		"modules/org/openteacher/savers/csv_/translations/fr.po",
		"modules/org/openteacher/savers/odt/odt.py",
		"modules/org/openteacher/savers/odt/translations/pt_BR.mo",
		"modules/org/openteacher/savers/odt/translations/nl.po",
		"modules/org/openteacher/savers/odt/translations/ru.po",
		"modules/org/openteacher/savers/odt/translations/nl.mo",
		"modules/org/openteacher/savers/odt/translations/zh_TW.po",
		"modules/org/openteacher/savers/odt/translations/zh_TW.mo",
		"modules/org/openteacher/savers/odt/translations/de.po",
		"modules/org/openteacher/savers/odt/translations/pt_BR.po",
		"modules/org/openteacher/savers/odt/translations/ru.mo",
		"modules/org/openteacher/savers/odt/translations/de.mo",
		"modules/org/openteacher/savers/odt/translations/org.openteacher.savers.odt.pot",
		"modules/org/openteacher/savers/png/png.py",
		"modules/org/openteacher/savers/png/translations/si.po",
		"modules/org/openteacher/savers/png/translations/fy.po",
		"modules/org/openteacher/savers/png/translations/pt_BR.mo",
		"modules/org/openteacher/savers/png/translations/zh_CN.mo",
		"modules/org/openteacher/savers/png/translations/cs.mo",
		"modules/org/openteacher/savers/png/translations/fr.mo",
		"modules/org/openteacher/savers/png/translations/es.po",
		"modules/org/openteacher/savers/png/translations/nl.po",
		"modules/org/openteacher/savers/png/translations/ru.po",
		"modules/org/openteacher/savers/png/translations/nl.mo",
		"modules/org/openteacher/savers/png/translations/zh_CN.po",
		"modules/org/openteacher/savers/png/translations/zh_TW.po",
		"modules/org/openteacher/savers/png/translations/org.openteacher.savers.png.pot",
		"modules/org/openteacher/savers/png/translations/zh_TW.mo",
		"modules/org/openteacher/savers/png/translations/de.po",
		"modules/org/openteacher/savers/png/translations/pt_BR.po",
		"modules/org/openteacher/savers/png/translations/es.mo",
		"modules/org/openteacher/savers/png/translations/ru.mo",
		"modules/org/openteacher/savers/png/translations/de.mo",
		"modules/org/openteacher/savers/png/translations/si.mo",
		"modules/org/openteacher/savers/png/translations/cs.po",
		"modules/org/openteacher/savers/png/translations/fy.mo",
		"modules/org/openteacher/savers/png/translations/fr.po",
		"modules/org/openteacher/savers/mediaHtml/mediaHtml.py",
		"modules/org/openteacher/savers/mediaHtml/translations/si.po",
		"modules/org/openteacher/savers/mediaHtml/translations/fy.po",
		"modules/org/openteacher/savers/mediaHtml/translations/pt_BR.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/zh_CN.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/cs.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/fr.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/es.po",
		"modules/org/openteacher/savers/mediaHtml/translations/nl.po",
		"modules/org/openteacher/savers/mediaHtml/translations/ru.po",
		"modules/org/openteacher/savers/mediaHtml/translations/nl.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/zh_CN.po",
		"modules/org/openteacher/savers/mediaHtml/translations/zh_TW.po",
		"modules/org/openteacher/savers/mediaHtml/translations/org.openteacher.savers.mediaHtml.pot",
		"modules/org/openteacher/savers/mediaHtml/translations/zh_TW.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/de.po",
		"modules/org/openteacher/savers/mediaHtml/translations/pt_BR.po",
		"modules/org/openteacher/savers/mediaHtml/translations/es.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/ru.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/de.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/si.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/cs.po",
		"modules/org/openteacher/savers/mediaHtml/translations/fy.mo",
		"modules/org/openteacher/savers/mediaHtml/translations/fr.po",
		"modules/org/openteacher/savers/ot/ot.py",
		"modules/org/openteacher/savers/ot/template.xml",
		"modules/org/openteacher/savers/ot/translations/si.po",
		"modules/org/openteacher/savers/ot/translations/fy.po",
		"modules/org/openteacher/savers/ot/translations/pt_BR.mo",
		"modules/org/openteacher/savers/ot/translations/zh_CN.mo",
		"modules/org/openteacher/savers/ot/translations/cs.mo",
		"modules/org/openteacher/savers/ot/translations/pl.mo",
		"modules/org/openteacher/savers/ot/translations/fr.mo",
		"modules/org/openteacher/savers/ot/translations/es.po",
		"modules/org/openteacher/savers/ot/translations/nl.po",
		"modules/org/openteacher/savers/ot/translations/ru.po",
		"modules/org/openteacher/savers/ot/translations/pl.po",
		"modules/org/openteacher/savers/ot/translations/nl.mo",
		"modules/org/openteacher/savers/ot/translations/zh_CN.po",
		"modules/org/openteacher/savers/ot/translations/zh_TW.po",
		"modules/org/openteacher/savers/ot/translations/zh_TW.mo",
		"modules/org/openteacher/savers/ot/translations/de.po",
		"modules/org/openteacher/savers/ot/translations/pt_BR.po",
		"modules/org/openteacher/savers/ot/translations/es.mo",
		"modules/org/openteacher/savers/ot/translations/ru.mo",
		"modules/org/openteacher/savers/ot/translations/de.mo",
		"modules/org/openteacher/savers/ot/translations/si.mo",
		"modules/org/openteacher/savers/ot/translations/org.openteacher.savers.ot.pot",
		"modules/org/openteacher/savers/ot/translations/cs.po",
		"modules/org/openteacher/savers/ot/translations/fy.mo",
		"modules/org/openteacher/savers/ot/translations/fr.po",
		"modules/org/openteacher/savers/wrts/template.xml",
		"modules/org/openteacher/savers/wrts/wrts.py",
		"modules/org/openteacher/savers/wrts/translations/si.po",
		"modules/org/openteacher/savers/wrts/translations/fy.po",
		"modules/org/openteacher/savers/wrts/translations/pt_BR.mo",
		"modules/org/openteacher/savers/wrts/translations/zh_CN.mo",
		"modules/org/openteacher/savers/wrts/translations/cs.mo",
		"modules/org/openteacher/savers/wrts/translations/pl.mo",
		"modules/org/openteacher/savers/wrts/translations/fr.mo",
		"modules/org/openteacher/savers/wrts/translations/es.po",
		"modules/org/openteacher/savers/wrts/translations/nl.po",
		"modules/org/openteacher/savers/wrts/translations/ru.po",
		"modules/org/openteacher/savers/wrts/translations/ar.po",
		"modules/org/openteacher/savers/wrts/translations/pl.po",
		"modules/org/openteacher/savers/wrts/translations/nl.mo",
		"modules/org/openteacher/savers/wrts/translations/zh_CN.po",
		"modules/org/openteacher/savers/wrts/translations/zh_TW.po",
		"modules/org/openteacher/savers/wrts/translations/org.openteacher.savers.wrts.pot",
		"modules/org/openteacher/savers/wrts/translations/zh_TW.mo",
		"modules/org/openteacher/savers/wrts/translations/de.po",
		"modules/org/openteacher/savers/wrts/translations/ar.mo",
		"modules/org/openteacher/savers/wrts/translations/pt_BR.po",
		"modules/org/openteacher/savers/wrts/translations/es.mo",
		"modules/org/openteacher/savers/wrts/translations/ru.mo",
		"modules/org/openteacher/savers/wrts/translations/de.mo",
		"modules/org/openteacher/savers/wrts/translations/si.mo",
		"modules/org/openteacher/savers/wrts/translations/cs.po",
		"modules/org/openteacher/savers/wrts/translations/fy.mo",
		"modules/org/openteacher/savers/wrts/translations/fr.po",
		"modules/org/openteacher/savers/pdf/pdf.py",
		"modules/org/openteacher/savers/pdf/translations/si.po",
		"modules/org/openteacher/savers/pdf/translations/fy.po",
		"modules/org/openteacher/savers/pdf/translations/pt_BR.mo",
		"modules/org/openteacher/savers/pdf/translations/zh_CN.mo",
		"modules/org/openteacher/savers/pdf/translations/cs.mo",
		"modules/org/openteacher/savers/pdf/translations/fr.mo",
		"modules/org/openteacher/savers/pdf/translations/es.po",
		"modules/org/openteacher/savers/pdf/translations/nl.po",
		"modules/org/openteacher/savers/pdf/translations/ru.po",
		"modules/org/openteacher/savers/pdf/translations/nl.mo",
		"modules/org/openteacher/savers/pdf/translations/zh_CN.po",
		"modules/org/openteacher/savers/pdf/translations/org.openteacher.savers.pdf.pot",
		"modules/org/openteacher/savers/pdf/translations/zh_TW.po",
		"modules/org/openteacher/savers/pdf/translations/zh_TW.mo",
		"modules/org/openteacher/savers/pdf/translations/de.po",
		"modules/org/openteacher/savers/pdf/translations/pt_BR.po",
		"modules/org/openteacher/savers/pdf/translations/es.mo",
		"modules/org/openteacher/savers/pdf/translations/ru.mo",
		"modules/org/openteacher/savers/pdf/translations/de.mo",
		"modules/org/openteacher/savers/pdf/translations/si.mo",
		"modules/org/openteacher/savers/pdf/translations/cs.po",
		"modules/org/openteacher/savers/pdf/translations/fy.mo",
		"modules/org/openteacher/savers/pdf/translations/fr.po",
		"modules/org/openteacher/savers/kvtml/template.xml",
		"modules/org/openteacher/savers/kvtml/kvtml.py",
		"modules/org/openteacher/savers/kvtml/translations/pt_BR.mo",
		"modules/org/openteacher/savers/kvtml/translations/org.openteacher.savers.kvtml.pot",
		"modules/org/openteacher/savers/kvtml/translations/nl.po",
		"modules/org/openteacher/savers/kvtml/translations/ru.po",
		"modules/org/openteacher/savers/kvtml/translations/nl.mo",
		"modules/org/openteacher/savers/kvtml/translations/zh_TW.po",
		"modules/org/openteacher/savers/kvtml/translations/zh_TW.mo",
		"modules/org/openteacher/savers/kvtml/translations/de.po",
		"modules/org/openteacher/savers/kvtml/translations/pt_BR.po",
		"modules/org/openteacher/savers/kvtml/translations/ru.mo",
		"modules/org/openteacher/savers/kvtml/translations/de.mo",
		"modules/org/openteacher/savers/topoHtml/topoHtml.py",
		"modules/org/openteacher/savers/topoHtml/translations/si.po",
		"modules/org/openteacher/savers/topoHtml/translations/fy.po",
		"modules/org/openteacher/savers/topoHtml/translations/pt_BR.mo",
		"modules/org/openteacher/savers/topoHtml/translations/zh_CN.mo",
		"modules/org/openteacher/savers/topoHtml/translations/cs.mo",
		"modules/org/openteacher/savers/topoHtml/translations/fr.mo",
		"modules/org/openteacher/savers/topoHtml/translations/es.po",
		"modules/org/openteacher/savers/topoHtml/translations/nl.po",
		"modules/org/openteacher/savers/topoHtml/translations/ru.po",
		"modules/org/openteacher/savers/topoHtml/translations/nl.mo",
		"modules/org/openteacher/savers/topoHtml/translations/zh_CN.po",
		"modules/org/openteacher/savers/topoHtml/translations/zh_TW.po",
		"modules/org/openteacher/savers/topoHtml/translations/zh_TW.mo",
		"modules/org/openteacher/savers/topoHtml/translations/de.po",
		"modules/org/openteacher/savers/topoHtml/translations/pt_BR.po",
		"modules/org/openteacher/savers/topoHtml/translations/es.mo",
		"modules/org/openteacher/savers/topoHtml/translations/ru.mo",
		"modules/org/openteacher/savers/topoHtml/translations/de.mo",
		"modules/org/openteacher/savers/topoHtml/translations/org.openteacher.savers.topoHtml.pot",
		"modules/org/openteacher/savers/topoHtml/translations/si.mo",
		"modules/org/openteacher/savers/topoHtml/translations/cs.po",
		"modules/org/openteacher/savers/topoHtml/translations/fy.mo",
		"modules/org/openteacher/savers/topoHtml/translations/fr.po",
		"modules/org/openteacher/savers/ottp/ottp.py",
		"modules/org/openteacher/savers/ottp/translations/fy.po",
		"modules/org/openteacher/savers/ottp/translations/pt_BR.mo",
		"modules/org/openteacher/savers/ottp/translations/cs.mo",
		"modules/org/openteacher/savers/ottp/translations/fr.mo",
		"modules/org/openteacher/savers/ottp/translations/es.po",
		"modules/org/openteacher/savers/ottp/translations/nl.po",
		"modules/org/openteacher/savers/ottp/translations/ru.po",
		"modules/org/openteacher/savers/ottp/translations/nl.mo",
		"modules/org/openteacher/savers/ottp/translations/zh_TW.po",
		"modules/org/openteacher/savers/ottp/translations/zh_TW.mo",
		"modules/org/openteacher/savers/ottp/translations/de.po",
		"modules/org/openteacher/savers/ottp/translations/pt_BR.po",
		"modules/org/openteacher/savers/ottp/translations/es.mo",
		"modules/org/openteacher/savers/ottp/translations/ru.mo",
		"modules/org/openteacher/savers/ottp/translations/de.mo",
		"modules/org/openteacher/savers/ottp/translations/cs.po",
		"modules/org/openteacher/savers/ottp/translations/org.openteacher.savers.ottp.pot",
		"modules/org/openteacher/savers/ottp/translations/fy.mo",
		"modules/org/openteacher/savers/ottp/translations/fr.po",
		"modules/org/openteacher/savers/otwd/otwd.py",
		"modules/org/openteacher/savers/otwd/translations/fy.po",
		"modules/org/openteacher/savers/otwd/translations/pt_BR.mo",
		"modules/org/openteacher/savers/otwd/translations/zh_CN.mo",
		"modules/org/openteacher/savers/otwd/translations/cs.mo",
		"modules/org/openteacher/savers/otwd/translations/fr.mo",
		"modules/org/openteacher/savers/otwd/translations/es.po",
		"modules/org/openteacher/savers/otwd/translations/nl.po",
		"modules/org/openteacher/savers/otwd/translations/ru.po",
		"modules/org/openteacher/savers/otwd/translations/nl.mo",
		"modules/org/openteacher/savers/otwd/translations/zh_CN.po",
		"modules/org/openteacher/savers/otwd/translations/zh_TW.po",
		"modules/org/openteacher/savers/otwd/translations/zh_TW.mo",
		"modules/org/openteacher/savers/otwd/translations/de.po",
		"modules/org/openteacher/savers/otwd/translations/org.openteacher.savers.otwd.pot",
		"modules/org/openteacher/savers/otwd/translations/pt_BR.po",
		"modules/org/openteacher/savers/otwd/translations/es.mo",
		"modules/org/openteacher/savers/otwd/translations/ru.mo",
		"modules/org/openteacher/savers/otwd/translations/de.mo",
		"modules/org/openteacher/savers/otwd/translations/cs.po",
		"modules/org/openteacher/savers/otwd/translations/fy.mo",
		"modules/org/openteacher/savers/otwd/translations/fr.po",
		"modules/org/openteacher/savers/otmd/otmd.py",
		"modules/org/openteacher/savers/otmd/translations/fy.po",
		"modules/org/openteacher/savers/otmd/translations/pt_BR.mo",
		"modules/org/openteacher/savers/otmd/translations/zh_CN.mo",
		"modules/org/openteacher/savers/otmd/translations/cs.mo",
		"modules/org/openteacher/savers/otmd/translations/pl.mo",
		"modules/org/openteacher/savers/otmd/translations/fr.mo",
		"modules/org/openteacher/savers/otmd/translations/es.po",
		"modules/org/openteacher/savers/otmd/translations/nl.po",
		"modules/org/openteacher/savers/otmd/translations/ru.po",
		"modules/org/openteacher/savers/otmd/translations/pl.po",
		"modules/org/openteacher/savers/otmd/translations/nl.mo",
		"modules/org/openteacher/savers/otmd/translations/zh_CN.po",
		"modules/org/openteacher/savers/otmd/translations/org.openteacher.savers.otmd.pot",
		"modules/org/openteacher/savers/otmd/translations/zh_TW.po",
		"modules/org/openteacher/savers/otmd/translations/zh_TW.mo",
		"modules/org/openteacher/savers/otmd/translations/de.po",
		"modules/org/openteacher/savers/otmd/translations/pt_BR.po",
		"modules/org/openteacher/savers/otmd/translations/es.mo",
		"modules/org/openteacher/savers/otmd/translations/ru.mo",
		"modules/org/openteacher/savers/otmd/translations/de.mo",
		"modules/org/openteacher/savers/otmd/translations/cs.po",
		"modules/org/openteacher/savers/otmd/translations/fy.mo",
		"modules/org/openteacher/savers/otmd/translations/fr.po",
		"modules/org/openteacher/updates/updates.py",
		"modules/org/openteacher/translationTest/translationTest.py",
		"modules/org/openteacher/mobileGenerator/logic.js.templ",
		"modules/org/openteacher/mobileGenerator/index.html.templ",
		"modules/org/openteacher/mobileGenerator/COPYING.txt",
		"modules/org/openteacher/mobileGenerator/config.xml",
		"modules/org/openteacher/mobileGenerator/header.html.templ",
		"modules/org/openteacher/mobileGenerator/mobileGenerator.py",
		"modules/org/openteacher/mobileGenerator/scr/copyrightInfoDialog.js",
		"modules/org/openteacher/mobileGenerator/scr/optionsDialog.js",
		"modules/org/openteacher/mobileGenerator/scr/jquery-1.8.2.js",
		"modules/org/openteacher/mobileGenerator/scr/practisingModeChoiceDialog.js",
		"modules/org/openteacher/mobileGenerator/scr/taboverride.js",
		"modules/org/openteacher/mobileGenerator/scr/menuDialog.js",
		"modules/org/openteacher/mobileGenerator/scr/jsdiff.js",
		"modules/org/openteacher/mobileGenerator/scr/jquery.mobile-1.2.0.js",
		"modules/org/openteacher/mobileGenerator/scr/jquery.taboverride.js",
		"modules/org/openteacher/mobileGenerator/scr/gui.js",
		"modules/org/openteacher/mobileGenerator/scr/enterTab.js",
		"modules/org/openteacher/mobileGenerator/scr/teachTab.js",
		"modules/org/openteacher/mobileGenerator/translations/fy.po",
		"modules/org/openteacher/mobileGenerator/translations/pt_BR.mo",
		"modules/org/openteacher/mobileGenerator/translations/zh_CN.mo",
		"modules/org/openteacher/mobileGenerator/translations/cs.mo",
		"modules/org/openteacher/mobileGenerator/translations/pl.mo",
		"modules/org/openteacher/mobileGenerator/translations/fr.mo",
		"modules/org/openteacher/mobileGenerator/translations/es.po",
		"modules/org/openteacher/mobileGenerator/translations/nl.po",
		"modules/org/openteacher/mobileGenerator/translations/ru.po",
		"modules/org/openteacher/mobileGenerator/translations/pl.po",
		"modules/org/openteacher/mobileGenerator/translations/nl.mo",
		"modules/org/openteacher/mobileGenerator/translations/zh_CN.po",
		"modules/org/openteacher/mobileGenerator/translations/zh_TW.po",
		"modules/org/openteacher/mobileGenerator/translations/zh_TW.mo",
		"modules/org/openteacher/mobileGenerator/translations/de.po",
		"modules/org/openteacher/mobileGenerator/translations/pt_BR.po",
		"modules/org/openteacher/mobileGenerator/translations/es.mo",
		"modules/org/openteacher/mobileGenerator/translations/ru.mo",
		"modules/org/openteacher/mobileGenerator/translations/tr.po",
		"modules/org/openteacher/mobileGenerator/translations/de.mo",
		"modules/org/openteacher/mobileGenerator/translations/cs.po",
		"modules/org/openteacher/mobileGenerator/translations/tr.mo",
		"modules/org/openteacher/mobileGenerator/translations/fy.mo",
		"modules/org/openteacher/mobileGenerator/translations/org.openteacher.mobileGenerator.pot",
		"modules/org/openteacher/mobileGenerator/translations/fr.po",
		"modules/org/openteacher/mobileGenerator/css/main.css",
		"modules/org/openteacher/mobileGenerator/css/themes/ios/styles.css",
		"modules/org/openteacher/mobileGenerator/css/themes/ios/images/tiling_stripes.gif",
		"modules/org/openteacher/mobileGenerator/css/themes/ios/images/tabSprite.png",
		"modules/org/openteacher/mobileGenerator/css/themes/ios/images/arrow_right.png",
		"modules/org/openteacher/mobileGenerator/css/themes/ios/images/backButtonSprite@2x.png",
		"modules/org/openteacher/mobileGenerator/css/themes/ios/images/arrow_right@2x.png",
		"modules/org/openteacher/mobileGenerator/css/themes/ios/images/tick.png",
		"modules/org/openteacher/mobileGenerator/css/themes/ios/images/backButtonSprite.png",
		"modules/org/openteacher/mobileGenerator/css/themes/ios/images/iconSprite.psd",
		"modules/org/openteacher/mobileGenerator/css/themes/ios/images/iconSprite.png",
		"modules/org/openteacher/mobileGenerator/css/themes/default/jquery.mobile-1.2.0.css",
		"modules/org/openteacher/mobileGenerator/css/themes/default/images/icons-36-black.png",
		"modules/org/openteacher/mobileGenerator/css/themes/default/images/icons-18-black.png",
		"modules/org/openteacher/mobileGenerator/css/themes/default/images/icons-18-white.png",
		"modules/org/openteacher/mobileGenerator/css/themes/default/images/ajax-loader.gif",
		"modules/org/openteacher/mobileGenerator/css/themes/default/images/icons-36-white.png",
		"modules/org/openteacher/mobileGenerator/css/themes/android/android-theme.css",
		"modules/org/openteacher/mobileGenerator/css/themes/android/images/icons-36-black.png",
		"modules/org/openteacher/mobileGenerator/css/themes/android/images/icons-18-black.png",
		"modules/org/openteacher/mobileGenerator/css/themes/android/images/icons-18-white.png",
		"modules/org/openteacher/mobileGenerator/css/themes/android/images/ajax-loader.png",
		"modules/org/openteacher/mobileGenerator/css/themes/android/images/icons-36-white.png",
		"modules/org/openteacher/codeDocs/rst-directive.py",
		"modules/org/openteacher/codeDocs/codeDocs.py",
		"modules/org/openteacher/codeDocs/resources/jquery.quicksearch.js",
		"modules/org/openteacher/codeDocs/resources/COPYING",
		"modules/org/openteacher/codeDocs/resources/jquery.tablesorter.js",
		"modules/org/openteacher/codeDocs/resources/fixme.jpg",
		"modules/org/openteacher/codeDocs/resources/jquery.js",
		"modules/org/openteacher/codeDocs/resources/priority.jpg",
		"modules/org/openteacher/codeDocs/resources/tablesorter/asc.gif",
		"modules/org/openteacher/codeDocs/resources/tablesorter/bg.gif",
		"modules/org/openteacher/codeDocs/resources/tablesorter/desc.gif",
		"modules/org/openteacher/codeDocs/templ/module.html",
		"modules/org/openteacher/codeDocs/templ/modules.html",
		"modules/org/openteacher/codeDocs/templ/dev_docs.html",
		"modules/org/openteacher/codeDocs/templ/style.css",
		"modules/org/openteacher/codeDocs/templ/fixmes.html",
		"modules/org/openteacher/codeDocs/templ/priorities.html",
		"modules/org/openteacher/studyStackApi/studyStackApi.py",
		"modules/org/openteacher/studyStackApi/translations/pt_BR.mo",
		"modules/org/openteacher/studyStackApi/translations/nl.po",
		"modules/org/openteacher/studyStackApi/translations/ru.po",
		"modules/org/openteacher/studyStackApi/translations/nl.mo",
		"modules/org/openteacher/studyStackApi/translations/zh_TW.po",
		"modules/org/openteacher/studyStackApi/translations/zh_TW.mo",
		"modules/org/openteacher/studyStackApi/translations/pt_BR.po",
		"modules/org/openteacher/studyStackApi/translations/ru.mo",
		"modules/org/openteacher/studyStackApi/translations/tr.po",
		"modules/org/openteacher/studyStackApi/translations/org.openteacher.studyStackApi.pot",
		"modules/org/openteacher/studyStackApi/translations/tr.mo",
		"modules/org/openteacher/settingsFilterer/settingsFilterer.py",
		"modules/org/openteacher/settingsFilterer/translations/fy.po",
		"modules/org/openteacher/settingsFilterer/translations/pt_BR.mo",
		"modules/org/openteacher/settingsFilterer/translations/pl.mo",
		"modules/org/openteacher/settingsFilterer/translations/fr.mo",
		"modules/org/openteacher/settingsFilterer/translations/es.po",
		"modules/org/openteacher/settingsFilterer/translations/nl.po",
		"modules/org/openteacher/settingsFilterer/translations/ru.po",
		"modules/org/openteacher/settingsFilterer/translations/pl.po",
		"modules/org/openteacher/settingsFilterer/translations/nl.mo",
		"modules/org/openteacher/settingsFilterer/translations/zh_TW.po",
		"modules/org/openteacher/settingsFilterer/translations/zh_TW.mo",
		"modules/org/openteacher/settingsFilterer/translations/de.po",
		"modules/org/openteacher/settingsFilterer/translations/pt_BR.po",
		"modules/org/openteacher/settingsFilterer/translations/es.mo",
		"modules/org/openteacher/settingsFilterer/translations/ru.mo",
		"modules/org/openteacher/settingsFilterer/translations/tr.po",
		"modules/org/openteacher/settingsFilterer/translations/de.mo",
		"modules/org/openteacher/settingsFilterer/translations/org.openteacher.settingsFilterer.pot",
		"modules/org/openteacher/settingsFilterer/translations/tr.mo",
		"modules/org/openteacher/settingsFilterer/translations/fy.mo",
		"modules/org/openteacher/settingsFilterer/translations/fr.po",
		"modules/org/openteacher/languageCodeGuesserTableGenerator/languageCodeGuesserTableGenerator.py",
		"modules/org/openteacher/profileDescriptions/test/test.py",
		"modules/org/openteacher/profileDescriptions/teacher/teacher.py",
		"modules/org/openteacher/profileDescriptions/teacher/translations/ja.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/pl.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/es.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/ru.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/pl.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/de.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/ja.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/ru.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/org.openteacher.profileDescriptions.teacher.pot",
		"modules/org/openteacher/profileDescriptions/teacher/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/teacher/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/teacher/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/codeDocumentation/codeDocumentation.py",
		"modules/org/openteacher/profileDescriptions/updateTranslations/updateTranslations.py",
		"modules/org/openteacher/profileDescriptions/generateLanguageCodeGuesserTable/generateLanguageCodeGuesserTable.py",
		"modules/org/openteacher/profileDescriptions/wordsOnly/wordsOnly.py",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/ja.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/pl.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/es.po",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/ru.po",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/pl.po",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/de.po",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/org.openteacher.profileDescriptions.wordsOnly.pot",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/ja.po",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/ru.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/wordsOnly/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/packageSource/packageSource.py",
		"modules/org/openteacher/profileDescriptions/generateWebsite/generateWebsite.py",
		"modules/org/openteacher/profileDescriptions/help/help.py",
		"modules/org/openteacher/profileDescriptions/help/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/help/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/pl.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/es.po",
		"modules/org/openteacher/profileDescriptions/help/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/help/translations/ru.po",
		"modules/org/openteacher/profileDescriptions/help/translations/pl.po",
		"modules/org/openteacher/profileDescriptions/help/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/help/translations/org.openteacher.profileDescriptions.help.pot",
		"modules/org/openteacher/profileDescriptions/help/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/help/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/ru.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/packageWindowsPortable.py",
		"modules/org/openteacher/profileDescriptions/packageRpm/packageRpm.py",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/getTranslationAuthors.py",
		"modules/org/openteacher/profileDescriptions/studentAtHome/studentAtHome.py",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/ja.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/pl.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/es.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/ru.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/pl.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/de.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/ja.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/ru.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/org.openteacher.profileDescriptions.studentAtHome.pot",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/packageDebian/packageDebian.py",
		"modules/org/openteacher/profileDescriptions/testServer/testServer.py",
		"modules/org/openteacher/profileDescriptions/testServer/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/testServer/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/testServer/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/testServer/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/testServer/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/testServer/translations/es.po",
		"modules/org/openteacher/profileDescriptions/testServer/translations/org.openteacher.profileDescriptions.testServer.pot",
		"modules/org/openteacher/profileDescriptions/testServer/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/testServer/translations/ru.po",
		"modules/org/openteacher/profileDescriptions/testServer/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/testServer/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/testServer/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/testServer/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/testServer/translations/de.po",
		"modules/org/openteacher/profileDescriptions/testServer/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/testServer/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/testServer/translations/ru.mo",
		"modules/org/openteacher/profileDescriptions/testServer/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/testServer/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/testServer/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/testServer/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/webApiServer/webApiServer.py",
		"modules/org/openteacher/profileDescriptions/selfstudy/selfstudy.py",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/ja.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/pl.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/es.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/ru.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/pl.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/de.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/ja.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/ru.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/org.openteacher.profileDescriptions.selfstudy.pot",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/all/all.py",
		"modules/org/openteacher/profileDescriptions/all/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/all/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/pl.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/es.po",
		"modules/org/openteacher/profileDescriptions/all/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/all/translations/ru.po",
		"modules/org/openteacher/profileDescriptions/all/translations/pl.po",
		"modules/org/openteacher/profileDescriptions/all/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/all/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/all/translations/org.openteacher.profileDescriptions.all.pot",
		"modules/org/openteacher/profileDescriptions/all/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/de.po",
		"modules/org/openteacher/profileDescriptions/all/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/all/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/ru.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/all/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/updateRosettaPriorities/updateRosettaPriorities.py",
		"modules/org/openteacher/profileDescriptions/testSuite/testSuite.py",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/packageSourceWithSetup.py",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/studentAtSchool.py",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/ja.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/pl.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/es.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/ru.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/pl.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/de.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/ja.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/ru.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/org.openteacher.profileDescriptions.studentAtSchool.pot",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/packageWindowsMsi.py",
		"modules/org/openteacher/profileDescriptions/packageMac/packageMac.py",
		"modules/org/openteacher/profileDescriptions/moduleGraph/moduleGraph.py",
		"modules/org/openteacher/profileDescriptions/codeComplexity/codeComplexity.py",
		"modules/org/openteacher/profileDescriptions/shell/shell.py",
		"modules/org/openteacher/profileDescriptions/generateMobile/generateMobile.py",
		"modules/org/openteacher/profileDescriptions/generateBusinessCard/generateBusinessCard.py",
		"modules/org/openteacher/profileDescriptions/cli/cli.py",
		"modules/org/openteacher/profileDescriptions/packageArch/packageArch.py",
		"modules/org/openteacher/profileDescriptions/ircBot/ircBot.py",
		"modules/org/openteacher/mimicryTypefaceConverterTest/mimicryTypefaceConverterTest.py",
		"modules/org/openteacher/dataTypeIcons/dataTypeIcons.py",
		"modules/org/openteacher/dataTypeIcons/icons/words.png",
		"modules/org/openteacher/dataTypeIcons/icons/COPYING",
		"modules/org/openteacher/dataTypeIcons/icons/media.png",
		"modules/org/openteacher/dataTypeIcons/icons/topo.png",
		"modules/org/openteacher/percentNotesViewer/percentNotesViewer.py",
		"modules/org/openteacher/dialogShower/dialogShower.py",
		"modules/org/openteacher/dialogShower/images/COPYING",
		"modules/org/openteacher/dialogShower/images/ot240.png",
		"modules/org/openteacher/dialogShower/images/ot2300.png",
		"modules/org/openteacher/dialogShower/images/otbroken240.png",
		"modules/org/openteacher/dialogShower/images/otbroken2300.png",
		"modules/org/openteacher/textToSpeech/textToSpeech.py",
		"modules/org/openteacher/textToSpeech/translations/org.openteacher.textToSpeech.pot",
		"modules/org/openteacher/textToSpeech/translations/fi.po",
		"modules/org/openteacher/textToSpeech/translations/si.po",
		"modules/org/openteacher/textToSpeech/translations/fy.po",
		"modules/org/openteacher/textToSpeech/translations/pt_BR.mo",
		"modules/org/openteacher/textToSpeech/translations/hu.po",
		"modules/org/openteacher/textToSpeech/translations/zh_CN.mo",
		"modules/org/openteacher/textToSpeech/translations/cs.mo",
		"modules/org/openteacher/textToSpeech/translations/pl.mo",
		"modules/org/openteacher/textToSpeech/translations/fr.mo",
		"modules/org/openteacher/textToSpeech/translations/es.po",
		"modules/org/openteacher/textToSpeech/translations/nl.po",
		"modules/org/openteacher/textToSpeech/translations/ru.po",
		"modules/org/openteacher/textToSpeech/translations/ar.po",
		"modules/org/openteacher/textToSpeech/translations/pl.po",
		"modules/org/openteacher/textToSpeech/translations/nl.mo",
		"modules/org/openteacher/textToSpeech/translations/zh_CN.po",
		"modules/org/openteacher/textToSpeech/translations/zh_TW.po",
		"modules/org/openteacher/textToSpeech/translations/zh_TW.mo",
		"modules/org/openteacher/textToSpeech/translations/de.po",
		"modules/org/openteacher/textToSpeech/translations/ar.mo",
		"modules/org/openteacher/textToSpeech/translations/pt_BR.po",
		"modules/org/openteacher/textToSpeech/translations/es.mo",
		"modules/org/openteacher/textToSpeech/translations/ru.mo",
		"modules/org/openteacher/textToSpeech/translations/hu.mo",
		"modules/org/openteacher/textToSpeech/translations/tr.po",
		"modules/org/openteacher/textToSpeech/translations/de.mo",
		"modules/org/openteacher/textToSpeech/translations/fi.mo",
		"modules/org/openteacher/textToSpeech/translations/sk.po",
		"modules/org/openteacher/textToSpeech/translations/si.mo",
		"modules/org/openteacher/textToSpeech/translations/cs.po",
		"modules/org/openteacher/textToSpeech/translations/tr.mo",
		"modules/org/openteacher/textToSpeech/translations/fy.mo",
		"modules/org/openteacher/textToSpeech/translations/sk.mo",
		"modules/org/openteacher/textToSpeech/translations/fr.po",
		"modules/org/openteacher/gui/ui.py",
		"modules/org/openteacher/gui/gui.py",
		"modules/org/openteacher/gui/icons/settings.png",
		"modules/org/openteacher/gui/icons/new.png",
		"modules/org/openteacher/gui/icons/quit.png",
		"modules/org/openteacher/gui/icons/save.png",
		"modules/org/openteacher/gui/icons/about.png",
		"modules/org/openteacher/gui/icons/COPYING",
		"modules/org/openteacher/gui/icons/save_as.png",
		"modules/org/openteacher/gui/icons/print.png",
		"modules/org/openteacher/gui/icons/help.png",
		"modules/org/openteacher/gui/icons/fullscreen.png",
		"modules/org/openteacher/gui/icons/open.png",
		"modules/org/openteacher/gui/icons/add.png",
		"modules/org/openteacher/gui/translations/fi.po",
		"modules/org/openteacher/gui/translations/ja.mo",
		"modules/org/openteacher/gui/translations/si.po",
		"modules/org/openteacher/gui/translations/en_GB.po",
		"modules/org/openteacher/gui/translations/en_GB.mo",
		"modules/org/openteacher/gui/translations/fy.po",
		"modules/org/openteacher/gui/translations/pt_BR.mo",
		"modules/org/openteacher/gui/translations/hu.po",
		"modules/org/openteacher/gui/translations/zh_CN.mo",
		"modules/org/openteacher/gui/translations/cs.mo",
		"modules/org/openteacher/gui/translations/en_AU.mo",
		"modules/org/openteacher/gui/translations/pl.mo",
		"modules/org/openteacher/gui/translations/fr.mo",
		"modules/org/openteacher/gui/translations/es.po",
		"modules/org/openteacher/gui/translations/nl.po",
		"modules/org/openteacher/gui/translations/ru.po",
		"modules/org/openteacher/gui/translations/org.openteacher.gui.pot",
		"modules/org/openteacher/gui/translations/ar.po",
		"modules/org/openteacher/gui/translations/pl.po",
		"modules/org/openteacher/gui/translations/nl.mo",
		"modules/org/openteacher/gui/translations/zh_CN.po",
		"modules/org/openteacher/gui/translations/zh_TW.po",
		"modules/org/openteacher/gui/translations/af.po",
		"modules/org/openteacher/gui/translations/eo.po",
		"modules/org/openteacher/gui/translations/zh_TW.mo",
		"modules/org/openteacher/gui/translations/de.po",
		"modules/org/openteacher/gui/translations/ar.mo",
		"modules/org/openteacher/gui/translations/pt_BR.po",
		"modules/org/openteacher/gui/translations/es.mo",
		"modules/org/openteacher/gui/translations/gl.po",
		"modules/org/openteacher/gui/translations/ja.po",
		"modules/org/openteacher/gui/translations/ru.mo",
		"modules/org/openteacher/gui/translations/it.po",
		"modules/org/openteacher/gui/translations/hu.mo",
		"modules/org/openteacher/gui/translations/it.mo",
		"modules/org/openteacher/gui/translations/tr.po",
		"modules/org/openteacher/gui/translations/de.mo",
		"modules/org/openteacher/gui/translations/fi.mo",
		"modules/org/openteacher/gui/translations/sk.po",
		"modules/org/openteacher/gui/translations/si.mo",
		"modules/org/openteacher/gui/translations/af.mo",
		"modules/org/openteacher/gui/translations/cs.po",
		"modules/org/openteacher/gui/translations/gl.mo",
		"modules/org/openteacher/gui/translations/eo.mo",
		"modules/org/openteacher/gui/translations/el.po",
		"modules/org/openteacher/gui/translations/tr.mo",
		"modules/org/openteacher/gui/translations/en_AU.po",
		"modules/org/openteacher/gui/translations/fy.mo",
		"modules/org/openteacher/gui/translations/el.mo",
		"modules/org/openteacher/gui/translations/sk.mo",
		"modules/org/openteacher/gui/translations/fr.po",
		"modules/org/openteacher/translationUpdater/translationUpdater.py",
		"modules/org/openteacher/testsViewer/testsViewer.py",
		"modules/org/openteacher/testsViewer/translations/ja.mo",
		"modules/org/openteacher/testsViewer/translations/org.openteacher.testsViewer.pot",
		"modules/org/openteacher/testsViewer/translations/si.po",
		"modules/org/openteacher/testsViewer/translations/fy.po",
		"modules/org/openteacher/testsViewer/translations/pt_BR.mo",
		"modules/org/openteacher/testsViewer/translations/hu.po",
		"modules/org/openteacher/testsViewer/translations/zh_CN.mo",
		"modules/org/openteacher/testsViewer/translations/cs.mo",
		"modules/org/openteacher/testsViewer/translations/fr.mo",
		"modules/org/openteacher/testsViewer/translations/es.po",
		"modules/org/openteacher/testsViewer/translations/nl.po",
		"modules/org/openteacher/testsViewer/translations/ru.po",
		"modules/org/openteacher/testsViewer/translations/ar.po",
		"modules/org/openteacher/testsViewer/translations/nl.mo",
		"modules/org/openteacher/testsViewer/translations/zh_CN.po",
		"modules/org/openteacher/testsViewer/translations/zh_TW.po",
		"modules/org/openteacher/testsViewer/translations/zh_TW.mo",
		"modules/org/openteacher/testsViewer/translations/de.po",
		"modules/org/openteacher/testsViewer/translations/ar.mo",
		"modules/org/openteacher/testsViewer/translations/pt_BR.po",
		"modules/org/openteacher/testsViewer/translations/es.mo",
		"modules/org/openteacher/testsViewer/translations/ja.po",
		"modules/org/openteacher/testsViewer/translations/ru.mo",
		"modules/org/openteacher/testsViewer/translations/it.po",
		"modules/org/openteacher/testsViewer/translations/hu.mo",
		"modules/org/openteacher/testsViewer/translations/it.mo",
		"modules/org/openteacher/testsViewer/translations/tr.po",
		"modules/org/openteacher/testsViewer/translations/de.mo",
		"modules/org/openteacher/testsViewer/translations/si.mo",
		"modules/org/openteacher/testsViewer/translations/cs.po",
		"modules/org/openteacher/testsViewer/translations/el.po",
		"modules/org/openteacher/testsViewer/translations/tr.mo",
		"modules/org/openteacher/testsViewer/translations/fy.mo",
		"modules/org/openteacher/testsViewer/translations/el.mo",
		"modules/org/openteacher/testsViewer/translations/fr.po",
		"modules/org/openteacher/wrtsApi/wrtsApi.py",
		"modules/org/openteacher/wrtsApi/api.py",
		"modules/org/openteacher/wrtsApi/ui.py",
		"modules/org/openteacher/wrtsApi/translations/org.openteacher.wrtsApi.pot",
		"modules/org/openteacher/wrtsApi/translations/fi.po",
		"modules/org/openteacher/wrtsApi/translations/ja.mo",
		"modules/org/openteacher/wrtsApi/translations/si.po",
		"modules/org/openteacher/wrtsApi/translations/fy.po",
		"modules/org/openteacher/wrtsApi/translations/pt_BR.mo",
		"modules/org/openteacher/wrtsApi/translations/hu.po",
		"modules/org/openteacher/wrtsApi/translations/zh_CN.mo",
		"modules/org/openteacher/wrtsApi/translations/cs.mo",
		"modules/org/openteacher/wrtsApi/translations/pl.mo",
		"modules/org/openteacher/wrtsApi/translations/fr.mo",
		"modules/org/openteacher/wrtsApi/translations/es.po",
		"modules/org/openteacher/wrtsApi/translations/nl.po",
		"modules/org/openteacher/wrtsApi/translations/ru.po",
		"modules/org/openteacher/wrtsApi/translations/ar.po",
		"modules/org/openteacher/wrtsApi/translations/pl.po",
		"modules/org/openteacher/wrtsApi/translations/nl.mo",
		"modules/org/openteacher/wrtsApi/translations/zh_CN.po",
		"modules/org/openteacher/wrtsApi/translations/zh_TW.po",
		"modules/org/openteacher/wrtsApi/translations/zh_TW.mo",
		"modules/org/openteacher/wrtsApi/translations/de.po",
		"modules/org/openteacher/wrtsApi/translations/ar.mo",
		"modules/org/openteacher/wrtsApi/translations/pt_BR.po",
		"modules/org/openteacher/wrtsApi/translations/es.mo",
		"modules/org/openteacher/wrtsApi/translations/gl.po",
		"modules/org/openteacher/wrtsApi/translations/ja.po",
		"modules/org/openteacher/wrtsApi/translations/ru.mo",
		"modules/org/openteacher/wrtsApi/translations/hu.mo",
		"modules/org/openteacher/wrtsApi/translations/de.mo",
		"modules/org/openteacher/wrtsApi/translations/fi.mo",
		"modules/org/openteacher/wrtsApi/translations/sk.po",
		"modules/org/openteacher/wrtsApi/translations/si.mo",
		"modules/org/openteacher/wrtsApi/translations/cs.po",
		"modules/org/openteacher/wrtsApi/translations/gl.mo",
		"modules/org/openteacher/wrtsApi/translations/el.po",
		"modules/org/openteacher/wrtsApi/translations/fy.mo",
		"modules/org/openteacher/wrtsApi/translations/el.mo",
		"modules/org/openteacher/wrtsApi/translations/sk.mo",
		"modules/org/openteacher/wrtsApi/translations/fr.po",
		"modules/org/openteacher/sourceSaver/sourceSaver.py",
		"modules/org/openteacher/ocr/wordListLoader/wordListLoader.py",
		"modules/org/openteacher/ocr/gui/gui.py",
		"modules/org/openteacher/ocr/gui/translations/pt_BR.mo",
		"modules/org/openteacher/ocr/gui/translations/pl.mo",
		"modules/org/openteacher/ocr/gui/translations/nl.po",
		"modules/org/openteacher/ocr/gui/translations/ru.po",
		"modules/org/openteacher/ocr/gui/translations/pl.po",
		"modules/org/openteacher/ocr/gui/translations/nl.mo",
		"modules/org/openteacher/ocr/gui/translations/zh_TW.po",
		"modules/org/openteacher/ocr/gui/translations/zh_TW.mo",
		"modules/org/openteacher/ocr/gui/translations/de.po",
		"modules/org/openteacher/ocr/gui/translations/pt_BR.po",
		"modules/org/openteacher/ocr/gui/translations/ru.mo",
		"modules/org/openteacher/ocr/gui/translations/tr.po",
		"modules/org/openteacher/ocr/gui/translations/de.mo",
		"modules/org/openteacher/ocr/gui/translations/tr.mo",
		"modules/org/openteacher/ocr/gui/translations/org.openteacher.ocr.gui.pot",
		"modules/org/openteacher/ocr/cuneiformRecognizer/cuneiformRecognizer.py",
		"modules/org/openteacher/ocr/tesseractRecognizer/tesseractRecognizer.py",
		"modules/org/openteacher/print/topo/topo.py",
		"modules/org/openteacher/print/media/media.py",
		"modules/org/openteacher/print/words/words.py",
		"modules/org/openteacher/print/words/translations/fi.po",
		"modules/org/openteacher/print/words/translations/ja.mo",
		"modules/org/openteacher/print/words/translations/fy.po",
		"modules/org/openteacher/print/words/translations/pt_BR.mo",
		"modules/org/openteacher/print/words/translations/hu.po",
		"modules/org/openteacher/print/words/translations/zh_CN.mo",
		"modules/org/openteacher/print/words/translations/cs.mo",
		"modules/org/openteacher/print/words/translations/fr.mo",
		"modules/org/openteacher/print/words/translations/es.po",
		"modules/org/openteacher/print/words/translations/nl.po",
		"modules/org/openteacher/print/words/translations/ru.po",
		"modules/org/openteacher/print/words/translations/ar.po",
		"modules/org/openteacher/print/words/translations/nl.mo",
		"modules/org/openteacher/print/words/translations/zh_CN.po",
		"modules/org/openteacher/print/words/translations/zh_TW.po",
		"modules/org/openteacher/print/words/translations/zh_TW.mo",
		"modules/org/openteacher/print/words/translations/de.po",
		"modules/org/openteacher/print/words/translations/ar.mo",
		"modules/org/openteacher/print/words/translations/pt_BR.po",
		"modules/org/openteacher/print/words/translations/es.mo",
		"modules/org/openteacher/print/words/translations/ja.po",
		"modules/org/openteacher/print/words/translations/ru.mo",
		"modules/org/openteacher/print/words/translations/hu.mo",
		"modules/org/openteacher/print/words/translations/tr.po",
		"modules/org/openteacher/print/words/translations/de.mo",
		"modules/org/openteacher/print/words/translations/fi.mo",
		"modules/org/openteacher/print/words/translations/sk.po",
		"modules/org/openteacher/print/words/translations/cs.po",
		"modules/org/openteacher/print/words/translations/el.po",
		"modules/org/openteacher/print/words/translations/tr.mo",
		"modules/org/openteacher/print/words/translations/fy.mo",
		"modules/org/openteacher/print/words/translations/el.mo",
		"modules/org/openteacher/print/words/translations/sk.mo",
		"modules/org/openteacher/print/words/translations/org.openteacher.print.words.pot",
		"modules/org/openteacher/print/words/translations/fr.po",
		"modules/org/openteacher/maps/world/world.py",
		"modules/org/openteacher/maps/world/resources/places.json",
		"modules/org/openteacher/maps/world/resources/COPYING",
		"modules/org/openteacher/maps/world/resources/map.gif",
		"modules/org/openteacher/maps/latinamerica/latinamerica.py",
		"modules/org/openteacher/maps/latinamerica/resources/places.json",
		"modules/org/openteacher/maps/latinamerica/resources/COPYING",
		"modules/org/openteacher/maps/latinamerica/resources/map.gif",
		"modules/org/openteacher/maps/usa/usa.py",
		"modules/org/openteacher/maps/usa/resources/places.json",
		"modules/org/openteacher/maps/usa/resources/COPYING",
		"modules/org/openteacher/maps/usa/resources/map.gif",
		"modules/org/openteacher/maps/asia/asia.py",
		"modules/org/openteacher/maps/asia/resources/places.json",
		"modules/org/openteacher/maps/asia/resources/COPYING",
		"modules/org/openteacher/maps/asia/resources/map.gif",
		"modules/org/openteacher/maps/africa/africa.py",
		"modules/org/openteacher/maps/africa/resources/places.json",
		"modules/org/openteacher/maps/africa/resources/COPYING",
		"modules/org/openteacher/maps/africa/resources/map.gif",
		"modules/org/openteacher/maps/europe/europe.py",
		"modules/org/openteacher/maps/europe/resources/places.json",
		"modules/org/openteacher/maps/europe/resources/COPYING",
		"modules/org/openteacher/maps/europe/resources/map.gif",
		"modules/org/openteacher/buttonRegister/buttonRegister.py",
		"modules/org/openteacher/getTranslationAuthors/getTranslationAuthors.py",
		"modules/org/openteacher/mediaTypes/youtube/youtube.py",
		"modules/org/openteacher/mediaTypes/website/website.py",
		"modules/org/openteacher/mediaTypes/liveleak/liveleak.py",
		"modules/org/openteacher/mediaTypes/vimeo/vimeo.py",
		"modules/org/openteacher/mediaTypes/image/image.py",
		"modules/org/openteacher/mediaTypes/audio/audio.py",
		"modules/org/openteacher/mediaTypes/text/text.py",
		"modules/org/openteacher/mediaTypes/video/video.py",
		"modules/org/openteacher/mediaTypes/dailymotion/dailymotion.py",
		"modules/org/openteacher/packagers/source/source.py",
		"modules/org/openteacher/packagers/mac/mac.py",
		"modules/org/openteacher/packagers/windowsPortable/windowsPortable.py",
		"modules/org/openteacher/packagers/debian/debian.py",
		"modules/org/openteacher/packagers/windowsMsi/openteacher.ico",
		"modules/org/openteacher/packagers/windowsMsi/leftbanner.bmp",
		"modules/org/openteacher/packagers/windowsMsi/topbanner.bmp",
		"modules/org/openteacher/packagers/windowsMsi/windowsMsi.py",
		"modules/org/openteacher/packagers/windowsMsi/COPYING.rtf",
		"modules/org/openteacher/packagers/sourceWithSetup/sourceWithSetup.py",
		"modules/org/openteacher/packagers/rpm/rpm.py",
		"modules/org/openteacher/packagers/arch/arch.py",
		"modules/org/openteacher/packagers/arch/PKGBUILD.templ",
		"modules/org/openteacher/dataTypeIconsTest/dataTypeIconsTest.py",
		"modules/org/openteacher/moduleManagerTest/moduleManagerTest.py",
		"modules/org/openteacher/pyinstallerInterface/icon.icns",
		"modules/org/openteacher/pyinstallerInterface/icon.ico",
		"modules/org/openteacher/pyinstallerInterface/pyinstallerInterface.py",
		"modules/org/openteacher/moduleGraphBuilder/moduleGraphBuilder.py",
		"modules/org/openteacher/wordListString/javascriptParser/parser.js",
		"modules/org/openteacher/wordListString/javascriptParser/javascriptParser.py",
		"modules/org/openteacher/wordListString/composerTest/composerTest.py",
		"modules/org/openteacher/wordListString/parserTest/parserTest.py",
		"modules/org/openteacher/wordListString/javascriptComposer/composer.js",
		"modules/org/openteacher/wordListString/javascriptComposer/javascriptComposer.py",
		"modules/org/openteacher/businessCardGenerator/businessCardGenerator.py",
		"modules/org/openteacher/friendlyTranslationNames/friendlyTranslationNames.py",
		"modules/org/openteacher/friendlyTranslationNames/translations/fi.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/ja.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/si.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/en_GB.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/en_GB.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/fy.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/pt_BR.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/hu.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/zh_CN.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/cs.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/pl.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/fr.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/es.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/nl.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/ru.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/org.openteacher.friendlyTranslationNames.pot",
		"modules/org/openteacher/friendlyTranslationNames/translations/ar.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/pl.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/nl.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/zh_CN.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/zh_TW.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/af.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/zh_TW.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/de.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/ar.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/pt_BR.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/es.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/gl.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/ja.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/ru.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/it.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/hu.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/it.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/tr.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/de.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/fi.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/si.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/af.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/cs.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/gl.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/el.po",
		"modules/org/openteacher/friendlyTranslationNames/translations/tr.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/fy.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/el.mo",
		"modules/org/openteacher/friendlyTranslationNames/translations/fr.po",
		"modules/org/openteacher/percentsCalculatorTest/percentsCalculatorTest.py",
		"modules/org/openteacher/translator/translator.py",
		"modules/org/openteacher/translator/translations/ja.mo",
		"modules/org/openteacher/translator/translations/en_GB.po",
		"modules/org/openteacher/translator/translations/en_GB.mo",
		"modules/org/openteacher/translator/translations/fy.po",
		"modules/org/openteacher/translator/translations/pt_BR.mo",
		"modules/org/openteacher/translator/translations/zh_CN.mo",
		"modules/org/openteacher/translator/translations/cs.mo",
		"modules/org/openteacher/translator/translations/pl.mo",
		"modules/org/openteacher/translator/translations/fr.mo",
		"modules/org/openteacher/translator/translations/es.po",
		"modules/org/openteacher/translator/translations/nl.po",
		"modules/org/openteacher/translator/translations/ru.po",
		"modules/org/openteacher/translator/translations/pl.po",
		"modules/org/openteacher/translator/translations/nl.mo",
		"modules/org/openteacher/translator/translations/zh_CN.po",
		"modules/org/openteacher/translator/translations/zh_TW.po",
		"modules/org/openteacher/translator/translations/zh_TW.mo",
		"modules/org/openteacher/translator/translations/de.po",
		"modules/org/openteacher/translator/translations/pt_BR.po",
		"modules/org/openteacher/translator/translations/es.mo",
		"modules/org/openteacher/translator/translations/gl.po",
		"modules/org/openteacher/translator/translations/ja.po",
		"modules/org/openteacher/translator/translations/ru.mo",
		"modules/org/openteacher/translator/translations/it.po",
		"modules/org/openteacher/translator/translations/org.openteacher.translator.pot",
		"modules/org/openteacher/translator/translations/it.mo",
		"modules/org/openteacher/translator/translations/tr.po",
		"modules/org/openteacher/translator/translations/de.mo",
		"modules/org/openteacher/translator/translations/cs.po",
		"modules/org/openteacher/translator/translations/gl.mo",
		"modules/org/openteacher/translator/translations/tr.mo",
		"modules/org/openteacher/translator/translations/fy.mo",
		"modules/org/openteacher/translator/translations/fr.po",
		"modules/org/openteacher/settings/settings.py",
		"modules/org/openteacher/moduleGraphBuilderTest/moduleGraphBuilderTest.py",
		"modules/org/openteacher/developerDocs/developerDocs.py",
		"modules/org/openteacher/developerDocs/docs/getting_started.rst",
		"modules/org/openteacher/developerDocs/docs/dev_tools.rst",
		"modules/org/openteacher/developerDocs/docs/data_format.rst",
		"modules/org/openteacher/developerDocs/docs/tools.jpg",
		"modules/org/openteacher/developerDocs/docs/user_agent.rst",
		"modules/org/openteacher/developerDocs/docs/interface.jpg",
		"modules/org/openteacher/developerDocs/docs/file_templates.rst",
		"modules/org/openteacher/developerDocs/docs/index.rst",
		"modules/org/openteacher/developerDocs/docs/modules.jpg",
		"modules/org/openteacher/developerDocs/docs/COPYING",
		"modules/org/openteacher/developerDocs/docs/dependencies.rst",
		"modules/org/openteacher/rosettaPrioritiesUpdater/rosettaPrioritiesUpdater.py",
		"modules/org/openteacher/friendlyTranslationNamesTest/friendlyTranslationNamesTest.py",
		"modules/org/openteacher/progressViewer/progressViewer.py",
		"modules/org/openteacher/progressViewer/translations/org.openteacher.progressViewer.pot",
		"modules/org/openteacher/progressViewer/translations/ja.mo",
		"modules/org/openteacher/progressViewer/translations/si.po",
		"modules/org/openteacher/progressViewer/translations/fy.po",
		"modules/org/openteacher/progressViewer/translations/pt_BR.mo",
		"modules/org/openteacher/progressViewer/translations/zh_CN.mo",
		"modules/org/openteacher/progressViewer/translations/cs.mo",
		"modules/org/openteacher/progressViewer/translations/pl.mo",
		"modules/org/openteacher/progressViewer/translations/fr.mo",
		"modules/org/openteacher/progressViewer/translations/es.po",
		"modules/org/openteacher/progressViewer/translations/nl.po",
		"modules/org/openteacher/progressViewer/translations/ru.po",
		"modules/org/openteacher/progressViewer/translations/pl.po",
		"modules/org/openteacher/progressViewer/translations/nl.mo",
		"modules/org/openteacher/progressViewer/translations/zh_CN.po",
		"modules/org/openteacher/progressViewer/translations/zh_TW.po",
		"modules/org/openteacher/progressViewer/translations/zh_TW.mo",
		"modules/org/openteacher/progressViewer/translations/de.po",
		"modules/org/openteacher/progressViewer/translations/pt_BR.po",
		"modules/org/openteacher/progressViewer/translations/es.mo",
		"modules/org/openteacher/progressViewer/translations/gl.po",
		"modules/org/openteacher/progressViewer/translations/ja.po",
		"modules/org/openteacher/progressViewer/translations/ru.mo",
		"modules/org/openteacher/progressViewer/translations/tr.po",
		"modules/org/openteacher/progressViewer/translations/de.mo",
		"modules/org/openteacher/progressViewer/translations/si.mo",
		"modules/org/openteacher/progressViewer/translations/cs.po",
		"modules/org/openteacher/progressViewer/translations/gl.mo",
		"modules/org/openteacher/progressViewer/translations/tr.mo",
		"modules/org/openteacher/progressViewer/translations/fy.mo",
		"modules/org/openteacher/progressViewer/translations/fr.po",
		"modules/org/openteacher/percentsCalculator/percentsCalculator.py",
		"modules/org/openteacher/testViewer/testViewer.py",
		"modules/org/openteacher/testViewer/translations/ja.mo",
		"modules/org/openteacher/testViewer/translations/fy.po",
		"modules/org/openteacher/testViewer/translations/pt_BR.mo",
		"modules/org/openteacher/testViewer/translations/hu.po",
		"modules/org/openteacher/testViewer/translations/zh_CN.mo",
		"modules/org/openteacher/testViewer/translations/cs.mo",
		"modules/org/openteacher/testViewer/translations/pl.mo",
		"modules/org/openteacher/testViewer/translations/fr.mo",
		"modules/org/openteacher/testViewer/translations/es.po",
		"modules/org/openteacher/testViewer/translations/nl.po",
		"modules/org/openteacher/testViewer/translations/ru.po",
		"modules/org/openteacher/testViewer/translations/ar.po",
		"modules/org/openteacher/testViewer/translations/org.openteacher.testViewer.pot",
		"modules/org/openteacher/testViewer/translations/pl.po",
		"modules/org/openteacher/testViewer/translations/nl.mo",
		"modules/org/openteacher/testViewer/translations/zh_CN.po",
		"modules/org/openteacher/testViewer/translations/zh_TW.po",
		"modules/org/openteacher/testViewer/translations/zh_TW.mo",
		"modules/org/openteacher/testViewer/translations/de.po",
		"modules/org/openteacher/testViewer/translations/ar.mo",
		"modules/org/openteacher/testViewer/translations/pt_BR.po",
		"modules/org/openteacher/testViewer/translations/es.mo",
		"modules/org/openteacher/testViewer/translations/gl.po",
		"modules/org/openteacher/testViewer/translations/ja.po",
		"modules/org/openteacher/testViewer/translations/ru.mo",
		"modules/org/openteacher/testViewer/translations/it.po",
		"modules/org/openteacher/testViewer/translations/hu.mo",
		"modules/org/openteacher/testViewer/translations/it.mo",
		"modules/org/openteacher/testViewer/translations/tr.po",
		"modules/org/openteacher/testViewer/translations/de.mo",
		"modules/org/openteacher/testViewer/translations/cs.po",
		"modules/org/openteacher/testViewer/translations/gl.mo",
		"modules/org/openteacher/testViewer/translations/el.po",
		"modules/org/openteacher/testViewer/translations/tr.mo",
		"modules/org/openteacher/testViewer/translations/fy.mo",
		"modules/org/openteacher/testViewer/translations/el.mo",
		"modules/org/openteacher/testViewer/translations/fr.po",
		"modules/org/openteacher/teachers/topo/topo.py",
		"modules/org/openteacher/teachers/topo/translations/org.openteacher.teachers.topo.pot",
		"modules/org/openteacher/teachers/topo/translations/fy.po",
		"modules/org/openteacher/teachers/topo/translations/pt_BR.mo",
		"modules/org/openteacher/teachers/topo/translations/zh_CN.mo",
		"modules/org/openteacher/teachers/topo/translations/cs.mo",
		"modules/org/openteacher/teachers/topo/translations/fr.mo",
		"modules/org/openteacher/teachers/topo/translations/es.po",
		"modules/org/openteacher/teachers/topo/translations/nl.po",
		"modules/org/openteacher/teachers/topo/translations/ru.po",
		"modules/org/openteacher/teachers/topo/translations/nl.mo",
		"modules/org/openteacher/teachers/topo/translations/zh_CN.po",
		"modules/org/openteacher/teachers/topo/translations/zh_TW.po",
		"modules/org/openteacher/teachers/topo/translations/zh_TW.mo",
		"modules/org/openteacher/teachers/topo/translations/de.po",
		"modules/org/openteacher/teachers/topo/translations/pt_BR.po",
		"modules/org/openteacher/teachers/topo/translations/es.mo",
		"modules/org/openteacher/teachers/topo/translations/ru.mo",
		"modules/org/openteacher/teachers/topo/translations/tr.po",
		"modules/org/openteacher/teachers/topo/translations/de.mo",
		"modules/org/openteacher/teachers/topo/translations/cs.po",
		"modules/org/openteacher/teachers/topo/translations/tr.mo",
		"modules/org/openteacher/teachers/topo/translations/fy.mo",
		"modules/org/openteacher/teachers/topo/translations/fr.po",
		"modules/org/openteacher/teachers/mediaTest/mediaTest.py",
		"modules/org/openteacher/teachers/media/media.py",
		"modules/org/openteacher/teachers/media/translations/fy.po",
		"modules/org/openteacher/teachers/media/translations/org.openteacher.teachers.media.pot",
		"modules/org/openteacher/teachers/media/translations/pt_BR.mo",
		"modules/org/openteacher/teachers/media/translations/zh_CN.mo",
		"modules/org/openteacher/teachers/media/translations/fr.mo",
		"modules/org/openteacher/teachers/media/translations/es.po",
		"modules/org/openteacher/teachers/media/translations/nl.po",
		"modules/org/openteacher/teachers/media/translations/ru.po",
		"modules/org/openteacher/teachers/media/translations/nl.mo",
		"modules/org/openteacher/teachers/media/translations/zh_CN.po",
		"modules/org/openteacher/teachers/media/translations/zh_TW.po",
		"modules/org/openteacher/teachers/media/translations/zh_TW.mo",
		"modules/org/openteacher/teachers/media/translations/de.po",
		"modules/org/openteacher/teachers/media/translations/pt_BR.po",
		"modules/org/openteacher/teachers/media/translations/es.mo",
		"modules/org/openteacher/teachers/media/translations/ru.mo",
		"modules/org/openteacher/teachers/media/translations/tr.po",
		"modules/org/openteacher/teachers/media/translations/de.mo",
		"modules/org/openteacher/teachers/media/translations/tr.mo",
		"modules/org/openteacher/teachers/media/translations/fy.mo",
		"modules/org/openteacher/teachers/media/translations/fr.po",
		"modules/org/openteacher/teachers/topoTest/topoTest.py",
		"modules/org/openteacher/teachers/wordsTest/wordsTest.py",
		"modules/org/openteacher/teachers/words/words.py",
		"modules/org/openteacher/teachers/words/translations/fi.po",
		"modules/org/openteacher/teachers/words/translations/ja.mo",
		"modules/org/openteacher/teachers/words/translations/si.po",
		"modules/org/openteacher/teachers/words/translations/org.openteacher.wordsTeacher.pot",
		"modules/org/openteacher/teachers/words/translations/fy.po",
		"modules/org/openteacher/teachers/words/translations/pt_BR.mo",
		"modules/org/openteacher/teachers/words/translations/hu.po",
		"modules/org/openteacher/teachers/words/translations/zh_CN.mo",
		"modules/org/openteacher/teachers/words/translations/cs.mo",
		"modules/org/openteacher/teachers/words/translations/pl.mo",
		"modules/org/openteacher/teachers/words/translations/fr.mo",
		"modules/org/openteacher/teachers/words/translations/es.po",
		"modules/org/openteacher/teachers/words/translations/nl.po",
		"modules/org/openteacher/teachers/words/translations/ru.po",
		"modules/org/openteacher/teachers/words/translations/ar.po",
		"modules/org/openteacher/teachers/words/translations/pl.po",
		"modules/org/openteacher/teachers/words/translations/nl.mo",
		"modules/org/openteacher/teachers/words/translations/zh_CN.po",
		"modules/org/openteacher/teachers/words/translations/zh_TW.po",
		"modules/org/openteacher/teachers/words/translations/zh_TW.mo",
		"modules/org/openteacher/teachers/words/translations/de.po",
		"modules/org/openteacher/teachers/words/translations/ar.mo",
		"modules/org/openteacher/teachers/words/translations/pt_BR.po",
		"modules/org/openteacher/teachers/words/translations/es.mo",
		"modules/org/openteacher/teachers/words/translations/gl.po",
		"modules/org/openteacher/teachers/words/translations/ja.po",
		"modules/org/openteacher/teachers/words/translations/ru.mo",
		"modules/org/openteacher/teachers/words/translations/hu.mo",
		"modules/org/openteacher/teachers/words/translations/tr.po",
		"modules/org/openteacher/teachers/words/translations/de.mo",
		"modules/org/openteacher/teachers/words/translations/fi.mo",
		"modules/org/openteacher/teachers/words/translations/sk.po",
		"modules/org/openteacher/teachers/words/translations/si.mo",
		"modules/org/openteacher/teachers/words/translations/cs.po",
		"modules/org/openteacher/teachers/words/translations/gl.mo",
		"modules/org/openteacher/teachers/words/translations/el.po",
		"modules/org/openteacher/teachers/words/translations/tr.mo",
		"modules/org/openteacher/teachers/words/translations/fy.mo",
		"modules/org/openteacher/teachers/words/translations/el.mo",
		"modules/org/openteacher/teachers/words/translations/sk.mo",
		"modules/org/openteacher/teachers/words/translations/fr.po",
		"modules/org/openteacher/openteacherAuthors/openteacherAuthors.py",
		"modules/org/openteacher/openteacherAuthors/translations/fi.po",
		"modules/org/openteacher/openteacherAuthors/translations/fy.po",
		"modules/org/openteacher/openteacherAuthors/translations/pt_BR.mo",
		"modules/org/openteacher/openteacherAuthors/translations/zh_CN.mo",
		"modules/org/openteacher/openteacherAuthors/translations/cs.mo",
		"modules/org/openteacher/openteacherAuthors/translations/pl.mo",
		"modules/org/openteacher/openteacherAuthors/translations/fr.mo",
		"modules/org/openteacher/openteacherAuthors/translations/es.po",
		"modules/org/openteacher/openteacherAuthors/translations/nl.po",
		"modules/org/openteacher/openteacherAuthors/translations/ru.po",
		"modules/org/openteacher/openteacherAuthors/translations/ar.po",
		"modules/org/openteacher/openteacherAuthors/translations/pl.po",
		"modules/org/openteacher/openteacherAuthors/translations/nl.mo",
		"modules/org/openteacher/openteacherAuthors/translations/zh_CN.po",
		"modules/org/openteacher/openteacherAuthors/translations/zh_TW.po",
		"modules/org/openteacher/openteacherAuthors/translations/zh_TW.mo",
		"modules/org/openteacher/openteacherAuthors/translations/de.po",
		"modules/org/openteacher/openteacherAuthors/translations/ar.mo",
		"modules/org/openteacher/openteacherAuthors/translations/pt_BR.po",
		"modules/org/openteacher/openteacherAuthors/translations/es.mo",
		"modules/org/openteacher/openteacherAuthors/translations/gl.po",
		"modules/org/openteacher/openteacherAuthors/translations/ru.mo",
		"modules/org/openteacher/openteacherAuthors/translations/tr.po",
		"modules/org/openteacher/openteacherAuthors/translations/de.mo",
		"modules/org/openteacher/openteacherAuthors/translations/fi.mo",
		"modules/org/openteacher/openteacherAuthors/translations/org.openteacher.openteacherAuthors.pot",
		"modules/org/openteacher/openteacherAuthors/translations/cs.po",
		"modules/org/openteacher/openteacherAuthors/translations/gl.mo",
		"modules/org/openteacher/openteacherAuthors/translations/tr.mo",
		"modules/org/openteacher/openteacherAuthors/translations/fy.mo",
		"modules/org/openteacher/openteacherAuthors/translations/fr.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectlyTest/wordsNeverAnsweredCorrectlyTest.py",
		"modules/org/openteacher/listModifiers/hardWordsTest/hardWordsTest.py",
		"modules/org/openteacher/listModifiers/reverseTest/reverseTest.py",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/wordsNeverAnsweredCorrectly.py",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fi.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ja.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fy.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/pt_BR.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/hu.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/zh_CN.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/cs.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/pl.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fr.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/es.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/nl.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ru.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ar.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/pl.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/nl.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/zh_CN.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/zh_TW.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/zh_TW.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/de.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ar.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/pt_BR.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/es.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ja.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ru.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/hu.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/tr.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/de.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fi.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/sk.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/org.openteacher.listModifiers.wordsNeverAnsweredCorrectly.pot",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/cs.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/el.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/tr.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fy.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/el.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/sk.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fr.po",
		"modules/org/openteacher/listModifiers/random_/random_.py",
		"modules/org/openteacher/listModifiers/random_/translations/fi.po",
		"modules/org/openteacher/listModifiers/random_/translations/ja.mo",
		"modules/org/openteacher/listModifiers/random_/translations/si.po",
		"modules/org/openteacher/listModifiers/random_/translations/fy.po",
		"modules/org/openteacher/listModifiers/random_/translations/pt_BR.mo",
		"modules/org/openteacher/listModifiers/random_/translations/hu.po",
		"modules/org/openteacher/listModifiers/random_/translations/zh_CN.mo",
		"modules/org/openteacher/listModifiers/random_/translations/cs.mo",
		"modules/org/openteacher/listModifiers/random_/translations/pl.mo",
		"modules/org/openteacher/listModifiers/random_/translations/fr.mo",
		"modules/org/openteacher/listModifiers/random_/translations/es.po",
		"modules/org/openteacher/listModifiers/random_/translations/org.openteacher.listModifiers.random_.pot",
		"modules/org/openteacher/listModifiers/random_/translations/nl.po",
		"modules/org/openteacher/listModifiers/random_/translations/ru.po",
		"modules/org/openteacher/listModifiers/random_/translations/ar.po",
		"modules/org/openteacher/listModifiers/random_/translations/pl.po",
		"modules/org/openteacher/listModifiers/random_/translations/nl.mo",
		"modules/org/openteacher/listModifiers/random_/translations/zh_CN.po",
		"modules/org/openteacher/listModifiers/random_/translations/zh_TW.po",
		"modules/org/openteacher/listModifiers/random_/translations/zh_TW.mo",
		"modules/org/openteacher/listModifiers/random_/translations/de.po",
		"modules/org/openteacher/listModifiers/random_/translations/ar.mo",
		"modules/org/openteacher/listModifiers/random_/translations/pt_BR.po",
		"modules/org/openteacher/listModifiers/random_/translations/es.mo",
		"modules/org/openteacher/listModifiers/random_/translations/ja.po",
		"modules/org/openteacher/listModifiers/random_/translations/ru.mo",
		"modules/org/openteacher/listModifiers/random_/translations/hu.mo",
		"modules/org/openteacher/listModifiers/random_/translations/tr.po",
		"modules/org/openteacher/listModifiers/random_/translations/de.mo",
		"modules/org/openteacher/listModifiers/random_/translations/fi.mo",
		"modules/org/openteacher/listModifiers/random_/translations/sk.po",
		"modules/org/openteacher/listModifiers/random_/translations/si.mo",
		"modules/org/openteacher/listModifiers/random_/translations/cs.po",
		"modules/org/openteacher/listModifiers/random_/translations/el.po",
		"modules/org/openteacher/listModifiers/random_/translations/tr.mo",
		"modules/org/openteacher/listModifiers/random_/translations/fy.mo",
		"modules/org/openteacher/listModifiers/random_/translations/el.mo",
		"modules/org/openteacher/listModifiers/random_/translations/sk.mo",
		"modules/org/openteacher/listModifiers/random_/translations/fr.po",
		"modules/org/openteacher/listModifiers/hardWords/hardWords.py",
		"modules/org/openteacher/listModifiers/hardWords/translations/fi.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/ja.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/fy.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/pt_BR.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/hu.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/zh_CN.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/cs.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/pl.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/fr.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/es.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/nl.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/ru.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/ar.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/pl.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/nl.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/zh_CN.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/zh_TW.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/zh_TW.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/de.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/ar.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/pt_BR.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/es.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/ja.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/ru.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/hu.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/tr.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/de.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/fi.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/sk.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/cs.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/el.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/tr.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/fy.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/el.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/sk.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/org.openteacher.listModifiers.hardWords.pot",
		"modules/org/openteacher/listModifiers/hardWords/translations/fr.po",
		"modules/org/openteacher/listModifiers/randomTest/randomTest.py",
		"modules/org/openteacher/listModifiers/reverse/reverse.py",
		"modules/org/openteacher/listModifiers/reverse/translations/fi.po",
		"modules/org/openteacher/listModifiers/reverse/translations/ja.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/si.po",
		"modules/org/openteacher/listModifiers/reverse/translations/fy.po",
		"modules/org/openteacher/listModifiers/reverse/translations/pt_BR.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/hu.po",
		"modules/org/openteacher/listModifiers/reverse/translations/zh_CN.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/cs.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/pl.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/fr.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/es.po",
		"modules/org/openteacher/listModifiers/reverse/translations/nl.po",
		"modules/org/openteacher/listModifiers/reverse/translations/ru.po",
		"modules/org/openteacher/listModifiers/reverse/translations/ar.po",
		"modules/org/openteacher/listModifiers/reverse/translations/pl.po",
		"modules/org/openteacher/listModifiers/reverse/translations/nl.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/zh_CN.po",
		"modules/org/openteacher/listModifiers/reverse/translations/org.openteacher.listModifiers.reverse.pot",
		"modules/org/openteacher/listModifiers/reverse/translations/zh_TW.po",
		"modules/org/openteacher/listModifiers/reverse/translations/af.po",
		"modules/org/openteacher/listModifiers/reverse/translations/zh_TW.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/de.po",
		"modules/org/openteacher/listModifiers/reverse/translations/ar.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/pt_BR.po",
		"modules/org/openteacher/listModifiers/reverse/translations/es.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/ja.po",
		"modules/org/openteacher/listModifiers/reverse/translations/ru.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/hu.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/tr.po",
		"modules/org/openteacher/listModifiers/reverse/translations/de.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/fi.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/sk.po",
		"modules/org/openteacher/listModifiers/reverse/translations/si.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/af.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/cs.po",
		"modules/org/openteacher/listModifiers/reverse/translations/el.po",
		"modules/org/openteacher/listModifiers/reverse/translations/tr.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/fy.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/el.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/sk.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/fr.po",
		"modules/org/openteacher/listModifiers/sortTest/sortTest.py",
		"modules/org/openteacher/listModifiers/sort/sort.py",
		"modules/org/openteacher/listModifiers/sort/translations/fi.po",
		"modules/org/openteacher/listModifiers/sort/translations/ja.mo",
		"modules/org/openteacher/listModifiers/sort/translations/si.po",
		"modules/org/openteacher/listModifiers/sort/translations/fy.po",
		"modules/org/openteacher/listModifiers/sort/translations/pt_BR.mo",
		"modules/org/openteacher/listModifiers/sort/translations/hu.po",
		"modules/org/openteacher/listModifiers/sort/translations/zh_CN.mo",
		"modules/org/openteacher/listModifiers/sort/translations/cs.mo",
		"modules/org/openteacher/listModifiers/sort/translations/org.openteacher.listModifiers.sort.pot",
		"modules/org/openteacher/listModifiers/sort/translations/fr.mo",
		"modules/org/openteacher/listModifiers/sort/translations/es.po",
		"modules/org/openteacher/listModifiers/sort/translations/nl.po",
		"modules/org/openteacher/listModifiers/sort/translations/ru.po",
		"modules/org/openteacher/listModifiers/sort/translations/ar.po",
		"modules/org/openteacher/listModifiers/sort/translations/nl.mo",
		"modules/org/openteacher/listModifiers/sort/translations/zh_CN.po",
		"modules/org/openteacher/listModifiers/sort/translations/zh_TW.po",
		"modules/org/openteacher/listModifiers/sort/translations/af.po",
		"modules/org/openteacher/listModifiers/sort/translations/zh_TW.mo",
		"modules/org/openteacher/listModifiers/sort/translations/de.po",
		"modules/org/openteacher/listModifiers/sort/translations/ar.mo",
		"modules/org/openteacher/listModifiers/sort/translations/pt_BR.po",
		"modules/org/openteacher/listModifiers/sort/translations/es.mo",
		"modules/org/openteacher/listModifiers/sort/translations/ja.po",
		"modules/org/openteacher/listModifiers/sort/translations/ru.mo",
		"modules/org/openteacher/listModifiers/sort/translations/hu.mo",
		"modules/org/openteacher/listModifiers/sort/translations/tr.po",
		"modules/org/openteacher/listModifiers/sort/translations/de.mo",
		"modules/org/openteacher/listModifiers/sort/translations/fi.mo",
		"modules/org/openteacher/listModifiers/sort/translations/sk.po",
		"modules/org/openteacher/listModifiers/sort/translations/si.mo",
		"modules/org/openteacher/listModifiers/sort/translations/af.mo",
		"modules/org/openteacher/listModifiers/sort/translations/cs.po",
		"modules/org/openteacher/listModifiers/sort/translations/el.po",
		"modules/org/openteacher/listModifiers/sort/translations/tr.mo",
		"modules/org/openteacher/listModifiers/sort/translations/fy.mo",
		"modules/org/openteacher/listModifiers/sort/translations/el.mo",
		"modules/org/openteacher/listModifiers/sort/translations/sk.mo",
		"modules/org/openteacher/listModifiers/sort/translations/fr.po",
		"modules/org/openteacher/cliTest/testfile.otwd",
		"modules/org/openteacher/cliTest/cliTest.py",
		"modules/org/openteacher/cliTest/ocr.png",
		"modules/org/openteacher/mergers/wordsTest/wordsTest.py",
		"modules/org/openteacher/mergers/words/words.py",
		"modules/org/openteacher/saver/saver.py",
		"modules/org/openteacher/progressViewerTest/progressViewerTest.py",
		"modules/org/openteacher/testRunner/testRunner.py",
		"modules/org/openteacher/printer/printer.py",
		"modules/org/openteacher/languageCodeGuesserTest/languageCodeGuesserTest.py",
		"modules/org/openteacher/buttonRegisterTest/buttonRegisterTest.py",
		"modules/org/openteacher/otxxloader/otxxloader.py",
		"modules/org/openteacher/wordsString/javaScriptComposer/composer.js",
		"modules/org/openteacher/wordsString/javaScriptComposer/javaScriptComposer.py",
		"modules/org/openteacher/wordsString/javaScriptParser/javaScriptParser.py",
		"modules/org/openteacher/wordsString/javaScriptParser/parser.js",
		"modules/org/openteacher/wordsString/checkerTest/checkerTest.py",
		"modules/org/openteacher/wordsString/composerTest/composerTest.py",
		"modules/org/openteacher/wordsString/parserTest/parserTest.py",
		"modules/org/openteacher/wordsString/javaScriptChecker/checker.js",
		"modules/org/openteacher/wordsString/javaScriptChecker/javaScriptChecker.py",
		"modules/org/openteacher/uiController/uiController.py",
		"modules/org/openteacher/uiController/translations/fy.po",
		"modules/org/openteacher/uiController/translations/pt_BR.mo",
		"modules/org/openteacher/uiController/translations/zh_CN.mo",
		"modules/org/openteacher/uiController/translations/cs.mo",
		"modules/org/openteacher/uiController/translations/pl.mo",
		"modules/org/openteacher/uiController/translations/fr.mo",
		"modules/org/openteacher/uiController/translations/es.po",
		"modules/org/openteacher/uiController/translations/nl.po",
		"modules/org/openteacher/uiController/translations/ru.po",
		"modules/org/openteacher/uiController/translations/org.openteacher.uiController.pot",
		"modules/org/openteacher/uiController/translations/pl.po",
		"modules/org/openteacher/uiController/translations/nl.mo",
		"modules/org/openteacher/uiController/translations/zh_CN.po",
		"modules/org/openteacher/uiController/translations/zh_TW.po",
		"modules/org/openteacher/uiController/translations/zh_TW.mo",
		"modules/org/openteacher/uiController/translations/pt_BR.po",
		"modules/org/openteacher/uiController/translations/es.mo",
		"modules/org/openteacher/uiController/translations/gl.po",
		"modules/org/openteacher/uiController/translations/ru.mo",
		"modules/org/openteacher/uiController/translations/tr.po",
		"modules/org/openteacher/uiController/translations/cs.po",
		"modules/org/openteacher/uiController/translations/gl.mo",
		"modules/org/openteacher/uiController/translations/tr.mo",
		"modules/org/openteacher/uiController/translations/fy.mo",
		"modules/org/openteacher/uiController/translations/fr.po",
		"modules/org/openteacher/profilesHelp/profilesHelp.py",
		"modules/org/openteacher/spellChecker/spellChecker.py",
		"modules/org/openteacher/testsTest/testsTest.py",
		"modules/org/openteacher/recentlyOpened/recentlyOpened.py",
		"modules/org/openteacher/recentlyOpened/translations/fy.po",
		"modules/org/openteacher/recentlyOpened/translations/org.openteacher.recentlyOpened.pot",
		"modules/org/openteacher/recentlyOpened/translations/pt_BR.mo",
		"modules/org/openteacher/recentlyOpened/translations/zh_CN.mo",
		"modules/org/openteacher/recentlyOpened/translations/cs.mo",
		"modules/org/openteacher/recentlyOpened/translations/pl.mo",
		"modules/org/openteacher/recentlyOpened/translations/fr.mo",
		"modules/org/openteacher/recentlyOpened/translations/es.po",
		"modules/org/openteacher/recentlyOpened/translations/nl.po",
		"modules/org/openteacher/recentlyOpened/translations/ru.po",
		"modules/org/openteacher/recentlyOpened/translations/pl.po",
		"modules/org/openteacher/recentlyOpened/translations/nl.mo",
		"modules/org/openteacher/recentlyOpened/translations/zh_CN.po",
		"modules/org/openteacher/recentlyOpened/translations/zh_TW.po",
		"modules/org/openteacher/recentlyOpened/translations/zh_TW.mo",
		"modules/org/openteacher/recentlyOpened/translations/de.po",
		"modules/org/openteacher/recentlyOpened/translations/pt_BR.po",
		"modules/org/openteacher/recentlyOpened/translations/es.mo",
		"modules/org/openteacher/recentlyOpened/translations/gl.po",
		"modules/org/openteacher/recentlyOpened/translations/ru.mo",
		"modules/org/openteacher/recentlyOpened/translations/it.po",
		"modules/org/openteacher/recentlyOpened/translations/it.mo",
		"modules/org/openteacher/recentlyOpened/translations/tr.po",
		"modules/org/openteacher/recentlyOpened/translations/de.mo",
		"modules/org/openteacher/recentlyOpened/translations/cs.po",
		"modules/org/openteacher/recentlyOpened/translations/gl.mo",
		"modules/org/openteacher/recentlyOpened/translations/tr.mo",
		"modules/org/openteacher/recentlyOpened/translations/fy.mo",
		"modules/org/openteacher/recentlyOpened/translations/fr.po",
		"modules/org/openteacher/eventTest/eventTest.py",
		"modules/org/openteacher/recentlyOpenedViewer/recentlyOpenedViewer.py",
		"modules/org/openteacher/moduleGraph/moduleGraph.py",
		"modules/org/openteacher/modulesTest/fileToImport.py",
		"modules/org/openteacher/modulesTest/modulesTest.py",
		"modules/org/openteacher/hiddenBrowser/hiddenBrowser.py",
		"modules/org/openteacher/hiddenBrowser/icons/COPYING",
		"modules/org/openteacher/hiddenBrowser/icons/back.png",
		"modules/org/openteacher/hiddenBrowser/icons/forward.png",
		"modules/org/openteacher/hiddenBrowser/icons/reload.png",
		"modules/org/openteacher/hiddenBrowser/translations/org.openteacher.hiddenBrowser.pot",
		"modules/org/openteacher/hiddenBrowser/translations/fi.po",
		"modules/org/openteacher/hiddenBrowser/translations/fy.po",
		"modules/org/openteacher/hiddenBrowser/translations/pt_BR.mo",
		"modules/org/openteacher/hiddenBrowser/translations/zh_CN.mo",
		"modules/org/openteacher/hiddenBrowser/translations/pl.mo",
		"modules/org/openteacher/hiddenBrowser/translations/fr.mo",
		"modules/org/openteacher/hiddenBrowser/translations/es.po",
		"modules/org/openteacher/hiddenBrowser/translations/nl.po",
		"modules/org/openteacher/hiddenBrowser/translations/ru.po",
		"modules/org/openteacher/hiddenBrowser/translations/pl.po",
		"modules/org/openteacher/hiddenBrowser/translations/nl.mo",
		"modules/org/openteacher/hiddenBrowser/translations/zh_CN.po",
		"modules/org/openteacher/hiddenBrowser/translations/zh_TW.po",
		"modules/org/openteacher/hiddenBrowser/translations/zh_TW.mo",
		"modules/org/openteacher/hiddenBrowser/translations/de.po",
		"modules/org/openteacher/hiddenBrowser/translations/pt_BR.po",
		"modules/org/openteacher/hiddenBrowser/translations/es.mo",
		"modules/org/openteacher/hiddenBrowser/translations/ru.mo",
		"modules/org/openteacher/hiddenBrowser/translations/tr.po",
		"modules/org/openteacher/hiddenBrowser/translations/de.mo",
		"modules/org/openteacher/hiddenBrowser/translations/fi.mo",
		"modules/org/openteacher/hiddenBrowser/translations/tr.mo",
		"modules/org/openteacher/hiddenBrowser/translations/fy.mo",
		"modules/org/openteacher/hiddenBrowser/translations/fr.po",
		"modules/org/openteacher/vocatrainApi/vocatrainApi.py",
		"modules/org/openteacher/vocatrainApi/translations/fy.po",
		"modules/org/openteacher/vocatrainApi/translations/pt_BR.mo",
		"modules/org/openteacher/vocatrainApi/translations/cs.mo",
		"modules/org/openteacher/vocatrainApi/translations/pl.mo",
		"modules/org/openteacher/vocatrainApi/translations/fr.mo",
		"modules/org/openteacher/vocatrainApi/translations/nl.po",
		"modules/org/openteacher/vocatrainApi/translations/ru.po",
		"modules/org/openteacher/vocatrainApi/translations/org.openteacher.vocatrainApi.pot",
		"modules/org/openteacher/vocatrainApi/translations/pl.po",
		"modules/org/openteacher/vocatrainApi/translations/nl.mo",
		"modules/org/openteacher/vocatrainApi/translations/zh_TW.po",
		"modules/org/openteacher/vocatrainApi/translations/zh_TW.mo",
		"modules/org/openteacher/vocatrainApi/translations/de.po",
		"modules/org/openteacher/vocatrainApi/translations/pt_BR.po",
		"modules/org/openteacher/vocatrainApi/translations/ru.mo",
		"modules/org/openteacher/vocatrainApi/translations/it.po",
		"modules/org/openteacher/vocatrainApi/translations/it.mo",
		"modules/org/openteacher/vocatrainApi/translations/de.mo",
		"modules/org/openteacher/vocatrainApi/translations/cs.po",
		"modules/org/openteacher/vocatrainApi/translations/fy.mo",
		"modules/org/openteacher/vocatrainApi/translations/fr.po",
		"modules/org/openteacher/testTypes/topo/topo.py",
		"modules/org/openteacher/testTypes/topo/translations/ja.mo",
		"modules/org/openteacher/testTypes/topo/translations/fy.po",
		"modules/org/openteacher/testTypes/topo/translations/pt_BR.mo",
		"modules/org/openteacher/testTypes/topo/translations/zh_CN.mo",
		"modules/org/openteacher/testTypes/topo/translations/cs.mo",
		"modules/org/openteacher/testTypes/topo/translations/pl.mo",
		"modules/org/openteacher/testTypes/topo/translations/fr.mo",
		"modules/org/openteacher/testTypes/topo/translations/es.po",
		"modules/org/openteacher/testTypes/topo/translations/nl.po",
		"modules/org/openteacher/testTypes/topo/translations/ru.po",
		"modules/org/openteacher/testTypes/topo/translations/pl.po",
		"modules/org/openteacher/testTypes/topo/translations/nl.mo",
		"modules/org/openteacher/testTypes/topo/translations/zh_CN.po",
		"modules/org/openteacher/testTypes/topo/translations/zh_TW.po",
		"modules/org/openteacher/testTypes/topo/translations/zh_TW.mo",
		"modules/org/openteacher/testTypes/topo/translations/de.po",
		"modules/org/openteacher/testTypes/topo/translations/pt_BR.po",
		"modules/org/openteacher/testTypes/topo/translations/es.mo",
		"modules/org/openteacher/testTypes/topo/translations/gl.po",
		"modules/org/openteacher/testTypes/topo/translations/ja.po",
		"modules/org/openteacher/testTypes/topo/translations/ru.mo",
		"modules/org/openteacher/testTypes/topo/translations/it.po",
		"modules/org/openteacher/testTypes/topo/translations/it.mo",
		"modules/org/openteacher/testTypes/topo/translations/tr.po",
		"modules/org/openteacher/testTypes/topo/translations/de.mo",
		"modules/org/openteacher/testTypes/topo/translations/cs.po",
		"modules/org/openteacher/testTypes/topo/translations/gl.mo",
		"modules/org/openteacher/testTypes/topo/translations/tr.mo",
		"modules/org/openteacher/testTypes/topo/translations/org.openteacher.testTypes.topo.pot",
		"modules/org/openteacher/testTypes/topo/translations/fy.mo",
		"modules/org/openteacher/testTypes/topo/translations/fr.po",
		"modules/org/openteacher/testTypes/media/media.py",
		"modules/org/openteacher/testTypes/media/translations/ja.mo",
		"modules/org/openteacher/testTypes/media/translations/si.po",
		"modules/org/openteacher/testTypes/media/translations/fy.po",
		"modules/org/openteacher/testTypes/media/translations/org.openteacher.testTypes.media.pot",
		"modules/org/openteacher/testTypes/media/translations/pt_BR.mo",
		"modules/org/openteacher/testTypes/media/translations/zh_CN.mo",
		"modules/org/openteacher/testTypes/media/translations/cs.mo",
		"modules/org/openteacher/testTypes/media/translations/pl.mo",
		"modules/org/openteacher/testTypes/media/translations/fr.mo",
		"modules/org/openteacher/testTypes/media/translations/es.po",
		"modules/org/openteacher/testTypes/media/translations/nl.po",
		"modules/org/openteacher/testTypes/media/translations/ru.po",
		"modules/org/openteacher/testTypes/media/translations/pl.po",
		"modules/org/openteacher/testTypes/media/translations/nl.mo",
		"modules/org/openteacher/testTypes/media/translations/zh_CN.po",
		"modules/org/openteacher/testTypes/media/translations/zh_TW.po",
		"modules/org/openteacher/testTypes/media/translations/zh_TW.mo",
		"modules/org/openteacher/testTypes/media/translations/de.po",
		"modules/org/openteacher/testTypes/media/translations/pt_BR.po",
		"modules/org/openteacher/testTypes/media/translations/es.mo",
		"modules/org/openteacher/testTypes/media/translations/gl.po",
		"modules/org/openteacher/testTypes/media/translations/ja.po",
		"modules/org/openteacher/testTypes/media/translations/ru.mo",
		"modules/org/openteacher/testTypes/media/translations/it.po",
		"modules/org/openteacher/testTypes/media/translations/it.mo",
		"modules/org/openteacher/testTypes/media/translations/tr.po",
		"modules/org/openteacher/testTypes/media/translations/de.mo",
		"modules/org/openteacher/testTypes/media/translations/si.mo",
		"modules/org/openteacher/testTypes/media/translations/cs.po",
		"modules/org/openteacher/testTypes/media/translations/gl.mo",
		"modules/org/openteacher/testTypes/media/translations/tr.mo",
		"modules/org/openteacher/testTypes/media/translations/fy.mo",
		"modules/org/openteacher/testTypes/media/translations/fr.po",
		"modules/org/openteacher/testTypes/words/words.py",
		"modules/org/openteacher/testTypes/words/translations/ja.mo",
		"modules/org/openteacher/testTypes/words/translations/fy.po",
		"modules/org/openteacher/testTypes/words/translations/pt_BR.mo",
		"modules/org/openteacher/testTypes/words/translations/zh_CN.mo",
		"modules/org/openteacher/testTypes/words/translations/cs.mo",
		"modules/org/openteacher/testTypes/words/translations/pl.mo",
		"modules/org/openteacher/testTypes/words/translations/fr.mo",
		"modules/org/openteacher/testTypes/words/translations/es.po",
		"modules/org/openteacher/testTypes/words/translations/nl.po",
		"modules/org/openteacher/testTypes/words/translations/ru.po",
		"modules/org/openteacher/testTypes/words/translations/pl.po",
		"modules/org/openteacher/testTypes/words/translations/nl.mo",
		"modules/org/openteacher/testTypes/words/translations/zh_CN.po",
		"modules/org/openteacher/testTypes/words/translations/zh_TW.po",
		"modules/org/openteacher/testTypes/words/translations/org.openteacher.testTypes.words.pot",
		"modules/org/openteacher/testTypes/words/translations/zh_TW.mo",
		"modules/org/openteacher/testTypes/words/translations/de.po",
		"modules/org/openteacher/testTypes/words/translations/pt_BR.po",
		"modules/org/openteacher/testTypes/words/translations/es.mo",
		"modules/org/openteacher/testTypes/words/translations/gl.po",
		"modules/org/openteacher/testTypes/words/translations/ja.po",
		"modules/org/openteacher/testTypes/words/translations/ru.mo",
		"modules/org/openteacher/testTypes/words/translations/tr.po",
		"modules/org/openteacher/testTypes/words/translations/de.mo",
		"modules/org/openteacher/testTypes/words/translations/cs.po",
		"modules/org/openteacher/testTypes/words/translations/gl.mo",
		"modules/org/openteacher/testTypes/words/translations/tr.mo",
		"modules/org/openteacher/testTypes/words/translations/fy.mo",
		"modules/org/openteacher/testTypes/words/translations/fr.po",
		"modules/org/openteacher/userDocumentationWrapper/userDocumentationWrapper.py",
		"modules/org/openteacher/userDocumentationWrapper/wrapper.html",
		"modules/org/openteacher/guiTest/guiTest.py",
		"modules/org/openteacher/testUrllibMock/testUrllibMock.py",
		"modules/org/openteacher/codeComplexity/impl.py",
		"modules/org/openteacher/codeComplexity/codeComplexity.py",
		"modules/org/openteacher/spellCheckerTest/spellCheckerTest.py",
		"modules/org/openteacher/backgroundImageGenerator/backgroundImageGenerator.py",
		"modules/org/openteacher/otxxsaver/otxxsaver.py",
		"modules/org/openteacher/authors/authors.py",
		"modules/org/openteacher/metadata/openteacher.png",
		"modules/org/openteacher/metadata/license.txt",
		"modules/org/openteacher/metadata/COPYING",
		"modules/org/openteacher/metadata/license_intro.txt",
		"modules/org/openteacher/metadata/comic.png",
		"modules/org/openteacher/metadata/metadata.py",
		"modules/org/openteacher/metadata/translations/fi.po",
		"modules/org/openteacher/metadata/translations/ja.mo",
		"modules/org/openteacher/metadata/translations/si.po",
		"modules/org/openteacher/metadata/translations/fy.po",
		"modules/org/openteacher/metadata/translations/pt_BR.mo",
		"modules/org/openteacher/metadata/translations/hu.po",
		"modules/org/openteacher/metadata/translations/zh_CN.mo",
		"modules/org/openteacher/metadata/translations/cs.mo",
		"modules/org/openteacher/metadata/translations/pl.mo",
		"modules/org/openteacher/metadata/translations/fr.mo",
		"modules/org/openteacher/metadata/translations/org.openteacher.listModifiers.metadata.pot",
		"modules/org/openteacher/metadata/translations/es.po",
		"modules/org/openteacher/metadata/translations/nl.po",
		"modules/org/openteacher/metadata/translations/ru.po",
		"modules/org/openteacher/metadata/translations/ar.po",
		"modules/org/openteacher/metadata/translations/pl.po",
		"modules/org/openteacher/metadata/translations/nl.mo",
		"modules/org/openteacher/metadata/translations/zh_CN.po",
		"modules/org/openteacher/metadata/translations/zh_TW.po",
		"modules/org/openteacher/metadata/translations/zh_TW.mo",
		"modules/org/openteacher/metadata/translations/de.po",
		"modules/org/openteacher/metadata/translations/ar.mo",
		"modules/org/openteacher/metadata/translations/pt_BR.po",
		"modules/org/openteacher/metadata/translations/es.mo",
		"modules/org/openteacher/metadata/translations/gl.po",
		"modules/org/openteacher/metadata/translations/ja.po",
		"modules/org/openteacher/metadata/translations/ru.mo",
		"modules/org/openteacher/metadata/translations/it.po",
		"modules/org/openteacher/metadata/translations/hu.mo",
		"modules/org/openteacher/metadata/translations/it.mo",
		"modules/org/openteacher/metadata/translations/tr.po",
		"modules/org/openteacher/metadata/translations/de.mo",
		"modules/org/openteacher/metadata/translations/fi.mo",
		"modules/org/openteacher/metadata/translations/sk.po",
		"modules/org/openteacher/metadata/translations/si.mo",
		"modules/org/openteacher/metadata/translations/cs.po",
		"modules/org/openteacher/metadata/translations/gl.mo",
		"modules/org/openteacher/metadata/translations/el.po",
		"modules/org/openteacher/metadata/translations/tr.mo",
		"modules/org/openteacher/metadata/translations/fy.mo",
		"modules/org/openteacher/metadata/translations/el.mo",
		"modules/org/openteacher/metadata/translations/sk.mo",
		"modules/org/openteacher/metadata/translations/fr.po",
		"modules/org/openteacher/authorsTest/authorsTest.py",
		"modules/org/openteacher/dialogs/updates/updates.py",
		"modules/org/openteacher/dialogs/updates/translations/fi.po",
		"modules/org/openteacher/dialogs/updates/translations/pt_BR.mo",
		"modules/org/openteacher/dialogs/updates/translations/zh_CN.mo",
		"modules/org/openteacher/dialogs/updates/translations/cs.mo",
		"modules/org/openteacher/dialogs/updates/translations/fr.mo",
		"modules/org/openteacher/dialogs/updates/translations/es.po",
		"modules/org/openteacher/dialogs/updates/translations/nl.po",
		"modules/org/openteacher/dialogs/updates/translations/nl.mo",
		"modules/org/openteacher/dialogs/updates/translations/zh_CN.po",
		"modules/org/openteacher/dialogs/updates/translations/zh_TW.po",
		"modules/org/openteacher/dialogs/updates/translations/org.openteacher.dialogs.updates.pot",
		"modules/org/openteacher/dialogs/updates/translations/zh_TW.mo",
		"modules/org/openteacher/dialogs/updates/translations/de.po",
		"modules/org/openteacher/dialogs/updates/translations/pt_BR.po",
		"modules/org/openteacher/dialogs/updates/translations/es.mo",
		"modules/org/openteacher/dialogs/updates/translations/de.mo",
		"modules/org/openteacher/dialogs/updates/translations/fi.mo",
		"modules/org/openteacher/dialogs/updates/translations/cs.po",
		"modules/org/openteacher/dialogs/updates/translations/fr.po",
		"modules/org/openteacher/dialogs/documentation/documentation.py",
		"modules/org/openteacher/dialogs/documentation/translations/fi.po",
		"modules/org/openteacher/dialogs/documentation/translations/si.po",
		"modules/org/openteacher/dialogs/documentation/translations/fy.po",
		"modules/org/openteacher/dialogs/documentation/translations/pt_BR.mo",
		"modules/org/openteacher/dialogs/documentation/translations/hu.po",
		"modules/org/openteacher/dialogs/documentation/translations/zh_CN.mo",
		"modules/org/openteacher/dialogs/documentation/translations/cs.mo",
		"modules/org/openteacher/dialogs/documentation/translations/org.openteacher.documentation.pot",
		"modules/org/openteacher/dialogs/documentation/translations/pl.mo",
		"modules/org/openteacher/dialogs/documentation/translations/fr.mo",
		"modules/org/openteacher/dialogs/documentation/translations/es.po",
		"modules/org/openteacher/dialogs/documentation/translations/nl.po",
		"modules/org/openteacher/dialogs/documentation/translations/ru.po",
		"modules/org/openteacher/dialogs/documentation/translations/ar.po",
		"modules/org/openteacher/dialogs/documentation/translations/pl.po",
		"modules/org/openteacher/dialogs/documentation/translations/nl.mo",
		"modules/org/openteacher/dialogs/documentation/translations/zh_CN.po",
		"modules/org/openteacher/dialogs/documentation/translations/zh_TW.po",
		"modules/org/openteacher/dialogs/documentation/translations/af.po",
		"modules/org/openteacher/dialogs/documentation/translations/zh_TW.mo",
		"modules/org/openteacher/dialogs/documentation/translations/de.po",
		"modules/org/openteacher/dialogs/documentation/translations/ar.mo",
		"modules/org/openteacher/dialogs/documentation/translations/pt_BR.po",
		"modules/org/openteacher/dialogs/documentation/translations/es.mo",
		"modules/org/openteacher/dialogs/documentation/translations/ru.mo",
		"modules/org/openteacher/dialogs/documentation/translations/it.po",
		"modules/org/openteacher/dialogs/documentation/translations/hu.mo",
		"modules/org/openteacher/dialogs/documentation/translations/it.mo",
		"modules/org/openteacher/dialogs/documentation/translations/tr.po",
		"modules/org/openteacher/dialogs/documentation/translations/de.mo",
		"modules/org/openteacher/dialogs/documentation/translations/fi.mo",
		"modules/org/openteacher/dialogs/documentation/translations/sk.po",
		"modules/org/openteacher/dialogs/documentation/translations/si.mo",
		"modules/org/openteacher/dialogs/documentation/translations/af.mo",
		"modules/org/openteacher/dialogs/documentation/translations/cs.po",
		"modules/org/openteacher/dialogs/documentation/translations/el.po",
		"modules/org/openteacher/dialogs/documentation/translations/tr.mo",
		"modules/org/openteacher/dialogs/documentation/translations/fy.mo",
		"modules/org/openteacher/dialogs/documentation/translations/el.mo",
		"modules/org/openteacher/dialogs/documentation/translations/sk.mo",
		"modules/org/openteacher/dialogs/documentation/translations/fr.po",
		"modules/org/openteacher/dialogs/aboutTest/aboutTest.py",
		"modules/org/openteacher/dialogs/print/print.py",
		"modules/org/openteacher/dialogs/settings/settings.py",
		"modules/org/openteacher/dialogs/settings/translations/fi.po",
		"modules/org/openteacher/dialogs/settings/translations/ja.mo",
		"modules/org/openteacher/dialogs/settings/translations/si.po",
		"modules/org/openteacher/dialogs/settings/translations/fy.po",
		"modules/org/openteacher/dialogs/settings/translations/pt_BR.mo",
		"modules/org/openteacher/dialogs/settings/translations/hu.po",
		"modules/org/openteacher/dialogs/settings/translations/zh_CN.mo",
		"modules/org/openteacher/dialogs/settings/translations/cs.mo",
		"modules/org/openteacher/dialogs/settings/translations/pl.mo",
		"modules/org/openteacher/dialogs/settings/translations/fr.mo",
		"modules/org/openteacher/dialogs/settings/translations/es.po",
		"modules/org/openteacher/dialogs/settings/translations/nl.po",
		"modules/org/openteacher/dialogs/settings/translations/ru.po",
		"modules/org/openteacher/dialogs/settings/translations/ar.po",
		"modules/org/openteacher/dialogs/settings/translations/pl.po",
		"modules/org/openteacher/dialogs/settings/translations/nl.mo",
		"modules/org/openteacher/dialogs/settings/translations/zh_CN.po",
		"modules/org/openteacher/dialogs/settings/translations/zh_TW.po",
		"modules/org/openteacher/dialogs/settings/translations/zh_TW.mo",
		"modules/org/openteacher/dialogs/settings/translations/de.po",
		"modules/org/openteacher/dialogs/settings/translations/ar.mo",
		"modules/org/openteacher/dialogs/settings/translations/pt_BR.po",
		"modules/org/openteacher/dialogs/settings/translations/es.mo",
		"modules/org/openteacher/dialogs/settings/translations/ja.po",
		"modules/org/openteacher/dialogs/settings/translations/ru.mo",
		"modules/org/openteacher/dialogs/settings/translations/hu.mo",
		"modules/org/openteacher/dialogs/settings/translations/tr.po",
		"modules/org/openteacher/dialogs/settings/translations/de.mo",
		"modules/org/openteacher/dialogs/settings/translations/fi.mo",
		"modules/org/openteacher/dialogs/settings/translations/org.openteacher.settingsDialog.pot",
		"modules/org/openteacher/dialogs/settings/translations/sk.po",
		"modules/org/openteacher/dialogs/settings/translations/si.mo",
		"modules/org/openteacher/dialogs/settings/translations/cs.po",
		"modules/org/openteacher/dialogs/settings/translations/el.po",
		"modules/org/openteacher/dialogs/settings/translations/tr.mo",
		"modules/org/openteacher/dialogs/settings/translations/fy.mo",
		"modules/org/openteacher/dialogs/settings/translations/el.mo",
		"modules/org/openteacher/dialogs/settings/translations/sk.mo",
		"modules/org/openteacher/dialogs/settings/translations/fr.po",
		"modules/org/openteacher/dialogs/documentationTest/documentationTest.py",
		"modules/org/openteacher/dialogs/file/file.py",
		"modules/org/openteacher/dialogs/results/results.py",
		"modules/org/openteacher/dialogs/about/about.py",
		"modules/org/openteacher/dialogs/about/about.html",
		"modules/org/openteacher/dialogs/about/translations/fi.po",
		"modules/org/openteacher/dialogs/about/translations/si.po",
		"modules/org/openteacher/dialogs/about/translations/fy.po",
		"modules/org/openteacher/dialogs/about/translations/pt_BR.mo",
		"modules/org/openteacher/dialogs/about/translations/hu.po",
		"modules/org/openteacher/dialogs/about/translations/zh_CN.mo",
		"modules/org/openteacher/dialogs/about/translations/cs.mo",
		"modules/org/openteacher/dialogs/about/translations/fr.mo",
		"modules/org/openteacher/dialogs/about/translations/es.po",
		"modules/org/openteacher/dialogs/about/translations/nl.po",
		"modules/org/openteacher/dialogs/about/translations/ru.po",
		"modules/org/openteacher/dialogs/about/translations/ar.po",
		"modules/org/openteacher/dialogs/about/translations/nl.mo",
		"modules/org/openteacher/dialogs/about/translations/zh_CN.po",
		"modules/org/openteacher/dialogs/about/translations/zh_TW.po",
		"modules/org/openteacher/dialogs/about/translations/zh_TW.mo",
		"modules/org/openteacher/dialogs/about/translations/de.po",
		"modules/org/openteacher/dialogs/about/translations/ar.mo",
		"modules/org/openteacher/dialogs/about/translations/pt_BR.po",
		"modules/org/openteacher/dialogs/about/translations/es.mo",
		"modules/org/openteacher/dialogs/about/translations/ru.mo",
		"modules/org/openteacher/dialogs/about/translations/hu.mo",
		"modules/org/openteacher/dialogs/about/translations/tr.po",
		"modules/org/openteacher/dialogs/about/translations/de.mo",
		"modules/org/openteacher/dialogs/about/translations/fi.mo",
		"modules/org/openteacher/dialogs/about/translations/sk.po",
		"modules/org/openteacher/dialogs/about/translations/si.mo",
		"modules/org/openteacher/dialogs/about/translations/cs.po",
		"modules/org/openteacher/dialogs/about/translations/el.po",
		"modules/org/openteacher/dialogs/about/translations/tr.mo",
		"modules/org/openteacher/dialogs/about/translations/org.openteacher.about.pot",
		"modules/org/openteacher/dialogs/about/translations/fy.mo",
		"modules/org/openteacher/dialogs/about/translations/el.mo",
		"modules/org/openteacher/dialogs/about/translations/sk.mo",
		"modules/org/openteacher/dialogs/about/translations/fr.po",
		"modules/org/openteacher/dialogs/settingsTest/settingsTest.py",
		"modules/org/openteacher/shell/shell.py",
		"modules/org/openteacher/testViewerTest/testViewerTest.py",
		"modules/org/openteacher/enterers/topo/topo.py",
		"modules/org/openteacher/enterers/topo/translations/fi.po",
		"modules/org/openteacher/enterers/topo/translations/fy.po",
		"modules/org/openteacher/enterers/topo/translations/pt_BR.mo",
		"modules/org/openteacher/enterers/topo/translations/zh_CN.mo",
		"modules/org/openteacher/enterers/topo/translations/cs.mo",
		"modules/org/openteacher/enterers/topo/translations/pl.mo",
		"modules/org/openteacher/enterers/topo/translations/fr.mo",
		"modules/org/openteacher/enterers/topo/translations/es.po",
		"modules/org/openteacher/enterers/topo/translations/nl.po",
		"modules/org/openteacher/enterers/topo/translations/ru.po",
		"modules/org/openteacher/enterers/topo/translations/pl.po",
		"modules/org/openteacher/enterers/topo/translations/nl.mo",
		"modules/org/openteacher/enterers/topo/translations/zh_CN.po",
		"modules/org/openteacher/enterers/topo/translations/org.openteacher.enterers.topo.pot",
		"modules/org/openteacher/enterers/topo/translations/zh_TW.po",
		"modules/org/openteacher/enterers/topo/translations/zh_TW.mo",
		"modules/org/openteacher/enterers/topo/translations/de.po",
		"modules/org/openteacher/enterers/topo/translations/pt_BR.po",
		"modules/org/openteacher/enterers/topo/translations/es.mo",
		"modules/org/openteacher/enterers/topo/translations/gl.po",
		"modules/org/openteacher/enterers/topo/translations/ru.mo",
		"modules/org/openteacher/enterers/topo/translations/tr.po",
		"modules/org/openteacher/enterers/topo/translations/de.mo",
		"modules/org/openteacher/enterers/topo/translations/fi.mo",
		"modules/org/openteacher/enterers/topo/translations/cs.po",
		"modules/org/openteacher/enterers/topo/translations/gl.mo",
		"modules/org/openteacher/enterers/topo/translations/tr.mo",
		"modules/org/openteacher/enterers/topo/translations/fy.mo",
		"modules/org/openteacher/enterers/topo/translations/fr.po",
		"modules/org/openteacher/enterers/mediaTest/mediaTest.py",
		"modules/org/openteacher/enterers/media/media.py",
		"modules/org/openteacher/enterers/media/translations/fi.po",
		"modules/org/openteacher/enterers/media/translations/fy.po",
		"modules/org/openteacher/enterers/media/translations/pt_BR.mo",
		"modules/org/openteacher/enterers/media/translations/hu.po",
		"modules/org/openteacher/enterers/media/translations/zh_CN.mo",
		"modules/org/openteacher/enterers/media/translations/cs.mo",
		"modules/org/openteacher/enterers/media/translations/pl.mo",
		"modules/org/openteacher/enterers/media/translations/fr.mo",
		"modules/org/openteacher/enterers/media/translations/es.po",
		"modules/org/openteacher/enterers/media/translations/nl.po",
		"modules/org/openteacher/enterers/media/translations/ru.po",
		"modules/org/openteacher/enterers/media/translations/pl.po",
		"modules/org/openteacher/enterers/media/translations/nl.mo",
		"modules/org/openteacher/enterers/media/translations/zh_CN.po",
		"modules/org/openteacher/enterers/media/translations/zh_TW.po",
		"modules/org/openteacher/enterers/media/translations/zh_TW.mo",
		"modules/org/openteacher/enterers/media/translations/de.po",
		"modules/org/openteacher/enterers/media/translations/pt_BR.po",
		"modules/org/openteacher/enterers/media/translations/org.openteacher.enterers.media.pot",
		"modules/org/openteacher/enterers/media/translations/es.mo",
		"modules/org/openteacher/enterers/media/translations/gl.po",
		"modules/org/openteacher/enterers/media/translations/ru.mo",
		"modules/org/openteacher/enterers/media/translations/hu.mo",
		"modules/org/openteacher/enterers/media/translations/tr.po",
		"modules/org/openteacher/enterers/media/translations/de.mo",
		"modules/org/openteacher/enterers/media/translations/fi.mo",
		"modules/org/openteacher/enterers/media/translations/cs.po",
		"modules/org/openteacher/enterers/media/translations/gl.mo",
		"modules/org/openteacher/enterers/media/translations/el.po",
		"modules/org/openteacher/enterers/media/translations/tr.mo",
		"modules/org/openteacher/enterers/media/translations/fy.mo",
		"modules/org/openteacher/enterers/media/translations/el.mo",
		"modules/org/openteacher/enterers/media/translations/fr.po",
		"modules/org/openteacher/enterers/topoTest/topoTest.py",
		"modules/org/openteacher/enterers/wordsTest/wordsTest.py",
		"modules/org/openteacher/enterers/words/words.py",
		"modules/org/openteacher/enterers/words/translations/fi.po",
		"modules/org/openteacher/enterers/words/translations/ja.mo",
		"modules/org/openteacher/enterers/words/translations/si.po",
		"modules/org/openteacher/enterers/words/translations/fy.po",
		"modules/org/openteacher/enterers/words/translations/pt_BR.mo",
		"modules/org/openteacher/enterers/words/translations/hu.po",
		"modules/org/openteacher/enterers/words/translations/zh_CN.mo",
		"modules/org/openteacher/enterers/words/translations/cs.mo",
		"modules/org/openteacher/enterers/words/translations/pl.mo",
		"modules/org/openteacher/enterers/words/translations/fr.mo",
		"modules/org/openteacher/enterers/words/translations/es.po",
		"modules/org/openteacher/enterers/words/translations/nl.po",
		"modules/org/openteacher/enterers/words/translations/ru.po",
		"modules/org/openteacher/enterers/words/translations/ar.po",
		"modules/org/openteacher/enterers/words/translations/pl.po",
		"modules/org/openteacher/enterers/words/translations/nl.mo",
		"modules/org/openteacher/enterers/words/translations/zh_CN.po",
		"modules/org/openteacher/enterers/words/translations/zh_TW.po",
		"modules/org/openteacher/enterers/words/translations/af.po",
		"modules/org/openteacher/enterers/words/translations/eo.po",
		"modules/org/openteacher/enterers/words/translations/zh_TW.mo",
		"modules/org/openteacher/enterers/words/translations/de.po",
		"modules/org/openteacher/enterers/words/translations/ar.mo",
		"modules/org/openteacher/enterers/words/translations/pt_BR.po",
		"modules/org/openteacher/enterers/words/translations/es.mo",
		"modules/org/openteacher/enterers/words/translations/gl.po",
		"modules/org/openteacher/enterers/words/translations/ja.po",
		"modules/org/openteacher/enterers/words/translations/ru.mo",
		"modules/org/openteacher/enterers/words/translations/hu.mo",
		"modules/org/openteacher/enterers/words/translations/tr.po",
		"modules/org/openteacher/enterers/words/translations/de.mo",
		"modules/org/openteacher/enterers/words/translations/fi.mo",
		"modules/org/openteacher/enterers/words/translations/sk.po",
		"modules/org/openteacher/enterers/words/translations/org.openteacher.wordsEnterer.pot",
		"modules/org/openteacher/enterers/words/translations/si.mo",
		"modules/org/openteacher/enterers/words/translations/af.mo",
		"modules/org/openteacher/enterers/words/translations/cs.po",
		"modules/org/openteacher/enterers/words/translations/gl.mo",
		"modules/org/openteacher/enterers/words/translations/eo.mo",
		"modules/org/openteacher/enterers/words/translations/el.po",
		"modules/org/openteacher/enterers/words/translations/tr.mo",
		"modules/org/openteacher/enterers/words/translations/fy.mo",
		"modules/org/openteacher/enterers/words/translations/el.mo",
		"modules/org/openteacher/enterers/words/translations/sk.mo",
		"modules/org/openteacher/enterers/words/translations/fr.po",
		"modules/org/openteacher/enterers/plainTextWords/plainTextWords.py",
		"modules/org/openteacher/enterers/plainTextWords/translations/fy.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/pt_BR.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/zh_CN.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/cs.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/pl.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/fr.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/es.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/nl.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/ru.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/ar.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/pl.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/nl.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/zh_CN.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/zh_TW.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/zh_TW.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/de.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/ar.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/pt_BR.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/es.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/ru.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/tr.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/de.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/org.openteacher.plainTextWordsEnterer.pot",
		"modules/org/openteacher/enterers/plainTextWords/translations/cs.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/el.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/tr.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/fy.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/el.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/fr.po",
		"modules/org/openteacher/quizletApi/quizletApi.py",
		"modules/org/openteacher/quizletApi/translations/pt_BR.mo",
		"modules/org/openteacher/quizletApi/translations/pl.mo",
		"modules/org/openteacher/quizletApi/translations/nl.po",
		"modules/org/openteacher/quizletApi/translations/ru.po",
		"modules/org/openteacher/quizletApi/translations/pl.po",
		"modules/org/openteacher/quizletApi/translations/nl.mo",
		"modules/org/openteacher/quizletApi/translations/zh_TW.po",
		"modules/org/openteacher/quizletApi/translations/zh_TW.mo",
		"modules/org/openteacher/quizletApi/translations/de.po",
		"modules/org/openteacher/quizletApi/translations/pt_BR.po",
		"modules/org/openteacher/quizletApi/translations/ru.mo",
		"modules/org/openteacher/quizletApi/translations/tr.po",
		"modules/org/openteacher/quizletApi/translations/de.mo",
		"modules/org/openteacher/quizletApi/translations/org.openteacher.quizletApi.pot",
		"modules/org/openteacher/quizletApi/translations/tr.mo",
		"modules/org/openteacher/mediaDisplay/mediaDisplay.py",
		"modules/org/openteacher/mediaDisplay/icons/player_pause.png",
		"modules/org/openteacher/mediaDisplay/icons/COPYING",
		"modules/org/openteacher/mediaDisplay/icons/player_play.png",
		"modules/org/openteacher/mediaDisplay/translations/fy.po",
		"modules/org/openteacher/mediaDisplay/translations/pt_BR.mo",
		"modules/org/openteacher/mediaDisplay/translations/zh_CN.mo",
		"modules/org/openteacher/mediaDisplay/translations/cs.mo",
		"modules/org/openteacher/mediaDisplay/translations/pl.mo",
		"modules/org/openteacher/mediaDisplay/translations/fr.mo",
		"modules/org/openteacher/mediaDisplay/translations/es.po",
		"modules/org/openteacher/mediaDisplay/translations/nl.po",
		"modules/org/openteacher/mediaDisplay/translations/ru.po",
		"modules/org/openteacher/mediaDisplay/translations/pl.po",
		"modules/org/openteacher/mediaDisplay/translations/nl.mo",
		"modules/org/openteacher/mediaDisplay/translations/zh_CN.po",
		"modules/org/openteacher/mediaDisplay/translations/org.openteacher.mediaDisplay.pot",
		"modules/org/openteacher/mediaDisplay/translations/zh_TW.po",
		"modules/org/openteacher/mediaDisplay/translations/zh_TW.mo",
		"modules/org/openteacher/mediaDisplay/translations/de.po",
		"modules/org/openteacher/mediaDisplay/translations/pt_BR.po",
		"modules/org/openteacher/mediaDisplay/translations/es.mo",
		"modules/org/openteacher/mediaDisplay/translations/ru.mo",
		"modules/org/openteacher/mediaDisplay/translations/tr.po",
		"modules/org/openteacher/mediaDisplay/translations/de.mo",
		"modules/org/openteacher/mediaDisplay/translations/cs.po",
		"modules/org/openteacher/mediaDisplay/translations/tr.mo",
		"modules/org/openteacher/mediaDisplay/translations/fy.mo",
		"modules/org/openteacher/mediaDisplay/translations/fr.po",
		"modules/org/openteacher/charsKeyboard/charsKeyboard.py",
		"modules/org/openteacher/execute/execute.py",
		"modules/org/openteacher/execute/translations/fi.po",
		"modules/org/openteacher/execute/translations/fy.po",
		"modules/org/openteacher/execute/translations/pt_BR.mo",
		"modules/org/openteacher/execute/translations/zh_CN.mo",
		"modules/org/openteacher/execute/translations/cs.mo",
		"modules/org/openteacher/execute/translations/pl.mo",
		"modules/org/openteacher/execute/translations/fr.mo",
		"modules/org/openteacher/execute/translations/es.po",
		"modules/org/openteacher/execute/translations/nl.po",
		"modules/org/openteacher/execute/translations/ru.po",
		"modules/org/openteacher/execute/translations/pl.po",
		"modules/org/openteacher/execute/translations/nl.mo",
		"modules/org/openteacher/execute/translations/zh_CN.po",
		"modules/org/openteacher/execute/translations/zh_TW.po",
		"modules/org/openteacher/execute/translations/zh_TW.mo",
		"modules/org/openteacher/execute/translations/de.po",
		"modules/org/openteacher/execute/translations/pt_BR.po",
		"modules/org/openteacher/execute/translations/es.mo",
		"modules/org/openteacher/execute/translations/org.openteacher.execute.pot",
		"modules/org/openteacher/execute/translations/ru.mo",
		"modules/org/openteacher/execute/translations/tr.po",
		"modules/org/openteacher/execute/translations/de.mo",
		"modules/org/openteacher/execute/translations/fi.mo",
		"modules/org/openteacher/execute/translations/cs.po",
		"modules/org/openteacher/execute/translations/tr.mo",
		"modules/org/openteacher/execute/translations/fy.mo",
		"modules/org/openteacher/execute/translations/fr.po",
		"modules/org/openteacher/settingsWidgets/settingsWidgets.py",
		"modules/org/openteacher/courseHeroApi/courseHeroApi.py",
		"modules/org/openteacher/courseHeroApi/translations/pl.mo",
		"modules/org/openteacher/courseHeroApi/translations/pl.po",
		"modules/org/openteacher/courseHeroApi/translations/org.openteacher.courseHeroApi.pot",
		"modules/org/openteacher/theme/theme.py",
		"modules/org/openteacher/ttsProviders/topo/topo.py",
		"modules/org/openteacher/ttsProviders/topo/translations/ja.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/fy.po",
		"modules/org/openteacher/ttsProviders/topo/translations/pt_BR.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/cs.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/pl.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/fr.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/es.po",
		"modules/org/openteacher/ttsProviders/topo/translations/nl.po",
		"modules/org/openteacher/ttsProviders/topo/translations/ru.po",
		"modules/org/openteacher/ttsProviders/topo/translations/pl.po",
		"modules/org/openteacher/ttsProviders/topo/translations/nl.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/zh_TW.po",
		"modules/org/openteacher/ttsProviders/topo/translations/zh_TW.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/de.po",
		"modules/org/openteacher/ttsProviders/topo/translations/pt_BR.po",
		"modules/org/openteacher/ttsProviders/topo/translations/es.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/ja.po",
		"modules/org/openteacher/ttsProviders/topo/translations/ru.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/it.po",
		"modules/org/openteacher/ttsProviders/topo/translations/it.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/tr.po",
		"modules/org/openteacher/ttsProviders/topo/translations/de.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/cs.po",
		"modules/org/openteacher/ttsProviders/topo/translations/tr.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/org.openteacher.ttsProviders.topo.pot",
		"modules/org/openteacher/ttsProviders/topo/translations/fy.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/fr.po",
		"modules/org/openteacher/ttsProviders/words/words.py",
		"modules/org/openteacher/ttsProviders/words/translations/ja.mo",
		"modules/org/openteacher/ttsProviders/words/translations/fy.po",
		"modules/org/openteacher/ttsProviders/words/translations/pt_BR.mo",
		"modules/org/openteacher/ttsProviders/words/translations/cs.mo",
		"modules/org/openteacher/ttsProviders/words/translations/pl.mo",
		"modules/org/openteacher/ttsProviders/words/translations/fr.mo",
		"modules/org/openteacher/ttsProviders/words/translations/es.po",
		"modules/org/openteacher/ttsProviders/words/translations/nl.po",
		"modules/org/openteacher/ttsProviders/words/translations/ru.po",
		"modules/org/openteacher/ttsProviders/words/translations/org.openteacher.ttsProviders.words.pot",
		"modules/org/openteacher/ttsProviders/words/translations/pl.po",
		"modules/org/openteacher/ttsProviders/words/translations/nl.mo",
		"modules/org/openteacher/ttsProviders/words/translations/zh_TW.po",
		"modules/org/openteacher/ttsProviders/words/translations/zh_TW.mo",
		"modules/org/openteacher/ttsProviders/words/translations/de.po",
		"modules/org/openteacher/ttsProviders/words/translations/pt_BR.po",
		"modules/org/openteacher/ttsProviders/words/translations/es.mo",
		"modules/org/openteacher/ttsProviders/words/translations/ja.po",
		"modules/org/openteacher/ttsProviders/words/translations/ru.mo",
		"modules/org/openteacher/ttsProviders/words/translations/it.po",
		"modules/org/openteacher/ttsProviders/words/translations/it.mo",
		"modules/org/openteacher/ttsProviders/words/translations/de.mo",
		"modules/org/openteacher/ttsProviders/words/translations/cs.po",
		"modules/org/openteacher/ttsProviders/words/translations/fy.mo",
		"modules/org/openteacher/ttsProviders/words/translations/fr.po",
		"modules/org/openteacher/lessonDialogs/lessonDialogs.py",
		"modules/org/openteacher/lessonDialogs/translations/fi.po",
		"modules/org/openteacher/lessonDialogs/translations/fy.po",
		"modules/org/openteacher/lessonDialogs/translations/pt_BR.mo",
		"modules/org/openteacher/lessonDialogs/translations/zh_CN.mo",
		"modules/org/openteacher/lessonDialogs/translations/cs.mo",
		"modules/org/openteacher/lessonDialogs/translations/pl.mo",
		"modules/org/openteacher/lessonDialogs/translations/fr.mo",
		"modules/org/openteacher/lessonDialogs/translations/es.po",
		"modules/org/openteacher/lessonDialogs/translations/nl.po",
		"modules/org/openteacher/lessonDialogs/translations/org.openteacher.lessonDialogs.pot",
		"modules/org/openteacher/lessonDialogs/translations/ru.po",
		"modules/org/openteacher/lessonDialogs/translations/pl.po",
		"modules/org/openteacher/lessonDialogs/translations/nl.mo",
		"modules/org/openteacher/lessonDialogs/translations/zh_CN.po",
		"modules/org/openteacher/lessonDialogs/translations/zh_TW.po",
		"modules/org/openteacher/lessonDialogs/translations/zh_TW.mo",
		"modules/org/openteacher/lessonDialogs/translations/de.po",
		"modules/org/openteacher/lessonDialogs/translations/pt_BR.po",
		"modules/org/openteacher/lessonDialogs/translations/es.mo",
		"modules/org/openteacher/lessonDialogs/translations/gl.po",
		"modules/org/openteacher/lessonDialogs/translations/ru.mo",
		"modules/org/openteacher/lessonDialogs/translations/it.po",
		"modules/org/openteacher/lessonDialogs/translations/it.mo",
		"modules/org/openteacher/lessonDialogs/translations/tr.po",
		"modules/org/openteacher/lessonDialogs/translations/de.mo",
		"modules/org/openteacher/lessonDialogs/translations/fi.mo",
		"modules/org/openteacher/lessonDialogs/translations/cs.po",
		"modules/org/openteacher/lessonDialogs/translations/gl.mo",
		"modules/org/openteacher/lessonDialogs/translations/tr.mo",
		"modules/org/openteacher/lessonDialogs/translations/fy.mo",
		"modules/org/openteacher/lessonDialogs/translations/fr.po",
		"modules/org/openteacher/languageCodeGuesser/tables.py",
		"modules/org/openteacher/languageCodeGuesser/languageCodeGuesser.py",
		"modules/org/openteacher/webApi/test/test.py",
		"modules/org/openteacher/webApi/serverRunner/serverRunner.py",
		"modules/org/openteacher/webApi/server/serverImpl.py",
		"modules/org/openteacher/webApi/server/server.py",
		"modules/org/openteacher/webApi/server/template.html",
		"modules/org/openteacher/lessons/topo/topo.py",
		"modules/org/openteacher/lessons/topo/translations/fi.po",
		"modules/org/openteacher/lessons/topo/translations/ja.mo",
		"modules/org/openteacher/lessons/topo/translations/si.po",
		"modules/org/openteacher/lessons/topo/translations/fy.po",
		"modules/org/openteacher/lessons/topo/translations/org.openteacher.lessons.topo.pot",
		"modules/org/openteacher/lessons/topo/translations/pt_BR.mo",
		"modules/org/openteacher/lessons/topo/translations/hu.po",
		"modules/org/openteacher/lessons/topo/translations/zh_CN.mo",
		"modules/org/openteacher/lessons/topo/translations/cs.mo",
		"modules/org/openteacher/lessons/topo/translations/pl.mo",
		"modules/org/openteacher/lessons/topo/translations/fr.mo",
		"modules/org/openteacher/lessons/topo/translations/es.po",
		"modules/org/openteacher/lessons/topo/translations/nl.po",
		"modules/org/openteacher/lessons/topo/translations/ru.po",
		"modules/org/openteacher/lessons/topo/translations/ar.po",
		"modules/org/openteacher/lessons/topo/translations/pl.po",
		"modules/org/openteacher/lessons/topo/translations/nl.mo",
		"modules/org/openteacher/lessons/topo/translations/zh_CN.po",
		"modules/org/openteacher/lessons/topo/translations/zh_TW.po",
		"modules/org/openteacher/lessons/topo/translations/zh_TW.mo",
		"modules/org/openteacher/lessons/topo/translations/de.po",
		"modules/org/openteacher/lessons/topo/translations/ar.mo",
		"modules/org/openteacher/lessons/topo/translations/pt_BR.po",
		"modules/org/openteacher/lessons/topo/translations/es.mo",
		"modules/org/openteacher/lessons/topo/translations/gl.po",
		"modules/org/openteacher/lessons/topo/translations/ja.po",
		"modules/org/openteacher/lessons/topo/translations/ru.mo",
		"modules/org/openteacher/lessons/topo/translations/hu.mo",
		"modules/org/openteacher/lessons/topo/translations/tr.po",
		"modules/org/openteacher/lessons/topo/translations/de.mo",
		"modules/org/openteacher/lessons/topo/translations/fi.mo",
		"modules/org/openteacher/lessons/topo/translations/sk.po",
		"modules/org/openteacher/lessons/topo/translations/si.mo",
		"modules/org/openteacher/lessons/topo/translations/cs.po",
		"modules/org/openteacher/lessons/topo/translations/gl.mo",
		"modules/org/openteacher/lessons/topo/translations/el.po",
		"modules/org/openteacher/lessons/topo/translations/tr.mo",
		"modules/org/openteacher/lessons/topo/translations/fy.mo",
		"modules/org/openteacher/lessons/topo/translations/el.mo",
		"modules/org/openteacher/lessons/topo/translations/sk.mo",
		"modules/org/openteacher/lessons/topo/translations/fr.po",
		"modules/org/openteacher/lessons/media/media.py",
		"modules/org/openteacher/lessons/media/translations/fi.po",
		"modules/org/openteacher/lessons/media/translations/si.po",
		"modules/org/openteacher/lessons/media/translations/fy.po",
		"modules/org/openteacher/lessons/media/translations/pt_BR.mo",
		"modules/org/openteacher/lessons/media/translations/hu.po",
		"modules/org/openteacher/lessons/media/translations/zh_CN.mo",
		"modules/org/openteacher/lessons/media/translations/cs.mo",
		"modules/org/openteacher/lessons/media/translations/pl.mo",
		"modules/org/openteacher/lessons/media/translations/fr.mo",
		"modules/org/openteacher/lessons/media/translations/es.po",
		"modules/org/openteacher/lessons/media/translations/nl.po",
		"modules/org/openteacher/lessons/media/translations/ru.po",
		"modules/org/openteacher/lessons/media/translations/ar.po",
		"modules/org/openteacher/lessons/media/translations/org.openteacher.lessons.media.pot",
		"modules/org/openteacher/lessons/media/translations/pl.po",
		"modules/org/openteacher/lessons/media/translations/nl.mo",
		"modules/org/openteacher/lessons/media/translations/zh_CN.po",
		"modules/org/openteacher/lessons/media/translations/zh_TW.po",
		"modules/org/openteacher/lessons/media/translations/af.po",
		"modules/org/openteacher/lessons/media/translations/zh_TW.mo",
		"modules/org/openteacher/lessons/media/translations/de.po",
		"modules/org/openteacher/lessons/media/translations/ar.mo",
		"modules/org/openteacher/lessons/media/translations/pt_BR.po",
		"modules/org/openteacher/lessons/media/translations/es.mo",
		"modules/org/openteacher/lessons/media/translations/gl.po",
		"modules/org/openteacher/lessons/media/translations/ru.mo",
		"modules/org/openteacher/lessons/media/translations/hu.mo",
		"modules/org/openteacher/lessons/media/translations/tr.po",
		"modules/org/openteacher/lessons/media/translations/de.mo",
		"modules/org/openteacher/lessons/media/translations/fi.mo",
		"modules/org/openteacher/lessons/media/translations/sk.po",
		"modules/org/openteacher/lessons/media/translations/si.mo",
		"modules/org/openteacher/lessons/media/translations/af.mo",
		"modules/org/openteacher/lessons/media/translations/cs.po",
		"modules/org/openteacher/lessons/media/translations/gl.mo",
		"modules/org/openteacher/lessons/media/translations/el.po",
		"modules/org/openteacher/lessons/media/translations/tr.mo",
		"modules/org/openteacher/lessons/media/translations/fy.mo",
		"modules/org/openteacher/lessons/media/translations/el.mo",
		"modules/org/openteacher/lessons/media/translations/sk.mo",
		"modules/org/openteacher/lessons/media/translations/fr.po",
		"modules/org/openteacher/lessons/words/words.py",
		"modules/org/openteacher/lessons/words/translations/fi.po",
		"modules/org/openteacher/lessons/words/translations/ja.mo",
		"modules/org/openteacher/lessons/words/translations/si.po",
		"modules/org/openteacher/lessons/words/translations/fy.po",
		"modules/org/openteacher/lessons/words/translations/pt_BR.mo",
		"modules/org/openteacher/lessons/words/translations/hu.po",
		"modules/org/openteacher/lessons/words/translations/zh_CN.mo",
		"modules/org/openteacher/lessons/words/translations/cs.mo",
		"modules/org/openteacher/lessons/words/translations/pl.mo",
		"modules/org/openteacher/lessons/words/translations/fr.mo",
		"modules/org/openteacher/lessons/words/translations/es.po",
		"modules/org/openteacher/lessons/words/translations/nl.po",
		"modules/org/openteacher/lessons/words/translations/ru.po",
		"modules/org/openteacher/lessons/words/translations/ar.po",
		"modules/org/openteacher/lessons/words/translations/pl.po",
		"modules/org/openteacher/lessons/words/translations/nl.mo",
		"modules/org/openteacher/lessons/words/translations/zh_CN.po",
		"modules/org/openteacher/lessons/words/translations/zh_TW.po",
		"modules/org/openteacher/lessons/words/translations/af.po",
		"modules/org/openteacher/lessons/words/translations/eo.po",
		"modules/org/openteacher/lessons/words/translations/zh_TW.mo",
		"modules/org/openteacher/lessons/words/translations/de.po",
		"modules/org/openteacher/lessons/words/translations/ar.mo",
		"modules/org/openteacher/lessons/words/translations/pt_BR.po",
		"modules/org/openteacher/lessons/words/translations/es.mo",
		"modules/org/openteacher/lessons/words/translations/gl.po",
		"modules/org/openteacher/lessons/words/translations/ja.po",
		"modules/org/openteacher/lessons/words/translations/ru.mo",
		"modules/org/openteacher/lessons/words/translations/hu.mo",
		"modules/org/openteacher/lessons/words/translations/org.openteacher.lessons.words.pot",
		"modules/org/openteacher/lessons/words/translations/tr.po",
		"modules/org/openteacher/lessons/words/translations/de.mo",
		"modules/org/openteacher/lessons/words/translations/fi.mo",
		"modules/org/openteacher/lessons/words/translations/sk.po",
		"modules/org/openteacher/lessons/words/translations/si.mo",
		"modules/org/openteacher/lessons/words/translations/af.mo",
		"modules/org/openteacher/lessons/words/translations/cs.po",
		"modules/org/openteacher/lessons/words/translations/gl.mo",
		"modules/org/openteacher/lessons/words/translations/eo.mo",
		"modules/org/openteacher/lessons/words/translations/el.po",
		"modules/org/openteacher/lessons/words/translations/tr.mo",
		"modules/org/openteacher/lessons/words/translations/fy.mo",
		"modules/org/openteacher/lessons/words/translations/el.mo",
		"modules/org/openteacher/lessons/words/translations/sk.mo",
		"modules/org/openteacher/lessons/words/translations/fr.po",
		"modules/org/openteacher/lessonTracker/lessonTracker.py",
		"modules/org/openteacher/cli/cli.py",
		"modules/org/openteacher/topoMaps/topoMaps.py",
		"modules/org/openteacher/topoMaps/resources/COPYING",
		"modules/org/openteacher/topoMaps/resources/crosshair.png",
		"modules/org/openteacher/topoMaps/translations/fy.po",
		"modules/org/openteacher/topoMaps/translations/pt_BR.mo",
		"modules/org/openteacher/topoMaps/translations/zh_CN.mo",
		"modules/org/openteacher/topoMaps/translations/cs.mo",
		"modules/org/openteacher/topoMaps/translations/pl.mo",
		"modules/org/openteacher/topoMaps/translations/fr.mo",
		"modules/org/openteacher/topoMaps/translations/es.po",
		"modules/org/openteacher/topoMaps/translations/nl.po",
		"modules/org/openteacher/topoMaps/translations/ru.po",
		"modules/org/openteacher/topoMaps/translations/pl.po",
		"modules/org/openteacher/topoMaps/translations/nl.mo",
		"modules/org/openteacher/topoMaps/translations/zh_CN.po",
		"modules/org/openteacher/topoMaps/translations/zh_TW.po",
		"modules/org/openteacher/topoMaps/translations/zh_TW.mo",
		"modules/org/openteacher/topoMaps/translations/de.po",
		"modules/org/openteacher/topoMaps/translations/pt_BR.po",
		"modules/org/openteacher/topoMaps/translations/es.mo",
		"modules/org/openteacher/topoMaps/translations/ru.mo",
		"modules/org/openteacher/topoMaps/translations/tr.po",
		"modules/org/openteacher/topoMaps/translations/de.mo",
		"modules/org/openteacher/topoMaps/translations/org.openteacher.topoMaps.pot",
		"modules/org/openteacher/topoMaps/translations/cs.po",
		"modules/org/openteacher/topoMaps/translations/tr.mo",
		"modules/org/openteacher/topoMaps/translations/fy.mo",
		"modules/org/openteacher/topoMaps/translations/fr.po",
		"modules/org/openteacher/ircBot/bot.py",
		"modules/org/openteacher/ircBot/ircBot.py",
		"modules/org/openteacher/settingsWidget/password/password.py",
		"modules/org/openteacher/settingsWidget/test/test.py",
		"modules/org/openteacher/settingsWidget/characterTable/characterTable.py",
		"modules/org/openteacher/settingsWidget/boolean/boolean.py",
		"modules/org/openteacher/settingsWidget/language/language.py",
		"modules/org/openteacher/settingsWidget/language/translations/fi.po",
		"modules/org/openteacher/settingsWidget/language/translations/ja.mo",
		"modules/org/openteacher/settingsWidget/language/translations/si.po",
		"modules/org/openteacher/settingsWidget/language/translations/fy.po",
		"modules/org/openteacher/settingsWidget/language/translations/pt_BR.mo",
		"modules/org/openteacher/settingsWidget/language/translations/hu.po",
		"modules/org/openteacher/settingsWidget/language/translations/zh_CN.mo",
		"modules/org/openteacher/settingsWidget/language/translations/cs.mo",
		"modules/org/openteacher/settingsWidget/language/translations/pl.mo",
		"modules/org/openteacher/settingsWidget/language/translations/fr.mo",
		"modules/org/openteacher/settingsWidget/language/translations/es.po",
		"modules/org/openteacher/settingsWidget/language/translations/nl.po",
		"modules/org/openteacher/settingsWidget/language/translations/ru.po",
		"modules/org/openteacher/settingsWidget/language/translations/ar.po",
		"modules/org/openteacher/settingsWidget/language/translations/org.openteacher.languageChooser.pot",
		"modules/org/openteacher/settingsWidget/language/translations/pl.po",
		"modules/org/openteacher/settingsWidget/language/translations/nl.mo",
		"modules/org/openteacher/settingsWidget/language/translations/zh_CN.po",
		"modules/org/openteacher/settingsWidget/language/translations/zh_TW.po",
		"modules/org/openteacher/settingsWidget/language/translations/af.po",
		"modules/org/openteacher/settingsWidget/language/translations/zh_TW.mo",
		"modules/org/openteacher/settingsWidget/language/translations/de.po",
		"modules/org/openteacher/settingsWidget/language/translations/ar.mo",
		"modules/org/openteacher/settingsWidget/language/translations/pt_BR.po",
		"modules/org/openteacher/settingsWidget/language/translations/es.mo",
		"modules/org/openteacher/settingsWidget/language/translations/gl.po",
		"modules/org/openteacher/settingsWidget/language/translations/ja.po",
		"modules/org/openteacher/settingsWidget/language/translations/ru.mo",
		"modules/org/openteacher/settingsWidget/language/translations/it.po",
		"modules/org/openteacher/settingsWidget/language/translations/hu.mo",
		"modules/org/openteacher/settingsWidget/language/translations/it.mo",
		"modules/org/openteacher/settingsWidget/language/translations/tr.po",
		"modules/org/openteacher/settingsWidget/language/translations/de.mo",
		"modules/org/openteacher/settingsWidget/language/translations/fi.mo",
		"modules/org/openteacher/settingsWidget/language/translations/si.mo",
		"modules/org/openteacher/settingsWidget/language/translations/af.mo",
		"modules/org/openteacher/settingsWidget/language/translations/cs.po",
		"modules/org/openteacher/settingsWidget/language/translations/gl.mo",
		"modules/org/openteacher/settingsWidget/language/translations/el.po",
		"modules/org/openteacher/settingsWidget/language/translations/tr.mo",
		"modules/org/openteacher/settingsWidget/language/translations/fy.mo",
		"modules/org/openteacher/settingsWidget/language/translations/el.mo",
		"modules/org/openteacher/settingsWidget/language/translations/fr.po",
		"modules/org/openteacher/settingsWidget/profile/profile.py",
		"modules/org/openteacher/settingsWidget/shortText/shortText.py",
		"modules/org/openteacher/settingsWidget/multiOption/multiOption.py",
		"modules/org/openteacher/settingsWidget/longText/longText.py",
		"modules/org/openteacher/settingsWidget/number/number.py",
		"modules/org/openteacher/settingsWidget/option/option.py",
		"modules/org/openteacher/loader/loader.py",
		"modules/org/openteacher/javaScript/api/api.py",
		"modules/org/openteacher/javaScript/api/api.js",
		"modules/org/openteacher/javaScript/event/event.py",
		"modules/org/openteacher/javaScript/event/event.js",
		"modules/org/openteacher/javaScript/evaluatorTest/evaluatorTest.py",
		"modules/org/openteacher/javaScript/evaluator/evaluator.py",
		"modules/org/openteacher/javaScript/implementationTest/implementationTest.py",
		"modules/org/openteacher/javaScript/apiTest/apiTest.py",
		"modules/org/openteacher/javaScript/lessonType/lessonType.py",
		"modules/org/openteacher/javaScript/lessonType/lessonType.js",
		"modules/org/openteacher/javaScript/jshintTest/jshintTest.py",
		"modules/org/openteacher/gtkGui/gtkGui.py",
		"modules/org/openteacher/qtApp/qtApp.py",
		"modules/org/openteacher/sourceWithSetupSaver/menu.templ",
		"modules/org/openteacher/sourceWithSetupSaver/setup.py.templ",
		"modules/org/openteacher/sourceWithSetupSaver/runner.templ",
		"modules/org/openteacher/sourceWithSetupSaver/manpage.templ",
		"modules/org/openteacher/sourceWithSetupSaver/desktop.templ",
		"modules/org/openteacher/sourceWithSetupSaver/sourceWithSetupSaver.py",
		"modules/org/openteacher/sourceWithSetupSaver/mimetypes.xml",
		"modules/org/openteacher/sourceWithSetupSaver/translations/pt_BR.mo",
		"modules/org/openteacher/sourceWithSetupSaver/translations/pl.mo",
		"modules/org/openteacher/sourceWithSetupSaver/translations/nl.po",
		"modules/org/openteacher/sourceWithSetupSaver/translations/ru.po",
		"modules/org/openteacher/sourceWithSetupSaver/translations/pl.po",
		"modules/org/openteacher/sourceWithSetupSaver/translations/nl.mo",
		"modules/org/openteacher/sourceWithSetupSaver/translations/zh_TW.po",
		"modules/org/openteacher/sourceWithSetupSaver/translations/zh_TW.mo",
		"modules/org/openteacher/sourceWithSetupSaver/translations/de.po",
		"modules/org/openteacher/sourceWithSetupSaver/translations/pt_BR.po",
		"modules/org/openteacher/sourceWithSetupSaver/translations/ru.mo",
		"modules/org/openteacher/sourceWithSetupSaver/translations/de.mo",
		"modules/org/openteacher/sourceWithSetupSaver/translations/org.openteacher.sourceWithSetupSaver.pot",
		"modules/org/openteacher/itemModifiers/test/test.py",
		"modules/org/openteacher/itemModifiers/foreignKnown/foreignKnown.py",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fi.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/si.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fy.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/pt_BR.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/hu.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/zh_CN.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/cs.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/org.openteacher.itemModifiers.foreignKnown.pot",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fr.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/es.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/nl.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/ru.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/ar.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/nl.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/zh_CN.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/zh_TW.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/af.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/zh_TW.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/de.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/ar.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/pt_BR.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/es.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/ru.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/hu.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/tr.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/de.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fi.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/sk.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/si.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/af.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/cs.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/el.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/tr.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fy.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/el.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/sk.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fr.po",
	]},
	data_files = [
		("share/applications", [
			"linux/openteacher.desktop"
		]),
		("share/menu", [
			"linux/openteacher"
		]),
		("share/pixmaps", [
			"linux/openteacher.xpm"
		]),
		("share/icons/hicolor/128x128/mimetypes", ['linux/application-x-openteachingtopography.png', 'linux/application-x-kvtml.png', 'linux/application-x-ludem.png', 'linux/application-x-wrts.png', 'linux/application-x-anki.png', 'linux/application-x-jmemorizelesson.png', 'linux/application-x-vokabeltrainer.png', 'linux/application-x-oriente-voca.png', 'linux/application-x-granuledeck.png', 'linux/application-x-domingo.png', 'linux/application-x-overhoringsprogrammatalen.png', 'linux/application-x-openteachingwords.png', 'linux/application-x-openteachingmedia.png', 'linux/application-x-pauker.png', 'linux/application-x-cuecard.png', 'linux/application-x-jvlt.png', 'linux/application-x-vocabularium.png', 'linux/application-x-overhoor.png', 'linux/application-x-apkg.png', 'linux/application-x-kgeographymap.png', 'linux/application-x-flashqard.png', 'linux/application-x-anki2.png', 'linux/application-x-backpack.png', 'linux/application-x-teachmaster.png', 'linux/application-x-teach2000.png', 'linux/application-x-openteacher.png']),
		("share/icons/hicolor/128x128/apps", [
			"linux/openteacher.png"
		]),
		("share/mime/packages", [
			"linux/openteacher.xml"
		])
	],
	ext_modules=[
		Extension("openteacher.moduleFilterer", ["openteacher/moduleFilterer.c"]),
	],
	scripts = ["bin/openteacher"],
	#a list of classifiers can be found at http://pypi.python.org/pypi?:action=list_classifiers
	classifiers = [
		"Development Status :: 5 - Production/Stable", 
		"Intended Audience :: End Users/Desktop",
		"Intended Audience :: Education",
		"License :: OSI Approved :: GNU General Public License (GPL)",
		"Operating System :: POSIX :: Linux",
		"Operating System :: Microsoft :: Windows",
		"Operating System :: MacOS :: MacOS X",
		"Environment :: X11 Applications :: Qt",
		"Programming Language :: Python",
		"Topic :: Education :: Testing",
	],
	long_description = """OpenTeacher is an opensource application that helps you learning a variety
of subjects. You just enter the questions and the answers, or download them from
the internet, and OpenTeacher tests you.

OpenTeacher 3.2 has the following features:
 - Viewing both recent and past results of tests with graphs
 - Smart question asking and interval training
 - Reverse rehearsal (the answer is asked, and you need to give the question)
 - Read support for more than 29 file formats; write support for over 14 file formats
 - Learn typing with our Typing Tutor which adapts itself to your skills
 - Print your word lists, media items and topography maps
 - (Partly) available in Arabic, Brazilian Portuguese, Simplified Chinese,
   Traditional Chinese, Czech, Dutch, Finnish, French, Frisian, Galician,
   German, Greek, Hungarian, Italian, Japanese, Polish, Russian, Sinhalese,
   Spanish and Turkish
 - and more...

OpenTeacher is available for Linux, Windows and Mac OS X."""
)
