// -*- C++ -*- 
/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef MILESTONE_H
#define MILESTONE_H

#include <string>
#include <vector>

using namespace std;

#include "namedid.h"
#include "task.h"

class MILESTONE : public NAMED_ID
{
public:

    typedef vector<MILESTONE *> PTRLIST;

    MILESTONE(char *id, char *name);
    ~MILESTONE() {};

    void addDepends( TASK * depends ) { mDepends.push_back( depends ); };
    TASK::PTRLIST::const_iterator begin_depends() { return mDepends.begin(); }; 
    TASK::PTRLIST::const_iterator end_depends() { return mDepends.end(); }; 
    
    int  day() const { return mDay; };
    void setDay(int day) { mDay = day; };
    int  bday() const { return mBday; };
    void setBday(int bday) { mBday = bday; };
    TASK * critical() const { return mCritical; };
    void setCritical(TASK * critical) { mCritical = critical; };

    // really part of reporting routines
    int x1,y1,x2,y2;  ///< gannt chart drawing coordinates
    int nx, ny;       ///< network diagram drawing coordinates

private:
    int  mDay;          ///< Baseline date met
    int  mBday;         ///< Baseline date met
    TASK *mCritical;    ///< which depends task sets date

    TASK::PTRLIST mDepends;  ///< what tasks must be finished first?
};

class CompareMilestoneDates
{
public:
    bool operator()(const MILESTONE * m1, const MILESTONE * m2) const
	{ return m1->day() < m2->day(); };
};



#endif
