/*
** Copyright (C) 2000 Idan Shoham <idan@m-tech.ab.ca>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cstdio>
#include <list>
#include <unistd.h>

using namespace std;

#include "messenger.h"
#include "project.h"
#include "projectFile.h"


#if 0
#define DEBUG	1
#endif

/// List of names of all files to process
typedef list<const char *> L_FILENAME;

/// Print the usage
/// \param out file the usage must be printed.
/// \param progName the name of the program.
static void usage(FILE *out, const char *progName)
{
  fprintf(out, "USAGE: %s [-d] [-v] [-h] file1 [file2 file3 ...]\n", progName);
}

/// Print the version message
void version (FILE * out)
{
  // Print some version informations
#if (defined(PACKAGE) && defined(VERSION))
  (void) fprintf (out, "%s %s\n", PACKAGE, VERSION);
#else
  (void) fprintf (out,
		  "No package-version available (due to generation).\n"
		  "CVS/RCS informations: $RCSfile: main.cc,v $ $Revision: 1.8 $\n");
#endif

  // Copyright notice
  (void) fprintf (out,
		  "Copyright (C) 2000 Idan Shoham\n"
		  "This program comes with NO WARRANTY.\n"
		  "You may redistribute copies of it under the terms of the\n"
		  "GNU General Public License.\n"
		  "For more information about these matters,\n"
		  "see the files named COPYING.\n");
}

int main(int argc, char **argv)
{
    ProjectFile projectFile;
    L_FILENAME files;
    L_FILENAME::iterator file;
    extern char *optarg;
    extern int optind, opterr, optopt;
    int c;
    int nbErrors = 0;

    // Init
    MESSENGER::setGlobalDebug(false);

    while ((c = getopt(argc, argv, "vhd")) != -1)
      {
	switch (c)
	  {
	  case 'v': // Version is requested
	    version(stdout);
	    return EXIT_SUCCESS;
	    break;
	  case 'h': // Help is requested
	    usage(stdout, argv[0]);
	    return EXIT_SUCCESS;
	    break;
	  case 'd': // Debug is requested
	    MESSENGER::setGlobalDebug(true);
	    break;
	  case '?':
	  default:
	    nbErrors++;
	    break;
	  }
      }

    /*
      if (optind < argc)
      {
      cerr << "Error: no files specified." << endl;
      nbErrors++;
      }
    */
    if (nbErrors > 0)
      {
	usage(stderr, argv[0]);
	return EXIT_FAILURE;
      }

    while (optind < argc)
      {
	files.push_back(argv[optind]);
	optind++;
      }

    try 
    {
	if ( files.size() == 0 )
	{
	    projectFile.Load("workplan.sched");
	}
	else
	{
	  for (file = files.begin() ; file != files.end() ; file++)
	    {
	      projectFile.Load(*file);
	    }
	}
    }
    catch ( ProjectFileException & e )
    {
	cerr << "Project not loaded: " << e.what() << endl;
	return EXIT_FAILURE;
    }

    try 
    {
      projectFile.checkComplete();

#ifdef DEBUG
      projectFile.Print();
#endif

      Project project = projectFile.project();
      project.DoScheduling();
      
      Reporter reporter = projectFile.reporter();
      reporter.DoReports( &project );
    
    }
    catch ( OpenschedException & e )
    {
      cerr << e.what() << endl;
      return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
