package net.sf.openrocket.util;

/**
 * A class defining various non-ASCII characters for easier use. 
 * 
 * @author Sampo Niskanen <sampo.niskanen@iki.fi>
 */
public class Chars {

	/** The fraction 1/2 */
	public static final char FRAC12 = '\u00BD';
	/** The fraction 1/4 */
	public static final char FRAC14 = '\u00BC';
	/** The fraction 3/4 */
	public static final char FRAC34 = '\u00BE';
	
	/** Degree sign */
	public static final char DEGREE = '\u00B0';
	
	/** Squared, superscript 2 */
	public static final char SQUARED = '\u00B2';
	/** Cubed, superscript 3 */
	public static final char CUBED = '\u00B3';
	
	/** Per mille sign */
	public static final char PERMILLE = '\u2030';
	
	/** Middle dot, multiplication */
	public static final char DOT = '\u00B7';
	/** Multiplication sign, cross */
	public static final char TIMES = '\u00D7';
	
	/** No-break space */
	public static final char NBSP = '\u00A0';
	/** Zero-width space */
	public static final char ZWSP = '\u200B';
	
	/** Micro sign (Greek letter mu) */
	public static final char MICRO = '\u00B5';

	/** Alpha */
	public static final char ALPHA = '\u03b1';
	/** Theta */
	public static final char THETA = '\u0398';
	
	/** Copyright symbol */
	public static final char COPY = '\u00A9';
	/** A centered bullet */
	public static final char BULLET = '\u2022';
}
