/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: GCJFileURLStreamHandler.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2006/03/16 11:16:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.help;
import java.io.File;
import java.io.FileInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;

public class GCJFileURLStreamHandler
	extends gnu.java.net.protocol.file.Handler {

	private static HashMap cache = new HashMap();

	GCJFileURLStreamHandler() {
	}

	public URLConnection openConnection(URL url) throws IOException {

        String externalForm = url.toExternalForm();

        if ( externalForm.endsWith(".xhp") ) {
			HelpLinker.totCount += 1;
            byte[] content = (byte[])cache.get(externalForm);
            if ( content == null ) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(new File(new URI(externalForm)));
                } catch (Exception e) {
                    System.err.println(e.getMessage());
                    System.exit(1);
                }

                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int nRead;
                byte[] buffer=new byte[0xFFFF];
                while( (nRead = is.read(buffer)) > -1) {
                    baos.write(buffer, 0, nRead);
                }

                content = baos.toByteArray();
                cache.put(externalForm, content);
            }
            else {
				HelpLinker.locCount += 1;
            }
               
            return new MemoryURLConnection(url, content);
        }
        else {
    		return super.openConnection(url);
        }
	}
}
