/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AdvancedPageDlg.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: obo $ $Date: 2005/12/19 17:15:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef DBAUI_ADVANCEDPAGEDLG_HXX
#include "AdvancedPageDlg.hxx"
#endif
#ifndef DBAUI_ADVANCEDPAGEDLG_HRC
#include "AdvancedPageDlg.hrc"
#endif
#ifndef _DBU_DLG_HRC_
#include "dbu_dlg.hrc"
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif
#ifndef _DBAUI_DATASOURCEITEMS_HXX_
#include "dsitems.hxx"
#endif
#ifndef _SFXSTRITEM_HXX
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _VCL_STDTEXT_HXX
#include <vcl/stdtext.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _DBAUI_DATASOURCEITEMS_HXX_
#include "dsitems.hxx"
#endif
#ifndef DBAUI_DRIVERSETTINGS_HXX
#include "DriverSettings.hxx"
#endif
#ifndef _DBAUI_DBADMINIMPL_HXX_
#include "DbAdminImpl.hxx"
#endif
#ifndef _DBAUI_PROPERTYSETITEM_HXX_
#include "propertysetitem.hxx"
#endif
#ifndef _DBAUI_ADMINPAGES_HXX_
#include "adminpages.hxx"
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::sdbc;

	//========================================================================
	//= OAdvancedTabPageDlg
DBG_NAME(OAdvancedTabPageDlg)
//========================================================================
	OAdvancedTabPageDlg::OAdvancedTabPageDlg(Window* _pParent
											, SfxItemSet* _pItems
											,const Reference< XMultiServiceFactory >& _rxORB
											,const ::com::sun::star::uno::Any& _aDataSourceName)
		:SfxTabDialog(_pParent, ModuleRes(DLG_DATABASE_ADVANCED), _pItems)
		,m_pItemSet(_pItems)
	{
        DBG_CTOR(OAdvancedTabPageDlg,NULL);

		m_pImpl = ::std::auto_ptr<ODbDataSourceAdministrationHelper>(new ODbDataSourceAdministrationHelper(_rxORB,_pParent,this));
		m_pImpl->setDataSourceOrName(_aDataSourceName);
		Reference< XPropertySet > xDatasource = m_pImpl->getCurrentDataSource();
		m_pImpl->translateProperties(xDatasource, *_pItems);
		SetInputSet(_pItems);
		// propagate this set as our new input set and reset the example set
		delete pExampleSet;
		pExampleSet = new SfxItemSet(*GetInputSetImpl());

		DATASOURCE_TYPE eType = m_pImpl->getDatasourceType(*_pItems);

		switch ( eType )
		{
			case DST_DBASE:
			case DST_FLAT: 
				AddTabPage(PAGE_DS_PROPERTIES_FILE, String(ResId(STR_DS_BEHAVIOUR)), ODriversSettings::CreateFileDsProperties,NULL);
				break;
			case DST_MSACCESS:
				AddTabPage(PAGE_DS_PROPERTIES_ACCESS, String(ResId(STR_DS_BEHAVIOUR)), ODriversSettings::CreateAccessDsProperties,NULL);
				break;
			case DST_ADABAS:
				AddTabPage(PAGE_DS_PROPERTIES_2, String(ResId(STR_DS_BEHAVIOUR)), ODriversSettings::Create2DsProperties,NULL);
				break;
			case DST_ADO:
				AddTabPage(PAGE_DS_PROPERTIES_3, String(ResId(STR_DS_BEHAVIOUR)), ODriversSettings::Create3DsProperties,NULL);
				break;

			case DST_ODBC:
				AddTabPage(PAGE_GENERATED_VALUES, String(ResId(STR_GENERATED_VALUE)), ODriversSettings::CreateGeneratedValues,NULL);
				AddTabPage(PAGE_DS_PROPERTIES_4, String(ResId(STR_DS_BEHAVIOUR)), ODriversSettings::Create4DsProperties,NULL);
				break;

			case DST_MYSQL_ODBC:
			case DST_MYSQL_JDBC:
				AddTabPage(PAGE_DS_PROPERTIES_ENABLEOJ, String(ResId(STR_DS_BEHAVIOUR)), ODriversSettings::CreateOJDsProperties,NULL);
				break;
			case DST_LDAP:
			case DST_CALC:
			case DST_MOZILLA: 
			case DST_THUNDERBIRD:
			case DST_EVOLUTION: 
			case DST_KAB: 
			case DST_OUTLOOK	: 
			case DST_OUTLOOKEXP:
				break;
			case DST_JDBC:
			case DST_ORACLE_JDBC:
			case DST_USERDEFINE1:	/// first user defined driver
			case DST_USERDEFINE2:
			case DST_USERDEFINE3:
			case DST_USERDEFINE4:
			case DST_USERDEFINE5:
			case DST_USERDEFINE6:
			case DST_USERDEFINE7:
			case DST_USERDEFINE8:
			case DST_USERDEFINE9:
			case DST_USERDEFINE10:
			default:
				AddTabPage(PAGE_GENERATED_VALUES, String(ResId(STR_GENERATED_VALUE)), ODriversSettings::CreateGeneratedValues,NULL);
				AddTabPage(PAGE_DS_PROPERTIES_4, String(ResId(STR_DS_BEHAVIOUR)), ODriversSettings::Create4DsProperties,NULL);
				break;
		}
		
		// remove the reset button - it's meaning is much too ambiguous in this dialog
		RemoveResetButton();
		FreeResource();
	}

	// -----------------------------------------------------------------------
	OAdvancedTabPageDlg::~OAdvancedTabPageDlg()
	{
		SetInputSet(NULL);
		DELETEZ(pExampleSet);
	
        DBG_DTOR(OAdvancedTabPageDlg,NULL);
    }
	// -----------------------------------------------------------------------
	short OAdvancedTabPageDlg::Execute()
	{
		short nRet = SfxTabDialog::Execute();
		if ( nRet == RET_OK )
		{
			pExampleSet->Put(*GetOutputItemSet());
			m_pImpl->saveChanges(*pExampleSet);
		}
		return nRet;
	}
	//-------------------------------------------------------------------------
	void OAdvancedTabPageDlg::PageCreated(USHORT _nId, SfxTabPage& _rPage)
	{
		// register ourself as modified listener
		static_cast<OGenericAdministrationPage&>(_rPage).SetServiceFactory(m_pImpl->getORB());
		static_cast<OGenericAdministrationPage&>(_rPage).SetAdminDialog(this,this);

		AdjustLayout();
		Window *pWin = GetViewWindow();
		if(pWin)
			pWin->Invalidate();

		SfxTabDialog::PageCreated(_nId, _rPage);
	}
	// -----------------------------------------------------------------------------
	const SfxItemSet* OAdvancedTabPageDlg::getOutputSet() const
	{
		return pExampleSet;
	}
	// -----------------------------------------------------------------------------
	SfxItemSet* OAdvancedTabPageDlg::getWriteOutputSet()
	{
		return pExampleSet;
	}
	// -----------------------------------------------------------------------------
	::std::pair< Reference<XConnection>,sal_Bool> OAdvancedTabPageDlg::createConnection()
	{
		return m_pImpl->createConnection();
	}
	// -----------------------------------------------------------------------------
	Reference< XMultiServiceFactory > OAdvancedTabPageDlg::getORB()
	{
		return m_pImpl->getORB();
	}
	// -----------------------------------------------------------------------------
	Reference< XDriver > OAdvancedTabPageDlg::getDriver()
	{
		return m_pImpl->getDriver();
	}
	// -----------------------------------------------------------------------------
	DATASOURCE_TYPE	OAdvancedTabPageDlg::getDatasourceType(const SfxItemSet& _rSet) const
	{
		return m_pImpl->getDatasourceType(_rSet);
	}
	// -----------------------------------------------------------------------------
	void OAdvancedTabPageDlg::clearPassword()
	{
		m_pImpl->clearPassword();
	}
	// -----------------------------------------------------------------------------
	void OAdvancedTabPageDlg::setTitle(const ::rtl::OUString& _sTitle)
	{
		SetText(_sTitle);
	}
	//-------------------------------------------------------------------------
	sal_Bool OAdvancedTabPageDlg::saveDatasource()
	{
		return PrepareLeaveCurrentPage();
	}
//.........................................................................
}	// namespace dbaui
//.........................................................................
