/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ifcc_ce.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:04:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_STORE_IFCC_CE_HXX
#define ARY_STORE_IFCC_CE_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>
#include <ary/cpp/c_etypes.hxx>
#include "../nametree.hxx"

template <class XY> class Manipulator;


namespace ary
{
    namespace cpp
    {
     	class Namespace;
		class Class;
		class Enum;
		class Typedef;
		class Function;
		class Variable;
        class EnumValue;
	}

	class CodeEntity;
    class InstanceList;

namespace store
{
	class Cpp;

namespace cpp
{


class CodeEntity_Ifc
{
  public:
	// LIFECYCLE
						CodeEntity_Ifc(
							ary::store::Cpp &	io_rStorageCpp );
	void				Init_GlobalNamespace(
							DYN ary::cpp::Namespace &
												let_drNamespace );
						~CodeEntity_Ifc();
	// OPERATIONS
	void                Add_Namespace(
							DYN ary::cpp::Namespace &
												let_drNamespace );
	void                Add_Class(
                            DYN ary::cpp::Class &
                                                let_drClass );
    void                Add_Enum(
                            DYN ary::cpp::Enum &
                                                let_drEnum );
    void                Add_Typedef(
                            DYN ary::cpp::Typedef &
                                                let_drTypedef );
    void                Add_Operation(
                            DYN ary::cpp::Function &
                                                let_drFunction );
    void                Add_Variable(
                            DYN ary::cpp::Variable &
												let_drVariable );
    void                Add_EnumValue(
                            DYN ary::cpp::EnumValue &
                                                let_drEnumValue );
    uintt               ForEachClass(
                            const Manipulator< ary::CodeEntity > &
                                                i_rManip );

	// INQUIRY
	const ary::cpp::Namespace &
						GlobalNamespace() const;
	const CodeEntity *  Find_Ce(
							Cid					i_nId ) const;
    const InstanceList &
                        Search_TypeName(
                            const udmstri &     i_sName ) const;
    const InstanceList &
                        Search_OperationName(
                            const udmstri &     i_sName ) const;
    const InstanceList &
                        Search_DataName(
                            const udmstri &     i_sName ) const;

	const ary::cpp::Namespace *
                        Find_Namespace(
                            Cid                 i_nId ) const;
	const ary::cpp::Class *
                        Find_Class(
                            Cid                 i_nId ) const;
    const ary::cpp::Enum *
                        Find_Enum(
                            Cid                 i_nId ) const;
    const ary::cpp::Typedef *
                        Find_Typedef(
                            Cid                 i_nId ) const;
    const ary::cpp::Function *
                        Find_Operation(
                            Cid                 i_nId ) const;
    const ary::cpp::Variable *
                        Find_Variable(
                            Cid                 i_nId ) const;
    const ary::cpp::EnumValue *
                        Find_EnumValue(
                            Cid                 i_nId ) const;

    ary::NameTree::const_iterator
                        LowerBound_Type(
                            const char *        i_sSearch ) const;
    ary::NameTree::const_iterator
                        LowerBound_Operation(
                            const char *        i_sSearch ) const;
    ary::NameTree::const_iterator
                        LowerBound_Data(
                            const char *        i_sSearch ) const;

		// ACCESS
	ary::cpp::Namespace &
                        GlobalNamespace();
	ary::cpp::Class *   Find_Class(
							Cid					i_nId );
  private:
	struct CheshireCat;

	// DATA
	Dyn<CheshireCat> 	pi;
};



// IMPLEMENTATION



}   // namespace cpp
}   // namespace store
}   // namespace ary



#endif

