/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_accitem.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:56:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _TOOLS_TIME_HXX //autogen
// auto strip #include <tools/time.hxx>
// auto strip #endif
// auto strip #ifndef _SV_ACCEL_HXX //autogen
// auto strip #include <vcl/accel.hxx>
// auto strip #endif
// auto strip #ifndef _SV_TIMER_HXX //autogen
// auto strip #include <vcl/timer.hxx>
// auto strip #endif
#pragma hdrstop

#include "app.hxx"
#include "accitem.hxx"
#include "sfxtypes.hxx"
// auto strip #include "msg.hxx"
#include "msgpool.hxx"
namespace binfilter {

//--------------------------------------------------------------------

SfxAcceleratorItem::SfxAcceleratorItem()
{
}

//--------------------------------------------------------------------


void SfxAcceleratorItem::Bind
(
	USHORT nId,
	Accelerator& rAccel,
	USHORT nAccId,
	SfxBindings &rBindings
)
{
	DBG( CheckConfigure_Impl(SFX_SLOT_ACCELCONFIG) );

	SfxControllerItem::Bind(nId, &rBindings);
	nAccelId = nAccId;
	pAccel = &rAccel;

#ifdef DBG_UTIL
	const SfxSlot *pSlot = SFX_SLOTPOOL().GetSlot( nId );
	if ( pSlot && !pSlot->IsMode( SFX_SLOT_ACCELCONFIG ) )
	{
		ByteString aStr( "Slot " );
		aStr += ByteString( nId );
		aStr += ByteString( " : AccelConfig fehlt!" );
		DBG_ERROR( aStr.GetBuffer() );
	}
#endif
}

//--------------------------------------------------------------------

void SfxAcceleratorItem::StateChanged
(
	USHORT 				nSID,
	SfxItemState 		eState,
	const SfxPoolItem* 	pState
)
{
	pAccel->EnableItem( nAccelId, eState != SFX_ITEM_DISABLED );
}


}
