/**
 * Title:        <p>
 * Description:  <p>
 * Copyright:    Copyright (c) <p>
 * Company:      <p>
 * @author
 * @version 1.0
 */


package com.sun.star.help;

import java.util.*;
import java.io.*;
import java.net.*;

// External packages
import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.parsers.*;
import com.jclark.xsl.sax.*;
import com.sleepycat.db.*;
import com.sun.xmlsearch.util.*;
import com.sun.xmlsearch.xml.qe.*;

import com.sun.star.frame.*;
import com.sun.star.container.*;
import com.sun.star.beans.*;
import com.sun.star.comp.loader.*;
import com.sun.star.registry.*;
import com.sun.star.lang.*;
import com.sun.star.io.*;
import com.sun.star.uno.*;
import com.sun.star.ucb.*;


public class HelpProvider implements XContentProvider,XContentIdentifierFactory,XInitialization
{
	static
	{
    	String urlmode = HelpDatabases.getURLMode();
      	HelpURLStreamHandlerFactory urlHandler = new HelpURLStreamHandlerFactory( urlmode );
		URL.setURLStreamHandlerFactory( urlHandler );
	}



	// Genereal service factory
	private XMultiServiceFactory     m_xFactory = null;

 	// For the XML-XSL stuff
	private XSLProcessor             m_xXslProcessor = null;
	private OutputMethodHandlerImpl  m_xOutputMethodHandler = null;

 	// a hash table for the query stuff
	private Hashtable                _queryProc = new Hashtable();

 	// User specific data
	boolean                          isInitialized = false;
 	private XMultiServiceFactory     m_xConfiguration = null;  // Must be hold, since the user

	// Defaultvalues must be sensible
	private String 	LanguageVar = "en",
		DeviceVar = null,
		ProgramVar = null,
		SystemVar = null;


	public XMultiServiceFactory getXMultiServiceFactory()
	{
		return m_xFactory;
	}
	
	
	public HelpProvider( XMultiServiceFactory xFactory )
	{
		m_xFactory = xFactory;
	}
	

	public final XContent queryContent( XContentIdentifier p0 ) throws IllegalIdentifierException,com.sun.star.uno.RuntimeException
	{
		try
		{
			if( ! isInitialized )
				initialize( null );
		}
		catch( com.sun.star.uno.Exception e )
		{
			throw new com.sun.star.uno.RuntimeException();
		}

		HelpContent theContent = null;
		HelpContentIdentifier aIdent = null;
		if( ! ( p0 instanceof HelpContentIdentifier ) )
		{
			// May throw IllegalIdentifierException if protocol != "vnd.sun.star.help"
			aIdent = new HelpContentIdentifier( p0.getContentIdentifier(),LanguageVar );
		}
		else
			aIdent = ( HelpContentIdentifier ) p0;

		theContent = new HelpContent( this,aIdent );
		return theContent;
	}



	public int compareContentIds(XContentIdentifier p0, XContentIdentifier p1) throws com.sun.star.uno.RuntimeException
	{
 		try
   		{
			if( ! isInitialized )
       			initialize( null );
    	}
     	catch( com.sun.star.uno.Exception e )
      	{
       		throw new com.sun.star.uno.RuntimeException();
       	}

 		try
   		{
 			HelpContentIdentifier ident0;
 			if( !( p0 instanceof HelpContentIdentifier ) )
   				ident0 = new HelpContentIdentifier( p0.getContentIdentifier(),LanguageVar );
      		else
       			ident0 = ( HelpContentIdentifier ) p0;

        	HelpContentIdentifier ident1;
        	if( !(  p1 instanceof HelpContentIdentifier ) )
        		ident1 = new HelpContentIdentifier( p1.getContentIdentifier(),LanguageVar );
        	else
        		ident1 = ( HelpContentIdentifier ) p1;

			return ident0.isEqualTo( ident1 );
   		}
        catch( com.sun.star.uno.Exception e	)
        {
        	return 0;
        }
     	catch( java.lang.Exception e )
      	{
       		return 0;
       	}
    }



	public XContentIdentifier createContentIdentifier(String p0) throws com.sun.star.uno.RuntimeException
	{
 		try
   		{
			if( ! isInitialized )
			    initialize( null );
    	}
     	catch( com.sun.star.uno.Exception e )
      	{
       		throw new com.sun.star.uno.RuntimeException();
       	}

		HelpContentIdentifier aIdent = null;
		try
		{
			aIdent = new HelpContentIdentifier( p0,LanguageVar );
		}
		catch( IllegalIdentifierException e )  // Throws if protocol != "vnd.sun.star.help"
		{
			throw new com.sun.star.uno.RuntimeException();
		}

		return aIdent;
	}



	public void initialize( Object[] p0 ) throws com.sun.star.uno.Exception,
		com.sun.star.uno.RuntimeException
	{
 		/**
    	 *  The given object must be the configuration provider for the given user
         *  or null, this second meaning that the configuration can be instantiated
         *  by normal uno-service-instantiation ( relevant for FAT-Office )
    	 */

 		if( isInitialized )
			return;

   		// Now a first try to access the configuration:

		String serviceName = "com.sun.star.configuration.ConfigurationProvider";
  		XMultiServiceFactory xConfiguration = null;

  		if( p0 != null )
    	{
			/*
			  // This is for portal only
			  String password = ( String ) p0[0];

			  Object[] arg = new Object[2];
			  arg[0]=new PropertyValue("user",-1,"nobody",PropertyState.DIRECT_VALUE);
			  arg[1]=new PropertyValue("password",-1,password,PropertyState.DIRECT_VALUE);

			  xConfiguration =
			  ( XMultiServiceFactory ) UnoRuntime.queryInterface( XMultiServiceFactory.class,
			  m_xFactory.createInstanceWithArguments( serviceName,arg ) );

			  isPortal = true;
			*/
  		}
		else
  		{
			// Instantiate the Configuration by service-request

			Object[] arg = new Object[1];

			arg[0] = new PropertyValue("servertype",-1,"plugin",PropertyState.DIRECT_VALUE );
			
			xConfiguration =
				( XMultiServiceFactory ) UnoRuntime.queryInterface( XMultiServiceFactory.class,
																	m_xFactory.createInstanceWithArguments( serviceName,arg ) );

			// Read the configuration ( only the install url )

			String readerAccess = "com.sun.star.configuration.ConfigurationAccess";
			arg[0] = "org.openoffice.Office.Common";

			XHierarchicalNameAccess nameAccess =
				( XHierarchicalNameAccess ) UnoRuntime.queryInterface( XHierarchicalNameAccess.class,
																	   xConfiguration.createInstanceWithArguments(readerAccess,arg));

			XNameAccess mainNode = ( XNameAccess ) UnoRuntime.queryInterface( XNameAccess.class,nameAccess );

			XNameAccess subNode = ( XNameAccess ) UnoRuntime.queryInterface( XNameAccess.class,
																			 mainNode.getByName( "Path" ) );
			subNode = ( XNameAccess ) UnoRuntime.queryInterface( XNameAccess.class,
																 subNode.getByName( "Current" ) );

			String insturl = ( String ) subNode.getByName( "Help" );

			String special = "com.sun.star.config.SpecialConfigManager";
			XConfigManager configmgr = ( XConfigManager ) UnoRuntime.queryInterface( XConfigManager.class,
																					 m_xFactory.createInstance( special ));
			insturl = configmgr.substituteVariables( insturl );
			insturl = insturl + "/";

			System.setProperty( "com.sun.star.help.Directory",insturl );
			HelpDatabases.setInstallPath( insturl );

			subNode = ( XNameAccess ) UnoRuntime.queryInterface( XNameAccess.class,
																 mainNode.getByName( "Help" ) );
			LanguageVar = ( String ) subNode.getByName( "Locale" );


			subNode = ( XNameAccess ) UnoRuntime.queryInterface( XNameAccess.class,
																 mainNode.getByName( "Help" ) );
			SystemVar = ( String ) subNode.getByName( "System" );
		}


        // Initialization done
        // if( ( m_xConfiguration = xConfiguration ) == null )
		// throw new com.sun.star.uno.RuntimeException();

  		initializeXMLXSL();
		isInitialized = true;
	}


 	private void initializeXMLXSL()
  	{
 		// Configuring SAXParser;
		m_xXslProcessor = new XSLProcessorImpl();
  		SAXParserFactory spf = SAXParserFactory.newInstance();
		spf.setValidating( false );
        Parser parser = null;

        try
		{
        	SAXParser sp = spf.newSAXParser();
            parser = sp.getParser();
        }
        catch( java.lang.Exception e )
        {
         	System.out.println( "<!-- NO HELP AVAILABLE: no parser found -->" );
         	System.exit( 1 );
        }

		// Configuring XMLProcessor
		m_xXslProcessor.setParser( parser );
		m_xOutputMethodHandler = new OutputMethodHandlerImpl( m_xXslProcessor );
		m_xXslProcessor.setOutputMethodHandler( m_xOutputMethodHandler );

		try
		{
			m_xXslProcessor.loadStylesheet( (new XSLData()).getInputSource() );
		}
		catch( SAXException e )
		{
			System.out.println( "<!-- NO HELP AVAILABLE: syntactic error in style-sheet -->" );
			System.out.println( e.getMessage() );
		}
		catch( java.io.IOException e )
		{
			System.out.println( "<!-- NO HELP AVAILABLE: style-sheet not found -->" );
		}
		catch( java.lang.Exception e )
		{
			System.out.println( e.getMessage() );
		}
   	}   // end initializeXMLXSL



    protected static final class ProviderDestination extends GenericDestination {

  		private OutputStream outputStream;
		private String _enc;

    	public ProviderDestination( OutputStream outputStream,String enc )
     	{
      		this( outputStream );
      		_enc = enc;
      	}

		public ProviderDestination( OutputStream outputStream )
  		{
			this.outputStream = outputStream;
   			_enc = null;
		}

		public OutputStream getOutputStream(String contentType, String encoding) throws java.io.IOException
  		{
			// System.out.println( "encoding: " + encoding );
			setEncoding( encoding );
			// System.out.println( "encoding: " + getEncoding() );
			return outputStream;
		}

		protected void setEncoding( String encoding )
  		{
			if( _enc != null )
				super.setEncoding( _enc );
			else
				super.setEncoding( "ISO-8859-1" );
    	}
	}



	// Get the desired content
	protected void writeHtmlStream( HelpURLParameter xParameter,HelpOutputStream xOutput )
	{
 		if( ! xParameter.isFile() )
   			return;

		// Possibly overwritting the default values
		m_xXslProcessor.setParameter( "Program",xParameter.get_program() );
		m_xXslProcessor.setParameter( "Database",xParameter.get_module() );
		m_xXslProcessor.setParameter( "Id",xParameter.get_id() );
		m_xXslProcessor.setParameter( "Path",xParameter.get_path() );
		m_xXslProcessor.setParameter( "Language",xParameter.get_language() );

		String sysVal = xParameter.get_system();
		if( !sysVal.equals("") )
			m_xXslProcessor.setParameter( "System",sysVal );

		// Not real parameters
		String devVal = xParameter.get_device();
		if( ! devVal.equals("") )
			m_xXslProcessor.setParameter( "Device",devVal );

  		String helpPrefix = xParameter.get_prefix();
     	if( ! helpPrefix.equals( "" ) )
		{
			try
			{
				helpPrefix = URLDecoder.decode( helpPrefix );

				m_xXslProcessor.setParameter( "hp",helpPrefix );
				m_xXslProcessor.setParameter( "sm","vnd.sun.star.help%3A%2F%2F" );
				m_xXslProcessor.setParameter( "qm","%3F" );
				m_xXslProcessor.setParameter( "es","%3D" );
				m_xXslProcessor.setParameter( "am","%26" );
				m_xXslProcessor.setParameter( "cl","%3A" );
				m_xXslProcessor.setParameter( "sl","%2F" );
				m_xXslProcessor.setParameter( "hm","%23" );
			}
			catch( java.lang.Exception e )
			{
				System.out.println( "------  cannot decode helpprefix -----------" );
				System.out.println( e.getMessage() );
			}
		}

   		String url = "vnd.sun.star.help://"
			+ xParameter.get_module()
			+ "/"
			+ xParameter.get_id()
			+ "?Language="
			+ xParameter.get_language();

		InputSource theInputSource;

		if( xParameter.get_eid().equals( "" ) )
			theInputSource = new InputSource( url );
		else
			theInputSource = new InputSource( HelpDatabases.popupDocument( xParameter ) );

  		theInputSource.setEncoding( "UTF-8" );
		try
		{
  			ProviderDestination dest = new ProviderDestination( xOutput );
  			synchronized( this )
     		{
				m_xOutputMethodHandler.setDestination( dest );
				m_xXslProcessor.parse( theInputSource );
    		}
		}
		catch( java.io.IOException e )
		{
			System.out.println( "xml file not found " );
		}
		catch( SAXException e )
		{
			System.out.println( "ill formed xml document: " + e.getMessage() );
		}
  		catch( java.lang.Exception e )
    	{
     		System.out.println( e.getMessage() );
     	}
	}



 	// Performs the query
	protected QueryResults queryResultSet( HelpURLParameter xParameter )
  	{
   		QueryResults queryResults = null;

   		if( ! xParameter.isQuery() ) return null;

     	// get the QueryProcessor for the current module
     	String keyQuery = HelpDatabases.lang(xParameter.get_language()) + "/" + xParameter.get_module();
		QueryProcessor xProcessor = ( QueryProcessor ) _queryProc.get( keyQuery );

  		if( xProcessor == null )
    	{
     		// Configure a new QueryProcessor
			String installDir = HelpDatabases.getInstallDirectory();

            String configArg =
 				"<?xml version=\"1.0\"?>"                                             +
				"<XmlSearchEngine name=\"Star Help\" category=\"software/StarHelp\""  +
				" indexLocation=\""  + installDir + keyQuery   +  ".idx\""          +
     			" 	documentType=\"STARHELP\""                                        +
       			" 	defaultSearchUnit=\"office:body\">"                               +
				"</XmlSearchEngine>";
			
            try
            {
			    Element config = Configuration.parse( configArg.getBytes() );
  			    QueryProcessorImpl queryProcessor = new QueryProcessorImpl();
			    queryProcessor.init( config );
  			    xProcessor = queryProcessor;
         		_queryProc.put( keyQuery,xProcessor );
    	    }
     	    catch( java.lang.Exception e )
      	    {
          	    System.out.println( "<!-- NO HELP AVAILABLE: search engine not found -->" );
       	    }
     	}

	    String Query = xParameter.get_query();      if( Query == null ) return queryResults;
		String Scope = xParameter.get_scope();
		if( "FullText".equals( Scope ) )
		{
			HelpDatabases.StaticModuleInformation inf = 
				HelpDatabases.getStaticInformationForModule( xParameter.get_module(),
															 xParameter.get_language() );
			Scope = inf.get_fulltext();
		}
		else if( "Heading".equals( Scope ) )
		{
			HelpDatabases.StaticModuleInformation inf = 
				HelpDatabases.getStaticInformationForModule( xParameter.get_module(),
															 xParameter.get_language() );
			Scope = inf.get_heading();
		}
		else
		{
			// Scope = null;
		}
		int HitCount = xParameter.get_hitCount();

		try
    	{
  			QueryStatement queryStatement = new QueryStatement( Query,Scope,HitCount );
			synchronized( this )
   			{
    			queryResults = xProcessor.processQuery( queryStatement );
       		}
   		}
      	catch( java.lang.Exception e )
       	{
        	e.printStackTrace();
		}

		return queryResults;
   	}


	// Methods and variables for registering this service

	public static final String serviceName = "com.sun.star.help.XMLHelp";

	public static XSingleServiceFactory getServiceFactory( String implName,
														   XMultiServiceFactory multiFactory,
														   XRegistryKey regKey)
	{
		XSingleServiceFactory xSingleServiceFactory = null;

		if ( implName.equals( HelpProvider.class.getName()) )
			xSingleServiceFactory = FactoryHelper.getServiceFactory(HelpProvider.class,
																	multiFactory,
																	regKey);
		return xSingleServiceFactory;
	}


	public static boolean writeRegistryServiceInfo(XRegistryKey regKey)
	{
		return FactoryHelper.writeRegistryServiceInfo( HelpProvider.class.getName(),serviceName,regKey);
	}
}
