/*************************************************************************
 *
 *  $RCSfile: flypos.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:12:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include "doc.hxx"
#include "node.hxx"
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif


#ifndef _FMTANCHR_HXX //autogen
#include <fmtanchr.hxx>
#endif
#include "flypos.hxx"
#include "frmfmt.hxx"
#include "dcontact.hxx"
#include "dview.hxx"
#include "flyfrm.hxx"
#include "dflyobj.hxx"
#include "ndindex.hxx"



SV_IMPL_OP_PTRARR_SORT( SwPosFlyFrms, SwPosFlyFrmPtr )

SwPosFlyFrm::SwPosFlyFrm( const SwNodeIndex& rIdx, const SwFrmFmt* pFmt,
							USHORT nArrPos )
	: pNdIdx( (SwNodeIndex*) &rIdx ), pFrmFmt( pFmt )
{
	BOOL bFnd = FALSE;
	const SwFmtAnchor& rAnchor = pFmt->GetAnchor();
	if( FLY_PAGE == rAnchor.GetAnchorId() )
		pNdIdx = new SwNodeIndex( rIdx );
	else if( pFmt->GetDoc()->GetRootFrm() )
	{
		SwClientIter aIter( (SwFmt&)*pFmt );
		if( RES_FLYFRMFMT == pFmt->Which() )
		{
			// Schauen, ob es ein SdrObject dafuer gibt
			if( aIter.First( TYPE( SwFlyFrm) ) )
				nOrdNum = ((SwFlyFrm*)aIter())->GetVirtDrawObj()->GetOrdNum(),
				bFnd = TRUE;
		}
		else if( RES_DRAWFRMFMT == pFmt->Which() )
		{
			// Schauen, ob es ein SdrObject dafuer gibt
			if( aIter.First( TYPE(SwDrawContact) ) )
				nOrdNum = ((SwDrawContact*)aIter())->GetMaster()->GetOrdNum(),
				bFnd = TRUE;
		}
	}

	if( !bFnd )
	{
		nOrdNum = pFmt->GetDoc()->GetSpzFrmFmts()->Count();
		nOrdNum += nArrPos;
	}
}

SwPosFlyFrm::~SwPosFlyFrm()
{
	const SwFmtAnchor& rAnchor = pFrmFmt->GetAnchor();
	if( FLY_PAGE == rAnchor.GetAnchorId() )
		delete pNdIdx;
}

BOOL SwPosFlyFrm::operator==( const SwPosFlyFrm& rPosFly )
{
	return FALSE;	// FlyFrames koennen auf der gleichen Position stehen
}

BOOL SwPosFlyFrm::operator<( const SwPosFlyFrm& rPosFly )
{
	if( pNdIdx->GetIndex() == rPosFly.pNdIdx->GetIndex() )
	{
		// dann entscheidet die Ordnungsnummer!
		return nOrdNum < rPosFly.nOrdNum;
	}
	return pNdIdx->GetIndex() < rPosFly.pNdIdx->GetIndex();
}



