
package org.netbeans.modules.openoffice.wizard.nodes;


import org.netbeans.modules.openoffice.wizard.panels.idl.*;
import org.netbeans.modules.openoffice.wizard.keys.AliasKey;
import org.netbeans.modules.openoffice.wizard.keys.NameKey;

import org.openide.nodes.AbstractNode;
import org.openide.util.actions.SystemAction;
import java.util.Vector;
import org.openide.nodes.Node;



public class ValueBoxNode extends LeafNode
{

    public ValueBoxNode(AliasKey aliaskey)
    {
        super(aliaskey);
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/value");
    }

    public String getName()
    {
        return getDisplayName();
    }

    public String getDisplayName()
    {
        return key.getName();
    }

    public String generateSelf(int i)
    {
        String s = "";
        for(int j = 0; j < i; j++)
            s = s + "    ";

        s = s + "valuetype " + getName() + " " + ((AliasKey)key).getType() + ";\n";
        return s;
    }

     public SystemAction[] createActions()
    {
            return (new SystemAction[]{});
    }

    public BasePanel getEditPanel()
    {
        ValueBoxPanel valueboxpanel = new ValueBoxPanel();
        valueboxpanel.setName(getName());
        valueboxpanel.setType(((AliasKey)key).getType());
        return valueboxpanel;
    }

    public void reInit(BasePanel expanel)
    {
        if(expanel instanceof ValueBoxPanel)
        {
            ValueBoxPanel valueboxpanel = (ValueBoxPanel)expanel;
            String s = valueboxpanel.getName();
            String s1 = valueboxpanel.getType();
            if(!s.equals(getName()))
            {
                setName(s);
                key.setName(s);
            }
            if(!s1.equals(((AliasKey)key).getType()))
                ((AliasKey)key).setType(s1);
        }
    }

    public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
    
    public static final String ICON_BASE = "org/netbeans/modules/openoffice/idl/node/value";
}
