/*************************************************************************
 *
 *  $RCSfile: crog_grp.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_CPP_CROG_GRP_HXX
#define ARY_CPP_CROG_GRP_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>


namespace ary
{
    class AryGroup;
    class TopProject;

namespace cpp
{
    class ProjectGroup;
    class FileGroup;


class RoGate_Groups
{
  public:
    // LIFECYCLE
    virtual             ~RoGate_Groups() {}

	// INQUIRY
    const TopProject &  Get_TopProject() const;

    const ary::AryGroup *
                        Find_Group(
                            Gid                 i_nId ) const;
    const ProjectGroup *
                        Find_ProjectGroup(
                            Gid                 i_nId ) const;
    const ProjectGroup *
                        Search_ProjectGroup(
                            const udmstri &     i_sProjectName ) const;
    const FileGroup *   Search_FileGroup(        
                            Lid                 i_nAssociatedFileId ) const;
  private:
    virtual const TopProject &
                        inq_Get_TopProject() const = 0;
    virtual const ary::AryGroup *
                        inq_Find_Group(
                            Gid                 i_nId ) const = 0;
    virtual const ProjectGroup *
                        inq_Find_ProjectGroup(
                            Gid                 i_nId ) const = 0;
    virtual const ProjectGroup *
                        inq_Search_ProjectGroup(
                            const udmstri &     i_sProjectName ) const = 0;
    virtual const FileGroup *
                        inq_Search_FileGroup(
                            Lid                 i_nAssociatedFileId ) const = 0;
};

inline const TopProject &
RoGate_Groups::Get_TopProject() const
    { return inq_Get_TopProject(); }
inline const AryGroup *
RoGate_Groups::Find_Group( Gid i_nId ) const
    { return inq_Find_Group(i_nId); }
inline const ProjectGroup *
RoGate_Groups::Find_ProjectGroup( Gid i_nId ) const
    { return inq_Find_ProjectGroup(i_nId); }
inline const ProjectGroup *
RoGate_Groups::Search_ProjectGroup( const udmstri & i_sProjectName ) const
    { return inq_Search_ProjectGroup(i_sProjectName); }
inline const FileGroup *
RoGate_Groups::Search_FileGroup( Lid i_nAssociatedFileId ) const
    { return inq_Search_FileGroup(i_nAssociatedFileId); }


}   // namespace cpp
}   // namespace ary



#endif

