'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_xml_save_ms_ole.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: pj $ $Date: 2006/02/10 12:19:58 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Conversion of Microsoft OLE objects in dependency of settings in Tools::Options::Load/Save::MS_Office
'*
'************************************************************************
'*
' #1 ms_ole        ' Initial routine
' #1 tXML_OLE_Conversion
' #1 subSetConversionMicrosoftOLE
'*
'\************************************************************************

sub ms_ole

  printLog Chr(13) + "---------  MS_OLE   ----------"
  'Ensure that paths are stored relativ
  ToolsOptions
  hToolsOptions ( "LoadSave", "General" )
  Kontext "TabSpeichern"
  URLimDateisystem.Check
  Kontext "ExtrasOptionenDlg"
  ExtrasOptionenDlg.OK
  
  Call tXML_OLE_Conversion ( "excelOLE.doc" )
  Call tXML_OLE_Conversion ( "excelOLE.ppt" )
  Call tXML_OLE_Conversion ( "mathOLE.doc" )
  Call tXML_OLE_Conversion ( "mathOLE.ppt" )
  Call tXML_OLE_Conversion ( "mathOLE.xls" )
  Call tXML_OLE_Conversion ( "pptOLE.doc" )
  Call tXML_OLE_Conversion ( "pptOLE.xls" )
  Call tXML_OLE_Conversion ( "wordOLE.ppt" )
  Call tXML_OLE_Conversion ( "wordOLE.xls" )
  'Reset Tools::Options::Load/Save::MS Office to default values
  call subSetConversionMicrosoftOLE ( "RESET" )

end sub

'*******************************************************************

testcase tXML_OLE_Conversion ( sCurrentTestDocument as STRING )
'///<u><b>Test the conversion of MS OLE objects while loading MS documents</b><br>///
'///(All OLE types in each application except OLE and application of same type)</u>///

dim iIndex as INTEGER

dim sInputFile as STRING
    sInputFile = convertpath ( gTesttoolpath & "xml/level1/input/framework/ms_ole/" & sCurrentTestDocument )
    
dim sSplitCurrentTestDocument() as STRING
    sSplitCurrentTestDocument() = split ( sCurrentTestDocument , "." )
dim sCurrentFileName as STRING
    sCurrentFileName = sSplitCurrentTestDocument ( 0 )
dim sCurrentExtension as STRING
    sCurrentExtension = sSplitCurrentTestDocument ( 1 )
    
dim sCurrentOLE as STRING
    sCurrentOLE = left ( sCurrentTestDocument , 3 )

dim sExtNames( 5 ) AS String
dim sCurrentExtensionOasis as STRING
    select case sCurrentExtension
           case ( "doc" ) : sExtNames() = hGetFilternameExtension ( "writer8" )
           case ( "xls" ) : sExtNames() = hGetFilternameExtension ( "calc8" )
           case ( "ppt" ) : sExtNames() = hGetFilternameExtension ( "impress8" )
    end select
    sCurrentExtensionOasis = " (." & sExtNames(0) & ")"
dim sCurrentFilter as STRING
    select case sCurrentExtension
           case ( "doc" ) : sCurrentFilter = hGetUIFiltername ( "writer8"  ) & sCurrentExtensionOasis
           case ( "xls" ) : sCurrentFilter = hGetUIFiltername (  "calc8"   ) & sCurrentExtensionOasis
           case ( "ppt" ) : sCurrentFilter = hGetUIFiltername ( "impress8" ) & sCurrentExtensionOasis
    end select
   
dim sConversionSettings as STRING
   
dim sStorageName as STRING
    sStorageName = ( gOfficePath & ConvertPath("user\work\xml_") & sCurrentFileName )
dim sOutputFile as STRING
dim sUnpackedStorageDir as STRING
dim sContentXML as STRING
dim sContentXMLObject as STRING
dim bContentXMLObjectExists as BOOLEAN
dim sRelativePathToObject as STRING
    
'///<ul><li>Test MS OLE conversion for current document in  four different cases</li>///
    '///<li>(Settings in Tools::Options::Load/Save::MS Office)</li>///
    for iIndex = 1 to 4
        '///<li>Set desired conversion options in Tools::Options::Load/Save::MS Office</li>///
        select case iIndex
               case 1 : sConversionSettings = "RESET"
               case 2 : sConversionSettings = "SAVE"  
               case 3 : sConversionSettings = "LOAD"
               case 4 : sConversionSettings = "ALL"
        end select
        call subSetConversionMicrosoftOLE (  sConversionSettings  )
        sleep(2)
        sOutputFile = sStorageName & "_" & sConversionSettings & "." & sExtNames(0)
        sUnpackedStorageDir = sOutputFile & "_unpacked" 
        'Erase storage dirctory if exists
        if (dir ( sUnpackedStorageDir ) <> "" ) then
            kill ( sUnpackedStorageDir )
        endif
        sContentXML = sUnpackedStorageDir & ConvertPath( "\content.xml" )
        
        '///<li>Open test document (MS format)</li>///
        call hDateiOeffnen ( sInputFile )
        printlog Chr(13) & "Loading: " & sInputFile
        sleep(2)
        '///<li>Save document in OpenDocument format</li>///
        if hSpeichernUnterMitFilterKill ( sOutputFile , sCurrentFilter ) then
            printlog "+ OK, successfully saved the test document!"
        else
            warnlog "+ Saving the testdocument failed!"
        endif
        sleep(2)
        '///<li>Close document</li>///
        call hCloseDocument
        '///<li>Reload document</li>///
        sleep(2)
        
        '///<li>Unpack storage to obtain the XML files</li>///
        printlog Chr(13) & "Unpacking storage of test document"
        try 
            UnpackStorage( sOutputFile , sUnpackedStorageDir )
        catch
            qaErrorLog "#i52632# - Unpacking XML storage failed -> we quit this iteration"
            goto skipThisIteration 'Quit only current Iteration (not testcase) on error
        endcatch
        printlog Chr(13) & "Read the test documents DOM."
        '///<li>Read DOM of content.xml</li>///
        SAXReadFile( sContentXML )
        sleep(2)
        '///<li>Set the DOM pointer on element 'office:body'</li>///
        printlog Chr(13) & "Set the DOM pointer on element 'office:body'"
        SAXSeekElement( "/" )
        SAXSeekElement( "office:document-content" )
        SAXSeekElement( "office:body" )
        '///<li>Seek XML element 'draw:object-ole' or'draw:object' in dependency of settings in Tools::Options::Load/Save::MS Office</li>///
        printlog Chr(13) & "Use recursion to find XML element 'draw:object-ole' or'draw:object'"
        select case sConversionSettings
               case "RESET" , "SAVE"
                    if hXMLSeekElementInTree ( "draw:object-ole" ) then
                        printlog "+ Desired node 'draw:object-ole' found"
                    else
                        warnlog "+ Not finding the node 'draw:object-ole' is unexpected -> Check this out!"
                        SAXRelease
                        goto skipThisIteration 'Quit only current Iteration (not testcase) on error
                    endif
               case "LOAD" , "ALL"
                    if hXMLSeekElementInTree ( "draw:object" ) then
                        printlog "+ Desired node 'draw:object' found"
                    else
                        warnlog "+ Not finding the node 'draw:object' is unexpected -> Check this out!"
                        SAXRelease
                        goto skipThisIteration 'Quit only current Iteration (not testcase) on error
                    endif
        end select
        '///<li>Determine Path to objects 'content.xml'</li>///
        sRelativePathToObject = SAXGetAttributeValue( "xlink:href" )
        sRelativePathToObject = Right ( sRelativePathToObject , Len ( sRelativePathToObject ) - 1 )
        sContentXMLObject = sUnpackedStorageDir & ConvertPath ( sRelativePathToObject & "\content.xml" )
        printlog Chr(13) & "Check existence of objects 'content.xml' in dependency of settings in Tools::Options::Load/Save::MS_Office"
        '///<li>Lookup if objects 'content.xml' exists - TRUE for OASIS OLE, FALSE for MS OLE</li>///
        if (dir ( sContentXMLObject ) <> "" ) then
            bContentXMLObjectExists = TRUE
        else
            bContentXMLObjectExists = FALSE
        endif
        '///<li>Verify result against expectations for existence of objects 'content.xml'</li>///
        select case sConversionSettings
               case "RESET" , "SAVE"
                    if bContentXMLObjectExists then
                        warnlog "+ OOPS, 'content.xml' shouldn't exist in MS OLE directory -> Check this out!" 
                    else
                        printlog "+ OK, no 'content.xml' found in MS OLE directory"
                    endif
               case "LOAD" , "ALL"
                    if bContentXMLObjectExists then
                        printlog "+ OK, 'content.xml' found in OASIS OLE directory"
                    else
                        warnlog "+ OOPS, 'content.xml' must exist in OASIS OLE directory -> Check this out!"
                    endif
        end select
        '///<li>Release documents DOM</li>///
        SAXRelease
        if bContentXMLObjectExists then
            printlog Chr(13) & "Read the OLE object DOM."
            '///<li>Read DOM of objects 'content.xml'</li>///
            SAXReadFile( sContentXMLObject )
            sleep(2)
            '///<li>Lookup identifier for correct object type</li>///
            printlog Chr(13) & "Check if expected OLE object was found in 'content.xml'"
            SAXSeekElement( "/" )
            select case sCurrentOLE
                   case "mat"
                        SAXSeekElement( 1 )
                        if SAXGetElementName() = "math:math" then
                            printlog "+ Yes, this is a Math object as expected"
                        else
                            warnlog "+ A Math object was expected here -> Check this out!"
                        endif
                   case else
                        SAXSeekElement( "office:document-content" )
                        SAXSeekElement( "office:body" )
                        SAXSeekElement( 1 )
                        select case sCurrentOLE
                               case "exc"
                                    if SAXGetElementName() = "office:spreadsheet" then
                                        printlog "+ Spreadsheet OLE fould as expected"
                                    else
                                        warnlog "+ OOPS, this OLE seems to be no spreadsheet -> Check this out!"
                                    endif
                               case "ppt"
                                    if SAXGetElementName() = "office:presentation" then
                                        printlog "+ Presentation OLE fould as expected"
                                    else
                                        warnlog "+ OOPS, this OLE seems to be no presentation -> Check this out!"
                                    endif
                               case "wor"
                                    if SAXGetElementName() = "office:text" then
                                        printlog "+ Writer OLE fould as expected"
                                    else
                                        warnlog "+ OOPS, this OLE seems to be no text -> Check this out!"
                                    endif
                        end select
            end select
            SAXRelease
        endif
     skipThisIteration:
     printlog Chr(13) & "**************************************************************" & Chr(13)
     next iIndex
     '///<li>END</li></ul>///
endcase
'
'-----------------------------------------------------------------------------
'
sub subSetConversionMicrosoftOLE ( OPTIONAL sConversionType as STRING )
'///<u><b>Routine to adjust the behaviour of Tools::Options::Load/Save::Microsoft Office</b></u>///
'///<b>Possible Keys for 'sConversionType' are:</b>///
'///<ul><li>RESET (or omitted): Uncheck all boxes (default in a freshly installed OOo))</li>///
'///<li>ALL: Check all boxes</li>/// 
'///<li>LOAD: Check all boxes for loading MS OLE objects (left side), uncheck all boxes for saving</li>///
'///<li>SAVE: Check all boxes for saving MS OLE objects (right side), uncheck all boxes for loading</li>///
'///<li>For other values the subroutine will exit</li></ul>
'///<b>Action:</b>///

'///<ul><li>Convert omitted 'sConversionType' to RESET</li>///
    if IsMissing ( sConversionType ) then
       sConversionType = "RESET"
    end if
    dim iPosInAuswahl as INTEGER
    dim iExtraToggle as INTEGER
    
    '///<li>Determine value of 'iExtraToggle' for known keys</li>///
    select case sConversionType
           case "RESET" : iExtraToggle = 1
           case "ALL"   : iExtraToggle = 2
           case "LOAD"  : iExtraToggle = 3
           case "SAVE"  : iExtraToggle = 4
           case else 
                warnlog "Unknown keyword for paramter -> Exit the subroutine"
                qaErrorLog "Valid keywords are RESET, ALL, LOAD and SAVE!"
                exit sub
    end select
    
    '///<li>Invoke Tools::Options</li>///       
    ToolsOptions
    '///<li>Go to tabpage Load/Save::Microsoft Office</li>///
    call hToolsOptions ( "LOADSAVE" , "MICROSOFTOFFICE" )
    '///<li>Go to top entry in listbox</li>///
    Auswahl.TypeKeys( "<PageUp>" )
    
    '///<li>Toggle (in a tricky way) to a defined state of checkboxes</li>///
    for iPosInAuswahl = 1 to 4
         Auswahl.TypeKeys ( "<RIGHT>" , 2 )
         while NOT Auswahl.IsChecked
             Auswahl.TypeKeys ( "<Space>" )
         wend
         while Auswahl.IsChecked
             Auswahl.TypeKeys ( "<Space>" )
         wend
         '///<li>Toggle to desired state of boxes</li>///
         Auswahl.TypeKeys ( "<Space>" , iExtraToggle )
         '///<li>Go one entry down in list box</li>///
         Auswahl.TypeKeys ( "<Down>" )
         '///<li>Loop for all lines</li>///
    next iPosInAuswahl
    
    '///<li>Quit dialog</li></ul>///
    Kontext "OptionenDLG"
    OptionenDLG.Ok
    
end sub

