'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_issuezilla_regression.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: hde $ $Date: 2006/08/16 13:56:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Avoid regression (issuezilla tasks)
'*
'\***********************************************************************


sub w_issuezilla_regression

    Call i64991


end sub

'--------------------------------------------------------------------------

testcase i64991
    Dim PrevMacroSetting as integer
    Dim sDocName as string, i as integer, j as integer    

    sDocName = ConvertPath(gtesttoolpath & "writer\level1\input\regression\issuezilla\i64991.odt")
    '/// New writer document
    Call hNewDocument
    '/// Set macro security to 'Medium' to activate Macros
    PrevMacroSetting = hSetMacroSecurity(1)
    '/// Open file \\writer\\level1\\input\\regression\\issuezilla\\i64991.odt
    printlog "- Open file: " & sDocName 
    FileOpen
    sleep (1)
    Kontext "OeffnenDlg"
    Dateiname.SetText sDocName
    sleep (3)
    Oeffnen.Click
    sleep(2)
    Kontext "SecurityWarning"
    if SecurityWarning.Exists(2) then
        SecurityWarning.OK
    else
        Warnlog "Security Warning not up. Test interrupted!"
        Call hCloseDocument
        goto endsub
    endif
    '/// Now Execute Macro 'Main' in Node 'i64991'->'check_page_style'
    printlog "- execute macro"
    ToolsMacrosRunMacro
    ' Sometimes it lasts long until dialog is shown
    For i = 1 to 15
        Sleep(i)
        Kontext "ScriptSelector"
        if ScriptSelector.Exists then exit for
    next i
    printlog " - select 'i64991' in Library list"
    Kontext "ScriptSelector"
    For i = 1 to LibraryTreeList.GetItemCount
        LibraryTreeList.Select i
        if LibraryTreeList.GetSelText = "i64991" then
            printlog " - open node 'i64991' in Library list"
            i = LibraryTreeList.GetItemCount + 1     
            LibraryTreeList.TypeKeys "+"
            wait 500
            printlog " - select 'Standard' in Library list"
            LibraryTreeList.TypeKeys "<Down>"            
            wait 500
            printlog " - open node 'Standard' in Library list"
            LibraryTreeList.TypeKeys "+"
            wait 500
            LibraryTreeList.TypeKeys "<Down>"
            printlog " - select 'check_page_style' in Library list"
            if LibraryTreeList.GetSelText <> "check_page_style" then
                Warnlog "Unable to find macro. Test interrupted!"
                ScriptSelector.Cancel
                Call hCloseDocument
                goto endsub
            endif
            printlog "- Now select script 'Main'"
            for j = 1 to ScriptList.GetItemCount
                ScriptList.Select j
                if ScriptList.GetSelText = "Main" then
                    printlog " - execute Script 'Main'"
                    ScriptSelector.Ok
                    exit for
                endif
            next j                
        endif
    next i
    Kontext "ScriptSelector"
    if ScriptSelector.Exists then
        Warnlog "Something failed executing macro. Test interrupted"
        ScriptSelector.Cancel
    else
        '/// check if page layout on first page is landscape
        printlog "Check layout on first page"
        FormatPageWriter
        Kontext
        Active.Setpage TabSeite
        Kontext "TabSeite"
        if Not Quer.IsChecked then Warnlog "#i64991#Setting a printer make the page styles to be lost"
        TabSeite.Cancel
        
        Call wDokSchreiben ("<Down>")
        
        '/// check if page layout on second page is still portrait
        printlog "Check layout on second page"
        FormatPageWriter
        Kontext
        Active.Setpage TabSeite
        Kontext "TabSeite"
        if Not Hoch.IsChecked then Warnlog "#i64991#Setting a printer make the page styles to be lost"
        TabSeite.Cancel
    endif
   
    '/// Set macro setting to previous value
    Call hSetMacroSecurity(PrevMacroSetting)
    
    '/// Close document
    Call hCloseDocument

endcase

'--------------------------------------------------------------------------
