'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_fields1.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: hde $ $Date: 2005/11/09 11:51:00 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Fields general test
'*
'************************************************************************
'*
' #1 tFields_1           'Insert / Fields / Date
' #1 tFields_2           'Insert / Fields / Time
' #1 tFields_3           'Insert / Fields / Page Number
' #1 tFields_4           'Insert / Fields / Page Count
' #1 tFields_5           'Insert / Fields / Subject
' #1 tFields_6           'Insert / Fields / Title
' #1 tFields_7           'Insert / Fields / Author
'*
'\***********************************************************************

testcase tFields_1

  Dim sDate , sDate1 , sDate2 as String

  sDate  = Date
  sDate1 = Left (sDate , 6)
  sDate2 = Right(sDate , 2)
  sDate  = sDate1 & sDate2

  printlog "Insert / Fields / Date"
 '/// <b> Insert / Fields / Date </b>
 '/// <b> Default should be mm/dd/yy </b>

  Call hNewDocument

  '/// Insert / Fields / Date , the 1st date is fixed
   InsertFieldsDate

  '/// Return
   Call wDokSchreiben "<Return>"

  '/// Insert / Fields / Date
   InsertFieldsDate

   Call wDokSchreiben "<Home>"

  '/// Set 2nd date only to be date , not fixed
  '/// In 2nd date , Edit / Fields , select date in 'select'
   EditFields
   Kontext "FeldbefehlBearbeitenDokument"
     Auswahl.Select 2
     Sleep 2
   FeldbefehlBearbeitenDokument.OK

  '/// Check if the date is correct
   Call wDokSchreiben "<MOD1 Home>"
   Call wDokSchreiben "<Shift Right>"
   EditCopy
   if GetClipboardText <> sDate then
       Warnlog "Fixed date is wrong ! Hope you don't run this case in the midnight"
   end if

   Call wDokSchreiben "<Down><Home>"
   Call wDokSchreiben "<Shift Right>"
   EditCopy
   if GetClipboardText <> sDate then
       Warnlog "Date is wrong ! Hope you don't run this case in the midnight"
   end if

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tFields_2

  Dim sTime , sTime1 , sTime2 as String
  Dim sTemp                   as String

  printlog "Insert / Fields / Time"
 '/// <b> Insert / Fields / Time </b>
 '/// <b> Default should be hh/mm/ss pm </b>

  Call hNewDocument

   sTime = Time
   sTemp = Right(sTime , 2)  'It should get am or pm

  '/// Insert / Fields / Time , the 1st time is fixed
   InsertFieldsTime

  '/// Return
   Call wDokSchreiben "<Return>"

  '/// Insert / Fields / Time
   InsertFieldsTime

   Call wDokSchreiben "<Home>"

  '/// Set 2nd time only to be time , not fixed
  '/// In 2nd time , Edit / Fields , select Time in 'select'
   EditFields
   Kontext "FeldbefehlBearbeitenDokument"
     Auswahl.Select 2
     Sleep 2
   FeldbefehlBearbeitenDokument.OK

  '/// Check if the time is correct
   Call wDokSchreiben "<MOD1 Home>"
   Call wDokSchreiben "<Shift Right>"
   EditCopy
   sTime1 = GetClipboardText
   if Len(sTime1)       <> 11    then Warnlog "Fixed time is wrong !"
   if Right(sTime1 , 2) <> sTemp then Warnlog "Fixed time is wrong ! , Hope you don't run this case in the midnight"

   Call wDokSchreiben "<Down><Home>"
   Call wDokSchreiben "<Shift Right>"
   EditCopy
   sTime2 = GetClipboardText
   if Len(sTime2)       <> 11    then Warnlog "Time is wrong !"
   if Right(sTime2 , 2) <> sTemp then Warnlog "Time is wrong ! , Hope you don't run this case in the midnight"

   printlog "Stop for a while ..."
  '/// Stop for  a while , check if the time is still correct
   Sleep 5
   Call wDokSchreiben "<MOD1 Home>"
   Call wDokSchreiben "<Shift Right>"
   EditCopy
   if GetClipboardText <> sTime1 then Warnlog "Fixed time is wrong !"

   Call wDokSchreiben "<Down><Home>"
   Call wDokSchreiben "<Shift Right>"
   EditCopy
   if GetClipboardText = sTime2  then Warnlog "Time is wrong !"

 Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tFields_3

  Dim sPage1 , sPage2 as String

  sPage1 = "1" : sPage2 = "2"

  printlog "Insert / Fields / Page Number"
 '/// <b> Insert / Fields / Page Number </b>

  Call hNewDocument

  '/// In 1st page , Insert / Fields / Page Number
   InsertFieldsPageNumbers

  '/// Insert a page break
   InsertManualBreak
   Sleep 2
   kontext "UmbruchEinfuegen"
     Seitenumbruch.check
   UmbruchEinfuegen.OK

  '/// In 2nd page , Insert / Fields / Page Number
   InsertFieldsPageNumbers

   Call wDokSchreiben "<MOD1 Home>"

  '/// Check if the page number is correct
   Call wDokSchreiben "<Shift Right>"
   ToolsCalculate
   if GetClipboardText <> sPage1 then
       QAErrorLog "#i31214# The 1st page number isn't correct !"
   end if

   Call wDokSchreiben "<MOD1 End>"
   Call wDokSchreiben "<Shift Left>"
   ToolsCalculate
   if GetClipboardText <> sPage2 then
       Warnlog "The 2nd page number isn't correct !"
   end if

 Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tFields_4

  Dim sPage1 , sPage2  as  String

  sPage1 = "1" : sPage2 = "2"

  printlog "Insert / Fields / Page Count"
 '/// <b> Insert / Fields / Page Count </b>

  Call hNewDocument

  '/// In 1st page , Insert / Fields / Page Count
   InsertFieldsPageCount

   Call wDokSchreiben "<MOD1 Home>"

  '/// Check if the 1st page count is correct
   Call wDokSchreiben "<Shift Right>"
   ToolsCalculate
   if GetClipboardText <> sPage1 then
       Warnlog "1-The 1st page count isn't correct !"
   end if
   Call wDokSchreiben "<End>"

  '/// Insert a page break
   InsertManualBreak
   Sleep 2
   kontext "UmbruchEinfuegen"
     Seitenumbruch.check
   UmbruchEinfuegen.OK

  '/// In 2nd page , Insert / Fields / Page Count
   InsertFieldsPageCount

   Call wDokSchreiben "<MOD1 Home>"

  '/// Check if the page count is correct
   Call wDokSchreiben "<Shift Right>"
   ToolsCalculate
   if GetClipboardText <> sPage2 then
       Warnlog "2-The 1st page count isn't correct"
   end if

   Call wDokSchreiben "<MOD1 End>"
   Call wDokSchreiben "<Shift Left>"
   ToolsCalculate
   if GetClipboardText <> sPage2 then
       Warnlog "The 2nd page count isn't correct !"
   end if

 Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tFields_5

  Dim sSubject  as  String

  sSubject = "This is a Subject"

  printlog "Insert / Fields / Subject"
 '/// <b> Insert / Fields / Subject </b>

  Call hNewDocument

  '/// File / Properties / Description , input some
  '/// + text in Subject
   Call fFileProperties("TabBeschreibung")
     Thema.Settext sSubject
   TabBeschreibung.OK

  '/// Insert / Fields / Subject
   InsertFieldsSubject

  '/// Check if the subject is correct
   Call wDokSchreiben "<Shift Left>"
   EditCopy
   if GetClipboardText <> sSubject then
       Warnlog "Subject isn't correct !"
   end if

 Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tFields_6

  Dim sTitle  as  String

  sTitle = "This is a Title"

  printlog "Insert / Fields / Title"
 '/// <b> Insert / Fields / Title </b>

  Call hNewDocument

  '/// File / Properties / Description , input some
  '/// + text in Title
   Call fFileProperties("TabBeschreibung")
     Titel.Settext sTitle
   TabBeschreibung.OK

  '/// Insert / Fields / Title
   InsertFieldsTitle

  '/// Check if the title is correct
   Call wDokSchreiben "<Shift Left>"
   EditCopy
   if GetClipboardText <> sTitle then
       Warnlog "Title isn't correct !"
   end if

 Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tFields_7

  Dim sFirstName  , sLastName  as String
  Dim sFirstName1 , sLastName1 as String

  sFirstName1 = "Test1" : sLastName1 = "Test2"

  printlog "Insert / Fields / Author"
 '/// <b> Insert / Fields / Author </b>

  Call hNewDocument

  '/// Change author to author :Test2 Test1
   ToolsOptions
   Call hToolsOptions("STAROFFICE","USERDATA")
     sFirstName = VorName.GetText
     sLastName  = ZuName.GetText
     VorName.SetText sFirstName1
     ZuName.SetText  sLastName1
     Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

  '/// File / Properties / General , check "Apply user
  '/// + data" , click "delete" button
   Call fFileProperties("TabDokument")
     BenutzerdatenVerwenden.Check
     Sleep 1
     Loeschen.Click
     Sleep 1
   TabDokument.OK

  '/// Insert / Fields / Author
   InsertFieldsAuthor

  '/// Check if the title is correct
   Call wDokSchreiben "<Shift Left>"
   EditCopy
   if GetClipboardText <> (sFirstName1 + " " + sLastName1) then
       Warnlog "Author isn't correct !"
   end if

  'Recover author to default
   ToolsOptions
   Call hToolsOptions("STAROFFICE","USERDATA")
     VorName.SetText sFirstName
     ZuName.SetText  sLastName
     Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

 Call hCloseDocument

endcase
