'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: id_tools.inc,v $
'*
'*  $Revision: 1.20 $
'*
'*  last change: $Author: fredrikh $ $Date: 2006/02/23 15:19:24 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description : some tools
'*
'******************************************************************
'*
' #1 hSetSpellHypLanguage
' #1 hFindSpellHypLanguage
' #1 GetDecimalSeperator
' #1 TBOrestart
' #1 StrToDouble
' #1 GetMeasUnit
' #1 LiberalMeasurement
' #1 fIsDocumentWritable
' #1 fMakeDocumentWritable
'*
'\*****************************************************************

sub hSetSpellHypLanguage
'/// select a language with a dictionary, used for spellcheck, thesaurus and hyphenation ///'
    dim sTrieit as string

    ' only for asian languages i need to set the default language for the current document  to 'English(USA)'
    ' in all other languages the default has a dictionary
    if (bAsianLan or (iSprache=55)) then
        '/// Tools->Options ///'
        ToolsOptions
        '/// select from section 'Language Settings' the item 'Languages' ///'
        hToolsOptions ("LANGUAGESETTINGS","LANGUAGES")
        '/// check checkbox 'For the current document only' in section 'Default languages for document' ///'
        AktuellesDokument.Check
        '/// If there is no Language defined in 'locale-file' (in same directory as this file is) be smart and select one that supports spellchecking ///'
        if (glLocale(4) = "") then
            Kontext "ExtrasOptionenDlg"
            '///+ cancel dialog 'Options - ' ///'
            ExtrasOptionenDlg.Cancel
            '///+ call the smart subroutine that tells you a valid language with an dictionary ///'
            sTrieit = hFindSpellHypLanguage
            '///+ Tools->Options ///'
            ToolsOptions
            '///+ select from section 'Language Settings' the item 'Languages' ///'
            hToolsOptions ("LANGUAGESETTINGS","LANGUAGES")
            '///+ check checkbox 'For the current document only' in section 'Default languages for document' ///'
            AktuellesDokument.Check
            '/// if smart routine found something, select it in section 'Default languages for document' listbox 'Western' ///'
            '///+ (manual users just select a language that has an icon in front of it ('ABC' with a checkmark) ///'
            if (sTrieit <> "") then
                try
                    Westlich.Select sTrieit
                catch
                    Font.Select sTrieit
                endcatch
            else
                qaErrorLog "Sorry no spellbook found: id_tools.inc::hSetSpellHypLanguage"
            endif
        else
        '/// if a Language is already defined in the textfile ///'
            printlog glLocale (4)
            try
                '/// select it in section 'Default languages for document' listbox 'Western' ///'
                '///+ (manual users just select a language that has an icon in front of it ('ABC' with a checkmark) ///'
                try
                    Westlich.Select glLocale (4)
                catch
                    Font.Select glLocale (4)
                endcatch
            catch
                warnlog "this language is not available: '" + glLocale (4) + "'"
            endcatch
        endif
            try
                printlog "selected: '" + Westlich.GetSelText + "'"
            catch
                printlog "selected: '" + Font.GetSelText + "'"
            endcatch
        Kontext "ExtrasOptionenDlg"
        '///+ close dialog 'Options - ' with OK ///'
        ExtrasOptionenDlg.OK
    endif
end sub

function hFindSpellHypLanguage (optional sBooks()) as string
'/// print all available languages that have a 'language module' ///'
    dim iListLength as integer
    dim i as integer
    dim sTemp as string

    '/// only necessarry for asian languages ///'
    if (bAsianLan or (iSprache=55)) then
        '/// Tools->Options ///'
        ToolsOptions
        '/// select from section 'Language Settings' the item 'Writing Aids' ///'
        hToolsOptions ("LANGUAGESETTINGS","WRITINGAIDS")
        '/// click button 'Edit...' in section 'Available language modules' ///'
        SprachmoduleBearbeiten.click
        kontext "ModuleBearbeiten"
        '/// print all entries from listbox 'Language' ///'
        for i = 1 to Sprache.GetItemCount
            sTemp = Sprache.GetItemText(i)
            if (NOT isMissing(sBooks())) then
                listAppend(sBooks(), sTemp)
            endif
            '/// return the first entry in the listbox ///'
            if i = 1 then hFindSpellHypLanguage = sTemp
        next i
        '/// close dialog 'Edit Modules' ///'
        ModuleBearbeiten.Close
        Kontext "ExtrasOptionenDlg"
        '/// close dialog 'Options - ' ///'
        ExtrasOptionenDlg.OK
        sleep 1
    endif
end function

function GetDecimalSeperator ( sDummy$ ) as String
'/// Input : number with fractionmark from 'NumericField' as String ///'
'///+ Output: '.' or ',' as String                                  ///'
   dim i1, i2 as integer

' get position of fraction mark / get IT
   i1 = instr (sDummy$, ",")
   i2 = instr (sDummy$, ".")
   if i1 > i2 then GetDecimalSeperator = "," else GetDecimalSeperator = "."
end function

sub TBOrestart
    hCloseDocument
    sleep (5)
    ExitRestartTheOffice
    sleep (10)
    hNewDocument
    sleep (5)
end sub

function LiberalMeasurement ( sShould$, sActual$) as Boolean
'/// Input : (1. Should, 2. Actual) as Number with or without MeasurementUnit 'NumericField' as String ///'
'///+          if input has no MeasurementUnit i take it as 'cm' (was the default in old tests) ///'
'///+ Output: Boolean are they likely the same?
'/// NEEDED: mathematical proofment of iTolerance, by now just some guesses :-| ///'
'/// reason for this function:///'
'///+   because SO counts internaly in 'twip???s' 'twentieth of a point' there are some rounding errors ///'
'///+ there are also some rounding errors because of the internal representatio of floating point numbers in computers ///'
'///+   now lets try to get rid of them and have a nicer output in tests... ///'
'/// measurement units are defined in http://gsl.openoffice.org/source/browse/gsl/vcl/source/src/units.src ///'
   dim iTolerance as Double

   LiberalMeasurement = False ' worst case

' trivial
   if (sShould$ = sActual$) then
      LiberalMeasurement = True
   else
      ' check if measunit is the same !!
      if (GetMeasUnit(sShould$) <> GetMeasUnit(sActual$) ) then
         warnlog "In function LiberalMeasurement the measUnit is different, compare not possible yet"
      else
        ' set factor for liberality ;-)
        ' took units from http://gsl.openoffice.org/source/browse/gsl/vcl/source/src/units.src
         select case GetMeasUnit(sShould$)
            case "mm", "ミリ", "公厘" : iTolerance = 2.0             '01, 81,     88
            case "cm","センチ","厘米","公分"  : iTolerance = 0.5       '01, 81, 86, 88
            case chr$(34) : iTolerance = 2.5
            case "pi","ピクセル" : iTolerance = 2.5                 '01, 81
            case "pt",  "ポイント" : iTolerance = 2.5                '01, 81
            case "" : iTolerance = 1.5 ' cm is presubposition in old functions
         case else
            iTolerance = 2.5
            qaErrorLog "This Unit is not available in this function. '" + GetMeasUnit(sShould$) + "'"
         end select
         ' have to get the measurem unit, cause the offset is different for each :-(
         ' !!! val(str()) is important because of double calculating actions !!! #110996#
         if ( val(str(StrToDouble(sShould$)+iTolerance)) >= StrToDouble(sActual$) ) AND (val(str(StrToDouble ( sShould$ )-iTolerance)) <= StrToDouble ( sActual$ )) then
             LiberalMeasurement = True
         else
            LiberalMeasurement = False
            'printlog "LM: ---------------------------: "+sShould$ +":"+sActual$
         end if
         'printlog "### LibMeas: "+ (StrToDouble(sShould$) + iTolerance) +" - "+ StrToDouble(sShould$) +" - "+ (StrToDouble ( sShould$ ) - iTolerance)+" ; '"+GetMeasUnit(sShould$)+"'"
      end if
   end if
'      Printlog "+++++++++++++++++++++++++++++++++++++meas lib was here: "+LiberalMeasurement
end function

function GetMeasUnit ( sWert$ ) as String
    dim iBounder as integer
'/// Input : Number with or without MeasurementUnit 'NumericField' as String ///'
'///+ Output: Initials of MeasurementUnit as String or "" when only a number ///'

    iBounder = -1
    do
        inc iBounder
    loop until ( isNumeric(mid (sWert$, len(sWert$)-iBounder, 1)) OR (len(sWert$) <= (iBounder + 1)) )

   ' printlog right (sWert$, iBounder)
    if (len(sWert$) <= (iBounder + 1)) then
        if isNumeric(left (sWert$, 1)) then
            GetMeasUnit = right (sWert$, iBounder)
        else
            GetMeasUnit = sWert$
        endif
    else
        GetMeasUnit = right (sWert$, iBounder)
    endif
end function


function StrToDouble ( sWert$ ) as Double
  Dim sDummy$
  dim i, i1, i2 as integer
  dim a as integer
  dim b as integer
  dim c as double
  dim n as integer

'/// Input : {'a[. ,]b[mm cm " pi pt]' with a, b as integer} as String ///'
'///+ Output: a[. , ]b as double ///'

' get rid of measure unit, the only single character is '"' all others are two chars
' there was a problem, if there is NO meas.unit!!!
      if (isNumeric (sWert$) = FALSE) then
         if (  StrComp (right (sWert$, 1), chr$(34) ) = 0 ) then
            sDummy$ = Left ( sWert$, Len(sWert$)-1 )
         else
            sDummy$ = Left ( sWert$, Len(sWert$)-2 )
         endif
      else
         sDummy$ = sWert$
      endif
   ' get position of fraction mark
      i1 = instr (sDummy$, ",")  ' wrong output
      i2 = instr (sDummy$, ".")
      if i1 > i2 then i = i1 else i = i2
        ' in front of decimal seperator
         try
            a = val (left (sDummy$,i-1))
         catch
            'printlog sWert$ + ":" + sDummy$ + ":" + i + ":" + i1+ ":" + i2
         endcatch
      ' after the decimal seperator
         n = (len (sDummy$)-i)
         b = val (right (sDummy$, n) )
         c = b * 10 ^ -n
         'printlog "-------------- :"+sWert$ +" :'"+a+"' :"+n+" :"+b+" :'"+c+"':"
         ' !!! val(str()) is important because of double calculating actions !!! #110996#
         StrToDouble = val(str(a + c))
end function

sub hTBOtypeInDoc
   hRechteckErstellen ( 10, 10, 30, 40 )
end sub

function fGetPositionX () as string
   fGetPositionX = ""
   try
      ContextPositionAndSize
   catch
      warnlog "couldn't call 'ContextPositionAndSize' no object selected ?"
   endcatch
   kontext
   active.SetPage TabPositionAndSize
   kontext "TabPositionAndSize"
   if TabPositionAndSize.exists (5) then
      fGetPositionX = PositionX.GetText
      TabPositionAndSize.OK
   else
      warnlog "Couldn't switch tab page :-( "
   endif
end function

sub Position_Vergleichen (Ueber_Text_1 as string,Ueber_Text_2 as string,Ueber_Text_3 as string)              ' Ueber_Text_1 : X-Position des Objektes
 dim Dummy_Text as string
'------------------------------------------------------------  ' Ueber_Text_2 : printlog, bei richtigem Objekt
'  gMouseClick 99,99
  sleep 1
  gMouseClick 50,50
  ContextPositionAndSize
  kontext
  active.SetPage TabPositionAndSize
  kontext "TabPositionAndSize"
  Dummy_Text = PositionX.GetText
  TabPositionAndSize.OK
  sleep 1
  if TabPositionAndSize.exists (5) then printlog "Yo!"
printlog "What?"
   if Dummy_Text = Ueber_Text_1 then
      Printlog Ueber_Text_2
   else
      warnlog Ueber_Text_3,":  is: ", Dummy_Text,"; should be: ", Ueber_Text_1
   end if
end sub

sub sPrintCheckOrder (optional bcheck as boolean)
   dim sTemp as string
   dim sTemp2 as string
   dim i as integer
   '/// deselect all ///'
   Printlog "-----------------------------------"
   '/// select in default order and take Position X in mind ;-) ///'
   hTypeKeys ("<escape><escape>")
   for i = 1 to 3
      hTypeKeys ("<TAB>")
      sTemp = fGetPositionX()
      Printlog " - " + i +": " + sTemp
      if ((isMissing(bcheck) <> FALSE) AND (bcheck = TRUE)) then
         Select Case i
            Case 1:  sTemp2 = Ueber_Text_1
            Case 2:  sTemp2 = Ueber_Text_2
            Case 3:  sTemp2 = Ueber_Text_3
         End Select
         if sTemp <> sTemp2 then
            warnlog " + " + i + " Arrangement is wrong; is: "+sTemp+"; should: "+sTemp2+";"
         end if
      endif
   next i
   hTypeKeys ("<escape><escape>")
   Printlog "-----------------------------------"
end sub

function setStartCurrentPage(optional bState as boolean) as boolean
    '/// tools->options ///'
    ToolsOptions
    '///+ select in section 'Presentation' tabpage 'general' ///'
    hToolsOptions ("Presentation","General")
        '///+ check the checkbox 'Always with current page' ///'
        setStartCurrentPage = MitAktuellerSeite.isChecked
        if bState then
            MitAktuellerSeite.Check
        else
            MitAktuellerSeite.UnCheck
        endif
    Kontext "ExtrasOptionenDlg"
    '///+ close dialog 'Options - Presenation - General' with OK ///'
    ExtrasOptionenDlg.OK
end function
'-------------------------------------------------------------------------
function fIsDocumentWritable() as boolean
    '/// check if a document is writeable
    '/// <u>parameter:</u>
    '/// <u>return:</u>
    '/// true if the document is writeable otherwise false

    Kontext "Standardbar"
        if Bearbeiten.GetState(2) <> 1 then
            fIsDocumentWritable = false
        else
            fIsDocumentWritable = true
        endif

end function
'-------------------------------------------------------------------------
function fMakeDocumentWritable() as boolean
    '/// make a document is writeable
    '/// <u>parameter:</u>
    '/// <u>return:</u>
    '/// true if the document can make writeable otherwise false

    Kontext "Standardbar"
        if Bearbeiten.GetState(2) <> 1 then
            Bearbeiten.Click
            Kontext
                if Active.Exists(1) then
                    Active.Yes
                    fMakeDocumentWritable = true
                else
                    warnlog "No messagebox after making document editable?"
                    fMakeDocumentWritable = false
                endif
        else
            qaerrorlog "Document is allready writable!"
            fMakeDocumentWritable = true
        endif

end function
