'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_insert.inc,v $
'*
'*  $Revision: 1.17 $
'*
'*  last change: $Author: fredrikh $ $Date: 2006/05/10 15:42:24 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description :
'*
'**************************************************************************************
' #1 tInsertFloatingFrame
' #1 tInsertFields
' #1 tdInsertObjectOleObjects
' #1 tdInsertSnapPoint_Line
' #1 tInsertSpecialCharacter
' #1 tInsertSpreadsheet
' #1 tInsertGraphics
' #1 tInsertObjectPlugIn
' #1 tInsertObjectApplet
' #1 tInsertObjectFormula
' #1 tInsertChart
' #1 tdInsertFile
'\*************************************************************************************

'    Dateiname.SetText ConvertPath (gTesttoolPath + "graphics\level1\input\einfg.ini")
'    DateiUrl.SetText ConvertPath (gTesttoolPath + "graphics\input\sample.mov")
'    Dateiname.SetText ConvertPath (gTesttoolPath + "global\input\java\rocket.class")
'                  Dateiname.SetText ConvertPath (gTesttoolPath + "graphics\level1\input\diashow.sx"+left(lcase(gApplication),1) ))

testcase tdInsertObjectOleObjects
   Dim Zaehler as Integer
   Dim i, a as integer
   Dim Liste (100) as String

   Liste (0) = 0
   '/// open application ///'
   Call hNewDocument
   '/// Insert->Object->OLE Object... ///'
   InsertObjectOLEObject
   Kontext "OLEObjektInsert"
   Zaehler = Objekttyp.GetItemCount

   printlog " - there are: --"+Zaehler + "-- possible items to insert"

'check available items against list
' serchinlist....

   ' on lin & sol there are no additional OLE-Types, like on win ??!?!?!?!.
   ' first letter is usuallay 'S' from 'Star...', but on windows exists 'Further Objects' as last type. this won't be used.
   if (left(Objekttyp.GetItemText (Zaehler),1) <> left (Objekttyp.GetItemText (1),1)) then
      PrintLog "    "+Zaehler +": '"+Objekttyp.GetItemText (Zaehler) + "' WONT be inserted"
      a = Zaehler -1
   else
      a = Zaehler
   endif

   '/// insert every object type, except the one, that is the last with the first letter being different from the firts' object' letter ///'
   for i = 1 to a
      '///+ select object entry in list ///'
      Objekttyp.Select i
      sleep 2
      PrintLog "    "+i+": '"+Objekttyp.GetSelText + "' will be inserted"
      '///+ leave dialog 'Insert OLE Object' with OK ///'
      OLEObjektInsert.OK
      sleep 2
      '///+ leave edit mode by typing key [Escape] ///'
      hTypeKeys "<escape>"
'      EditSelectAll
'      sleep 2
      '///+ delte object by typing key [Delete] ///'
      hTypeKeys "<DELETE>"
      sleep 2
      '///+ Insert->Object->OLE Object... ///'
      InsertObjectOLEObject
      Kontext "OLEObjektInsert"
   next i

   '///+ leave dialog 'Insert OLE Object' with CANCEL ///'
   OLEObjektInsert.Cancel
   sleep 1
   '/// close application ///'
   Call hCloseDocument
endcase

testcase tInsertFloatingFrame
   '/// open application ///'
   Call hNewDocument
   '/// Insert->Floating Frame... ///'
   InsertFloatingFrame
      Kontext "TabEigenschaften"
      '/// set 'name' to something ///'
      FrameName.SetText "StarDivision Home"
      '/// set 'Contents' to 'graphics\\input\\leer.sxd' ///'
      Inhalt.SetText ConvertPath (gTesttoolPath + "graphics\input\leer.sxd")
      '/// close dialog 'Floating Frames Properties' with OK ///'
      TabEigenschaften.OK
   sleep 10
'   gMouseMove 10,10,90,90
   '/// the object should be selected by default now ///'
   try
      '/// Format->Position And Size ///'
      ContextPositionAndSize
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      If (PositionY.GetText = "") Then
         Warnlog "No position for frame available ?!"
      endif
      '/// close dialog with OK ///'
      TabPositionAndSize.OK
   catch
      Warnlog "- Insert Floating Frame did not work, there is nothing in the document?"
   endcatch
   '/// delete object by typing Key [Delete] ///'
   hTypekeys "<DELETE>"
   sleep 2
   kontext
   if (messagebox.exists (5)) then
      printlog "messageb: " + messagebox.gettext
      messagebox.cancel
   else
      qaErrorLog "Messagebox missing about changes in inserted document! #103343# 6.y"
   endif
   sleep 2
   '/// close application ///'
   Call hCloseDocument
endcase

testcase tInsertFields
   dim sTemp as string
   dim sFile as string
   dim i as integer

   '/// open application ///'
   Call hNewDocument           '/// new document ///'

   '/// open 'tools->options' and set first/last name and email adress on the page 'StarOffice->UserData' ///'
   ToolsOptions
   hToolsOptions ("STAROFFICE","USERDATA")
   VorName.SetText "Garfield"
   ZuName.SetText  "Peanuts"
   EMail.SetText   "recumbent@sun.com"
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

   '/// every item from menue 'Insert->Fields' is inserted, and the keys [Strg]+[A], [Delete] are pressed ///'
   InsertFieldsDateFix            '///  (date fix) ///'
   EditSelectAll
   hTypeKeys "<DELETE>"

   InsertFieldsDateVariable       '///  (date variable) ///'
   EditSelectAll
   hTypeKeys "<DELETE>"

   InsertFieldsTimeFix            '///  (time fix)
   EditSelectAll
   hTypeKeys "<DELETE>"

   InsertFieldsTimeVariable       '///  (time variable) ///'
   EditSelectAll
   hTypeKeys "<DELETE>"

   InsertFieldsAuthorDraw         '///  (author) ///'
   '///+ additional test for author ///'
   '///+ it has to tbe 'Garfield Peanuts' ///'
   hTypeKeys "<F2>"
   EditSelectAll
   EditCopy
   sTemp = GetClipboard()
   if (sTemp <> "Garfield Peanuts") then
      Warnlog "wrong author; expected: 'Garfield Peanuts' is: '" + sTemp + "'"
   else
      Printlog "Author is: '" + sTemp + "'"
   endif
   hTypeKeys "<Escape><Escape>"
   EditSelectAll   
   hTypeKeys "<DELETE>"

   for i = 1 to 2
      InsertFieldsPageNumberDraw        '///  (page number) ///'
      '///+ additional test for pagenumber  ///'
      '///+ it has to be '1' and should remain the same when we insert a new slide ///'
      hTypeKeys "<F2>"
      EditSelectAll      
      EditCopy
      sTemp = GetClipboard()
      if (sTemp <> right(str(i),1) ) then
         if sTemp = 2 then
            warnlog "Wrong number; expected it to still be: '1' but was: '" + sTemp + "'"
         else
            printlog "Good. Number is: '" + sTemp + "'"
         endif
      else
         printlog "Good. Number is: '" + sTemp + "'"
      endif
      hTypeKeys "<Escape><Escape>"
      EditSelectAll      
      hTypeKeys "<DELETE>"
      '/// Insert->Slide ///'
      InsertSlide
      sleep 2
   next i

'/// and one try when we switch slides manually ///'
   EditDeleteSlide
   EditDeleteSlide

   for i = 1 to 2
      InsertFieldsPageNumberDraw        '///  (page number) ///'
      '///+ additional test for pagenumber  ///'
      '///+ it has to chenge when we insert a new slide and press pagedown ///'
      hTypeKeys "<F2>"
      EditSelectAll
      EditCopy
      sTemp = GetClipboard()
      if i > 1 then
         if (sTemp <> right(str(i),1) ) then
            warnlog "Wrong number; expected: '" + i + "' and it was: '" + sTemp + "'"
         else
            printlog "Good. We expected number: '" + i + "' and it was number: '" + sTemp + "'"
         endif
      else
         if (sTemp <> right(str(i),1) ) then
            warnlog "Wrong number; expected: '" + i + "' and it was: '" + sTemp + "'"
         else
            printlog "Good. We expected number: '" + i + "' and it was number: '" + sTemp + "'"
         endif
      endif
      hTypeKeys "<Escape><Escape>"
      EditSelectAll
      hTypeKeys "<DELETE>"      
      '/// Insert->Slide ///'
      InsertSlide
      hTypeKeys "<PAGEDOWN>"
      sleep 2
   next i

   InsertFieldsFileName           '///  (file name) ///'
   '///+ additional test for filename ///'
   '///+ save file as "gOfficePath + "user\\work\\fields.sx[i|d]"" ///'
   sFile = ConvertPath (gOfficePath + "user\work\fields.sx"+left(lcase(gApplication),1) )
   hSpeichernUnterKill (sFile)
   sleep 5
   hTypeKeys "<F2>"
   EditSelectAll
   EditCopy
   sTemp = GetClipboard()
   if (sTemp <> sFile) then
      Warnlog "wrong author; expected: '" + sFile + "' is: '" + sTemp + "'"
   else
      Printlog "Author is: '" + sTemp + "'"
   endif
   hTypeKeys "<Escape><Escape>"
   EditSelectAll
   hTypeKeys "<DELETE>"   
   
   '/// close application ///'
   hCloseDocument
endcase

testcase tdInsertSnapPoint_Line
    Dim Wert1 as string
    Dim Wert2 as string
    dim sGridArea as string ' holds the old value from the options
    dim i,z as integer
    dim itemp as integer
    dim iState as integer
    dim iPosition as integer

    '/// new document ///'
    Call hNewDocument

    '/// the snap depends on the snap-grid in tools->options->draw->grid ...->snap range ///'
    '///+  so i will modify the snap range to the maximum of 50 pixel, to be safe, i hope :-) ///'
    '/// Tools->Options ///'
    ToolsOptions
        '/// select Grid tab page in application ///'
        Select Case Ucase(gApplication)
            case "DRAW"         :    hToolsOptions ("Drawing","GRID")
            case "IMPRESS"      :    hToolsOptions ("Presentation","GRID")
        end select
        sGridArea = fangenFangBereich.GetText
        '/// set metric field 'Snap Range' to Maximum ///'
        fangenFangBereich.ToMax
        Kontext "ExtrasOptionenDlg"
        '/// close options dialog with OK ///'
        ExtrasOptionenDlg.OK

    for i = 1 to 3
        '/// new document ///'
        Call hNewDocument

        '/// ContextMenu: Insert SnapPointLine ///'
        InsertSnapPointLine
            Kontext "NeuesFangobjekt"
            '///+ check checkbox 'Type: Point' ///'
            select case i
                case 1: printlog "------- vertical Snap Object"
                        Vertikal.Check
                case 2: printlog "------- horizontal Snap Object"
                        Horizontal.Check
                case 3: printlog "------- Point Snap Object"
                        Punkt.Check
            end select
            '///+ set Metric Field 'Position X' to 5 and get entry from field for further reference ///'
            if (1 AND i) then
                X.SetText "5"
                Wert1=X.GetText
            endif
            '///+ set Metric Field 'Position Y' to 5 and get entry from field for further reference ///'
            if (2 AND i) then
                Y.SetText "5"
                Wert2=Y.GetText
            else
                Wert2=Wert1
            endif
            sleep 2
            '///+ close dialog 'New Snap Object' with OK ///'
            NeuesFangobjekt.OK
            Printlog "SnapPoint x: '"+Wert1+"', y: '"+Wert2+"' created"
            sleep 2

        '/// view->Zoom... ///'
        ViewZoom
            Kontext "Massstab"
            '///+ check radiobutton '75%'  ///'
            Vergroesserung75.Check
            '///+ close dialog 'Zoom' with OK ///'
            Massstab.OK

        '/// create a rectangle ///'
        Call hRechteckErstellen (27,27,80,80)
        sleep 3
        '/// Moove rectangle to test snapping: ///'
        '///+ Format->Position and SIze...  ///'
        ContextPositionAndSize
            Kontext
            '///+ select tabpage 'Position and Size' on dialog 'Position and Size' ///'
            Active.SetPage TabPositionAndSize
            Kontext "TabPositionAndSize"
            '///+ enter saved text into metricfields into 'Position X' and 'Position Y' ///'
            '///+ press more button on metric fields 'Position X' and 'Position Y' ///'
            if (1 AND i) then
                PositionX.SetText Wert1
                sleep 1
                PositionX.More
            endif
            if (2 AND i) then
                PositionY.SetText Wert2
                sleep 1
                PositionY.More
            endif
            '///+ close dialog 'Position and Size' with OK ///'
            TabPositionAndSize.OK
            sleep 2

        '/// move rectangle  ///'
        iState = 0
        for z = 1 to 100
            gmousemove2 z,z
            try
                iTemp = getmousestyle
            catch
                qaerrorlog "OOo-Application was not on top all applications - please move the testtool to the back!"
            endcatch
            if ((0 = iState) and (6 = iTemp)) then
                iState = 1 ' found object
                iPosition = z
                printlog "found: " + z
            endif
            if ((1 = iState) and (6 <> iTemp)) then
                iState = 2 ' left object
                iPosition = (fix (z - iPosition) / 2) + iPosition
                printlog "found: " + z
            endif
        next z
        if (2 <> iState) then
            qaerrorlog "couldn't find object - the following action may fail..."
            iPosition = 60
        endif
            gMousemove (iPosition,iPosition,iPosition + 1,iPosition + 1)
        sleep 4
        '/// check if object snapped back to snap point ///'
        ContextPositionAndSize
        Kontext
            if active.exists (5) then
                Active.SetPage TabPositionAndSize
            else
                warnlog "Couldn't switch tabpage (2), because object was deselected"
                hTypeKeys "<TAB>"
                ContextPositionAndSize
                Kontext
                Active.SetPage TabPositionAndSize
            endif
            Kontext "TabPositionAndSize"
            if (1 AND i) then
                if (PositionX.GetText <> Wert1) Then
                    WarnLog "(1) Rectangle not aligned to snap point. Soll X= "+ Wert1 + "  IST= " + PositionX.GetText
                else
                    PrintLog "(1) Rectangle aligned to snap point. Soll= " + Wert1 + "  Ist= " + PositionX.GetText
                end if
            end if
            if (2 AND i) then
                if (PositionY.GetText <> Wert2) Then
                    WarnLog "(1) Rectangle not aligned to snap point. Soll Y= "+ Wert2 + "  IST= " + PositionY.GetText
                else
                    PrintLog "(1) Rectangle aligned to snap point. Soll= " + Wert2 + "  Ist= " + PositionY.GetText
                end if
            end if
            TabPositionAndSize.OK
        sleep 1

        '/// close application ///'
        Call hCloseDocument
    next i

    ToolsOptions
        Select Case Ucase(gApplication)
            case "DRAW"         :    hToolsOptions ("Drawing","GRID")
            case "IMPRESS"      :    hToolsOptions ("Presentation","GRID")
        end select
        fangenFangBereich.SetText sGridArea
        Kontext "ExtrasOptionenDlg"
        ExtrasOptionenDlg.OK

    '/// close application ///'
    Call hCloseDocument
endcase

testcase tdInsertFile
   dim sTemp as string
   dim sFile as string
   dim i as integer
   dim iCut as integer

   '/// open application ///'
   Call  hNewDocument
   sleep 1
   '///<b> take a text file without .txt extension, to test file regcognition </b>///'
   '/// Insert->File ///'
   InsertFileDraw
      sleep 1
      Kontext "OeffnenDlg"
      '/// use file: "graphics\\level1\\input\\einfg.ini" ///'
      sFile = ConvertPath (gTesttoolPath + "graphics\level1\input\einfg.ini")
      Printlog "file:     '" + sFile + "'"
      Dateiname.SetText (sFile)
      '/// click button 'Insert' ///'
      Oeffnen.Click
         Kontext "SeitenObjekteEinfuegen"
         sleep 3
         '/// expected: dialog 'Insert Slides/Objects' ///'
         if (SeitenObjekteEinfuegen.Exists (5) = False) Then
            warnlog "1  - Dialog 'Insert Slides/Objects' does not exist :-("
            kontext
            ' Text File Path - do it again :-(
            if active.exists (5) then
               printlog "ACTIVE: "+active.gettext
               active.ok
               ' will be wrong next time, bzw support it tooo
               printlog "Have to select the text filter manually, to get file loaded"
               InsertFileDraw
                  sleep 1
                  Kontext "OeffnenDlg"
                  Dateiname.SetText ConvertPath (gTesttoolPath + "graphics\level1\input\einfg.ini")
                  Select Case Ucase(gApplication)
                     case "DRAW"
                        DateiTyp.Select 6 ' hopefully TEXT!
                     case "IMPRESS"
                        DateiTyp.Select 11 ' hopefully TEXT!
                  end select
                  printlog "selected filter: "+DateiTyp.GetSelText
                  Oeffnen.Click
                  kontext
                  if active.exists (5) then
                     printlog "ACTIVE: "+active.gettext
                     active.ok
                     warnlog "failed to open file? :-("
                  endif
            ' Text File Path - dialog is there :-(
            else
               Kontext "AsciiFilterOptionen"
               If AsciiFilterOptionen.Exists(3) then
                  printlog "NO, not loaded (yet): we are in ASCII filter dialog :-("
                  AsciiFilterOptionen.OK
               else
                  warnlog "Now there is a problem :-( 1"
               endif
            endif
            sleep 3
            Kontext "SeitenObjekteEinfuegen"
            if SeitenObjekteEinfuegen.Exists (5) <> TRUE then
               warnlog "Now there is a problem :-( 2"
            else
               Printlog "InsertFile Text-dialogue came up :-) (finaly)"
               SeitenObjekteEinfuegen.OK
               sleep 3
            endif
         ' as expected, file got regcognized and i can select the slides
         else ' the good way with    ' little strange dialog
'*SeitenObjekteEinfuegen   DLG_INSERT_PAGES_OBJS
'DeleteUnusedBackgrounds sd:CheckBox:DLG_INSERT_PAGES_OBJS:CBX_CHECK_MASTERS
            Printlog "1: '" + InsertObjectsList.GetSelText + "'"
            '/// leave dialog 'Insert Slides/Objects' with OK ///'
            SeitenObjekteEinfuegen.OK
            sleep 3
         end if
   '/// select all inserted text, by typing [Strg]+[A] ///'
   EditSelectAll
   try
      '/// Edit->Cut ///'
      EditCut
   catch
      Warnlog "It seems there is nothing inserted :-("
   endcatch
   sleep 1

   '///<b> use a presentation file to test extended capability of dialog </b>///'
   '/// Insert->File ///'
   InsertFileDraw
      sleep 1
      Kontext "OeffnenDlg"
      '/// use file: "graphics\level1\input\diashow.sx[i|d]" ///'
'      sFile = ConvertPath (gTesttoolPath + "graphics\level1\input\diashow.sx"+left(lcase(gApplication),1) )
      sFile = ConvertPath (gTesttoolPath + "graphics\input\diashow.sxi" )
      Printlog "file used : '" + sFile + "'"
      Dateiname.SetText (sFile)
      '/// click button 'Insert' ///'
      Oeffnen.Click
         Kontext "SeitenObjekteEinfuegen"
         sleep 3
         '/// expected: dialog 'Insert Slides/Objects' ///'
         if (SeitenObjekteEinfuegen.Exists (5) = False) Then
            warnlog "unexpected error :-("
         else ' the good way with    ' little strange dialog
'*SeitenObjekteEinfuegen   DLG_INSERT_PAGES_OBJS
'DeleteUnusedBackgrounds sd:CheckBox:DLG_INSERT_PAGES_OBJS:CBX_CHECK_MASTERS
            InsertObjectsList.TypeKeys "<up>"
            sTemp = InsertObjectsList.GetSelText
            if (gPlatgroup <> "unx") then ' to get rid of file://[/] on unix the last '/' belongs too the file path :-(
               iCut = 8
            else
               iCut = 7
            endif
            if (fConvertBackslashToSlash (sFile) = right(sTEmp, len(sTemp)-(iCut))) then
               Printlog " 0:  '" + sTemp + "'"
            else
               Warnlog "different : '" + fConvertBackslashToSlash  (sFile) + "' than '" + right(sTEmp, len(sTemp)-(iCut)) + "'"
            endif
            InsertObjectsList.TypeKeys "<+>"
            sleep 10
            for i = 1 to 4
               InsertObjectsList.TypeKeys "<down>"
               sTemp = InsertObjectsList.GetSelText
               if (right(sTemp,1) <> right (str(i),1)) then
                  warnlog " " + i + ": '" + sTemp + "' is not as expected :-("
               else
                  Printlog " " + i + ": '" + sTemp + "'"
               endif
            next i
            '/// leave dialog 'Insert Slides/Objects' with OK ///'
            SeitenObjekteEinfuegen.OK
            sleep 3
         end if
   kontext "Messagebox" '/// in draw pops a mesbox up, about adopting format for objects, too [yes no cancel] -> say NO '///
   if messagebox.exists (5) then
      printlog "active: '" + messagebox.gettext + "'"
      messagebox.no
   endif
   '/// select the inserted slide content on the last slide, by typing [End] [Strg]+[A] ///'
   hTypeKeys "<end>"
   EditSelectAll
   try
      '/// Edit->Cut ///'
      EditCut
   catch
      Warnlog "It seems there is nothing inserted :-("
   endcatch
   sleep 1

   '/// close application ///'
   Call hCloseDocument
endcase

testcase tInsertGraphics
   dim i as integer

   '/// open application ///'
   Call hNewDocument
   '/// Insert->Graphics ///'
   InsertGraphicsFromFile
      Kontext "GrafikEinfuegenDlg"
      sleep 2
      '/// check number of graphics filter in dialog, should be 27 ///'
      i = Dateityp.GetItemCount
      if (i <> 27) Then
         Warnlog "- Number of filters changed. Should be = 27 / but it is = '" + i + "'"
      endif
      sleep 1
      '/// set file name to "global\\input\\graf_inp\\enter.bmp" ///'
      Dateiname.SetText ConvertPath (gTesttoolPath + "global\input\graf_inp\enter.bmp")
      sleep 3
      '/// check checkbox 'Preview' ///'
      Preview.Check
      sleep 5
      '/// click button 'open' ///'
      Oeffnen.Click
   sleep 5
   Kontext "Active"
   if Active.Exists Then
      Warnlog Active.GetText
      Active.OK
   end if
   try
      '/// to check if something was inserted, try Edit->Cut and Edit->Paste ///'
      EditCut
      sleep 3
      EditPaste
      sleep 3
   catch
      WarnLog "  Nothing was created, so EditCut does not work ?"
   endcatch
   sleep 2
   '/// close application ///'
   Call hCloseDocument
 'TODO: TBO: Check if link graphic would work!"
endcase

testcase tInsertObjectApplet
   '/// open application ///'
   Call hNewDocument
   '/// Insert->Object->Applet ///'
   sleep 1
   InsertObjectApplet
      Kontext "AppletEinfuegen"
      '/// press button 'Search' ///'
     sleep 2
      Suchen.Click
         Kontext "OeffnenDlg"
         '/// set filename to 'global\\input\\java\\rocket.class' ///'
         Dateiname.SetText ConvertPath (gTesttoolPath + "global\input\java\Clock.class")
         '/// close dialog 'Open' by pressing 'Open' ///'
         sleep 2
         Oeffnen.Click
      Kontext "AppletEinfuegen"
      '/// close dialog 'Insert Applet' by pressing OK ///'
      sleep 2
      AppletEinfuegen.OK
   sleep 3
   '/// deselect object by typing key [Escape] ///'
   hTypeKeys ("<Escape>")
   sleep 3
   try
      '/// Edit->Select All ///'
      EditSelectAll
      '/// delete object by typing key [Delete] ///'
      sleep 3
      hTypeKeys "<DELETE>"
   catch
      Warnlog "Delete did not work, maybe some error while creating the object before"
   endcatch
   sleep 1
'   gMouseclick 70,70
   '/// close application ///'
   Call hCloseDocument
endcase

testcase tInsertObjectFormula
   '/// open application ///'
   Call hNewDocument
   '/// put '1+2+3+4+5+6+7+8+9=x' into the Clipboard ///'
   SetClipboard "1+2+3+4+5+6+7+8+9=x"
   '/// Insert->Object->Formula ///'
   InsertObjectFormulaDraw
   sleep 1
   '/// put Clipboard into window 'Commands' with Edit->Paste ///'
   EditPaste
   sleep 2
   '/// check if window 'Selection' exists -> if not ERROR & open window with View->Selection ///'
   Kontext "AuswahlMath"
   if AuswahlMath.Exists Then
      printlog "  - selection is visible :-) "
   else
      ViewSelection
      printlog "  - selection wasn't visible :-( "
      Kontext "AuswahlMath"
      if (AuswahlMath.Exists = FALSE) Then
         warnlog "  - selection is STILL not visible :-) "
      endif
   endif
   sleep 5
   Kontext "AuswahlMath"
   sleep 3
   if AuswahlMath.Exists Then
      AuswahlMath.Close
      PrintLog "Formel: " + GetClipboardText + " placed into document"
   else
      Warnlog " Selection-window doesn't exist"
   end if
   gMouseClick   10,10
   '/// close application ///'
   hCloseDocument
endcase

testcase tInsertChart
   dim sTemp as string

   '/// open application ///'
   Call hNewDocument
   '/// Insert->Chart ///'
   InsertObjectChart
   sleep 5
   '/// now to check we are in Chart mode, trie Insert->Title ///'
   InsertTitle
      Kontext "Titel"
      '/// type something in field 'Main Title' ///'
      HaupttitelText.SetText "Koelner Dom Koelsch"
      PrintLog HaupttitelText.GetText
      '/// Close dialog 'Title' ///'
      Titel.OK
   '/// click outside the chart, to get out of chart mode ///'
   gMouseClick 10,10
   try
      InsertTitle
      Kontext "Titel"
      if Titel.exists then
         Warnlog "edit mode of chart was not left :-("
      else
         Warnlog "edit mode of chart was not left :-("
      endif
      Titel.Cancel
   catch
      Printlog "edit mode of chart left :-)"
   endcatch
   '/// go into edit mode of chart again, by typing [Tab][Return] ///'
   hTypeKeys "<tab><return>"
   '/// now to check we are in Chart mode, trie Insert->Title ///'
   InsertTitle
      Kontext "Titel"
      sTemp = HaupttitelText.GetText
      if (sTemp <> "Koelner Dom Koelsch") then
         Warnlog "title changed :-( is: '" + sTemp + "'; should: '" + "Koelner Dom Koelsch" + "'"
      endif
      Titel.Cancel
   '/// click outside the chart, to get out of chart mode ///'
   gMouseDoubleClick 10,10
   '/// close application ///'
   Call hCloseDocument
endcase

testcase tInsertObjectPlugIn
   dim i,x as integer
   dim bAble as boolean
   dim sTemp as string

   '/// open application ///'
   call hNewDocument
   sleep 2
   '/// Insert->Object->Plug-in///'
   InsertObjectPlugIn
      sleep 2
      Kontext "PlugInEinfuegen"
      '/// click on button 'Browse...' ///'
      Durchsuchen.Click
      sleep 2
      kontext "OeffnenDLG"
         sleep 1
         bAble = FALSE
         x = Dateityp.GetItemCount
         Printlog "-------TBO: print all entries from File-Type-List: "
         for i = 1 to x
            sTemp = Dateityp.GetItemText (i)
            printlog "- - - - -: '"+ sTemp +"'"
            if (inStr(sTemp, ".mov") > 0) then
               bAble = True
               Printlog "^^^^^^^^^^^^^^^^^^ contains a Apple QT plugin .mov :-) "
            endif
         next i
         Printlog "---------------------------------------------------"
         OeffnenDLG.cancel
         Kontext "PlugInEinfuegen" ' :-)
      '/// if .mov files are regcognized, insert the folowing one; else cancel dialog!///'
      if bAble then
            '///+ set field 'File/URL' to 'graphics\\input\\sample.mov' ///'
            DateiUrl.SetText ConvertPath (gTesttoolPath + "graphics\input\sample.mov")
            '///+ press button 'OK' to close dialog ///'
            PlugInEinfuegen.OK
         sleep 2
         Kontext "Active"
         if Active.Exists then
            printlog Active.GetText
            Active.OK
            sleep 1
         end if
         '///+ click outside the inserted frame ///'
         gMouseClick 30,30
         try
            '///+ check with 'Edit->Select all' and key [delete] if something was inserted ///'
            EditSelectAll
            hTypeKeys "<DELETE>"
         catch
            Warnlog " Nothing inserted which could be deleted"
         endcatch
      else
         qaErrorLog "Not able to test the insertion of a plugin, because no ability to play .mov files is available :-("
         PlugInEinfuegen.Cancel
      endif
   '/// close application ///'
   hCloseDocument
endcase

testcase tInsertSpecialCharacter
   Dim i, j, Zaehler as integer
   Dim sSchriftType, Zufall as Integer
   dim sTemp as string

   '/// open application ///'
   Call hNewDocument

   '/// insert a text frame with content ///'
   hTextRahmenErstellen ("Who will read this?",30,30,80,80)
   '///<b> Insert->Special Character... </b>///'
   InsertSpecialCharacterDraw
   Kontext "Sonderzeichen"
   '/// select a character for every 'font' ///'
   j = Schrift.GetItemCount
   For i = 1 to j
      Schrift.Select j
      Zufall = Int((12*Rnd)+1)
      '///+ to insert a character, randomize the type keys [Cursor Right] and press [Space] ///'
      SchriftListe.TypeKeys "<RIGHT>" , Zufall
      SchriftListe.TypeKeys "<SPACE>"
   next i
   sleep 1
   '/// press button [Delete] ///'
   Loeschen.Click '----------------------------------- > NOTHING is inserted !!
   sleep 1
   try
      '/// tries to close dialog 'Special Characters' with OK ///'
      Sonderzeichen.OK
      Warnlog "Dialogue need not to be closeable, because nothing is selected :-("
   catch
      '/// close dialog with 'Cancel' ///'
      Sonderzeichen.Cancel
   endcatch
   sleep 1
   '/// select something with keys [Shift]+[Home] ///'
   hTypeKeys "<SHIFT HOME>"
   '/// Edit->Copy ///'
   EditCopy
   sTemp = GetClipboardText
   '/// Compare the selected text with the  one typed at the beginning - it has to be the same ///'
'   if  (sTemp <> "Who will read this?") then
'      Warnlog "Hmm, there is something wrong! But what? :-( "
'      printlog "is: '" + sTemp + "'; should: '" + "Who will read this?" + "'"
'   endif
   sleep 2
   hTypeKeys "<end>"

'   '///<b> select a character for every 'font' </b>///'
'   j = Schrift.GetItemCount
   For i = 1 to j
      '/// Insert->Special Character... ///'
      InsertSpecialCharacterDraw
      Kontext "Sonderzeichen"
      sleep 1
      try
          Schrift.Select i
      catch
          qaErrorLog("Sometimes this Timeout happens: " + i )
      endcatch
      Printlog "(" + i + "/" + j + "): '" + Schrift.GetSelText + "'"
      sleep 1
      Zufall = Int((256*Rnd)+1)
      '///+ to insert a character, randomize the type keys [Cursor Right] and press [Space] ///'
      SchriftListe.TypeKeys "<home>"
      SchriftListe.TypeKeys "<RIGHT>" , Zufall
      SchriftListe.TypeKeys "<SPACE>"
      sleep 1
      try
         '/// trie to close dialog 'Special Characters' with OK ///'
         Sonderzeichen.OK
      catch
         '/// close dialog with 'Cancel' ///'
         Warnlog "Dialog was not closeable with OK :-("
         Sonderzeichen.Cancel
      endcatch
      sleep 2
   next i
   '/// select the inserted chars with keys with keys [Strg]+[End] + j-times [shift]+[right] ///'
   hTypeKeys "<Mod1 end>"
   hTypeKeys ("<shift left>", j)
   '/// Edit->Copy ///'
   EditCut
   '/// now select the rest with keys [Shift]+[Home] ///'
   hTypeKeys "<SHIFT HOME>"
   '/// Edit->Copy ///'
   EditCopy
   sTemp = GetClipboardText
   '/// Compare the selected text with the  one typed at the beginning - it has to be the same ///'
   if  (sTemp <> "Who will read this?") then
      qaerrorlog "is: '" + sTemp + "'; should: '" + "Who will read this?" + "'"
   endif
   sleep 2
   hTypeKeys "<end>"

   '///<b> Insert->Special Character... </b>///'
   InsertSpecialCharacterDraw
   Kontext "Sonderzeichen"
   sleep 3
'   '/// select a character for every 'font' ///'
'   j = Schrift.GetItemCount
   For i = 1 to j
     Zufall = Int((256*Rnd)+1)
     Schrift.Select i
      sleep 5
      Printlog "(" + i + "/" + j + "): '" + Schrift.GetSelText + "'; " + Zufall
      sleep 3
      '///+ to insert a character, randomize the type keys [Cursor Right] and press [Space] ///'
      SchriftListe.TypeKeys "<RIGHT>" , Zufall
      SchriftListe.TypeKeys "<SPACE>"
      sleep 3
   next i
   sleep 1
   try
      '/// tries to close dialog 'Special Characters' with OK ///'
      Sonderzeichen.OK
   catch
      '/// close dialog with 'Cancel' ///'
      Warnlog "Dialogue was not closeable with OK :-("
      Sonderzeichen.Cancel
   endcatch
   sleep 2
   '/// close application ///'
   Call hCloseDocument
endcase

testcase tInsertSpreadsheet
   '/// open application ///'
   Call hNewDocument
   sleep 3
   '/// Insert->Spreadsheet ///'
   InsertSpreadsheetDraw
   sleep 2
   try
      '/// Spreadsheet is in edit mode per default ///'
      '/// Format->Sheet->Rename ///'
      FormatSheetRename
      Kontext "TabelleUmbenennen"
      '/// close dialog 'Rename Sheet' with OK ///'
      TabelleUmbenennen.OK
   catch
      WarnLog "Spreadsheet is not in editmode :-( "
   endcatch
   '/// delete spreadsheet OLE by typing [DELETE] (first click outside the spreadsheet!) ///'
   gMouseClick (1,1)
   hTypeKeys "<tab>"
   sleep 3
   hTypeKeys "<DELETE>"
   sleep 2
   '/// close application ///'
   hCloseDocument
endcase

function fConvertBackslashToSlash (sInput as string) as string
   dim i as integer
   dim sTemp as string
   dim sI as string
   dim x as integer

   sTemp = ""
   x = len (sInput)
   for i = 1 to x
      sI = mid(sInput, i, 1)
      if (sI = "\") then
         sI = "/"
      endif
      sTemp = sTemp + sI
   next i
   fConvertBackslashToSlash = sTemp
end function

function hScreenFontAntialiasing (bEnable as boolean) as boolean
   ToolsOptions
   hToolsOptions ("STAROFFICE", "VIEW")
   hScreenFontAntialiasing = FontAntiAliasing.IsChecked
   if (bEnable) then
      FontAntiAliasing.Check
   else
      FontAntiAliasing.Uncheck
   endif
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
end function
