'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: t_basic.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:09:15 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Check basic functions in testtool
'*
'***************************************************************************
' #1 CheckCommand_Join() as boolean ' Checks the function Join
' #1 CheckCommand_Split() as boolean ' Check the function Split
'\**************************************************************************


function CheckCommand_Join() as boolean
 Dim BlaBla(10) As String, Test As String
 Dim i As Integer

'/// Syntax: ///
'/// Join(list[, delimiter]) ///
'/// list (Required) ///
'/// One-dimensional array containing substrings to be joined. ///

'/// delimiter (Optional) ///
'/// String character used to separate the substrings in the ///
'/// returned string. If omitted, the space character (" ") ///
'/// is used. If delimiter is a zero-length string (""), all ///
'/// items in the list are concatenated with no delimiters. ///
'/// Checks this function and returns 'True' if it worked ///

 For i = 0 To 10
  BlaBla(i) = "This is Number" & i
 Next i

 Test = Join(BlaBla(), "|")
 if Test <> "This is Number0|This is Number1|This is Number2|This is Number3|This is Number4|This is Number5|This is Number6|This is Number7|This is Number8|This is Number9|This is Number10" then
  CheckCommand_Join = False
 else
  CheckCommand_Join = True
 endif

end function



function CheckCommand_Split() as boolean
 '/// Syntax: ///
 '/// Split(expression[, delimiter[, count]]) ///
 '/// expression (Required) ///
 '///     String expression containing substrings and delimiters. If ///
 '///     expression is a zero-length string, Split returns an empty ///
 '///     array, that is, an array with no elements and no data. ///

 '/// delimiter (Optional) ///
 '/// String character used to identify substring limits. If omit- ///
 '/// ted, the space character (" ") is assumed to be the delimi- ///
 '/// ter. If delimiter is a zero-length string, a single-element ///
 '/// array containing the entire expression string is returned. ///

 '/// count (Optional) ///
 '/// Number of substrings to be returned; -1 indicates that all  ///
 '/// substrings are returned. ///

 '/// Checks this function and returns 'True' if it worked ///

 Dim BlaBla(10) As String, Test As String
 Dim i As Integer, CheckTest() as string

 For i = 0 To 10
  BlaBla(i) = "This is Number" & i
 Next i

 Test = Join(BlaBla(), "|")
 if Test <> "This is Number0|This is Number1|This is Number2|This is Number3|This is Number4|This is Number5|This is Number6|This is Number7|This is Number8|This is Number9|This is Number10" then
  CheckCommand_Split = False
 else
   CheckTest = Split(Test,"|")
   if Ubound(CheckTest) <> 10 then
    CheckCommand_Split = False
   else
    CheckTest = Split(Test,"|",5)
    if Ubound(CheckTest) <> 4 then
     CheckCommand_Split = False
    else
     CheckCommand_Split = True
    endif
   endif
 endif

end function
