'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: accels.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/11 11:19:51 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : handle accelerators
'*
'*******************************************************************************
'**
' #1 hGetAccel    ' function to retrieve a language specific accelerator 
'**
'\******************************************************************************

function hGetAccel( cCommand as string ) as string

    '///<h3>Retrieve a keyboard accelerator for a specific function</h3>
    '///<i>Uses: framework/tools/input/accelerators.txt</i><br>
    '///<i>NOTE: Accelerator is language dependent</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>name of the action to be executed (string). Valid options are:</li>
    '///<ul>
    '///+<li>&quot;FileOpen&quot;</li>
    '///+<li>&quot;FileSave&quot;</li>
    '///+<li>&quot;Print&quot;</li>
    '///+<li>&quot;SelectAll&quot;</li>
    '///+<li>&quot;DocumentConverter_ShowLog&quot;</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Accelerator (string)</li>
    '///<ul>
    '///+<li>A string ready to use by .typeKeys(...) method</li>
    '///+<li>&quot;Error&quot; if the requested Accelerator is unknown</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    const CFN = "hGetAccel::"

    dim cAccel as string
    dim lsAccelerators( 200 ) as string
    dim cFile as string
        cFile = gTesttoolpath & "framework/tools/input/accelerators.txt"
        cFile = convertpath( cFile )

    cCommand = ucase( cCommand )

    '///+<li>get the section from the accelerators file</li>
    hGetDatafileSection( cFile , lsAccelerators() , cCommand , "" , "" )

    '///+<li>find the matching string for the current language (cast int -> string)</li>
    cAccel = hGetValueForKeyAsString( lsAccelerators() , iSprache )

    '///+<li>in case we did not define the value, hGetValueForKeyAsString returns an errorstring</li> 
    if ( instr( cAccel , "Error" ) <> 0 ) then
        warnlog( CFN & cAccel & " - defaulting to en_US" )
        cAccel = hGetValueForKeyAsString( lsAccelerators() , 1 )
    endif

    '///+<li>build the complete accelerator-string so it can be used by "TypeKeys"</li>
    '///+<li>print it to the log and return the string to the calling function</li>
    
    cAccel = "<" & cAccel & ">"
    printlog( CFN & "Requested accelerator:" & cAccel )
    hGetAccel() = cAccel
    '///</ul>

end function
