'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_folders1.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsk $ $Date: 2006/06/07 09:08:58 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'*******************************************************************************
' **
' #1 tFolder1                           ' create folders with different names ( 'new folder'-button )
' **
'\******************************************************************************

testcase tFolder1

   '///<h1>Level 1 test: Create new folders from the File Open dialog</h1>
   Dim VerList(50) as String
   dim FULLPATH as string
       FULLPATH = gOfficePath + "user\work\"
   
   '///<ul>    
   printlog " - cleanup the output-dir, kill all directories."
    
   '///+<li>Delete all directories in [testtool-path]\framework\filedlg\output\*</li>
   GetDirList ( ConvertPath ( FULLPATH ), "*" , VerList() )
   KillDirList ( VerList() )

   '///+<li>Either click on &quot;FileOpen&quot; or use the menu to get there</li>
   FileOpen
   
   'This is a hack to prevent trouble when opening 'FileOpen' and the path
   'is not accessible. 
   '///+<li>Handle possible errormessages (path not accessible)</li>
   Kontext "Active"
   if Active.Exists( 1 ) then
      Warnlog "The preset path is invalid, a messagebox has been shown."
      Active.OK()
      endif
      
   '///+<li>Insert the pathname into the filename field</li>
   Kontext "OeffnenDlg"
   Dateiname.SetText( ConvertPath ( FULLPATH ) )
   Oeffnen.Click()
   
   
   '///+<li>click on 'new folder', insert as name 'z' and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername with only one character"
   CreateValidDirectory( "z" )


   '///<li>click on 'new folder', insert as name '1234' and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername only with numbers"
   CreateValidDirectory( "1234" )
  

   '///+<li>click on 'new folder', insert as name 'xaxaxaxa' ( 8 characters ) and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername with 8 characters"
   CreateValidDirectory( "xaxaxaxa" )

  
   '///+<li>click on 'new folder', insert as name 'yxyxyxyx.aaa' ( 8.3 characters ) and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername with 8.3 characters"
   CreateValidDirectory( "yxyxyxyx.aaa" )   

  
   '///+<li>click on 'new folder', insert as name 'yxyxyxyxyxyx.aaabbb' ( more than 8.3 characters ) and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername with more than 8.3 characters"
   CreateValidDirectory( "yxyxyxyxyxyx.aaabbb" )

  
   '///+<li>click on 'new folder', insert as name 'hälölüle' ( with special characters - umlauts ) and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername with special charaters ( umlauts )"
   CreateValidDirectory( "hälölüle" )
  
   
   '///+<li>click on 'new folder', insert as name 'aa bb' ( with spaces in the middle ) and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername with one whitespace in the middle"
   CreateValidDirectory( "aa bb" )
  

   '///+<li>click on 'new folder', insert as name ' ccdd' ( with leading spaces ) and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername with leading spaces"
   CreateValidDirectoryCrop( " lead" , "lead" )

   
   '///+<li>click on 'new folder', insert as name 'ddee ' ( with spaces at the end ) and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername with trailing spaces"
   CreateValidDirectoryCrop( "trail " , "trail" )
   

   '///+<li>click on 'new folder', insert as name 'Here is a dir with spaces' ( with more spaces ) and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername with more spaces"
   CreateValidDirectory( "here is a dir with spaces" )   

   
   '///+<li>click on 'new folder', insert as name '??++!!' ( with forbidden signes on windows ) and click OK<br>
   '///+ Verify that the folder was created ( if yes -> kill it )</li>
   printlog " - foldername with forbidden signes ( ?+! ) - only on windows they are forbidden"
   CreateInvalidDirectory( "??++!!" )   

	'///+<li>Cancel the File Open dialog</li>
   Kontext "OeffnenDlg"
   OeffnenDlg.Cancel()
   '///</ul>
   
endcase
