'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg5.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'*******************************************************************************
' **
' #1 tUpOneLevel1                       ' click 'up one level' 10 times and control the results
' #1 tUpOneLevel2            'wrn:1     ' go up one level with '..' 10 times and control the results
' #1 tUpOneLevel3                       ' jump to the root with '/' or '\' and control the result
' #1 tUpOneLevel4                       ' control the items under 'up one level'-button
' **
'\*****************************************************************************

testcase tUpOneLevel1

   '///10 times 'up one level'

   Dim i as Integer
   Dim sEntry as String, sIsEntry as String

   '///file/open
   '///+ open [Testtoolpath]\framework\filedlg\input\filetest\level1\level2\level3
   FileOpen

   Kontext "OeffnenDlg"
   Sleep (1)
   Dateiname.SetText ConvertPath ( gTesttoolPath + "framework\filedlg\input\filetest\level1\level2\level3" )
   Oeffnen.Click()
   Sleep (2)
   printlog "- click 15 times on the button 'up one level' in the filedialog"
   '///+click 15 times on 'up one level'-button and check in which directory you are
   for i=1 to 15
      try
         UebergeordneterOrdner.Click()
      catch
         if i < 9 then Warnlog "The button 'up one level' isn' active => BUG!"
      endcatch
      Sleep (2)

      sEntry = GetFirstNameOfFileList
      select case i
         case 1 : sIsEntry = "level3"
         case 2 : sIsEntry = "level2"
         case 3 : sIsEntry = "level1"
         case 4 : sIsEntry = "alldocs"
         case 5 : sIsEntry = "inc"
         case 6 : sIsEntry = "basic"
      end select
      if i < 7 then
         if sEntry <> sIsEntry then Warnlog "Error at i=" + i + " : entry is not '"+sIsEntry + "', it is '"+ sEntry + "'"
      end if
   next i
   Sleep (1)
   OeffnenDlg.Cancel()

endcase

'*******************************************************************************

testcase tUpOneLevel2

   '///go up one level with '..' in the filename-field ( 11 times )

   Dim i as Integer, iDir as Integer
   Dim sEntry as String, sIsEntry as String, sPathName as String
   Dim lsList(50) as String
   Dim nErr as Boolean

   nErr = FALSE

   '///file open
   FileOpen
   Kontext "OeffnenDlg"
   Sleep (1)

   '///+ open [Testtoolpath]\framework\filedlg\input\filetest\level1\level2\level3
   printlog "- 15 times one level higher with '..'"
   sPathName = ConvertPath ( gTesttoolPath + "framework\filedlg\input\filetest\level1\level2\level3" )
   iDir = DirNameList ( sPathName, lsList() )
   Dateiname.SetText( sPathName )
   Oeffnen.Click()
   Sleep (2)

   '///+insert '..' as filename and press the open-button 15-times and check in which directory you are
   for i=1 to ( iDir + 5 )
      Dateiname.SetText ".."
      Oeffnen.Click
      Sleep (2)

      kontext "Active"
      If Active.Exists then
         if i < iDir then
            Warnlog "You cannot jump to the root of a volume with '..' -> BugID:96274"
            nErr = TRUE
         else
            Warnlog "Repetition " + i + " : An messagebox comes up! => perhaps BugID:96274"
         end if
         printlog "The text of the messagebox is :"
         printlog Chr(13) + Active.GetText + Chr(13)
         Active.OK
         i=iDir + 10
      else
         Kontext "OeffnenDlg"
         sEntry = GetFirstNameOfFileList
         select case i
            case 1 : sIsEntry = "level3"
            case 2 : sIsEntry = "level2"
            case 3 : sIsEntry = "level1"
            case 4 : sIsEntry = "alldocs"
            case 5 : sIsEntry = "inc"
            case 6 : sIsEntry = "basic"
            case 7 : sIsEntry = "errorlog"
            case 10 : sIsEntry = sEntry
         end select
      end if
      if i < 7 then
         if sEntry <> sIsEntry then Warnlog "Error at i=" + i + ": entry is not '"+sIsEntry + "', it is '"+ sEntry + "'"
      end if

   next i
   Sleep (1)

   Kontext "OeffnenDlg"
   OeffnenDlg.Cancel()

endcase

'*******************************************************************************

testcase tUpOneLevel3

   '///go to the root with '/' or '\'

   Dim i as Integer, j as Integer
   Dim sEntry as String, sIsEntry as String

   '///file open
   FileOpen
   Kontext "OeffnenDlg"
   Sleep (1)

   '///+ open [Testtoolpath]\framework\filedlg\input\filetest\level1\level2\level3
   '///+insert '\' as filename and press the open-button 4-times and check if you are in the root of the volume
   '///+ open [Testtoolpath]\framework\filedlg\input\filetest\level1\level2\level3
   '///+insert '/' as filename and press the open-button 4-times and check if you are in the root of the volume

   ' File-checking is only performed on first run
   ' i = 2, 3 or 4 probably exist because there once was a bug that crashed the
   ' office if '/' was opened several times

   for j=1 to 2

      Dateiname.SetText( ConvertPath ( gTesttoolPath + "framework\filedlg\input\filetest\level1\level2\level3" ) )
      Oeffnen.Click()
      sIsEntry = GetFirstNameOfFileList()
      Sleep (2)

      for i=1 to 4

         if j=1 then
            printlog( " - 4 times jump to the root with '\': " + i )
            Dateiname.SetText( "\" )
         end if

         if j=2 then
            printlog( " - 4 times jump to the root with '/': " + i )
            Dateiname.SetText( "/" )
         end if

         Oeffnen.Click()

         Kontext "Active"
         if ( j = 1 AND gPlatGroup = "unx" ) then
            if Active.Exists() then Active.OK()
         else
            if Active.Exists() then
               Warnlog( Active.GetText() )
               Active.OK()
            end if
         end if

         Kontext "OeffnenDlg"
         Sleep (2)
         sEntry = GetFirstNameOfFileList()

         if i=1 then 'problems should preferably be encountered at first run
            if sEntry = sIsEntry then 'The directory/file has not changed
               if( gPlatGroup <> "unx" )then ' ... on UNIX this is OK
                  warnlog( "The jump to the root gave an error!" )
                  printlog( "Current entry differs from the former: " + sEntry )
               else
                  printlog( " - UNIX doesn't accept '\'. Good." )
               endif
               i=4 'break the loop on first error
            end if
            sIsEntry = sEntry
         else
            if sEntry <> sIsEntry then
               Warnlog ( "The jump to the root gave an error!" )
               printlog( "The entry is" + sEntry )
               printlog( "but it should be " + sIsEntry )
            endif
         end if

      next i

   next j

   Sleep (1)
   OeffnenDlg.Cancel()

endcase

'*******************************************************************************

testcase tUpOneLevel4
'///check all entries under the 'up one level'-button
 Dim i as Integer, iSoll as Integer, iSCount as Integer
 Dim sEntry as String

'///file open
   FileOpen
   Kontext "OeffnenDlg"
   Sleep (1)

'///+open the menu on the 'up one level'-button
'///+click on the first entry until there is no entry
'///+check each time if you are in the correct directory

  printlog "- check all entries under the 'up one level'-button"
   Dateiname.SetText ConvertPath ( gTesttoolPath + "framework\filedlg\input\filetest\level1\level2\level3" )
   Oeffnen.Click
   Sleep (2)

   UebergeordneterOrdner.Open
   Sleep (1)
   iSoll = hMenuItemGetCount
   iSCount = 9 ' there have to be at least 9 entries! (all other depends if you mount via /net or something different!)
   if iSoll < iSCount then
      if iSoll = ( iSCount-1 ) then
         if gPlatgroup = "w95" then
            Warnlog "The entry for the workplace ( 'my computer' ) is missing!"
         else
            Warnlog "Can't open the root for this UNIX-mashine!"
         end if
      else
         Warnlog "There are " + iSoll + " entries in the list, but there have to be " + iSCount + "!"
      end if
   end if

  printlog "- activate each entry"
   for i=1 to iSoll-1
      Sleep (2)
      hMenuSelectNr ( 1 )
      Sleep (2)
      UebergeordneterOrdner.Open
      Sleep (2)
      if hMenuItemGetCount <> ( iSoll -i ) then Warnlog "The entries unter the button now are wrong: shoud " & iSoll-i & "   is " + hMenuItemGetCount
   next i
   hMenuSelectNr ( 1 )
   Sleep (2)

   if iSoll = 8 then
      UebergeordneterOrdner.Click
      Sleep 2
   end if
   try
      UebergeordneterOrdner.Click
      Warnlog "The button is disabled, although we are not in the root of the system!"
   catch
   endcatch

   Sleep (2)
   OeffnenDlg.Cancel

endcase

