'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_formcontrols_common.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsk $ $Date: 2006/05/18 13:22:55 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Common properties for all formcontrols
'*
'*******************************************************************************
'**
' #1 tCommonFormControls  ' Set and verify properties common for all controls
' #1 hSetCommonProperties ' Set properties for a control
' #1 hGetCommonProperties ' Get and verify properties for a control
'**
'\******************************************************************************

testcase tCommonFormControls

    '///<H1>Set and verify properties common for all controls</H1>
    '///<ul>

    const SVERSION = "680" ' major office version
    const CFN = "tCommonFormControls::"
    const CMODULE = "tcommon" 

    dim brc as boolean ' multi purpose returncode
    dim sFile as string
        sFile = hGetBasicWorkFile( SVERSION )

    dim lsControlNames( 30 ) as string

    dim iCurrentControl as integer
    dim sCurrentControl as string
    dim iCurrentProperty as integer
    
    ' file might exist, leftover by prior run
    '///+<li>Init: Cleanup possible leftovers from prior run</li>
    hDeleteFile( sFile )

    '///+<li>Set gApplication to WRITER (only tested application)</li>
    gApplication = "WRITER"  ' we only look at the writer for now.

    ' get a new document (2 open then), verify
    '///+<li>Create a new document</li>
    hCreateDocument()
    
    '///+<li>Create a new module, create a new dialog, open macro controls float</li>
    brc = hInitFormControls( CMODULE )
    if ( not brc ) then
        printlog( CFN & "Aborting due to previous errors." )
        call hCloseDocument()
        goto endsub
    endif

    '///+<li>Draw all 21 controls to a dialog</li>
    '///<ul>
    for iCurrentControl = 1 to ICONTROLCOUNT - 1  

        '///+<li>Draw the control</li>
        sCurrentControl = hDrawControlOnDialog( iCurrentControl )
        
        '///+<li>Select the control</li>
        hSelectControl( iCurrentControl )
        
        '///+<li>Open Property Browser</li>
        hOpenPropertyBrowser()
        
        '///+<li>Make sure we are on the properties page</li>
        hSetPBTabPage( 1 )
        
        '///+<li>Change common properties</li>
        hSetCommonProperties( iCurrentControl )
        
        '///+<li>Close Property Browser</li>
        hClosePropertyBrowser()
            
    next iCurrentControl
    '///</ul>
    
    '///+<li>Close the Basic IDE</li>
    hCloseBasicIde()
    
    '///+<li>Save the file for later usage</li>
    hSaveFile( sFile , "" , false , false )
    
    '///+<li>Close the document</li>
    hDestroyDocument()
    
    '///+<li>Reload the docuement via FileOpen</li>
    hLoadFile( sFile )
    
    '///+<li>Handle the expected security warning</li>
    hHandleSecurityWarning()
    
    '///+<li>Open Basic Macro Organizer, select the document and its module</li>
    hSelectTheLastModule( true )
    
    '///+<li>Click &quot;Edit...&quot;_</li>
    Bearbeiten.click()
    
    '///+<li>Find the dialog</li>
    hFindFirstDialog()
    
    '///+<li>Open the Macro controls float</li>
    hShowMacroControls()
    
    '///+<li>Run through all controls and verify the settings</li>
    '///<ul>
    for iCurrentControl = 1 to ICONTROLCOUNT - 1
        
        '///+<li>Select the control</li>
        hSelectControl( iCurrentControl )
        
        '///+<li>Open the property browser</li>
        hOpenPropertyBrowser()
        
        '///+<li>Verify the settings for the common controls</li>
        hGetCommonProperties( iCurrentControl )
        
        '///+<li>Close the Property Browser</li>
        hClosePropertyBrowser()
            
    next iCurrentControl
    '///</ul>

    '///+<li>Close the Basic IDE</li>
    hCloseBasicIde()
    
    '///+<li>Close the document</li>
    hDestroyDocument()
    
    '///+<li>Delete the file</li>
    hDeleteFile( sFile )
    '///</ul>

endcase

'******************************************************************************

function hSetCommonProperties( iIndex as integer ) as boolean

    '///<h3>Set some values for the properties all form controls have in common</h3>
    '///<i>Starting point</i>: Property browser must be open for selected control<br><br>
    '///<u>Input value(s):</u><br>
    '///<ol>

    '///+<li>Index (Integer) as specified in formcontrols.inc</li>
    '///<ul>
    '///+<li>Values between 1 and 21 are allowed</li>
    '///</ul>
    '///</ol>


    '///<u>Return Value:</u><br>
    '///<ol>
    '///+<li>Errorcondition (Boolean)</li>
    '///<ul>
    '///+<li>TRUE if all is ok</li>
    '///+<li>FALSE on invalid function parameter</li>
    '///+<li>FALSE if Property Browser is not open</li>
    '///+<li>FALSE if any control could not be accessed</li>
    '///</ul>
    '///</ol>

    const CFN = "hSetCommonProperties::"
    dim iBreakPos as integer
    
    '///<u>Description:</u>
    '///<ul>    
    
    kontext "TabGeneralControl"
    
    '///+<li>Verify function parameter validity</li>
    if ( ( iIndex < 1 ) or ( iIndex > ICONTROLCOUNT -1 ) ) then
        warnlog( CFN & "Invalid index passed to function, aborting" )
        hSetCommonProperties() = false
        exit function
    endif
    
    '///+<li>Verify that the control NameText is visible (Property browser is open)</li>
    if ( not NameText.exists() ) then
        warnlog( CFN & "Unable to access properties, aborting" )
        hSetCommonProperties() = false
        exit function
    endif    
    
    try
        iBreakPos = 0
        '///+<li>Set &quot;NameText&quot;</li>
        NameText.setText( "MyControl" & iIndex )
        
        iBreakPos = 1 
        '///+<li>Select entry 2 for control &quot;Enabled&quot;</li>
        Enabled.select( 2 )
        
        iBreakPos = 2
        '///+<li>Select entry 2 for control &quot;Printable&quot;</li>
        Printable.select( 2 )
        
        iBreakPos = 3
        '///+<li>Enter some text into &quot;HelpText&quot;</li>
        HelpText.setText( "MyHelpText" & iIndex )
        
        iBreakPos = 4
        '///+<li>Enter an URL into &quot;HelpUrl&quot;</li>
        HelpUrl.setText( "http://www.sun.com" )
        
        iBreakPos = 5
        '///+<li>Enter some text into &quot;Information&quot;</li>
        Information.setText( "My Additional Information " & iIndex )
        
    catch
        warnlog( CFN & "Failed to access a control after Pos " & iBreakPos )
        hSetCommonProperties() = false
        exit function
    endcatch
    
    '///+<li>Print status to logfile</li>
    printlog( CFN & "Success" )
    hSetCommonProperties() = true
    '///</ul>
    
end function
        
'*******************************************************************************

function hGetCommonProperties( iIndex as integer ) as boolean

    '///<h3>Get some values for the properties all form controls have in common</h3>
    '///<i>Starting point</i>: Property browser must be open for selected control<br>
    '///<i>Note</i>: Values must be set using hSetCommonProperties( ... )<br><br>
    '///<u>Input value(s):</u><br>
    '///<ol>

    '///+<li>Index (Integer) as specified in formcontrols.inc</li>
    '///<ul>
    '///+<li>Values between 1 and 21 are allowed</li>
    '///</ul>
    '///</ol>


    '///<u>Return Value:</u><br>
    '///<ol>
    '///+<li>Errorcondition (Boolean)</li>
    '///<ul>
    '///+<li>TRUE if all is ok</li>
    '///+<li>FALSE on invalid function parameter</li>
    '///+<li>FALSE if Property Browser is not open</li>
    '///+<li>FALSE if any control could not be accessed</li>
    '///</ul>
    '///</ol>

    const CFN = "hGetCommonProperties::"
    dim iBreakPos as integer
    
    dim cPropertyValue as string
    dim iPropertyValue as integer
    dim cReferenceValue as string
    
    dim iErr as integer
        iErr = 0
        
    '///<u>Description:</u>
    '///<ul>    
    
    kontext "TabGeneralControl"
    
    '///+<li>Verify function parameter validity</li>
    if ( ( iIndex < 1 ) or ( iIndex > ICONTROLCOUNT -1 ) ) then
        warnlog( CFN & "Invalid index passed to function, aborting" )
        hGetCommonProperties() = false
        exit function
    endif
    
    '///+<li>Verify that the control NameText is visible (Property browser is open)</li>
    if ( not NameText.exists() ) then
        warnlog( CFN & "Unable to access properties, aborting" )
        hGetCommonProperties() = false
        exit function
    endif    
    
    try
        '///+<li>Verify &quot;NameText&quot;</li>
        iBreakPos = 0
        cPropertyValue = NameText.getText()
        cReferenceValue = "MyControl" & iIndex 
        if ( cPropertyValue <> cReferenceValue ) then
            warnlog( CFN & "NameText not saved" )
            iErr = 1
        endif
        
        '///+<li>Verify &quot;Enabled&quot;</li>
        iBreakPos = 1
        iPropertyValue = Enabled.getSelIndex()
        if ( iPropertyValue <> 2 ) then
            warnlog( CFN & "Enabled not saved" )
            iErr = 1
        endif        
        
        '///+<li>Verify &quot;Printable&quot;</li>
        iBreakPos = 2
        iPropertyValue = Printable.getSelIndex()
        if ( iPropertyValue <> 2 ) then
            warnlog( CFN & "Printable not saved" )
            iErr = 1
        endif        
        
        '///+<li>Verify &quot;HelpText&quot;</li>
        iBreakPos = 3
        cPropertyValue = HelpText.getText()
        cReferenceValue = "MyHelpText" & iIndex 
        if ( cPropertyValue <> cReferenceValue ) then
            warnlog( CFN & "HelpText not saved" )
            iErr = 1
        endif        
        
        '///+<li>Verify &quot;HelpUrl&quot;</li>
        iBreakPos = 4
        cPropertyValue = HelpUrl.getText()
        cReferenceValue = "http://www.sun.com" 
        if ( cPropertyValue <> cReferenceValue ) then
            warnlog( CFN & "HelpUrl not saved" )
            iErr = 1
        endif        
        
        '///+<li>Verify &quot;Information&quot;</li>
        iBreakPos = 5
        cPropertyValue = Information.getText()
        cReferenceValue = "My Additional Information " & iIndex 
        if ( cPropertyValue <> cReferenceValue ) then
            warnlog( CFN & "Information not saved" )
            iErr = 1
        endif        
        
    catch
        warnlog( CFN & "Failed to access a control after Pos " & iBreakPos )
        hSetCommonProperties() = false
        exit function
    endcatch
    
    '///+<li>Print status to logfile</li>
    if ( iErr = 0 ) then
        printlog( CFN & "Success" )
    endif
    hGetCommonProperties() = true
    '///</ul>
    
end function
    
