'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: un_redo7.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/15 13:51:04 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description    :       Complete Test for the undo/redo function which test
'*
'************************************************************************
'*
' #1 un_redo7            ' Initial routine
' #1 tDeleteCellContents ' Delete content - Undo/Redo - Check correct result
'*
'\***********************************************************************

sub un_redo7

Printlog Chr(13) + "--------- Delete of cellcontents ---------"

        call tDeleteCellContents                'wrn:2|err:0

end sub

'**************************************************************************************************

testcase tDeleteCellContents

        Printlog ""
        Printlog "* DeleteCellContents"
        dim file, menutext as String
        dim Checkstr as String
        dim sDateFormat$
        dim i, nID, count as integer
'/// Open the file gtesttoolpath & "calc/special/input/content.sxc" and goto cell 'A4'
'/// then call menuitem 'FormatCell', goto tabpage 'Numbers' and select nr 6 from
'/// category
        file = convertpath(gtesttoolpath & "calc/special/input/content.sxc")
'/// Open the file (gtesttoolpath & "calc/special/input/content.sxc"), goto cell 'A4'
'/// and call menuitem 'FormatCell'
        call hDateiOeffnen file
        call cGotoCell ("A4")
        FormatCell
        Kontext
'/// At first check the format of the date in cell A4
        Active.setPage TabZahlen
        Kontext "TabZahlen"
        Kategorie.select 6
        sDateFormat$ = FormatCode.getText
        
        select case sDateFormat$
               case "MM/DD/YY" : Checkstr = "10/10/00"
               case "MM/DD/YYYY" : Checkstr = "10/10/2000"
               case "TT.MM.JJJJ" : Checkstr = "10.10.2000"
               case "TT.MM.JJ" : Checkstr = "10.10.00"
               case else : QAErrorLog "Unexpected date format is selected."
                           QAErrorLog "Select date format is: " & sDateFormat$
                           QAErrorLog "A warnlog will appear later in this test."
        end select
        
        TabZahlen.Close
        sleep 2
        call Del_routine

        Alles.Check
        InhalteLoeschen.OK

'/// check if the command has been executed
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Home>"
   for i = 1 to 7
        checkcellwert("A" & i, "")
   next i

'/// check if the undo-function works
   printlog "* Check the undo-function"
   EditUndo
   checkcellwert("A1", "Text")
   checkcellwert("A2", "10")
   checkcellwert("A3", "Format")
   checkcellwert("A4", Checkstr)
   checkcellwert("A5", "10")
   checkcellwert("A6", "20")            ' the formula can be tested when the office can use the clipboard
   cgotocell("A7")
   Kontext "DocumentCalc"
   DocumentCalc.OpenContextMenu
   nid = MenuGetItemID (14)
   printlog "nID:" & nID
   menutext = MenuGetItemText (nID)
        printlog "menutext:" & menutext
   MenuSelect nID
   if nID <> 26630 then
        warnlog "The menuID isn't the right, perhaps there is no note in the cell:-> bug!"
   end if

   ' deselect the menuitem "Show note"
   'DokumentCalc.OpenContextMenu
   'nid = MenuGetItemID (14)
   'MenuSelect nID

        ' check if the command del_string works
        printlog "* Check the command del_string"
   call Del_routine
   Zeichenketten.Check
   InhalteLoeschen.OK
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   checkcellwert("A1", "")

'/// check if the undo-function works
   call Undo_function
   checkcellwert("A1", "Text")

'/// check if the redo-function works
   call Redo_function
   checkcellwert("A1", "")

   EditUndo
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   '________________________________________________________________________________________________

'/// check if the command del_numbers works
   printlog "* Check the command del_numbers"
   call Del_routine
   i = 2
   Zahlen.Check
   InhalteLoeschen.OK
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   checkcellwert("A" & i, "")

'/// check if the undo-function works
   Kontext "DocumentCalc"
   call Undo_function
   checkcellwert("A" & i, "10")

'/// check if the redo-function works
   call Redo_function
   checkcellwert("A" & i, "")

   EditUndo
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   '________________________________________________________________________________________________

'/// check if the command del_date/time works
   printlog "* Check the command del_date/time"
   call Del_routine
   i = 4
   DatumZeit.Check
   InhalteLoeschen.OK
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   checkcellwert("A" & i, "")

'/// check if the undo-function works
   Kontext "DocumentCalc"
   call Undo_function
   checkcellwert("A" & i, Checkstr)

'/// check if the redo-function works
   call Redo_function
   checkcellwert("A" & i, "")

   EditUndo
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   '________________________________________________________________________________________________
'/// check if the command del_formulas works
   printlog "* Check the command del_formulas"
   call Del_routine
   i = 6
   Formeln.Check
   InhalteLoeschen.OK
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   checkcellwert("A" & i, "")

   ' check if the undo-function works
   Kontext "DocumentCalc"
   call Undo_function
   checkcellwert("A" & i, "20")

   ' check if the redo-function works
   call Redo_function
   checkcellwert("A" & i, "")

   EditUndo
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   '________________________________________________________________________________________________
'/// check if the command del_notes works
   printlog "* Check the command del_notes"
   call Del_routine
   dim menu_count as integer
   i = 7
   Notizen.Check
   InhalteLoeschen.OK
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   cgotocell("A" & i)
   DocumentCalc.OpenContextMenu
   menu_count = MenuGetItemCount
   if menu_count = 14 then
        printlog "OK, the note has been deleted"
   else
        warnlog "The note hasn't been deleted"
   end if
   MenuSelect(0)        ' close the contextmenu

   ' check if the undo-function works
   Kontext "DocumentCalc"
   call Undo_function
   cgotocell("A" & i)
   DocumentCalc.OpenContextMenu
   menu_count = MenuGetItemCount
   if menu_count = 16 then
        printlog "OK, the note has been inserted"
   else
        warnlog "The note hasn't been inserted"
   end if
   MenuSelect(0)

   ' check if the redo-function works
   Kontext "DocumentCalc"
   call Redo_function
   cgotocell("A" & i)
   DocumentCalc.OpenContextMenu
   menu_count = MenuGetItemCount
   if menu_count = 14 then
        printlog "OK, redo works"
   else
        warnlog "The redo-function doesn't work"
   end if
   MenuSelect(0)

   EditUndo
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"
   '________________________________________________________________________________________________

'/// check if the command del_formats works
   printlog "* Check the command del_formats"
   call Del_routine
   i = 3
   Formate.Check
   InhalteLoeschen.OK
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home><Down><Down>"
   FormatCells
   Kontext
   active.setpage TabFont
   Kontext "TabFont"
   try
      if StyleWest.GetSelIndex = 1 then
         printlog "OK, the cellformat has been deleted"
      else
         warnlog "The cellformat hasn't been deleted"
      end if
   catch
      if Style.GetSelIndex = 1 then
         printlog "OK, the cellformat has been deleted"
      else
         warnlog "The cellformat hasn't been deleted"
      end if
   endcatch
   Kontext
   TabFont.Cancel

'/// check if the undo-function works
   Kontext "DocumentCalc"
   call Undo_function
   DocumentCalc.TypeKeys "<Mod1 Home><Down><Down>"
   FormatCells
   Kontext
   active.setpage TabFont
   Kontext "TabFont"
   try
      if StyleWest.GetSelIndex = 2 then
         printlog "OK, the cellformat has been reset to current"
      else
         warnlog "The cellformat hasn't been reset to current"
      end if
   catch
      if Style.GetSelIndex = 2 then
         printlog "OK, the cellformat has been reset to current"
      else
         warnlog "The cellformat hasn't been reset to current"
      end if
   endcatch
   Kontext
   TabFont.Cancel

'/// check if the redo-function works
   call Redo_function
   DocumentCalc.TypeKeys "<Mod1 Home><Down><Down>"
   FormatCells
   Kontext
   active.setpage TabFont
   sleep 3
   Kontext "TabFont"
   try
      if StyleWest.GetSelIndex = 1 then
         printlog "OK, redo works"
      else
         warnlog "The redo-function doesn't work"
      end if
   catch
      if Style.GetSelIndex = 1 then
         printlog "OK, redo works"
      else
         warnlog "The redo-function doesn't work"
      end if
   endcatch
   Kontext
   TabFont.Cancel

   EditUndo
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Mod1 Home>"

   call hCloseDocument
        '________________________________________________________________________________________________

'/// check if the command del_objects works
        call hDateiOeffnen file
   printlog "* Check the command del_objects"
   call Del_routine
   Objekte.Check
   InhalteLoeschen.OK
   Kontext "DocumentCalc"
   call gMouseClick (80,50)
   try
        FormatTextWriter
        warnlog "The OLE-Object is still inserted:Bug!"
           call Text_dialog
   catch
        printlog "OK, the OLE-Object has been deleted"
   endcatch
   sleep (2)

   call gMouseClick (12,5)

'/// check if the undo-function works
   sleep (2)
   EditUndo
   sleep (2)
   Kontext "DocumentCalc"
   call gMouseDoubleClick (60,60)
   sleep (2)
   try
        call Counter_dialog
        printlog "OK, the OLE-Object has been inserted"
        TabBullet.Cancel
   catch
        warnlog "The OLE-Object hasn't been inserted:Bug!"
   endcatch

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Escape><Escape>"

'/// check if the redo-function works
   sleep 3
   try
        EditRedo
        sleep (2)
        Kontext "DocumentCalc"
        call gMouseDoubleClick (80,100)
        sleep (2)
        try
                call Counter_dialog
                warnlog "The OLE-Object hasn't been deleted:Bug!"
                TabBullet.Cancel
        catch
                printlog "OK, redo works"
                endcatch
        catch
        warnlog "Sometimes the redo function works with OLE-Objects and sometimes not. But still yet"
        warnlog "it is not possible to reproduce the problem."
        endcatch

        sleep(2)

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Escape><Escape>"

        Kontext "DocumentCalc"

        call hCloseDocument
        '________________________________________________________________________________________________
        call hDateiOeffnen file

        Kontext "DocumentCalc"
        call gMouseClick (50,10)
        sleep (2)
        DocumentCalc.TypeKeys "<Delete>"
        sleep (2)

'/// check if the command delete works
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Home>"
        call gMouseClick (50,10)
        sleep (2)
        try
                FormatLine
                warnlog "The drawingobject is still there:Bug!"
                call Line_dialog
   catch
      printlog "OK, the drawingobject has been deleted"
        endcatch
   Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Escape><Mod1 Home>"

'/// check if the undo-function works
   sleep (2)
   EditUndo
   sleep (2)
   Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Home>"
        call gMouseClick (50,10)
        sleep (2)
        try
                FormatLine
                printlog "OK, the drawingobject is there"
                call Line_dialog
        catch
        warnlog "The drawinobject isn't there but it should be:Bug!"
        endcatch

'/// check if the redo-function works
   sleep (2)
   EditRedo
   sleep (2)
   call gMouseClick (50,10)
   sleep (2)
        try
                FormatLine
                warnlog "The redo-function doesn't work"
      call Line_dialog
   catch
        printlog "OK, redo works"
   endcatch
   sleep (2)
   EditUndo
   sleep (2)

        call hCloseDocument

endcase
'checkintest

