'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: coption_tools.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/16 12:41:04 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : Tools for Options test
'*
'\***********************************************************************

sub formatFont(ind as integer, ftype as string)

        dim str_cell as string
        str_cell = fWhereIsTheCellCursor

        FormatCells
        Kontext
        Active.SetPage TabFont
        Kontext "TabFont"
        if gAsianSup then
                if StyleWest.GetSelIndex = ind then
                        printlog "Ok, the font style from " & str_cell & " is correctly set to " & ftype
                else
                        Kontext "TabFont"
                        warnlog "The font style from " & str_cell & " is set to " & StyleWest.GetSelText & " instead to " & ftype
                end if
        else
                if Style.GetSelIndex = ind then
                        printlog "Ok, the font style from " & str_cell & " is correctly set to " & ftype
                else
                        Kontext "TabFont"
                        warnlog "The font style from " & str_cell & " is set to " & Style.GetSelText & " instead to " & ftype
                end if
        end if
        Kontext "TabFont"
        TabFont.Cancel
        Kontext "DocumentCalc"

end sub

sub mvselect()

        'check if the cursor moved left after <Enter>
        if iSprache < 80 then 'because there is no thesaurus available for asian languages
                if cCellContent = "Current" then
                        printlog "OK, the hit on the return key moved the selection to left"
                else
                        cellLoc = fWhereIsTheCellCursor
                        warnlog "It seems that the hit on the return key moved the selection to " & cellLoc & " instead on A1"
                end if
        else
                if cZellwert(fWhereIsTheCellCursor) = "Current" then
                        printlog "OK, the hit on the return key moved the selection to left"
                else
                        cellLoc = fWhereIsTheCellCursor
                        warnlog "It seems that the hit on the return key moved the selection to " & cellLoc & " instead on A1"
                end if
        end if

end sub

sub stselect()

        'check if the cursor stays in the cell
        if iSprache < 80 then 'because there is no thesaurus available for asian languages
                if cCellContent = "Next" then
                        printlog "OK, the <Enter> key didn't move the selection"
                else
                        cellLoc = fWhereIsTheCellCursor
                        warnlog "It seems that the <Enter> key moved the selection to " & cellLoc & " instead to stay on B1"
                end if
        else
                if cZellwert(fWhereIsTheCellCursor)= "Next" then
                        printlog "OK, the <Enter> key didn't move the selection"
                else
                        cellLoc = fWhereIsTheCellCursor
                        warnlog "It seems that the <Enter> key moved the selection to " & cellLoc & " instead to stay on B1"
                end if
        end if

end sub

sub contextmenuopen()

        dim nid as integer

        Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Mod1 Home>Word<return>"
    'change to the edit mode
    DocumentCalc.TypeKeys "<return>"
    'try to mark this word with the hotkey <shift home>
    DocumentCalc.TypeKeys "<Shift Home>"
    sleep 3
    Kontext "DocumentCalc"
    DocumentCalc.OpenContextMenu
        sleep 3 'test the contextmenu
        nid = MenuGetItemID (7)
        sleep 2
        MenuSelect nid
        sleep 2
        Kontext
        sleep 2
        try
                Active.SetPage TabFont
                sleep 2
        Kontext "TabFont"
        TabFont.Cancel
        printlog "OK, the edit mode was available"
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<return>"
    catch
                warnlog "The opened menu wasn't 'TabFont' but " & MenuGetItemText (5)
        printlog "Try to close it"
        Kontext "InhalteLoeschen"
        InhalteLoeschen.Cancel
        endcatch

end sub

'routines for the functionality test

sub insVal()

        printlog "Check the option <iterations> and the settings for <steps> and <minimum change>"
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Home>"
        DocumentCalc.TypeKeys "=COS(A1)"
        DocumentCalc.TypeKeys "<RETURN>"
        FormatCells
        Kontext
        Active.SetPage TabZahlen
        Kontext "TabZahlen"
        Nachkommastellen.settext "4"
    TabZahlen.OK
    cval = cZellwert("a1")
    printlog "cval: " & cval
    if cval = cval_current then                 'By this value x = cos(x)
        printlog "OK, Iterations work"
    else
        warnlog "Iterations doesn't work"
    end if

end sub

sub StepsAndChange()

        select case iSystemSprache
                case 01:        minChg = "0.0001"       :       set_Steps = "1,000"
                case 49:        minChg = "0,0001"       :       set_Steps = "1.000"
        end select

        if Schritte.isenabled then
                if Schritte.GetText = curr_Steps then
                Schritte.SetText set_Steps
                str_Steps = Schritte.GetText
                printlog "str_Steps " & str_Steps
        else
                warnlog "The default for Steps is " & Schritte.GetText & " instead of " & curr_Steps
            Schritte.SetText set_Steps
                str_Steps = Schritte.GetText
        end if
        end if
        if MinimalerAenderungswert.isenabled then
                if MinimalerAenderungswert.GetText = curr_Change then
                        MinimalerAenderungswert.SetText minChg
                        str_Change = MinimalerAenderungswert.GetText
                else
                        warnlog "The default for Minimum Change is " & MinimalerAenderungswert.GetText & " instead of " & curr_Change
                        MinimalerAenderungswert.SetText minChg
                        str_Change = MinimalerAenderungswert.GetText
                end if
        end if

end sub

sub CaseSensitive()

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Home>"
        DocumentCalc.TypeKeys "TesT<right>Test<right>"
        DocumentCalc.TypeKeys "=a1=b1<return><up>"
        cval = cZellwert("c1")
        printlog "Cellvalue: " & cval
        if cval = boolval then
                printlog "OK <case sensitive> works"
        else
                warnlog "<case sensitive> doesn't work"
        end if

end sub

sub Precision()

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Home>"
        DocumentCalc.TypeKeys "<Shift right right>"
        FormatCells
        Kontext
        Active.SetPage TabZahlen
        Kontext "TabZahlen"
        Kategorie.Select 3
        Zahlenformat.Select 2
        Kontext "TabZahlen"
        TabZahlen.OK
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<left><left>"
        if iSystemSprache = 1  then
                DocumentCalc.TypeKeys "0.6<right>0.6<right>"
        else
                DocumentCalc.TypeKeys "0,6<right>0,6<right>"
        end if
        DocumentCalc.TypeKeys "=a1+b1<return>"
        precval = cZellwert("c1")
        if precval = "2" then
                printlog "OK, the option <precision as shown> works"
        else
                warnlog "It seems that the option <precision as shown> doesn't work"
        end if

end sub

' Needed in coption3.inc

sub Search()

        Kontext "DocumentCalc"
        if cZellwert("c16") = "0" then
                printlog "OK, <search criteria> work"
        else
                warnlog "<search criteria> doesn't work"
        end if


end sub

sub ColRow()

        dim cellvalue as string

        Kontext "DocumentCalc"
        cellvalue = cZellwert("D12")
        if cellvalue = "1110" then
                printlog "OK, <automatically find col/row headers> work"
        else
                warnlog "<automatically find col/row headers> doesn't work"
        end if

end sub

sub Decimal()

        dim cellvalue as string

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Home>"
        if iSystemSprache = 1  then
                DocumentCalc.TypeKeys "1.1567<return>"
        else
                DocumentCalc.TypeKeys "1,1567<return>"
        end if
        cellvalue = cZellwert("a1")
        if iSystemSprache = 1 then
                if cellvalue = "1.1567" then
                        printlog "OK, <decimal places> works"
                else
                        warnlog "<decimal places> doesn't work"
                end if
        else
                if cellvalue = "1,1567" then
                        printlog "OK, <decimal places> works"
                else
                        warnlog "<decimal places> doesn't work"
                end if
        end if

end sub

sub Dateformat(dformat as string, dkind as string)

        dim str_sdate
        dim result as double
        Kontext "DocumentCalc"
        'str_sdate = cZellwert("A1")
        'result = val(dformat) -  val(str_sdate)
        'printlog "Dateformat: " & val(dformat) & " - " & val(str_sdate)
        'if result = 0 then
        if cZellWert("C4") = "0" then
                printlog "OK, the dateformat " &  dkind & " works"
        else
                warnlog "The dateformat " & dkind & " doesn't work, it is " & cZellWert("C4") & " instead of 0"
        end if

end sub

'*********************************************************************************************************
' routines for the functionality test (needed in coption6)

sub drawform(x1,y1,x2,y2,Controltype)

    Kontext "FormControls"
    if Not FormControls.Exists then
       Call hToolbarSelect("CONTROLS", true)
    end if
    Kontext "FormControls"
    FormControls.Move 20, 20
    sleep 3

    select case Controltype
        case "Pushbutton" 
             try
                Pushbutton.click
             catch
                printlog "Enable the design modus and try again"
                SwitchControlDesignMode.click
                sleep 3
                Pushbutton.click
             endcatch
        case else : warnlog "This control isn't covered yet by this routine"
    end select

        Kontext "DocumentCalc"
        printlog "Drawing Coordinates :" & x1 & "," & y1 & "," & x2 & "," & y2
        sleep 10
        DocumentCalc.MouseDown x1, y1
        sleep 10
        DocumentCalc.MouseMove x2, y2
        sleep 10
        DocumentCalc.MouseUp x2, y2
        sleep 10
        'if Controltype = "TabellenControl" then call sAutoPilotTabelle
        'if Controltype = "Groupbox" then call sAutoPilotGrpbox
        Kontext "DocumentCalc"
        DocumentCalc.Mousemove x2 + 10,y2 + 10
        sleep 10
        Kontext "FormControls"
        SelectObject.Click
        sleep 3

end sub

sub inscontrol(mv as boolean)
' mv = true means that the inserted button is moved on the document
' false means that the button is created.
        dim nid as integer

        if mv then
                printlog "Check if the option <snap to grid> works with form controls"
                Kontext "DocumentCalc"
                sleep 10
                DocumentCalc.MouseDown 37,37
                DocumentCalc.MouseUp 37,37
                sleep 5
                DocumentCalc.MouseDown 37,37
                DocumentCalc.MouseMove 44,51
                sleep 5
                DocumentCalc.MouseUp 44,51
                sleep 10
        else
                call drawform(20,20,40,40,"Pushbutton")
        end if
        Kontext "DocumentCalc"
        sleep 5
        DocumentCalc.openContextmenu
                sleep 3 'test the contextmenu
                nid = MenuGetItemID(1)
                sleep 5
                MenuSelect nid
                sleep 2
                Kontext
                sleep 2
                try
                Active.SetPage TabPositionAndSize
                sleep 3
                Kontext "TabPositionAndSize"
                if mv then
                        x1_pos = PositionX.GetText
                        y1_pos = PositionY.GetText
                else
                        x_pos = Val(PositionX.GetText)
                        y_pos = Val(PositionY.GetText)
                end if
                sleep 3
                Kontext "TabPositionAndSize"
                sleep 3
                TabPositionAndSize.Cancel
                sleep 3
        catch
            warnlog "Couldn't open the dialog 'PositionAndSize'"
        endcatch

end sub

sub checkpos()

        dim xstr as string, xstr1 as string, ystr as string, ystr1 as string
        dim xstat as boolean, ystat as boolean

        xstat = false
        ystat = false

        if iSystemSprache = 1 then
                xstr = right(str(x1_pos), 3)
                xstr = left(xstr,2)
                xstr1 = right(str(xstr), 1)
                ystr = right(str(y1_pos), 3)
                ystr = left(ystr,2)
                ystr1 = right(str(ystr), 1)
        else
                xstr = right(str(x1_pos), 4)
                xstr = left(xstr,2)
                xstr1 = right(str(xstr), 1)
                ystr = right(str(y1_pos), 4)
                ystr = left(ystr,2)
                ystr1 = right(str(ystr), 1)
        end if
        printlog "xstr: " & xstr
        printlog "xstr1: " & xstr1
        printlog "ystr: " & ystr
        printlog "ystr1: " & ystr1
        if xstr = "00" or xstr = "50" or xstr = "25" then
                xstat = true
                printlog "OK, the function <snap to grid> works with the x-axis"
        else
                qaErrorLog "Snap to the x-axis doesn't work, probably a rounding error related to the driver of the graphics adapter."
        end if
    if ystr = "00" or ystr = "50" or ystr = "25" then
        ystat = true
        printlog "OK, the function <snap to grid> works with the y-axis"
    else
                qaErrorLog "Snap to the y-axis doesn't work, probably a rounding error related to the driver of the graphics adapter."
        end if

        if xstat and ystat then
                printlog "OK, the function <snap to grid> works with both axes"
        end if

end sub
' Needed in clocale
sub CheckContent(Celladdr as String, ChkContent as String)

        if cZellWert(Celladdr) = ChkContent then
        printlog "OK, the value of " & Celladdr & " is correct"
    else
        warnlog "The value of " & Celladdr & " is " & cZellWert(Celladdr) & " instead of " & ChkContent
    end if

end sub
