// $Id: RS232Connector.cc 8351 2008-11-12 18:20:29Z m9710797 $

#include "RS232Connector.hh"
#include "RS232Device.hh"
#include "DummyRS232Device.hh"
#include "checked_cast.hh"
#include "serialize.hh"

namespace openmsx {

RS232Connector::RS232Connector(PluggingController& pluggingController,
                               const std::string& name)
	: Connector(pluggingController, name,
	            std::auto_ptr<Pluggable>(new DummyRS232Device()))
{
}

RS232Connector::~RS232Connector()
{
}

const std::string& RS232Connector::getDescription() const
{
	static const std::string desc("Serial RS232 connector.");
	return desc;
}

const std::string& RS232Connector::getClass() const
{
	static const std::string className("RS232");
	return className;
}

RS232Device& RS232Connector::getPluggedRS232Dev() const
{
	return *checked_cast<RS232Device*>(&getPlugged());
}

template<typename Archive>
void RS232Connector::serialize(Archive& ar, unsigned /*version*/)
{
	ar.template serializeBase<Connector>(*this);
}
INSTANTIATE_SERIALIZE_METHODS(RS232Connector);

} // namespace openmsx
