#region: French
#format: <UNICODE>, <ROW><COL>, <MODIFIERS>
# <UNICODE>: hexadecimal unicode number or DEADKEY
# <ROW>: row in keyboard matrix (hexadecimal: 0-B)
# <COL>: column in keyboard matrix (0-7)
# <MODIFIERS>: space separated list of modifiers:
#              SHIFT CTRL GRAPH CODE
#
# Example characters in comments are encoded in UTF-8
#
DEADKEY, 15,
0000, 02, CTRL CODE   # ^@
0001, 46, CTRL        # ^A
0002, 27, CTRL        # ^B
0003, 30, CTRL        # ^C
0004, 31, CTRL        # ^D
0005, 32, CTRL        # ^E
0006, 33, CTRL        # ^F
0007, 34, CTRL        # ^G
0008, 75,             # Backspace
0009, 73,             # Tab
000a, 37, CTRL        # ^J
000b, 81,             # Home (is Home a unicode character?)
000c, 41, CTRL        # ^L
000d, 77,             # Enter/CR
000e, 43, CTRL        # ^N
000f, 44, CTRL        # ^O
0010, 45, CTRL        # ^P
0011, 26, CTRL        # ^Q
0012, 82,             # Insert (is Insert a unicode character?)
0013, 50, CTRL        # ^S
0014, 51, CTRL        # ^T
0015, 52, CTRL        # ^U
0016, 53, CTRL        # ^V
0017, 57, CTRL        # ^W
0018, 76,             # Select (is Select a unicode character?)
0019, 56, CTRL        # ^Y
001a, 54, CTRL        # ^Z
001b, 72,             # Escape(SDL maps ESC and ^[ to this code)
001c, 87,             # Right (SDL maps ^\ to this code)
001d, 84,             # Left  (SDL maps ^] to this code)
001e, 85,             # Up    (SDL maps ^6 to this code)
001f, 86,             # Down  (SDL maps ^/ to this code)
0020, 80,             # Space
0021, 10,             # !
0022, 03,             # "
0023, 21,             # #
0024, 16,             # $
0025, 20, SHIFT       # %
0026, 01,             # &
0027, 04,             # '
0028, 05,             # (
0029, 12,             # )
002a, 16, SHIFT       # *
002b, 24, SHIFT       # +
002c, 42,             # ,
002d, 13,             # -
002e, 22, SHIFT       # .
002f, 23, SHIFT       # /
0030, 00, SHIFT       # 0
0031, 01, SHIFT       # 1
0032, 02, SHIFT       # 2
0033, 03, SHIFT       # 3
0034, 04, SHIFT       # 4
0035, 05, SHIFT       # 5
0036, 06, SHIFT       # 6
0037, 07, SHIFT       # 7
0038, 10, SHIFT       # 8
0039, 11, SHIFT       # 9
003a, 23,             # :
003b, 22,             # ;
003c, 14,             # <
003d, 24,             # =
003e, 14, SHIFT       # >
003f, 42, SHIFT       # ?
0040, 02, CODE        # @
0041, 46, SHIFT       # A
0042, 27, SHIFT       # B
0043, 30, SHIFT       # C
0044, 31, SHIFT       # D
0045, 32, SHIFT       # E
0046, 33, SHIFT       # F
0047, 34, SHIFT       # G
0048, 35, SHIFT       # H
0049, 36, SHIFT       # I
004a, 37, SHIFT       # J
004b, 40, SHIFT       # K
004c, 41, SHIFT       # L
004d, 17, SHIFT       # M
004e, 43, SHIFT       # N
004f, 44, SHIFT       # O
0050, 45, SHIFT       # P
0051, 26, SHIFT       # Q
0052, 47, SHIFT       # R
0053, 50, SHIFT       # S
0054, 51, SHIFT       # T
0055, 52, SHIFT       # U
0056, 53, SHIFT       # V
0057, 57, SHIFT       # W
0058, 55, SHIFT       # X
0059, 56, SHIFT       # Y
005a, 54, SHIFT       # Z
005b, 05, SHIFT CODE  # [
005c, 23, SHIFT CODE  # \
005d, 12, SHIFT CODE  # ]
005e, 06, CODE        # ^
005f, 13, SHIFT       # _
0060, 04, CODE        # `
0061, 46,             # a
0062, 27,             # b
0063, 30,             # c
0064, 31,             # d
0065, 32,             # e
0066, 33,             # f
0067, 34,             # g
0068, 35,             # h
0069, 36,             # i
006a, 37,             # j
006b, 40,             # k
006c, 41,             # l
006d, 17,             # m
006e, 43,             # n
006f, 44,             # o
0070, 45,             # p
0071, 26,             # q
0072, 47,             # r
0073, 50,             # s
0074, 51,             # t
0075, 52,             # u
0076, 53,             # v
0077, 57,             # w
0078, 55,             # x
0079, 56,             # y
007a, 54,             # z
007b, 05, CODE        # {
007c, 01, CODE        # |
007d, 12, CODE        # }
007e, 07, SHIFT CODE  # ~
007f, 83,             # Delete
00a0, 80,             # No-break space (&nbsp;)
00a1, 01, SHIFT CODE  # ¡
00a2, 16, CODE        # ¢
00a3, 21, SHIFT       # £
00a5, 56, SHIFT CODE  # ¥
00a7, 06,             # §
00aa, 23, CODE        # ª
00ab, 14, GRAPH       # «
00ac, 56, SHIFT GRAPH # ¬
00b0, 12, SHIFT       # °
00b1, 24, GRAPH       # ±
00b2, 02, SHIFT GRAPH # ²
00b5, 42, CODE        # µ
00b6, 06, SHIFT CODE  # ¶
00b7, 30, SHIFT GRAPH # ·
00ba, 24, CODE        # º
00bb, 14, SHIFT GRAPH # »
00bc, 01, GRAPH       # ¼
00bd, 02, GRAPH       # ½
00be, 03, GRAPH       # ¾
00bf, 42, SHIFT CODE  # ¿
00c3, 35, SHIFT CODE  # Ã
00c4, 26, SHIFT CODE  # Ä
00c5, 22, SHIFT CODE  # Å
00c6, 37, SHIFT CODE  # Æ
00c7, 11, SHIFT CODE  # Ç
00c9, 02, SHIFT CODE  # É
00d1, 43, SHIFT CODE  # Ñ
00d5, 41, SHIFT CODE  # Õ
00d6, 33, SHIFT CODE  # Ö
00dc, 34, SHIFT CODE  # Ü
00df, 27, CODE        # ß
00e0, 00,             # à
00e1, 56, CODE        # á
00e2, 46, CODE        # â
00e3, 35, CODE        # ã
00e4, 26, CODE        # ä
00e5, 22, CODE        # å
00e6, 37, CODE        # æ
00e7, 11,             # ç
00e8, 07,             # è
00e9, 02,             # é
00ea, 54, CODE        # ê
00eb, 50, CODE        # ë
00ec, 30, CODE        # ì
00ed, 36, CODE        # í
00ee, 32, CODE        # î
00ef, 31, CODE        # ï
00f1, 43, CODE        # ñ
00f2, 53, CODE        # ò
00f3, 44, CODE        # ó
00f4, 47, CODE        # ô
00f5, 41, CODE        # õ
00f6, 33, CODE        # ö
00f7, 22, GRAPH       # ÷
00f9, 20,             # ù
00fa, 45, CODE        # ú
00fb, 51, CODE        # û
00fc, 34, CODE        # ü
00ff, 52, CODE        # ÿ
0128, 40, SHIFT CODE  # Ĩ
0129, 40, CODE        # ĩ
0132, 20, SHIFT CODE  # Ĳ
0133, 20, CODE        # ĳ
0168, 17, SHIFT CODE  # Ũ
0169, 17, CODE        # ũ
0192, 55, CODE        # ƒ
0393, 10, SHIFT CODE  # Γ
0394, 00, SHIFT CODE  # Δ
03a3, 21, SHIFT CODE  # Σ
03a6, 13, SHIFT CODE  # Φ
03a9, 57, SHIFT CODE  # Ω
03b1, 03, CODE        # α
03b4, 00, CODE        # δ
03b5, 07, CODE        # ε
03b8, 11, CODE        # θ
03c0, 45, SHIFT CODE  # π
03c3, 21, CODE        # σ
03c4, 10, CODE        # τ
03c6, 13, CODE        # φ
03c9, 57, CODE        # ω
2022, 55, SHIFT GRAPH # •
2027, 11, GRAPH       # ‧
2030, 21, GRAPH       # ‰
207f, 03, SHIFT GRAPH # ⁿ
20a7, 03, SHIFT CODE  # ₧
221a, 07, GRAPH       # √
221e, 10, GRAPH       # ∞
2229, 05, GRAPH       # ∩
223d, 04, GRAPH       # ∽
2248, 04, SHIFT GRAPH # ≈
2260, 51, SHIFT GRAPH # ≠
2261, 24, SHIFT GRAPH # ≡
2264, 14, CODE        # ≤
2265, 14, SHIFT CODE  # ≥
2310, 47, SHIFT GRAPH # ⌐
2320, 06, GRAPH       # ⌠
2321, 06, SHIFT GRAPH # ⌡
2500, 13, GRAPH       # ─
2502, 01, SHIFT GRAPH # │
250c, 47, GRAPH       # ┌
2510, 56, GRAPH       # ┐
2514, 53, GRAPH       # └
2518, 43, GRAPH       # ┘
251c, 33, GRAPH       # ├
2524, 35, GRAPH       # ┤
252c, 51, GRAPH       # ┬
2534, 27, GRAPH       # ┴
253c, 34, GRAPH       # ┼
2571, 23, SHIFT GRAPH # ╱
2572, 23, GRAPH       # ╲
2573, 55, GRAPH       # ╳
2580, 36, SHIFT GRAPH # ▀
2582, 52, GRAPH       # ▂
2584, 36, GRAPH       # ▄
2586, 44, GRAPH       # ▆
2588, 45, GRAPH       # █
258a, 41, GRAPH       # ▊
258c, 40, GRAPH       # ▌
258e, 37, GRAPH       # ▎
2590, 40, SHIFT GRAPH # ▐
2594, 44, SHIFT GRAPH # ▔
2595, 41, SHIFT GRAPH # ▕
2596, 35, SHIFT GRAPH # ▖
2597, 33, SHIFT GRAPH # ▗
2598, 43, SHIFT GRAPH # ▘
259a, 31, SHIFT GRAPH # ▚
259d, 53, SHIFT GRAPH # ▝
259e, 31, GRAPH       # ▞
25a7, 46, GRAPH       # ▧
25a8, 46, SHIFT GRAPH # ▨
25a9, 45, SHIFT GRAPH # ▩
25b2, 32, SHIFT GRAPH # ▲
25b6, 54, GRAPH       # ▶
25bc, 32, GRAPH       # ▼
25c0, 54, SHIFT GRAPH # ◀
25c7, 30, GRAPH       # ◇
25cb, 00, GRAPH       # ○
25d8, 11, SHIFT GRAPH # ◘
25d9, 00, SHIFT GRAPH # ◙
25fc, 26, SHIFT GRAPH # ◼
25fe, 26, GRAPH       # ◾
263a, 12, GRAPH       # ☺
263b, 12, SHIFT GRAPH # ☻
263c, 57, GRAPH       # ☼
2640, 42, SHIFT GRAPH # ♀
2642, 42, GRAPH       # ♂
2660, 17, GRAPH       # ♠
2663, 20, GRAPH       # ♣
2665, 20, SHIFT GRAPH # ♥
2666, 17, SHIFT GRAPH # ♦
266a, 16, GRAPH       # ♪
266b, 16, SHIFT GRAPH # ♫
29d3, 50, GRAPH       # ⧓
