// $Id: RenShaTurbo.cc,v 1.15 2006/01/18 22:29:44 m9710797 Exp $

#include "RenShaTurbo.hh"
#include "XMLElement.hh"
#include "Autofire.hh"

namespace openmsx {

RenShaTurbo::RenShaTurbo(CommandController& commandController,
                         const XMLElement& machineConfig)
{
	const XMLElement* config = machineConfig.findChild("RenShaTurbo");
	if (config) {
		int min_ints = config->getChildDataAsInt("min_ints", 47);
		int max_ints = config->getChildDataAsInt("max_ints", 221);
		autofire.reset(new Autofire(commandController, min_ints,
		                            max_ints, "renshaturbo"));
	}
}

RenShaTurbo::~RenShaTurbo()
{
}

byte RenShaTurbo::getSignal(const EmuTime& time)
{
	return autofire.get() ? autofire->getSignal(time) : 0;
}

} // namespace openmsx
