#!/bin/sh
# path trick for smash variants \
exec smash $0 ${1+"$@"}

# filter.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_filename g_threshold g_histSize

proc showUsage {} {
    puts stdout "filter.tcl -f <file> -t <threshold> -s <history size>"
}

proc getFlags {argv} {
    global g_filename g_threshold g_histSize

    set g_filename "log.in"
    set g_threshold 30
    set g_histSize 20

    set state flag
    foreach arg $argv {
        switch -exact -- $state {
            flag {
                switch -exact -- $arg {
                    -f {
                        set state filename
                    }
		    -t {
                        set state threshold
                    }
		    -s {
                        set state histSize
                    }
                    -help {
                        showUsage
                        exit
                    }
                    default {
                        showUsage
                        exit
                    }
                }
            }
	    filename {
		set g_filename $arg
		set state flag
	    }
	    threshold {
		set g_threshold $arg
		set state flag
	    }
	    histSize {
		set g_histSize $arg
		set state flag
	    }
	}
    }
    puts stdout "#filename  = $g_filename"
    puts stdout "#threshold = $g_threshold"
    puts stdout "#histSize  = $g_histSize"
}

proc doFilter {} {
    global g_filename g_threshold g_histSize

#    puts stdout "TitleText: QM Microphone Inputs"
#    puts stdout "XUnitText: Set() calls (every 16.67 ms)"
#    puts stdout "YUnitText: Raw value"

    if {$g_filename == "stdin"} {
	set fd "stdin"
    } else {
	if {[catch {open $g_filename r} fd]} {
	    puts stdout "Cannot open file $g_filename for reading"
	    return 0
	}
    }

    set trans [new Transducer/Gauge $g_histSize "Test"]
    $trans setThreshold $g_threshold

    while {[gets $fd line] >= 0} {
#	puts stdout $line
	set sLine [split $line " "]
	set index [lindex $sLine 0]
	set val [lindex $sLine 1]
#	puts stdout "\tindex=$index   val=$val"
	$trans setCall $val
	set sum [$trans getActiveSum]
	puts stdout "$index $sum"
    }
    close $fd

    return 1
}

# main program

getFlags $argv

doFilter
