# session-scuba.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/scuba/session-scuba.tcl,v 1.19 2002/02/03 04:29:36 lim Exp $

#Class Session/Scuba

Session/Scuba set sessionbw_ 0

Session/Scuba instproc init {} {
	$self next

	$self set share_ 0.05
	$self set sessionbw_ 0
}

Session/Scuba instproc sessionbw { b } {
	$self instvar sessionbw_
	set sessionbw_ $b
	$self set_allocation
}

Session/Scuba instproc unregister { src } {
#puts "unregister $src"
	$self clean_scoretab $src
}

Session/Scuba instproc register { src } {}
Session/Scuba instproc activate { src } {}
Session/Scuba instproc deactivate { src } {}
Session/Scuba instproc notify { src } {}
Session/Scuba instproc trigger_media { src } {}
Session/Scuba instproc trigger_format { src } {}
Session/Scuba instproc trigger_sdes { src } {}
Session/Scuba instproc trigger_idle { src } {}

Session/Scuba instproc recv_scuba_entry { sender srcid val } {
	$self instvar scoretab_
#puts "$self: $proc $sender:$srcid $val"

	set scoretab_($sender:$srcid) [expr $val/1e6]
}

Session/Scuba instproc clean_scoretab { src } {
	$self instvar scoretab_

	set idxs [array names scoretab_ $src:*]
	foreach i $idxs {
		unset scoretab_($i)
	}
}

Session/Scuba instproc delete_reporter { s } {
	$self clean_scoretab $s
	$self set_allocation
}
